; TK3TUT17.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; showing use of a table
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
PCL             EQU 2                   ; Program Counter
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag

STORE           EQU H'20'               ; variable named STORE

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00001111'       ; RA0-RA3 as input
                movwf TRISA
                clrf TRISB
                BANK0

                goto LOOP               ; bypass Table and go to LOOP
                 
TABLE           andlw B'00001111'       ; AND with 15 to limit jumps to 0-15
                addwf PCL,F             ; ADD result to program counter
                retlw 255               ; 0 returns with 255 in W (11111111)
                retlw 1                 ; 1 returns with 1 in W (00000001)
                retlw '5'               ; 2 returns with ASCII value for 5 (53)
                retlw 0                 ; 3 returns with 0 in W
                retlw 31                ; 4 returns with 31 in W
                retlw 193               ; 5 returns with 193 in W
                goto OTHER              ; 6 jump to routine at OTHER
                return                  ; 7 returns with value in W unchanged
                retlw B'10101010'       ; 8 returns with this value in W
                retlw H'C7'             ; 9 returns with this value in W
                retlw 'A'               ; 10 returns with ASCII value for A (65)
                retlw 65                ; 11 returns with this value in W
                retlw 'B'               ; 12 returns with ASCII value for B
                retlw 'x'               ; 13 returns with ASCII value for x
                goto OTHER1             ; 14 jump to routine at OTHER1
                movf STORE,W            ; 15 get value within STORE
                return                  ; return with STORE value now in W
                 
LOOP            movf PORTA,W            ; get switch settings value
                call TABLE              ; get table value for that setting value
                movwf PORTB             ; output table value to PORTB
                goto LOOP               ; repeat
                 
OTHER           retlw STORE             ; jumped to from table jump 6
                                        ; returns with equated value for STORE in W
                 
OTHER1          movlw 128		; jumped to from table jump 14
		addwf PORTA,W           ; add 128 to PORTA value
                return                  ; returns with this value in W
                 
                end                     ; final statement
