; TK3TUT12.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; using 4 switches on Port A, showing their status on Port B
           
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00001111'       ; PORTA RA0 to RA3 as input
                movwf TRISA
                clrf TRISB
                BANK0
                 
LOOP            movf PORTA,W            ; get value of PORTA
                andlw B'00001111'       ; ANDED with binary 1111 so that only
                                        ; first 4 bits of 8-bit value in W
                                        ; have any effect
                movwf PORTB             ; set Port B to the value of Port A
                goto LOOP               ; the loop is repeated endlessly
                 
                end                     ; final statement
