VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmTestComms 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Confirm Communications Interface"
   ClientHeight    =   4485
   ClientLeft      =   2400
   ClientTop       =   2100
   ClientWidth     =   5790
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   HelpContextID   =   800
   Icon            =   "frmTestComms.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4485
   ScaleWidth      =   5790
   Begin VB.CommandButton cmdCancelTest 
      Caption         =   "Cancel Testing"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2280
      TabIndex        =   1
      Top             =   3090
      Width           =   1845
   End
   Begin VB.CommandButton cmdLoopBack 
      Caption         =   "Cable LoopBack Test"
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   3090
      Width           =   1845
   End
   Begin MSCommLib.MSComm MSComPort 
      Left            =   4635
      Top             =   45
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   0   'False
      OutBufferSize   =   1
      RThreshold      =   1
      SThreshold      =   1
   End
   Begin MSComctlLib.ProgressBar pbProgress 
      Height          =   315
      Left            =   105
      TabIndex        =   8
      Top             =   4140
      Visible         =   0   'False
      Width           =   5625
      _ExtentX        =   9922
      _ExtentY        =   556
      _Version        =   393216
      Appearance      =   1
      Max             =   10
   End
   Begin VB.CommandButton cmdTest 
      Caption         =   "Start Board Test"
      Height          =   375
      Left            =   120
      TabIndex        =   2
      Top             =   3615
      Width           =   1845
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "You now have two testing options available. !!"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   270
      Left            =   150
      TabIndex        =   11
      Top             =   2715
      Width           =   5325
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " All Power jumper wires are removed and DIPS are off"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   6
      Left            =   120
      TabIndex        =   10
      Top             =   2250
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " JP1 and JP2 are NOT inserted on the main PCB"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   5
      Left            =   120
      TabIndex        =   9
      Top             =   1902
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " Configuration settings for COM port and speed are correct"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   4
      Left            =   120
      TabIndex        =   7
      Top             =   1560
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " The power to the tester is connected and switched on"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   3
      Left            =   120
      TabIndex        =   6
      Top             =   1206
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " The tester is connected to COM on the computer"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   2
      Left            =   120
      TabIndex        =   5
      Top             =   855
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      BackStyle       =   0  'Transparent
      Caption         =   " There is no IC in the test socket"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   225
      Index           =   1
      Left            =   120
      TabIndex        =   4
      Top             =   510
      Width           =   5595
   End
   Begin VB.Label lblNotes 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Check the following first:"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00C00000&
      Height          =   195
      Index           =   0
      Left            =   120
      TabIndex        =   3
      Top             =   165
      Width           =   2070
   End
End
Attribute VB_Name = "frmTestComms"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mbStopTest                              As Boolean
Private ComPort                                 As MSComm

Private Const Module_Name                       As String = "frmTestComms"
Public Sub LogEvent(sDescription As String)

    frmCommsOutput.AddLog sDescription
    
End Sub

Public Property Let Terminate(ByRef new_Terminate As Boolean)

    mbStopTest = new_Terminate
    
End Property

Private Sub cmdCancelTest_Click()

    cmdCancelTest.Enabled = False
    frmCommsOutput.AddLog "Cancel Pressed !"
    
    mbStopTest = True
    
End Sub

Private Sub cmdLoopBack_Click()
    Dim bError                          As Boolean
    Dim bFlag                           As Boolean
    Dim F                               As Integer
    Dim sBuffer                         As String
    Dim sTemp                           As String
    Dim sngTimer                        As Single
    
    Const PROC_NAME                     As String = "cmdLoopBack_Click"
    Const TEST_PATTERN                  As String = "0123456789ABCDEFGHIJK8A"
    
    On Error GoTo ErrorHandler
    
    cmdCancelTest.Enabled = True
    cmdTest.Enabled = False
    mbStopTest = False
    
    Set ComPort = MSComPort
    
    '
    ' Open comms port
    frmCommsOutput.Show
    LogEvent "Open Communcations Port..."
    Call Device_OpenPort(ComPort) ' This often causes Datacomms Error on the PIC !
    
    '
    ' Make sure there nothing in the RX buffer
    LogEvent "Flush RX Buffer..."
    Device_FlushBuffer MSComPort
    
    LogEvent ""
    LogEvent "This routine will send ASCII Characters out to the serial port."
    LogEvent "These can then be 'looped back' into the serial port."
    LogEvent "Use this feature to check the correct operation of the serial port,"
    LogEvent "cable, and Windows COM port settings...."
    LogEvent ""
    
    Sleep 2000
    
    LogEvent "Sending ASCII Characters: " & TEST_PATTERN
    
    Do
        ' Send test pattern
        Device_TX ComPort, TEST_PATTERN
        
        DoEvents
        
        '
        ' What did we get
        sBuffer = ComPort.Input
            
        LogEvent "Received:" & sBuffer
        
        If sBuffer <> TEST_PATTERN Then
            LogEvent "Pattern not correct...."
        Else
            LogEvent "********* PASSED !!!!!! *************"
        End If
        
        DoEvents ' Let Windows do any stuff it need to...
        Sleep 1000 ' Sleep for 1 second using NO CPU.
        '
        ' Flush receive buffer
        Device_FlushBuffer MSComPort
        
    Loop While mbStopTest = False
    
    
TerminateTest:
    '
    ' Close Comms Port
    LogEvent "Closing Communications Port..."
    Device_ClosePort ComPort
    
    cmdCancelTest.Enabled = False
    cmdTest.Enabled = True
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub

Private Sub cmdTest_Click()

    Dim bError                          As Boolean
    Dim F                               As Integer
    Dim sBuffer                         As String
    Dim sTemp                           As String
    
    Const PROC_NAME                     As String = "cmdTest_Click"
    
    On Error GoTo ErrorHandler
    
    Set ComPort = MSComPort
    mbStopTest = False
    cmdLoopBack.Enabled = False
    
    '
    ' Open comms port
    frmCommsOutput.Show
    pbProgress.Value = 1
    pbProgress.Visible = True
    LogEvent "Open Communcations Port..."
    Call Device_OpenPort(ComPort) ' This often causes Datacomms Error on the PIC !
    
    '
    ' Make sure there nothing in the RX buffer
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Flush RX Buffer..."
    Device_FlushBuffer MSComPort
    
    '
    ' Send the device reset command
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Sending Device Reset Command..."
    Device_Reset ComPort
    
    '
    ' Wait for Reply
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Waiting For Response..."
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 8) = "Ready." & vbCrLf Then
        ' All ok
        LogEvent "Response OK"
    Else
        LogEvent "Invalid Response"
        bError = True
        GoTo TerminateTest
    End If
    
    '
    ' Now read back the port status
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Read Back Tester Status..."
    Device_ReadStatus MSComPort
    
    '
    ' Wait for Reply
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Waiting For Response..."
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 5) = "OK." & vbCrLf Then
        ' All ok
        LogEvent "Response OK"
    Else
        LogEvent "Invalid Response"
        bError = True
        GoTo TerminateTest
    End If
    
    pbProgress.Value = pbProgress.Value + 1
    If Len(sBuffer) <> 9 Then
        LogEvent "Response received not valid"
        sTemp = ""
        For F = 1 To Len(sBuffer)
            sTemp = sTemp & Right$("00" & Hex$(Asc(Mid$(sBuffer, F, 1))), 2) & " "
        Next F
        LogEvent "Hex Dump:" & sTemp
        bError = True
        GoTo TerminateTest
    Else
        For F = 1 To 4
            sTemp = sTemp & Right$("00" & Hex$(Asc(Mid$(sBuffer, F, 1))), 2) & " "
        Next F
        LogEvent "4 Bytes Received - Hex Dump:" & sTemp
    End If
        
    ' Get firmware version details
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Get firmware version..."
    Device_GetVersion MSComPort
    
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Waiting For Response..."
    sBuffer = Device_ReadBuffer(ComPort)
    If Right$(sBuffer, 3) = "." & vbCrLf Then
        ' All ok
        LogEvent "Response OK"
        LogEvent sBuffer
    Else
        LogEvent "Invalid Response"
        bError = True
        GoTo TerminateTest
    End If
    
    
TerminateTest:
    '
    ' Close Comms Port
    pbProgress.Value = pbProgress.Value + 1
    LogEvent "Closing Communications Port..."
    Device_ClosePort ComPort
    
    If bError = True Then
        frmCommsOutput.lstLog.BackColor = QBColor(12) ' Light Red
        MsgBox "Testing Complete..." & vbCrLf & vbCrLf & "Errors Detected...", vbOKOnly + vbCritical, "Testing Device Interface"
    Else
        frmCommsOutput.lstLog.BackColor = QBColor(10) ' Light Green
        LogEvent "Test Completed... No Errors Found..."
        pbProgress.Value = pbProgress.Max
        MsgBox "Testing Complete..." & vbCrLf & vbCrLf & "No Errors Found...", vbOKOnly + vbInformation, "Testing Device Interface"
    End If
    
    cmdLoopBack.Enabled = True
    
    Exit Sub
    
ErrorHandler:
    ErrorRoutine Module_Name, PROC_NAME, Err
End Sub




Private Sub Form_Load()

    lblNotes(2).Caption = " The tester is connected to COM" & Format$(gnPort) & " on the computer"
    
End Sub








