;BIGDIGIT92.ASM 07FEB02 - JOHN BECKER

; PIC16F84, 4.0MHz xtal, WDT off, POR on 
; Written in TASM for TK2/TK3 assembly

	list	p=16F84,r=dec
        __config        h'3FF1'

#DEFINE PAGE0 BCF 3,5    
#DEFINE PAGE1 BSF 3,5    

INDF:     .EQU $00              
OPTION:   .EQU $01              
PCL:      .EQU $02              
STATUS:   .EQU $03              
FSR:      .EQU $04              
PORTA:    .EQU $05              
TRISA:    .EQU $05              
PORTB:    .EQU $06              
TRISB:    .EQU $06              
INTCON:   .EQU $0B
EEDATA:   .EQU $08
EECON1:   .EQU $08
EEADR:    .EQU $09
EECON2:   .EQU $09


LOOP:   .EQU $0C   ;general loop
STORE:  .EQU $0F   ;temporary store
COL:    .EQU $10   ;column counter (inc in decimal)
ROW:    .EQU $11   ;row counter (inc as matrix val)
ANSWER: .EQU $12   ;holds final keyed answer
NUMBER:  .EQU $16
PULSECNT: .EQU $19
DIGIT:   .EQU $1A
SEGLOGIC: .EQU $1B
PREVDIGIT1:  .EQU $1C
PREVDIGIT2:  .EQU $1D
PREVDIGIT3:  .EQU $1E
PREVDIGIT4:  .EQU $1F
PREVDIGIT5:  .EQU $20
PREVDIGIT6:  .EQU $21
PREVDIGIT7:  .EQU $22
PREVDIGIT8:  .EQU $23

PREVDIGIT9:  .EQU $24
PREVDIGIT10:  .EQU $25
PREVDIGIT11:  .EQU $26
PREVDIGIT12:  .EQU $27
PREVDIGIT13:  .EQU $28
PREVDIGIT14:  .EQU $29
PREVDIGIT15:  .EQU $2A
PREVDIGIT16:  .EQU $2B

PREVDIGIT17:  .EQU $2C
PREVDIGIT18:  .EQU $2D
PREVDIGIT19:  .EQU $2E
PREVDIGIT20:  .EQU $2F
PREVDIGIT21:  .EQU $30
PREVDIGIT22:  .EQU $31
PREVDIGIT23:  .EQU $32
PREVDIGIT24:  .EQU $33

SEGSTORE:     .EQU $34
NEWBIT:       .EQU $35
CURRENTBIT:   .EQU $36
DIGITBANK:    .EQU $37

W:        .EQU 0
F:        .EQU 1                
C:        .EQU 0                
DC:       .EQU 1                
Z:        .EQU 2                
GIE:      .EQU 7               ; global interrupt bit
INTF:     .EQU 1               ; RB0 interrupt flag
WR:       .EQU 1  ;eeprom write initiate flag
WREN:     .EQU 2  ;eeprom write enable flag
RD:       .EQU 0  ;eeprom read enable flag
MATRIX    .EQU 4  ;matrix quantity value
                  ;set as 3 for (3 x 4)
                  ; or as 4 for (4 x 4)

          ; locations up to $3F are available

          .ORG $0004
          goto START
          .ORG $0005
          goto START

VALUE:  ADDWF PCL,F       ;lookup table for key allocation
        retlw 1
        retlw 2
        retlw 3
        retlw 10
        retlw 4
        retlw 5
        retlw 6
        retlw 11
        retlw 7
        retlw 8
        retlw 9
        retlw 12
        retlw 14
        retlw 0
        retlw 15
        retlw 13

TABLE:  addwf PCL,F     ; segment allocations for keyboard input numbers
        retlw %00111111 ;0
        retlw %00000110 ;1
        retlw %01011011 ;2
        retlw %01001111 ;3
        retlw %01100110 ;4
        retlw %01101101 ;5
        retlw %01111101 ;6
        retlw %00000111 ;7
        retlw %01111111 ;8
        retlw %01100111 ;9
        retlw %01110111 ;10 A
        retlw %01111100 ;11 b
        retlw %00111001 ;12 c
        retlw %01011110 ;13 d
        retlw %10000000 ;14 blank
        retlw %01000000 ;15 -
        ;       gfedcba

TABLE2: addwf PCL,F     ; PORTB code to turn on named segment
        retlw %01000000 ;1 a 4 (IC4 A-C are swapped on PCB)
        retlw %00100000 ;4 b 2
        retlw %01100000 ;5 c 6
        retlw %00010000 ;6 d 1
        retlw %01010000 ;7 e 5
        retlw %00110000 ;3 f 3
        retlw %01110000 ;2 g 7
        retlw %00000000 ;0 -  common anode codes

BANKTABLE: addwf PCL,F  ; digit bank allocation table
        retlw 1         ; 0
        retlw 1         ; 1
        retlw 1         ; 2
        retlw 1         ; 3
        retlw 1         ; 4
        retlw 1         ; 5
        retlw 1         ; 6
        retlw 1         ; 7

        retlw 2         ; 8
        retlw 2         ; 9
        retlw 2         ; 10
        retlw 2         ; 11
        retlw 2         ; 12
        retlw 2         ; 13
        retlw 2         ; 14
        retlw 2         ; 15

        retlw 4         ; 16
        retlw 4         ; 17
        retlw 4         ; 18
        retlw 4         ; 19
        retlw 4         ; 20
        retlw 4         ; 21
        retlw 4         ; 22
        retlw 4         ; 23

START:   bcf INTCON,GIE        ;disable all interrupts
         btfsc INTCON,GIE      ;are all interrupts disabled?
         goto START            ;no, try again

         clrf PORTA
         clrf PORTB
         PAGE1
         movlw %00010000
         movwf TRISA    
         movlw %11111111
         movwf TRISB    
         movlw %00000101       ;set timer ratio 1:64, interrupt on falling edge of RB0/INT (bit 6 = 0)
         movwf OPTION          ;pull-ups on (bit 7 = 0)
         PAGE0

         clrf DIGIT
         clrf PREVDIGIT1
         clrf PREVDIGIT2
         clrf PREVDIGIT3
         clrf PREVDIGIT4
         clrf PREVDIGIT5
         clrf PREVDIGIT6
         clrf PREVDIGIT7
         clrf PREVDIGIT8

         clrf PREVDIGIT9
         clrf PREVDIGIT10
         clrf PREVDIGIT11
         clrf PREVDIGIT12
         clrf PREVDIGIT13
         clrf PREVDIGIT14
         clrf PREVDIGIT15
         clrf PREVDIGIT16

         clrf PREVDIGIT17
         clrf PREVDIGIT18
         clrf PREVDIGIT19
         clrf PREVDIGIT20
         clrf PREVDIGIT21
         clrf PREVDIGIT22
         clrf PREVDIGIT23
         clrf PREVDIGIT24

         clrf SEGSTORE
         clrf NEWBIT
         clrf CURRENTBIT
         movlw 1
         movwf DIGITBANK

         movf PORTB,W       ; check PORTB status, 0 = PC, 255 = keyboard
         xorlw 255
         btfss STATUS,Z     ; is PORTB = 255 (keypad bias value)?
         goto COMPROG       ; no, so input from PC

MAINPROG: PAGE1
         movlw %11110000    ; set RB7-4 as input, RB3-0 as output
         movwf TRISB
         bcf OPTION,7       ; pullups on 
         PAGE0
         clrf PORTA         ; set PORTA low (to turn off DIGIT power)
         clrf NUMBER
         movlw PREVDIGIT1
         addwf DIGIT,W
         movwf FSR
MAIN2:   call GETKEY        ; get data, if any
         movf NUMBER,W      ; is NUMBER = 0 (no data)?
         btfsc STATUS,Z
         goto MAIN2         ; yes, so repeat data test
         clrf PORTB         ; there is data, so sent to display
         PAGE1
         bsf OPTION,7       ; pullups off
         movlw %00000000    ; set PORTB as output
         movwf TRISB
         PAGE0

         clrf LOOP
         movf NUMBER,W
         movwf STORE

         movlw %00000001
         movwf CURRENTBIT
         bsf STATUS,C

LOOP2:  movlw %10000000     ; set for RB7 (seg on)
        rrf STORE,F
        btfss STATUS,C      ; is C set (bit = 1)?
        movlw %00001000     ; no, bit = 0 so set for RB3 (seg off)
        movwf SEGLOGIC      ; store on/off result

        movf CURRENTBIT,W    ; get value of current bit number
        andwf NUMBER,W
        movwf NEWBIT         ; store it

        movf CURRENTBIT,W    ; get value of same bit in prev number
        andwf INDF,W
        xorwf NEWBIT,W       ; is it the same value as bit in new number?
        btfsc STATUS,Z
        goto LOOP3           ; yes, so bypass segment control

        movf LOOP,W
        call TABLE2         ; get segment number
        iorwf SEGLOGIC,W    ; OR in ON/OFF logic turn on IC4 or IC5
        iorwf DIGIT,W       ; OR in DIGIT to turn on selected DIGIT thro IC4/5
        movwf PORTB         ; output to PORTB
        movf DIGITBANK,W
        movwf PORTA
        call PULSEIT        ; delay (approx 70ms)
        clrf PORTB

LOOP3:  bcf STATUS,C
        rlf CURRENTBIT,F
        incf LOOP,F         ; repeat for next segment
        btfss LOOP,3
        goto LOOP2
        clrf PORTA          ; turn off DIGIT power
        clrf PORTB
        movf NUMBER,W
        movwf INDF
        goto MAINPROG

;********** SEND PULSE TO SEGMENT CONTROL **** 

PULSEIT: movlw %00010000
        movwf PULSECNT
PULSE2: btfss PORTA,4      ; has bit 4 gone high (cap charged up enough)?
        goto PULSE2        ; no, repeat check
        bcf PORTA,4        ; yes, set bit 4 low to discharge cap again
        PAGE1
        bcf TRISA,4        ; set bit 4 as output
        PAGE0
        nop                ; brief wait discharge capacitor
        PAGE1
        bsf TRISA,4        ; set bit 4 as input
        PAGE0
        decfsz PULSECNT,F  ; repeat for set delay loop time
        goto PULSE2
	return

;..........GET KEYPAD VAL ROUTINE........

GETKEY:  clrf PORTB       ; yes, so there is keyboard input. Set RB3-0 low
         nop              ;pause to allow PORTB to stabilise
         comf PORTB,W     ;get & invert PORTB
         andlw %11110000  ;isolate bits 7-4
         btfsc STATUS,Z   ;is result NOT zero (keys pressed)?
         return           ;no, so return to main prog

         movlw %00000111  ;yes, a key is pressed so get it
         movwf PORTB      ;initial val for PORTB
         clrf COL

GK2:     comf PORTB,W     ;get & invert PORTB
         andlw %11110000  ;isolate bits 7-4
         btfss STATUS,Z   ;is result NOT zero (keys pressed)?
         goto GK3         ;yes
         incf COL,F       ;no, inc col val

         rrf PORTB,F      ;rotate PORTB right
         btfsc STATUS,C   ;is Carry zero?
         goto GK2         ;no, so repeat
         return           ;yes, so return to main prog

GK3:     movwf STORE
         swapf STORE,F
         clrf ROW         ;clear row number count

GK4:     rrf STORE,F      ;rotate right PORTB store val
         btfsc STATUS,C   ;is carry flag set?
         goto SUMIT       ;yes so key pressed, go & finish answer
         movlw MATRIX
         addwf ROW,F      ;add matrix val to ROW count
         goto GK4

SUMIT:   movf COL,W
         sublw 3
         movwf COL        ;store as column
         movf ROW,W       ;sum up results to single answer
         addwf COL,W      ;add ROW to COL (total of 0-15)
         call VALUE       ;convert val to allocated table character
         movwf ANSWER     ;store it

CHECK13: xorlw 13         ; had D been pressed? (step DIGIT on by 1)
         btfss STATUS,Z
         goto CHECK12
         call INCDIGIT
         movlw 14
         movwf ANSWER
         movlw PREVDIGIT1
         addwf DIGIT,W
         movwf FSR
         movlw 255
         movwf INDF
         goto KEYTAB

CHECK12: movf ANSWER,W
         xorlw 12         ; had C been pressed? (reset DIGIT to 0)
         btfss STATUS,Z
         goto KEYTAB
         movlw 14
         movwf ANSWER
         clrf DIGIT
         movlw PREVDIGIT1
         addwf DIGIT,W
         movwf FSR
         movlw 255
         movwf INDF

KEYTAB:  movf ANSWER,W
         call TABLE
         movwf NUMBER

WAITKEY: comf PORTB,W     ;get & invert PORTB
         andlw %11110000  ;isolate bits 7-4
         btfss STATUS,Z   ;is key still pressed?
         goto WAITKEY     ; yes
         return           ; no, so return to main prog

;***************

COMPROG: clrf PORTA         ; set PORTA low (to turn off DIGIT power)
         clrf PORTB
         PAGE1
         bsf OPTION,7       ; pullups off
         PAGE0
         clrf DIGIT
         movlw 1
         movwf DIGITBANK

COMP0:   PAGE1
         movlw 255          ; set PORTB as input
         movwf TRISB
         PAGE0
         clrf NUMBER
         movlw PREVDIGIT1
         addwf DIGIT,W
         movwf FSR

COMP1:  bsf PORTA,3         ; tell PC to send data
        nop
GETPORT: btfss PORTB,7
        goto GETPORT
        movf PORTB,W
        movwf NUMBER
        bcf PORTA,3         ; inhibit PC from sending data
GETPORT2: btfsc PORTB,7     ; wait till PC acknowledges
        goto GETPORT2
        xorlw %10000001     ; is RESET called?
        btfsc STATUS,Z
        goto COMPROG        ; yes

        PAGE1
        clrf TRISB          ; set PORTB as output
        PAGE0

        clrf LOOP
        movf NUMBER,W
        andlw %01111111
        movwf STORE

        movlw %00000001
        movwf CURRENTBIT
        bsf STATUS,C

COMP2:  movlw %10000000     ; set for RB7 (seg on)
        rrf STORE,F
        btfss STATUS,C      ; is C set (bit = 1)?
        movlw %00001000     ; no, bit = 0 so set for RB3 (seg off)
        movwf SEGLOGIC      ; store on/off result

        movf CURRENTBIT,W   ; get value of current bit number
        andwf NUMBER,W
        movwf NEWBIT        ; store it

        movf CURRENTBIT,W   ; get value of same bit in prev number
        andwf INDF,W
        xorwf NEWBIT,W      ; is it the same value as bit in new number?
        btfsc STATUS,Z
        goto COMP3          ; yes, so bypass segment control

        movf LOOP,W
        call TABLE2         ; get segment number
        iorwf SEGLOGIC,W    ; OR in ON/OFF logic turn on IC4 or IC5
        iorwf DIGIT,W       ; OR in DIGIT to turn on selected DIGIT thro IC4/5
        movwf PORTB         ; output to PORTB
        movf DIGITBANK,W
        movwf PORTA
        call PULSEIT        ; delay (approx 70ms)
        clrf PORTB

COMP3:  bcf STATUS,C
        rlf CURRENTBIT,F
        incf LOOP,F         ; repeat for next segment
        btfss LOOP,3
        goto COMP2
        clrf PORTA          ; turn off DIGIT power
        clrf PORTB

        movf NUMBER,W
        movwf INDF
        call INCDIGIT       ; no, so inc digit count and get bank number
        goto COMP0           ;ROG

INCDIGIT: incf DIGIT,F        ; inc digit count and get bank number
        movf DIGIT,W        ; is digit count = 24? (digit range val = 0 to 23)
        xorlw 24
        btfsc STATUS,Z
        clrf DIGIT          ; yes, reset to 0
        movf DIGIT,W
        call BANKTABLE      ; get digit bank number
        movwf DIGITBANK
        return

        .end
