'DIGIT11.BAS  EPE BIG DIGIT 7-SEGMENT CONTROL 07FEB02
SCREEN 9: COLOR 14, 1: DIM seg$(255), segs%(255)

' You may fill in your own additional DATA for key/segment control

'     abcdefg - bit to segment allocation, 0 = off, 1 = on, first val is keyboard character
DATA 01111110
DATA 10110000
DATA 21101101
DATA 31111001
DATA 40110011
DATA 51011011
DATA 60011111
DATA 71110000
DATA 81111111
DATA 91111011
DATA A1110111
DATA a0000000
DATA B0000000
DATA b0011111
DATA C1001110
DATA c0001101
DATA D0000000
DATA d0111101
DATA E1001111
DATA e0000000
DATA F1000111
DATA f0000000
DATA G1011111
DATA g0000000
DATA H0110111
DATA h0010111
DATA I0110000
DATA i0010000
DATA J0111100
DATA j0000000
DATA K0000000
DATA k0000000
DATA L0001110
DATA l0000110
DATA M0000000
DATA m0000000
DATA N0000000
DATA n0010101
DATA O1111110
DATA o0011101
DATA P1100111
DATA p0000000
DATA Q0000000
DATA q1110011
DATA R0000000
DATA r0000101
DATA S1011011
DATA s0000000
DATA T0000000
DATA t0001111
DATA U0111110
DATA u0011100
DATA V0000000
DATA v0000000
DATA W0000000
DATA w0000000
DATA X0000000
DATA x0000000
DATA Y0000000
DATA y0111011
DATA Z0000000
DATA z0000000
DATA =0001001
DATA -0001000
DATA " 0000000"
DATA "^1100011"
DATA *

COLOR 14
LINE (2, 2)-(638, 348), 14, B: LINE (4, 4)-(636, 346), 14, B
LOCATE 2, 25: PRINT "EPE BIG-DIGIT 7-SEGMENT DISPLAY"
LOCATE 4, 25: PRINT "0"; : COLOR 11: PRINT "  Port 378 hex (most common)"
COLOR 14: LOCATE 5, 25: PRINT "1"; : COLOR 11: PRINT "  Port 278 hex"
COLOR 14: LOCATE 6, 25: PRINT "2"; : COLOR 11: PRINT "  Port 3BC hex"
COLOR 14: LOCATE 8, 18: PRINT "Select Printer Port address (press key 0, 1 or 2)"
getadr: a$ = INKEY$: IF a$ = "" THEN GOTO getadr
a = VAL(a$): IF a > 2 THEN a = 0

IF a = 0 THEN port = &H378: port$ = "378 hex"
IF a = 1 THEN port = &H278: port$ = "278 hex"
IF a = 2 THEN port = &H3BC: port$ = "3BC hex"
OUT port, 0

LOCATE 4, 25: PRINT "                              "
LOCATE 5, 25: PRINT "                "
LOCATE 6, 25: PRINT "                "
LOCATE 8, 18: PRINT "                                                 "

COLOR 11: LOCATE 24, 7: PRINT "USABLE 7-SEGMENT CHARACTERS: ";
segs%(13) = 1: seg$(13) = "00000001"
segments: READ a$: IF a$ = "*" THEN GOTO 150
a = ASC(a$): seg$(a) = MID$(a$, 2): B = 0: d = 0
FOR c = 2 TO LEN(a$): IF MID$(a$, c, 1) = "1" THEN d = d + (2 ^ B)
B = B + 1: NEXT: segs%(a) = d: IF a = 65 THEN PRINT " ";
IF d > 0 THEN PRINT CHR$(a);
GOTO segments

150 :
COLOR 11
LOCATE 2, 6: PRINT "<ESC>  RESTART"
LOCATE 3, 6: PRINT "<CTRL/BRK> END"
LOCATE 2, 62: PRINT "<ENTER> RESET"
LOCATE 3, 62: PRINT "<SPACE> BLANK"

COLOR 14
LOCATE 6, 30: PRINT "SWITCH ON PIC UNIT NOW"
LOCATE 8, 12: PRINT "Do not switch on PIC unit until AFTER you see this message"
LOCATE 9, 8: PRINT "(Otherwise PIC will think it has to monitor keypad rather than PC)"

ON ERROR GOTO errortrap
COLOR 11: LOCATE 4, 34: PRINT "Port = "; port$: COLOR 14
LOCATE 3, 27: PRINT "HOW MANY DIGITS (MAX 24)"; : INPUT B$: digits = VAL(B$)

'limit number of digits - for more than 24 digits see EPE text
IF LEN(B$) > 20 THEN GOTO errortrap
IF digits < 1 OR digits > 24 OR LEN(a$) > 4 THEN
LOCATE 3, 31: PRINT "                                                 ": GOTO 150
END IF

LOCATE 6, 30: PRINT "                      "
LOCATE 8, 12: PRINT "                                                          "
LOCATE 9, 8: PRINT "                                                                  "


ON ERROR GOTO 0

seghi = 26: thick = 4
IF digits <= 32 THEN
banklength = 8: indent = 160: startheight = 50 + (seghi * 2)
IF digits < 8 THEN indent = 168 + (seghi / 2) + ((8 - digits) / 2 * seghi)
ELSE banklength = 16: startheight = 50: indent = 22
END IF

'draw boxes
lt = indent + 20: top = startheight
FOR f = 1 TO digits
LINE (lt - 6, top - 5)-(lt + 29, top + 55), 14, B: lt = lt + 40 - 5:
IF (f \ banklength) = f / banklength THEN lt = indent + 20: top = top + 70
NEXT

'send RESET to PIC
lt = indent + 19: top = startheight - 1
f = 1: v = 13: GOSUB waitport:  'reset to first digit
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

' send "8" to all digits
lt = indent + 19: top = startheight - 1: v = ASC("8"): a$ = seg$(v):
FOR f = 1 TO VAL(B$): GOSUB waitport: NEXT
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

'send RESET to PIC
lt = indent + 19: top = startheight - 1
f = 1: v = 13: GOSUB waitport:  'reset to first digit
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

'send blank to all digits
lt = indent + 19: top = startheight - 1: v = ASC(" "): a$ = seg$(v):
FOR f = 1 TO VAL(B$): GOSUB waitport: NEXT
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

'send RESET to PIC
lt = indent + 19: top = startheight - 1
f = 1: v = 13: GOSUB waitport:  'reset to first digit
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

'main loop
DISPLAYLOOP:

'send RESET to PIC
lt = indent + 19: top = startheight - 1
f = 1: v = 13: a$ = seg$(v): GOSUB waitport: 'reset to first digit

'clear underline from final character position
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF

'draw underline at first character position
lt = indent + 19: top = startheight - 1
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 10, BF

' send keyboard characters for all digits
FOR f = 1 TO digits:
segroute: z$ = INKEY$: IF z$ = "" THEN GOTO segroute
OUT port, 0: v = ASC(z$): ' PRINT z$, v, seg$(v), segs%(v)
IF z$ >= "a" AND z$ <= "z" THEN z$ = UCASE$(z$): v = ASC(z$): GOTO seg2
IF z$ >= "A" AND z$ <= "Z" THEN z$ = LCASE$(z$): v = ASC(z$)
seg2: a$ = seg$(v): IF z$ = " " THEN GOTO seg4

IF v = 13 THEN
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF
f = digits: 'ENTER key - reset to first DIGIT
END IF

IF v = 27 THEN RUN: 'ESC key to start program again
IF segs%(v) = 0 THEN GOTO segroute: ' if no segment code allocated wait next key
seg4: GOSUB waitport: ' send character
'q = q + 1: LOCATE 2, 1: PRINT q
NEXT: ' repeat for next val in loop

'clear underline from final character position
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF
GOTO DISPLAYLOOP: ' start loop again

' send character to PIC, with handshakes
waitport: IF INKEY$ = CHR$(27) THEN RUN: 'ESC key to start program again
a = INP(port + 1): IF (a AND 8) = 0 THEN GOTO waitport
seg3: OUT port, segs%(v) OR 128
waitport2: IF INKEY$ = CHR$(27) THEN RUN: 'ESC key to start program again
a = INP(port + 1): IF (a AND 8) = 8 THEN GOTO waitport2
OUT port, 0: IF v = 13 THEN RETURN

'display character in screen box - first clear all segments not required
COLOR 0: FOR c = 1 TO 7
IF VAL(MID$(a$, c, 1)) = 0 THEN ON c GOSUB sa, sb, sc, sd, se, sf, sg
NEXT

' now show all segments required
COLOR 14: FOR c = 1 TO 7
IF VAL(MID$(a$, c, 1)) = 1 THEN ON c GOSUB sa, sb, sc, sd, se, sf, sg
NEXT

' clear previous underline
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 0, BF
'inc counter and box position, if box line exceeded start next line
lt = lt + 35: IF (f \ banklength) = f / banklength THEN lt = indent + 20: top = top + 70

' draw new underline
LINE (lt - 4, top + (seghi * 2) + 5)-(lt + seghi + 3, top + (seghi * 2) + 8), 10, BF
RETURN

' segment drawing/clearing routines
sa: x = lt: y = top: LINE (x, y)-(x + seghi, y + thick), , BF: RETURN
sb: x = lt + seghi - thick: y = top: LINE (x, y)-(x + thick, y + seghi), , BF: RETURN
sc: x = lt + seghi - thick: y = top + seghi: LINE (x, y)-(x + thick, y + seghi), , BF: RETURN
sd: x = lt: y = top + (seghi * 2): LINE (x, y - thick)-(x + seghi, y), , BF: RETURN
se: x = lt: y = top + seghi: LINE (x, y)-(x + thick, y + seghi), , BF: RETURN
sf: x = lt: y = top: LINE (x, y)-(x + thick, y + seghi), , BF: RETURN
sg: x = lt: y = top + seghi: LINE (x, y)-(x + seghi, y + thick), , BF: RETURN

' error trap for excess line length entry by mischievous user!
errortrap: CLS
LOCATE 15, 15: PRINT "NOW YOU'VE DONE IT - YOU'LL HAVE TO START AGAIN"
LOCATE 16, 15: PRINT "     THAT'LL TEACH YOU TO CHALLENGE ME! :-)"
RESUME endit
endit:

