; Program 8
; Program 5 with 2 interrupts
; Flash a led at about 1Hz
; Interrupts on RB0 and TMR0

	list	p=16F84,r=dec
	__config	h'3FF3'

; Macros

#define BANK0   BCF 0x03,5
#define BANK1   BSF 0x03,5

#define SPEED	5		; controls led flash rate

Enter_Critical_Section	macro
	LOCAL	__cs1
__cs1	bcf	INTCON, GIE
	btfsc	INTCON, GIE
	goto	__cs1
			endm

Leave_Critical_Section	macro
	bsf	INTCON, GIE
			endm

; Equates for registers

	include	p16f84.inc

; Data locations

SAVEW:  equ	0x20	; preserve W during interrupts
SAVES:  equ	0x21	; preserve STATUS during interrupts
COUNT:	equ	0x22	; count of timer ticks
ICOUNT:	equ	0x23	; number of interrupts

; code
	org	0
	goto	init
        org	4
        goto	ISR      	; Interrupt vector
        org	5

; initialise PIC

init:   clrf PORTA		; initialise all port outputs to zero
        clrf PORTB
	BANK1
	clrf	TRISA		; RA0 - RA4 all outputs
 	movlw	b'00000001'	; RB0 input, rest outputs
	movwf	TRISB
	movlw	b'00000111'	; enable PORTB pullups, PSA to TMR, prescale /256
	movwf	OPTION_REG
	BANK0

; interrupt setup

        bsf     INTCON, INTE    ; enable INTF interrupt
	clrf	TMR0		; clear internal clock count-up
	clrf	COUNT		; clear clock wrapped count
	bcf	INTCON,T0IF	; clear the TMR0 wrapped flag
	bsf	INTCON,T0IE	; enable timer interrupts
        bsf     INTCON,GIE	; enable global interrupts

; data initialisation

	bsf	PORTA,0		; turn on the led

; main loop

main:	movlw	SPEED		; about 10 bumps/sec at 2MHz clock
	Enter_Critical_Section
	subwf	COUNT,W		; sets C if COUNT >= W
	btfss	STATUS,C	; test C
	goto	A2		; C clear so COUNT < SPEED
	clrf	COUNT		; reset the wrapped count
	Leave_Critical_Section
	movlw	1		; wraps COUNT = SPEED so
	xorwf	PORTA,F		; toggle RA0
	goto	main		; repeat main loop
A2:	Leave_Critical_Section
	goto	main		; and repeat main loop

; Interrupt service routine

ISR:    movwf   SAVEW           ; save W 
	swapf	STATUS,W
	movwf	SAVES		; save STATUS
	BANK0			; ensure bank 0 set
	incf	ICOUNT,F	; bump interrupt count
        btfss   INTCON, INTF    ; test INTF
	goto	TMR		; not an RB0 interrupt - try timer

; INTF interrupt
	
      	nop			; nothing to do for this demo!
	bcf     INTCON, INTF    ; clear the interrupt

TMR:	btfss	INTCON, T0IF	; test INTF
	goto	POP		; not a timer interrupt

; timer interrupt

	incf	COUNT,F		; bump clocks wrapped count
	bcf	INTCON, T0IF	; clear the interrupt

POP:    swapf   SAVES,W		; restore STATUS
	movwf	STATUS
	swapf	SAVEW,F		; restore W
	swapf	SAVEW,W
	retfie			; exit ISR

        end			; of program
