;MATCHBOX MEMORY UNIT N DOSSIS 1/6/01
;FINAL VERSION - FILENAME 'EEPROM.ASM'
;ABLE TO LOAD AND SAVE DATA TO MINI ENIGMA
;40 CHARACTER SAVE
;
;

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5


C:      .EQU 0          ;carry flag
Z:      .EQU 2          ;zero flag
INDF:   .EQU $00        ;register used when calling Indirect address
OPTION: .EQU $01        ;option register
PCL:    .EQU $02        ;Program Counter
STATUS: .EQU $03        ;status register
FSR:    .EQU $04        ;register which holds Indirect address
TRISA:  .EQU $05        ;
PORTA:  .EQU $05        ;
TRISB:  .EQU $06        ;
PORTB:  .EQU $06        ;
DATA:  .EQU $0D         ;data store
WORD:  .EQU $0F         ;word store
TEMP:  .EQU $10         ;temp store
COUNT: .EQU $11         ;counter store
SPACE:  .EQU $1A        ;
INTCON: .EQU $0B        ;
CLKCNT: .EQU $0E        ;125 secs counter

EEDATA: .EQU $08
EECON1: .EQU $08
EEADR:  .EQU $09
EECON2: .EQU $09

WR:     .EQU 1  ;eeprom write initiate flag
WREN:   .EQU 2  ;eeprom write enable flag
RD:     .EQU 0  ;eeprom read enable flag

LETTER1: .EQU $0         ;start address for eeprom memory

W:      .EQU 0          ;
F:      .EQU 1          ;

        .ORG $0004
        .ORG $0005

        clrf PORTA      ;
        clrf PORTB      ;
        PAGE1           ;
        movlw %00000000 ;
        movwf TRISA     ;Port A0-A4 as output
        movlw %11000000 ;
        movwf TRISB     ;Port B6-B7 as input
        movlw %00000110 ;set timer ratio 1:128
        movwf OPTION    ;
        PAGE0           ;

        goto WAIT       ;

WAIT:   movf PORTB,W    ;move port B to w
        movwf TEMP      ;move to temp
        btfsc TEMP,7    ;test for LOAD signal
        goto TX         ;
        btfsc TEMP,6    ;test for SAVE signal
        goto RX         ;
        goto WAIT       ;loop round

TX:     PAGE1           ;LOAD TO ENIGMA ROUTINE
        clrf TRISB      ;port B as outputs
        PAGE0           ;
        clrf PORTB      ;
        clrf WORD       ;clears all files
        clrf DATA       ;
        clrf TEMP       ;
        clrf COUNT      ;
        clrf SPACE      ;
        movlw LETTER1   ;move eeprom start address to count variable
        movwf COUNT     ;
TSTART: movf COUNT,W    ;
        call GETMEM     ;recalls eeprom memory at count address
        movwf DATA      ;move character to data file
        movf DATA,W     ;
        movwf SPACE     ;
        movlw 8         ;move 8 into w
        movwf WORD      ;word set up for 8 bits
TDATA:  clrf PORTB      ;clear clock and data pulses
        movf DATA,W     ;move data to w
        andlw %10000000 ;isolate bits 0 to 6
        movwf TEMP      ;move answer into temp
        bsf TEMP,6      ;set clock bit
        movf TEMP,W     ;move temp to w
        movwf PORTB     ;send clock and data pulses to enigma
        rlf DATA,F      ;rotate data file left
        clrf TEMP       ;clear temp file
        decfsz WORD,F   ;decrement word file
        goto TDATA      ;loop until all 8 bits are sent
        incf COUNT,W    ;increment counter
        xorlw $28       ;have all 40 characters been sent?
        btfsc STATUS,Z  ;test zero flag
        goto TSTOP      ;yes, end transmission
        incf COUNT,F    ;no, increment count
        bsf SPACE,7      ;
        movlw %10000000 ;
        xorwf SPACE,W   ;test for character being a space
        btfsc STATUS,Z  ;
        goto TSTOP      ;yes, finish transmitting data
        goto TSTART     ;no, loop round
TSTOP:  clrf PORTB      ;clear port b
        PAGE1           ;
        movlw %11000000 ;port B bits 6 & 7 as input
        movwf TRISB     ;
        PAGE0           ;
        goto WAIT       ;go and wait for instructions from enigma

RX:     PAGE1           ;SAVE DATA FROM ENIGMA ROUTINE
        movlw %10000000 ;port b bit 7 as an output
        movwf TRISB     ;
        PAGE0           ;
        movlw LETTER1   ;move start address to w
        movwf COUNT     ;move w into counter       
MAT:    clrf PORTB      ;clear port B
        clrf WORD       ;clear files
        clrf DATA       ;
        clrf TEMP       ;
RDATA:  movlw 8         ;move 8 into w, denotes an 8 bit word   
        movwf WORD      ;move w into word file
CLK:    bsf PORTB,6     ;send clock signal to enigma
        movf PORTB,W    ;move data from enigma to w
        movwf TEMP      ;move w to data file
        rlf DATA,F      ;rotate data file left
        btfsc TEMP,7    ;test for data being high or low
        bsf DATA,0      ;data is high, set code bit zero
        clrf TEMP       ;clear temp file
        bcf PORTB,6     ;make clock signal go low
        decfsz WORD,F   ;decrement count file
        goto CLK        ;loop until all 8 bits are received
        incf COUNT,W    ;increment counter
        xorlw $28       ;have all 40 characters been sent?
        btfsc STATUS,Z  ;test zero flag
        goto TSTOP      ;yes, end transmission
        movf COUNT,W    ;
        call SETMEM     ;save letter into eeprom memory at count address
        incf COUNT,F    ;increment count
        movlw %10000000 ;test for letter being a space
        xorwf DATA,W    ;
        btfsc STATUS,Z  ;
        goto TSTOP      ;space received end SAVE routine
        goto MAT        ;no, loop round

                      ;eeprom memory routines

SETMEM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movf DATA,W     ;get data value from DATA and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
GETMEM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1           ;
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return

        .END            ;final line. This line must be retained.









