;MINI-ENIGMA V2 - N DOSSIS 4/6/01
;VERSION TWO - FILENAME 'E2.ASM'
;40 CHARACTER DATA LOAD/SAVE FACILITY
;EEPROM STORAGE OF PROGRAMMABLE CODEWORD

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

C:      .EQU 0          ;carry flag
Z:      .EQU 2          ;zero flag
INDF:   .EQU $00        ;register used when calling Indirect address
OPTION: .EQU $01        ;option register
PCL:    .EQU $02        ;Program Counter
STATUS: .EQU $03        ;status register
FSR:    .EQU $04        ;register which holds Indirect address
TRISA:  .EQU $05        ;
PORTA:  .EQU $05        ;
TRISB:  .EQU $06        ;
PORTB:  .EQU $06        ;
LETTER1:  .EQU $1F      ;1F to 46 reserved for 40 letters
INTCON: .EQU $0B        ;
LENGTH: .EQU $1C        ;length of codeword

LOOP:   .EQU $0C        ;loop counter 1 - general
LOOPA:  .EQU $0D        ;loop counter 2 - LCD use only
CLKCNT: .EQU $0E        ;125 secs counter
STORE:  .EQU $0F        ;general store
RSLINE: .EQU $10        ;bit 4 RS line flag for LCD
CODE:   .EQU $11        ;code variable
COUNT:  .EQU $12        ;count variable
COUNTER: .EQU $13       ;counter variable
COMBI:  .EQU $14        ;combination variable
POSITN: .EQU $15        ;position of letters on screen
ALPHA1: .EQU $16        ;temporary letter store
ADDSUB: .EQU $17        ;code/decode flag

EEDATA: .EQU $08
EECON1: .EQU $08
EEADR:  .EQU $09
EECON2: .EQU $09

WR:     .EQU 1  ;eeprom write initiate flag
WREN:   .EQU 2  ;eeprom write enable flag
RD:     .EQU 0  ;eeprom read enable flag


W:      .EQU 0          ;
F:      .EQU 1          ;

        .ORG $0004
        .ORG $0005

        clrf PORTA      ;
        clrf PORTB      ;
        PAGE1           ;
        movlw %00001111 ;
        movwf TRISA     ;Port A0-A4 as input
        movlw %11000000 ;
        movwf TRISB     ;Port B7-B6 as input, B5-B0 output
        movlw %00000110 ;set timer ratio 1:128
        movwf OPTION    ;
        PAGE0           ;
        goto SETUP      ;bypass table

TABLCD: ADDWF PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001110 ;set display, cursor
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end initialisation table

INSTR1: addwf PCL,F     ;Screen 1
        retlw ' '
        retlw %01111111
        retlw ' '
        retlw %01111110
        retlw ' '
        retlw ' '
        retlw '1'
        retlw '='
        retlw 'E'
        retlw 'n'
        retlw 't'
        retlw 'e'
        retlw 'r'
        retlw ' '
        retlw '2'
        retlw '='
        retlw 'N'
        retlw 'e'
        retlw 'x'
        retlw 't'
        retlw ' '
        retlw %01111111
        retlw ' '
        retlw %01111110
        retlw ' '
        retlw ' '
        retlw '1'
        retlw '='
        retlw 'E'
        retlw 'n'
        retlw 't'
        retlw 'e'
        retlw 'r'
        retlw ' '
        retlw '2'
        retlw '='
        retlw 'N'
        retlw 'e'
        retlw 'x'
        retlw 't'

INSTR2: addwf PCL,F     ;Screen 2
        retlw ' '
        retlw ' '
        retlw %01111111
        retlw '='
        retlw 'C'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw %01111110
        retlw '='
        retlw 'D'
        retlw 'c'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw ' '
        retlw ' '
        retlw '1'    ;line 2
        retlw '='
        retlw 'C'
        retlw 'l'
        retlw 'e'
        retlw 'a'
        retlw 'r'
        retlw ' '
        retlw '2' 
        retlw '='
        retlw 'M'
        retlw 'a'
        retlw 't'
        retlw 'c'
        retlw 'h'
        retlw ' '
        retlw 'B'
        retlw 'o'
        retlw 'x'
        retlw ' '
       
MESSA1: addwf PCL,F     ;start-up message
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'M'
        retlw 'i'
        retlw 'n'
        retlw 'i'
        retlw '-'
        retlw 'E'
        retlw 'n'
        retlw 'i'
        retlw 'g'
        retlw 'm'
        retlw 'a'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '       ;line 2
        retlw ' '
        retlw ' '
        retlw ' '
        retlw 'N'
        retlw 'i'
        retlw 'c'
        retlw 'k'
        retlw '.'
        retlw 'D'
        retlw '.'
        retlw '2'
        retlw '0'
        retlw '0'
        retlw '1'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

TXRX:   addwf PCL,F     ;ask to transmit or receive
        retlw ' '
        retlw ' '
        retlw %01111111
        retlw '='
        retlw 'S'
        retlw 'a'
        retlw 'v'
        retlw 'e'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw %01111110
        retlw '='
        retlw 'L'
        retlw 'o'
        retlw 'a'
        retlw 'd'
        retlw ' '
        retlw ' '
        retlw ' '   ;line2
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '1'
        retlw '='
        retlw 'C'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw 'w'
        retlw 'o'
        retlw 'r'
        retlw 'd'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

TRANSL: addwf PCL,F     ;load message
        retlw ' '
        retlw '"'
        retlw 'L'
        retlw 'o'
        retlw 'a'
        retlw 'd'
        retlw 'i'
        retlw 'n'
        retlw 'g'
        retlw '"'
        retlw ' '
        retlw ' '
        retlw %01111111
        retlw '='
        retlw 'A'
        retlw 'b'
        retlw 'o'
        retlw 'r'
        retlw 't'
        retlw ' '

TRANSS: addwf PCL,F     ;save message
        retlw ' ' 
        retlw '"'
        retlw 'S'
        retlw 'a'
        retlw 'v'
        retlw 'i'
        retlw 'n'
        retlw 'g'
        retlw '"'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw %01111111
        retlw '='
        retlw 'A'
        retlw 'b'
        retlw 'o'
        retlw 'r'
        retlw 't'
        retlw ' '

COMTEXT: addwf PCL,F     ;
        retlw ' '
        retlw '('
        retlw 'N'
        retlw 'e'
        retlw 'w'
        retlw '?'
        retlw ')'
        retlw ' '
        retlw ' '
        retlw ' '

COMTEXT2: addwf PCL,F     ;
        retlw ' '
        retlw '('
        retlw 'C'
        retlw 'u'
        retlw 'r'
        retlw 'r'
        retlw 'e'
        retlw 'n'
        retlw 't'
        retlw ')'

SETUP:  call PAUSIT     ;perform first 1/5th sec delay

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        call PAUSIT     ;yes, perform second 1/5th sec delay
                        ;to allow final LCD command to occur
                        ;(it takes longer than the rest)

CLEN:   movlw 20        ;gets codeword length from eeprom 
        call GETMEM     ;when unit is switched on 
        movwf LENGTH    ;

INTRO:  call LINE1      ;this routine shows start up message
        clrf LOOP       ;loop=0
IN:     movf LOOP,W     ;moves loop into w
        call MESSA1     ;calls message letter
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;increment loop
        xorlw 20        ;tests to see if 20 characters have been shown
        btfsc STATUS,Z  ;
        call LINE2      ;yes, start printing on line 2
        incf LOOP,W     ;no, carry on
        xorlw 40        ;tests to see if all
        btfsc STATUS,Z  ;letters have been shown
        goto DEL        ;yes, go to wait
        incf LOOP,F     ;no, increment loop 
        goto IN         ;and go round again

DEL:    movf PORTA,W    ;wait for any key to be pressed
        btfsc STATUS,Z  ;test zero flag
        goto DEL        ;if port a is zero then loop around
        call PAUSIT     ;if not then pause then carry on
        goto DIRECT     ;

WAIT2:  call PAUSIT     ;waits to see if you want to code or decode
WAI:    btfsc PORTA,2   ;has button 2 been pressed?
        goto DC         ;yes, go and decode the message
        btfsc PORTA,3   ;has button 1 been pressed?
        goto CODER      ;yes, go and code the message
        btfsc PORTA,1   ;has button 3 been pressed?
        goto DIRECT     ;yes, go clear memory
        btfsc PORTA,0   ;has button 4 been pressed?
        goto MATCH      ;yes, go and transfer data
        goto WAI        ;loop around

WAIT:   btfss PORTA,0   ;has button 4 been pressed?
        goto WAIT       ;no, loop round
        call CLRLCD     ;yes, goto clear lcd

DIRECT: call CLRLCD     ;clears screen
        movlw LETTER1   ;this routine clears the memory of the 20 addresses
        movwf FSR       ;copy w into Indirect address reg
        movlw 40        ;move 40 into w
        movwf LOOP      ;move w into loop       
RESET:  movlw %10000000 ;moves blank space into w
        movwf INDF      ;moves w into indirect file
        incf FSR,F      ;increments fsr
        decfsz LOOP,F   ;has loop reached zero?
        goto RESET      ;no, loop round
        movlw LETTER1   ;yes, move address of LETTER1 into W
        movwf FSR       ;copy w into Indirect address reg

INSTRUC: call LINE2     ;calls line 2 routine
        clrf LOOP       ;this routine shows the instructions
L:      movf LOOP,W     ;move loop into w
        call INSTR1     ;calls instruction table
        call LCDOUT     ;shows letter
        incf LOOP,W     ;increment loop
        xorlw 40        ;test to see if all 40
        btfsc STATUS,Z  ;letters have been shown
        goto TEXT       ;yes, goto text
        incf LOOP,F     ;no, increment loop
        goto L          ;and loop around

TEXT:   clrf POSITN     ;lcd position 0
        bsf POSITN,7    ;set command instruction
        movlw 1         ;move 1 into w
        movwf COUNTER   ;move w into counter
POS:    clrf ADDSUB     ;clear flag
POSI1:  clrf RSLINE     ;clears RS line
        movf POSITN,W   ;move display position 0 to w
        call LCDOUT     ;gets position 0
        bsf RSLINE,4    ;set RS for data send
KEY:    btfsc PORTA,2   ;has button 2 been pressed?
        goto ROTUP      ;yes, goto rotate letters up routine
        btfsc PORTA,1   ;has button 3 been pressed?
        goto ENTER      ;yes, enter letter into memory and screen
        btfsc PORTA,0   ;has button 4 been pressed?
        goto ASKQUE1    ;yes, go to next screen
        btfsc PORTA,3   ;has button 1 been pressed?
        goto ROTDOWN    ;yes, goto rotate letters down routine
        goto KEY        ;loop around

ROTUP:  incf COUNTER,F  ;increments counter
        bsf COUNTER,6   ;sets upper bit of counter for asci
        movf COUNTER,W  ;moves counter value into w
        xorlw %01011011 ;tests to see if we have gone past Z
        btfsc STATUS,Z  ;
        goto AY         ;yes, go and rotate to A
        movf COUNTER,W  ;move counter to w
AYY:    movwf ALPHA1    ;moves w into temporary alphabet store
        call LCDOUT     ;puts letter on the lcd
        call PAUSIT     ;wait to debounce keys
        clrf ADDSUB     ;clears flag variable
        goto POSI1      ;go and move position of text
AY:     movlw %01000001 ;move letter A to w
        movwf COUNTER   ;move A into counter
        goto AYY        ;go back to routine

ROTDOWN: decf COUNTER,F  ;increments counter
        bsf COUNTER,6   ;sets upper bit of counter for asci
        movf COUNTER,W  ;moves counter value into w
        xorlw %01000000 ;tests to see if we have reached @
        btfsc STATUS,Z  ;
        goto ZED        ;yes, go rotate to Z
        movf COUNTER,W  ;move counter to w
ZEDD    movwf ALPHA1    ;moves w into temporary alphabet store
        call LCDOUT     ;puts letter on the lcd
        call PAUSIT     ;wait to debounce keys
        clrf ADDSUB     ;clears flag variable
        goto POSI1      ;go and move position of text
ZED:    movlw %01011010 ;move letter Z to w
        movwf COUNTER   ;move Z into counter
        goto ZEDD       ;go back to routine

ENTER:  btfsc ADDSUB,7  ;tests flag variable
        goto DELETE     ;if it is set, then goto delete characters
        bcf POSITN,7    ;clear upper bit of position
        movf POSITN,W   ;if it is clear, then enter characters as normal
        addlw 237       ;has character position reached 20?
        btfsc STATUS,C  ;check carry flag
        call SHIFTL     ;yes, shift screen to the left
        movf ALPHA1,W   ;moves letter in temp store to w
        movwf INDF      ;copy it into reg pointed to by FSR
        call LCDOUT     ;prints letter on lcd
        call PAUSIT     ;wait for lcd
        incf FSR,F      ;inc FSR address
        incf POSITN,F   ;increment screen position by 1 character
        bcf POSITN,7    ;clears upper command bit of position value
        movf POSITN,W   ;moves value into w
        xorlw 40        ;have 40 characters been entered yet?
        btfsc STATUS,Z  ;check zero flag
        goto ASKQUE1    ;yes, go to next screen
        bsf POSITN,7    ;sets upper command bit of position value
        clrf RSLINE     ;clears RS line
        movf POSITN,W   ;moves position value to w
        call LCDOUT     ;get lcd to set screen position
        bsf RSLINE,4    ;set RS for data send
        call PAUSIT     ;wait to debounce keys
        bsf ADDSUB,7    ;sets flag variable to highlight enter occurring
        goto POSI1      ;return to main program

DELETE: bcf POSITN,7    ;
        decf POSITN,W   ;decrement position
        xorlw 0         ;test to see if position is zero
        btfsc STATUS,Z  ;check zero flag
        goto DIRECT     ;yes, do no more & goto main 
        movf POSITN,W   ;move position to w
        addlw 236       ;has character position reached 20?
        btfsc STATUS,C  ;
        call SHIFTR     ;yes, shift screen to the left
        decf POSITN,F   ;no, decrement position
        decf FSR,F      ;decrement fsr
        movlw %10000000 ;move space into w
        movwf INDF      ;move space into indirect file
        bsf POSITN,7    ;set upper bit of position
        clrf RSLINE     ;clear rsline for instruction send
        movf POSITN,W   ;move position to w
        call LCDOUT     ;set position on screen
        bsf RSLINE,4    ;set rsline for character send
        call PAUSIT     ;wait for lcd
        movf INDF,W     ;move indirect file to w
        call LCDOUT     ;show it on screen
        call PAUSIT     ;wait for lcd
        goto POSI1      ;go back to main program

CODER:  clrf ADDSUB     ;if coding text, clear addsub variable
        goto CDR        ;bypass next line
DC:     bsf ADDSUB,0    ;if decoding text, set bit zero of addsub
CDR:    call CLRLCD     ;clear screen
        call LINE1      ;get line 1
        movlw LETTER1   ;move letter 1 value into w
        movwf FSR       ;copy w into Indirect address reg
        movlw 40        ;move 40 into w
        movwf LOOP      ;move w into loop       
R:      movf INDF,W     ;moves w into indirect file
        call LCDOUT     ;print stored letter on lcd
        incf FSR,F      ;increments fsr
        decfsz LOOP,F   ;has loop reached zero?
        goto R          ;no, loop round
SEEIT:  call LINE2      ;get line 2
        clrf COMBI      ;clears combination variable
        clrf LOOP       ;clears loop counter
        movlw LETTER1   ;move address of LETTER1 into w
        movwf FSR       ;copy w into Indirect address reg
CODED1: clrf COUNT      ;clears count
        clrf CODE       ;clears code variable
        clrf COUNTER    ;clears counter variable
        bsf RSLINE,4    ;set RS for data send
CODED2: movf COMBI,W    ;get combination address
        call GETMEM     ;get eeprom value
        andlw %00001111 ;remove upper 4 bits to reduce value to 15
        movwf STORE     ;moves w to store variable
        movf STORE,W    ;
        addlw 246       ;checks to see if combination value >9
        btfsc STATUS,C  ;
        bcf STORE,3     ;yes, clear bit to reduce number less than 9
LP:     movf INDF,W     ;move indirect file into w
        xorlw %10000000 ;test to see if file contains a space
        btfsc STATUS,Z  ;a space denotes that the text has ended
        goto ASK        ;yes, go and wait for keys
        btfsc ADDSUB,0  ;test the zero bit of addsub
        goto DCODE      ;if zero is set then text needs decoding
        movf INDF,W     ;if zero is clear then text needs coding
        addwf STORE,W   ;adds letter ascii value to combination value
JUMP:   movwf CODE      ;move answer into code variable
UMP:    movlw 26        ;moves 26 into w
        movwf COUNTER   ;moves w into counter
START:  incf COUNTER,F  ;this routine tests for asci codes 27-38
        bcf CODE,6      ;clears upper bit of code
        movf COUNTER,W  ;moves counter into w
        xorlw 38        ;checks to see if value of 38 has occurred
        btfsc STATUS,Z  ;
        goto SEE        ;yes, lets see the character
        movf CODE,W     ;moves value of code variable into w
        xorwf COUNTER,W ;checks to see if counter value
        btfsc STATUS,Z  ;equals the code value
        goto NOKAK      ;yes, get rid of kak characters
        goto START      ;no, go round again
SEE:    bsf CODE,6      ;sets upper bit of code
        bcf CODE,5      ;clears bit 5 of code
        bcf CODE,7      ;clears bit 7 of code
        movf CODE,W     ;moves code value back into w
        call LCDOUT     ;shows coded value on 2nd line of lcd
        incf LOOP,W     ;increment loop
        xorlw 40        ;have all twenty letters been shown?
        btfsc STATUS,Z  ;
        goto ASK        ;yes, go test the keys again
        incf LOOP,F     ;no, increment loop
        incf COMBI,F    ;increment combination variable
        movf COMBI,W    ;move combination variable to w
        xorwf LENGTH,W  ;has the last numeral of the
        btfsc STATUS,Z  ;combination been used?
        clrf COMBI      ;yes, clear combination to beginning
        movf CODE,W     ;
        movwf INDF      ;
        incf FSR,F      ;increment FSR
        goto CODED1     ;go round again

NOKAK:  movf CODE,W     ;this routine gets rid of the duff characters
        addlw 6         ;adds 6 to w to get past kak characters
        xorlw 0         ;test to see if value is zero
        btfsc STATUS,Z  ;which is ASCI for @
        addlw 1         ;yes, add value of 1 to make code=A
        movwf CODE      ;no, move w back into code
        bsf CODE,6      ;set upper bit of code variable
        goto SEE        ;lets go and see it

DCODE:  movf STORE,W    ;this is a subtract routine to decode
        subwf INDF,W    ;subtract the combination value from indf
        movwf CODE      ;move answer into code variable
        btfsc CODE,5    ;test to see if subtraction is a minus value
        goto CARRY      ;yes, goto carry routine
        movf STORE,W    ;no, move combination variable into w
        subwf INDF,W    ;subtract the combination value from indf
        call TESTASC    ;go and test if ascii value=@
        movwf CODE      ;move final answer into code variable
        goto SEE        ;go back to main routine

CARRY:  movlw 6         ;this removes duff characters when decoding
        addwf STORE,F   ;add 6 to combination value
        movf STORE,W    ;move answer to w
        subwf INDF,W    ;subtract answer from indf
        call TESTASC    ;go and test if ascii value=@
        movwf CODE      ;no, move w back into code
        bsf CODE,4      ;set and clear upper bits of ascii code
        bcf CODE,7      ;
        goto SEE        ;go back to main routine

TESTASC: xorlw %01000000 ;test to see if value 
        btfsc STATUS,Z  ;equals the ascii for @
        movlw %01011010 ;yes, make value equal letter Z
        return          ;

ASK:    btfsc PORTA,0   ;has key 4 been pressed?
        goto ASKQUE1    ;yes, go and ask questions 
        btfsc PORTA,3   ;has key 1 been pressed?
        call SHIFTL     ;yes, shift screen left
        btfsc PORTA,2   ;has key 2 been pressed?
        call SHIFTR     ;yes, shift screen right
        goto ASK        ;loop round

ASKQUE1: call LINE1     ;this routine asks whether to code/decode
        call CURSHOME   ;
        clrf LOOP       ;loop=0
LO:     movf LOOP,W     ;moves loop into w
        call INSTR2     ;calls message letter
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;increment loop
        xorlw 20        ;have 20 characters been shown?
        btfsc STATUS,Z  ;
        call LINE2      ;yes, start on line 2
        incf LOOP,W     ;increment loop
        xorlw 40        ;tests to see if all
        btfsc STATUS,Z  ;letters have been shown
        goto WAIT2      ;yes, go to wait
        incf LOOP,F     ;no, increment loop 
        goto LO         ;and go round again

MATCH:  clrf LOOP       ;this routine shows screen 3
        call CLRLCD     ;clear screen
TXMESS: movf LOOP,W     ;moves loop into w
        call TXRX       ;calls message letter
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;increment loop
        xorlw 20        ;have 20 characters been shown?
        btfsc STATUS,Z  ;
        call LINE2      ;
        incf LOOP,W     ;
        xorlw 40        ;
        btfsc STATUS,Z  ;
        goto ASK3       ;yes, carry on
        incf LOOP,F     ;no, loop round
        goto TXMESS     ;     

ASK3:   btfsc PORTA,3   ;has key 3 been pressed?
        goto TXSIG      ;yes, go and save data
        btfsc PORTA,2   ;has key 2 been pressed?
        call RXSIG      ;yes, go and load data
        btfsc PORTA,1   ;has key 1 been pressed?
        goto COMBINA    ;yes, go change code
        goto ASK3       ;loop round

COMBINA: call CLRLCD     ;clear screen
        call LINE1      ;get line 1
        movlw %01111111 ;print text
        call LCDOUT     ;
        movlw '='       ;
        call LCDOUT     ;
CO:     movlw LETTER1   ;move letter 1 value into w
        movwf FSR       ;copy w into Indirect address reg
        movlw 8         ;move 8 into w
        movwf LOOP      ;move w into loop       
COM1:   movf INDF,W     ;moves w into indirect file
        call LCDOUT     ;print stored letter on lcd
        incf FSR,F      ;increments fsr
        decfsz LOOP,F   ;has loop reached zero?
        goto COM1       ;no, loop round
        clrf LOOP       ;
COM2:   movf LOOP,W     ;prints (new?)
        call COMTEXT    ;
        call LCDOUT     ;
        incf LOOP,W     ;
        xorlw 10        ;
        btfsc STATUS,Z  ;
        goto COM3       ;
        incf LOOP,F     ;
        goto COM2       ;
COM3:   call LINE2      ;get line 2
        movlw %01111110 ;prints text
        call LCDOUT     ;
        movlw '='       ;
        call LCDOUT     ;
        clrf LOOP       ;
COM4:   movf LOOP,W     ;this routine shows eeprom codeword
        call GETMEM     ;calls eeprom memory
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;
        xorlw 8         ;
        btfsc STATUS,Z  ;continue until all 8 letters are shown
        goto COM5       ;
        incf LOOP,F     ;
        goto COM4       ;loop round
COM5:   clrf LOOP       ;
COM6:   movf LOOP,W     ;prints (current)
        call COMTEXT2   ;
        call LCDOUT     ;
        incf LOOP,W     ;
        xorlw 10        ;
        btfsc STATUS,Z  ;
        goto ASK4       ;go and wait for key press
        incf LOOP,F     ;
        goto COM6       ;loop round

ASK4:   btfsc PORTA,2   ;has key 3 been pressed?
        goto DIRECT     ;yes, keep codeword the same as previous
        btfsc PORTA,3   ;has key 2 been pressed?
        goto EEPROM     ;yes, change codeword to new        
        goto ASK4       ;loop round

EEPROM: clrf LOOP       ;this routine alters the codeword in eeprom
        clrf STORE      ;
        movlw LETTER1   ;move letter 1 value into w
        movwf FSR       ;copy w into Indirect address register    
EEP:    movf INDF,W     ;moves indirect file into w
        movwf STORE     ;move w to store
        movf STORE,W    ;move store to w
        xorlw %10000000 ;check letter for a space
        btfsc STATUS,Z  ;
        call CL1        ;yes, store codeword length and set flag
EEP2:   movf LOOP,W     ;move loop to w
        call SETMEM     ;stores value in eeprom memory
        incf FSR,F      ;increments fsr
        incf LOOP,W     ;increment loop
        xorlw 9         ;checks to see if 9 has been reached
        btfsc STATUS,Z  ;
        goto CLENGTH    ;once all 8 letters are stored goto next routine
        incf LOOP,F     ;increment loop
        goto EEP        ;no, loop round

CL1:    btfsc ADDSUB,4  ;this routine stores codeword length
        return          ;if flag is already set then return
        movf LOOP,W     ;move loop to w
        movwf LENGTH    ;move w to length file
        bsf ADDSUB,4    ;set flag so that program knows that
        return          ;the codeword has already been stored

CLENGTH: btfss ADDSUB,4 ;if flag is set then codeword is set so skip next line
        call CL2        ;if not set make codeword length=8 
        movf LENGTH,W   ;move length to w
        movwf STORE     ;move w to store
        movlw 20        ;move 20 to w
        call SETMEM     ;stores length into eeprom
        bcf ADDSUB,4    ;clears flag
        goto DIRECT     ;return to screen 1

CL2:    movlw 8         ;makes codeword length=8
        movwf LENGTH    ;
        return          ;return

RXSIG:  movlw LETTER1   ;this routine sends save instruction to memory
        movwf FSR       ;copy w into Indirect address reg
        clrf COUNTER    ;move clear counter       
        call LOADMSG    ;show LOAD message
SETR:   call LINE1      ;start on line 1
        PAGE1           ;
        clrf TRISB      ;port B as outputs
        PAGE0           ;
        movlw %10000000 ;move receive instruction to w
        movwf PORTB     ;move it to port b
        call PAUSIT     ;wait for memory to receive
        call PAUSIT     ;wait
        PAGE1           ;
        movlw %11000000 ;port B bits 6,7 as inputs
        movwf TRISB     ;
        PAGE0           ;
        clrf PORTB      ;clear port B
MAT:    clrf COUNT      ;clear 8 bit store
        clrf CODE       ;clear data word file
        clrf ALPHA1     ;clear temp file
RX:     movlw 8         ;move 8 into w, denotes an 8 bit word   
        movwf COUNT     ;move w into word file
CLK:    btfsc PORTA,3   ;test for abort key
        goto ASKQUE1    ;abort
        movf PORTB,W    ;move port B to w
        movwf ALPHA1    ;move w to alpha file
        btfss ALPHA1,6  ;test for clock signal from matchbox
        goto CLK        ;clock not received loop around
        rlf CODE,F      ;clock received, rotate data file left
        btfsc ALPHA1,7  ;test for data being high or low
        bsf CODE,0      ;data is high, set code bit zero
        clrf ALPHA1     ;clear alpha file
        ;call PAUSIT    ;ONLY NEEDED IF DATA TRANSFER IS TOO FAST 
CL:     btfsc PORTB,6   ;test for clock signal going low
        goto CL         ;loop until it goes low
        decfsz COUNT,F  ;decrement count file
        goto CLK        ;loop until all 8 bits are received
        movf COUNTER,W  ;
        xorlw 0         ;check to see if it is the 1st character
        btfsc STATUS,Z  ;
        bcf CODE,7      ;if it is the 1st character then clear bit 7
        movf CODE,W     ;move result to w
        call LCDOUT     ;show letter on screen
        movf CODE,W     ;
        movwf INDF      ;moves code into indirect file
        ;bsf CODE,7     ;ONLY NEEDED IF TRANSFER IS TOO FAST FOR 1ST BIT
        movlw %10000000 ;test if letter is a space
        xorwf CODE,W    ;
        btfsc STATUS,Z  ;
        goto ASKQUE1    ;yes, finish loading and goto decode menu
        incf COUNTER,W  ;not a space, increment counter
        xorlw 20        ;
        btfsc STATUS,Z  ;check zero flag
        call LINE2      ;
        incf COUNTER,W  ;not a space, increment counter
        xorlw 40        ;have all 40 characters been sent?
        btfsc STATUS,Z  ;test zero flag
        goto RSTOP      ;yes, end LOAD routine
        incf COUNTER,F  ;no, increment count
        incf FSR,F      ;increment direct address
        goto MAT        ;no, loop round
RSTOP:  call CLRLCD     ;yes, clear lcd
        goto ASKQUE1    ;go to decode menu




TXSIG:  movlw LETTER1   ;move start address to w
        movwf FSR       ;copy w into Indirect address reg     
        call SAVEMSG    ;show SAVE message
        call LINE1      ;start on line 1
SETT:   PAGE1           ;
        clrf TRISB      ;port b outputs
        PAGE0           ;
        movlw %01000000 ;move transmit instruction to matchbox
        movwf PORTB     ;move it to port b
        call PAUSIT     ;
        clrf PORTB      ;clear port B
        PAGE1           ;
        movlw %01000000 ;
        movwf TRISB     ;port b outputs, except clock bit 6
        PAGE0           ;
        clrf PORTB      ;
        clrf COUNTER    ;clears 8 bit file
        clrf CODE       ;clears letter file
        clrf ALPHA1     ;clears temp file
        clrf COUNT      ;
TSTART: movlw 8         ;move 8 into w
        movwf COUNTER   ;word set up for 8 bits
        movf INDF,W     ;
        movwf CODE      ;
TDATA:  clrf PORTB      ;
        movf CODE,W     ;move code to w
        andlw %10000000 ;isolate bits 0 to 6
        movwf ALPHA1    ;move answer into temp
TCLK:   btfsc PORTA,3   ;test for abort signal
        goto ASKQUE1    ;abort
        btfss PORTB,6   ;test for clock signal from matchbox
        goto TCLK       ;clock not received loop around
        movf ALPHA1,W   ;clock received, send data bit to matchbox
        movwf PORTB     ;send data info
        rlf CODE,F      ;rotate code file left
        clrf ALPHA1     ;clear temp file
TCL:    btfsc PORTB,6   ;test for clock signal going low
        goto TCL        ;loop until it goes low
        decfsz COUNTER,F ;decrement word file
        goto TDATA      ;loop until all 8 bits are sent
        movf INDF,W     ;letter transmitted, show on screen
        call LCDOUT     ;
        movlw %10000000 ;test letter file being a space
        xorwf INDF,W    ;
        btfsc STATUS,Z  ;
        goto TSTOP      ;space transmitted, goto decode menu
        incf COUNT,W    ;not a space, increment counter
        xorlw 20        ;
        btfsc STATUS,Z  ;check zero flag
        call LINE2      ;
        incf COUNT,W    ;
        xorlw 40        ;have all 40 characters been sent?
        btfsc STATUS,Z  ;test zero flag
        goto TSTOP      ;yes, end save routine
        incf COUNT,F    ;no, increment count
        incf FSR,F      ;increment direct address
        goto TSTART     ;loop round

TSTOP:  clrf PORTB      ;clear port b
        PAGE1           ;
        movlw %11000000 ;port B bits 6 & 7 as input
        movwf TRISB     ;
        PAGE0           ;
        call CLRLCD     ;clear lcd
        goto ASKQUE1    ;go and wait for instructions


LOADMSG: call CLRLCD    ;show 'data transfer' message
        call LINE2      ;this routine transfers data
        clrf LOOP       ;loop=0
LMA:     movf LOOP,W     ;moves loop into w
        call TRANSL     ;calls message letter
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;increment loop
        xorlw 20        ;have 20 characters been shown?
        btfsc STATUS,Z  ;
        return          ;yes, carry on 
        incf LOOP,F     ;no, loop round
        goto LMA        ;

SAVEMSG: call CLRLCD    ;show 'data transfer' message
        call LINE2      ;this routine transfers data
        clrf LOOP       ;loop=0
SMA:    movf LOOP,W     ;moves loop into w
        call TRANSS     ;calls message letter
        call LCDOUT     ;shows it on screen
        incf LOOP,W     ;increment loop
        xorlw 20        ;have 20 characters been shown?
        btfsc STATUS,Z  ;
        return          ;yes, carry on 
        incf LOOP,F     ;no, loop round
        goto SMA        ;


CLRLCD: clrf RSLINE     ;clears RS line
        movlw %00000001 ;clear lcd instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        call PAUSIT     ;pause for lcd
        return          ;

SHIFTL: clrf RSLINE     ;clears RS line
        movlw %00011000 ;shift left instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        call PAUSIT     ;pause for lcd
        return          ;

SHIFTR: clrf RSLINE     ;clears RS line
        movlw %00011100 ;shift right instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        call PAUSIT     ;pause for lcd
        return          ;

CURSHOME: clrf RSLINE   ;clears RS line
        movlw %00000010 ;cursor home instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        call PAUSIT     ;pause for lcd
        return          ;

LINE1:  clrf RSLINE     ;line 1 routine
        movlw %10000000 ;line 1 instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        return          ;

LINE2:  clrf RSLINE     ;line 2 routine
        movlw %11000000 ;line 2 instruction
        call LCDOUT     ;gets line 2
        bsf RSLINE,4    ;set RS for data send
        return          ;

LCDOUT: movwf STORE     ;temp store data
        movlw 20        ;set minimum time between sending full bytes to
        movwf LOOPA     ;LCD - value of 20 seems OK for this prog with
DELAY:  decfsz LOOPA,F  ;XTAL clk of upto 5MHz, possibly 5.5MHz
        goto DELAY      ;keep decrementing LOOPA until zero
        call SENDIT     ;send MSB
        call SENDIT     ;send LSB
        return          ;

SENDIT: swapf STORE,F   ;swap data nibbles
        movf STORE,W    ;get data byte
        andlw 15        ;get nibble from byte (LSB)
        iorwf RSLINE,W  ;OR the RS bit
        movwf PORTB     ;output the byte
        bsf PORTB,5     ;set E line high
        bcf PORTB,5     ;set E line low
        return          ;

PAUSIT: movlw 5         ;set delay counter to 5
        movwf CLKCNT    ;(for 1/25th sec x 5)
        clrf INTCON     ;clear interupt flag
PAUSE:                  ;initial 1/5th sec wait before setting up LCD
        btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        bcf INTCON,2    ;yes
        decfsz CLKCNT,F ;dec counter, is it zero?
        goto PAUSE      ;no
        return          ;yes

                      ;eeprom memory routines

SETMEM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movf STORE,W    ;get data value from STORE and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
GETMEM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1           ;
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return


        .END            ;final line. This line must be retained.









