; GONG202.ASM 01NOV01 - EPE PIC MAGICK MUSICK - COPYRIGHT JOHN BECKER
; PIC16F84, 4.0MHz XTAL, WDT off, POR on 
; Written in TASM for TK2/TK3 assembly

	list	p=16F84,r=dec
        __config        h'3FF1'

#DEFINE PAGE0 BCF 3,5    
#DEFINE PAGE1 BSF 3,5    

INDF:     .EQU $00              
OPTION:   .EQU $01              
PCL:      .EQU $02              
STATUS:   .EQU $03              
FSR:      .EQU $04              
PORTA:    .EQU $05              
TRISA:    .EQU $05              
PORTB:    .EQU $06              
TRISB:    .EQU $06              
INTCON:   .EQU $0B
EEDATA:   .EQU $08
EECON1:   .EQU $08
EEADR:    .EQU $09
EECON2:   .EQU $09

COUNT0:   .EQU $0C             ; RECEIVE counter 0
COUNT1:   .EQU $0D             ; RECEIVE counter 1
LOOPB:    .EQU $0E             ; loop counter B
CLKCNT:   .EQU $0F             ; pre-counter for PAUSE
DELAY:    .EQU $10             ; masking delay
DAC:      .EQU $11             ; DAC value
VALUE:    .EQU $12             ; stored value of echo
PREVVAL   .EQU $13             ; previous VALUE
ASCEND:   .EQU $14             ; scale direction
PROMCNT:  .EQU $15             ; eeprom data access loop
STORE:    .EQU $16             ; temp store

          ; locations up to $3F are available

W:        .EQU 0
F:        .EQU 1                
C:        .EQU 0                
DC:       .EQU 1                
Z:        .EQU 2                
GIE:      .EQU 7               ; global interrupt bit
INTF:     .EQU 1               ; RB0 interrupt flag
WR:       .EQU 1  ;eeprom write initiate flag
WREN:     .EQU 2  ;eeprom write enable flag
RD:       .EQU 0  ;eeprom read enable flag

          .ORG $0004
          goto START
          .ORG $0005

START:   bcf INTCON,GIE        ;disable all interrupts
         btfsc INTCON,GIE      ;are all interrupts disabled?
         goto START            ;no, try again

         clrf PORTA
         clrf PORTB
         PAGE1
         movlw %00011111
         movwf TRISA           ;Port A0-A1 as output, A2-A4 as input 
         movlw %11100001
         movwf TRISB           ;Port B1-B4 as output, B0, B5-B7 as input
         movlw %10000101       ;set timer ratio 1:64, interrupt on falling edge of RB0/INT (bit 6 = 0)
         movwf OPTION          ;pull-ups off (bit 7 = 1)
         PAGE0

         btfsc PORTA,0
         goto STARTTX
         goto TONES

ROUTE2:  movf VALUE,W
         andlw 15
         addwf PCL,F
         goto BVL              ; not used
         goto CL               ; C   - ideal 130.813Hz
         goto DL               ; D   - ideal 146.832Hz
         goto EL               ; E   - ideal 164.814Hz
         goto FL               ; F   - ideal 174.615Hz
         goto GL               ; G   - ideal 195.998Hz
         goto AL               ; A   - ideal 220.000Hz
         goto BL               ; B   - ideal 246.941Hz

         goto C0               ; C   - ideal 261.625Hz
         goto D0               ; D   - ideal 293.664Hz
         goto E0               ; E   - ideal 329.627Hz
         goto F0               ; F   - ideal 349.229Hz
         goto G0               ; G   - ideal 391.995Hz
         goto A0               ; A   - ideal 440.000Hz
         goto B0               ; B   - ideal 493.883Hz
         goto C1               ; C1  - ideal 523.251Hz
                               ; C#  - ideal 277.182Hz
                               ; D#  - ideal 311.126Hz
                               ; F#  - ideal 369.994Hz
                               ; G#  - ideal 415.304Hz
                               ; A#  - ideal 466.163Hz
                                 
CHORDUP: rrf COUNT0,W
         andlw 7
         addwf PCL,F
         retlw 2
         retlw 6
         retlw 10
         retlw 16
         retlw 20
         retlw 24
         retlw 28
         retlw 30

CHORDUP2: movf COUNT0,W
         andlw 15
         addwf PCL,F
         retlw 0
         retlw 2
         retlw 2
         retlw 6
         retlw 6
         retlw 10
         retlw 10
         retlw 16
         retlw 16
         retlw 20
         retlw 20
         retlw 24
         retlw 24
         retlw 28
         retlw 28
         retlw 30
         retlw 30

LOOKUP:  movf STORE,W
         andlw 15
         addwf PCL,F
         retlw 0       ; 0
         retlw 6       ; 1  a
         retlw 7       ; 2  b
         retlw 1       ; 3  c
         retlw 2       ; 4  d
         retlw 3       ; 5  e
         retlw 4       ; 6  f
         retlw 5       ; 7  g

         retlw 15      ; 8  Top C
         retlw 13      ; 9  A
         retlw 14      ; 10 B
         retlw 8       ; 11 C
         retlw 9       ; 12 D
         retlw 10      ; 13 E
         retlw 11      ; 14 F
         retlw 12      ; 15 G

STARTTX: call PAUSIT
         call PAUSIT
         PAGE1
         movlw %00011100
         movwf TRISA           ;Port A0-A1 as output, A2-A4 as input 
         PAGE0

TXIT:    movlw 6
         movwf LOOPB           ;set transmission loop to 6
         clrf COUNT0           ;clear counters
         clrf COUNT1
         bsf PORTA,0
         bcf PORTA,1

BEAMIT:  nop                   ;send 40kHz signal
         nop                   ;command qty sets freq/mark-space
         nop
         nop
         nop
         nop
         nop
         movlw %00000010
         movwf PORTA
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         movlw %00000001
         movwf PORTA
         decfsz LOOPB,F
         goto BEAMIT
         clrf PORTA
         call RECEIVE
         call PAUSIT
         goto TXIT

RECEIVE: decfsz DELAY,F        ; masking wait for 256 cycles
         goto RECEIVE

         bcf INTCON,INTF       ;clear RB0 interrupt flag
LISTEN:  btfsc INTCON,INTF     ;has echo been heard? (interrupt on RB0)
         goto ENDECHO          ;yes
         incfsz COUNT0,F
         goto LISTEN
         incfsz COUNT1,F
         goto LISTEN

ENDECHO: bcf STATUS,C
         rrf COUNT1,F
         rrf COUNT0,F

         movf COUNT1,W          ; is the count1 = 0 ?
         btfss STATUS,Z         ;
         return                 ; no

         btfsc PORTA,3          ; yes, is S2 on?
         goto SCALE             ; yes

; finger notes section

         swapf COUNT0,W         ; no
         andlw 15
         movwf COUNT0   
         rlf COUNT0,W   
         andlw %00011110
         btfsc PORTA,2          ; is S1 on?
         call CHORDUP2          ; yes, limit finger notes to 1,3,5,8 etc
         movwf PORTB
         return

; ......... preset notes section

SCALE:   btfsc PORTA,2         ; is S1 on?
         goto PROMDATA         ; yes, get data from eeprom

         btfsc ASCEND,0
         goto SCALEUP
S2:      movlw 15
         movwf COUNT0

SCALE2:  rlf COUNT0,W
         andlw %00011110
         btfss PORTA,2
         goto S3
         btfsc ASCEND,1
         call CHORDUP

S3:      movwf PORTB
         call PAUSIT2
         decfsz COUNT0,F
         goto SCALE2
         incf ASCEND,F
         call PAUSIT2
         call PAUSIT2
         call PAUSIT2
         call PAUSIT2
         return

SCALEUP: clrf COUNT0
SCALEUP2: rlf COUNT0,W
         andlw %00011110
         btfsc ASCEND,1
         call CHORDUP

         movwf PORTB
         call PAUSIT2
         incf COUNT0,F
         btfss COUNT0,4
         goto SCALEUP2
         incf ASCEND,F
         call PAUSIT2
         call PAUSIT2
         call PAUSIT2
         call PAUSIT2
         return

PAUSIT:  movlw 8               ;delay set
         movwf CLKCNT          
         clrf INTCON
PAUSE:   btfss INTCON,2        ;has a timer time-out been detected?
         goto PAUSE            ;no
         bcf INTCON,2          ;yes
         decfsz CLKCNT,F       ;dec loop, is it zero?
         goto PAUSE            ;no
         return                ;yes

PAUSIT2: movlw 6               ;delay set
         movwf CLKCNT          
         clrf INTCON
PAUSE2:  btfss INTCON,2        ;has a timer time-out been detected?
         goto PAUSE2           ;no
         bcf INTCON,2          ;yes
         decfsz CLKCNT,F       ;dec loop, is it zero?
         goto PAUSE2            ;no
         return                ;yes

;.............

PROMDATA: clrf PROMCNT
PROM2:   movf PROMCNT,W
         call PRMGET
         andlw %00011110
         btfss STATUS,Z
         movwf PORTB
         btfss PORTA,2
         return
         btfss PORTA,3
         return
         call PAUSIT2
         call PAUSIT2
         call PAUSIT2
         incf PROMCNT,F
         btfss PROMCNT,6
         goto PROM2
         return


;********* 2ND PART OF SOFTWARE - FOR PIC 2 - TONE GENERATION
; NB command qty sets frequency. "Actual" refers to the prototype.


TONES:   call PAUSIT
         call PAUSIT
         clrf PORTB
         clrf DAC
         bcf PORTA,0
         PAGE1
         movlw %11111110
         movwf TRISA           ;Port A1-A4 as input, A0 as output 
         clrf TRISB            ;Port B as output
         PAGE0

TONE2:   nop
         goto ROUTE2
         call OUT2
         goto TONE2

BVL:    goto OUT2             ;0 - not used

CL:     movlw 35               ;1 C   - ideal 130.813Hz, actual 130
        movwf LOOPB
CLa:    decfsz LOOPB,F
        goto CLa
        goto OUTIT

DL:     movlw 29               ;2 D   - ideal 146.832Hz, actual 147
        movwf LOOPB
DLa:    decfsz LOOPB,F
        goto DLa
        nop
        nop
        nop
        nop
        goto OUTIT

EL:     movlw 26               ;3 E   - ideal 164.814Hz, actual 164
        movwf LOOPB
ELa:    decfsz LOOPB,F
        goto ELa
        nop
        nop
        goto OUTIT

FL:     movlw 24               ;4 F   - ideal 174.615Hz, actual 175
        movwf LOOPB
FLa:    decfsz LOOPB,F
        goto FLa
        nop
        nop
        goto OUTIT

GL:     movlw 21               ;5 G   - ideal 195.998Hz, actual 195
        movwf LOOPB
GLa:    decfsz LOOPB,F
        goto GLa
        nop
        nop
        goto OUTIT

AL:     movlw 18               ;6 A   - ideal 220.000Hz, actual 223
        movwf LOOPB
ALa:    decfsz LOOPB,F
        goto ALa
        nop
        goto OUTIT

BL:     movlw 16               ;7 B   - ideal 246.941Hz, actual 247
        movwf LOOPB
BLa:    decfsz LOOPB,F
        goto BLa
        goto OUTIT

C0:     movlw 14               ;8 C   - ideal 261.625Hz, actual 264
        movwf LOOPB
C0a:    decfsz LOOPB,F
        goto C0a
        nop
        nop
        goto OUTIT

D0:     movlw 12               ;9 D   - ideal 293.664Hz, actual 293
        movwf LOOPB
D0a:    decfsz LOOPB,F
        goto D0a
        nop
        nop
        goto OUTIT

E0:     movlw 10               ;10 E   - ideal 329.627Hz, actual 330
        movwf LOOPB
E0a:    decfsz LOOPB,F
        goto E0a
        nop
        nop
        goto OUTIT

F0:     movlw 9                ;11 F   - ideal 349.229Hz, actual 353
        movwf LOOPB
F0a:    decfsz LOOPB,F
        goto F0a
        nop
        nop
        goto OUTIT

G0:     movlw 8                 ;12 G   - ideal 391.995Hz, actual 398
        movwf LOOPB
G0a:    decfsz LOOPB,F
        goto G0a
        goto OUTIT

A0:     movlw 6                 ;13 A   - ideal 440.000Hz, actual 443
        movwf LOOPB
A0a:    decfsz LOOPB,F
        goto A0a
        nop
        nop
        goto OUTIT

B0:     movlw 5                 ;14 B   - ideal 493.883Hz, actual 500
        movwf LOOPB
B0a:    decfsz LOOPB,F
        goto B0a
        nop
        goto OUTIT

C1:     movlw 5                 ;15 C1  - ideal 523.251Hz, actual 534
        movwf LOOPB
C1a:    decfsz LOOPB,F
        goto C1a
        nop

OUTIT:  incfsz PORTB,F
        goto TONE2
        call OUT2

        bsf PORTB,7
        bsf PORTB,6
        goto TONE2

OUT2:   bcf PORTA,0
        rrf PORTA,W
        andlw %00001111
        btfsc STATUS,Z
        goto ZERO
        movwf COUNT0
        rrf COUNT0,F
        rlf VALUE,F
        rrf COUNT0,F
        rlf VALUE,F
        rrf COUNT0,F
        rlf VALUE,F
        rrf COUNT0,F
        rlf VALUE,F
        movf VALUE,W

        andlw 15
        movwf VALUE

        xorwf PREVVAL,W
        btfsc STATUS,Z
        return
        bsf PORTA,0
        movf VALUE,W
        movwf PREVVAL
        return

ZERO:   clrf PREVVAL
        return

;...............

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        movwf STORE
        btfss STORE,6   ; is character alpha?
        goto ENDPROM
        btfss STORE,5   ; is it lower case?
        bsf STORE,3
        call LOOKUP
        movwf STORE

ENDPROM: rlf STORE,W
        return          ;and return

        .END            ;final line. This line must be retained.
