; WATER40.ASM 22APR01 EPE Water Meter John Becker

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:   .EQU $00
OPTION: .EQU $01
PCL:    .EQU $02
STATUS: .EQU $03
FSR:    .EQU $04
PORTA:  .EQU $05
TRISA:  .EQU $05
PORTB:  .EQU $06
TRISB:  .EQU $06
EEDATA: .EQU $08
EECON1: .EQU $08
EEADR:  .EQU $09
EECON2: .EQU $09
INTCON: .EQU $0B

PRDMIN: .EQU $0C        ; ON duration mins
PRDHRS: .EQU $0D        ; ON duration hours
CLKSEC: .EQU $0E        ;CLOCK main counter - secs
CLKMIN: .EQU $0F        ;CLOCK - mins
CLKHRS: .EQU $10        ;CLOCK - hours
LITRE0: .EQU $11        ; litres count LSB
LITRE1: .EQU $12        ; litres count NMSB
LITRE2: .EQU $13        ; litres count MSB
TOTAL0: .EQU $14        ; running total cost of litres used LSB
TOTAL1: .EQU $15        ; running total cost of litres used NMSB
TOTAL2: .EQU $16        ; running total cost of litres used NMSB
TOTAL3: .EQU $17        ; running total cost of litres used MSB
PRICE0: .EQU $18        ; price per cubic metre LSB
PRICE1: .EQU $19        ; price per cubic metre NMSB
PRICE2: .EQU $1A        ; price per cubic metre MSB
PULSE:  .EQU $1B        ; pulse flag
LOOPB:  .EQU $1C        ; misc loop

STORE1: .EQU $1D        ; general store 1
STORE2: .EQU $1E        ; general store 2
LOOPA:  .EQU $1F        ; loop counter 2 - LCD use only
RSLINE: .EQU $20        ; RS line flag for LCD
SENS0:  .EQU $21        ; water sensor counter LSB
SENS1:  .EQU $22        ; water sensor counter MSB
DIGIT1: .EQU $23        ; decimal digit MSB
DIGIT2: .EQU $24        ; decimal digit
DIGIT3: .EQU $25        ; decimal digit
DIGIT4: .EQU $26        ; decimal digit
DIGIT5: .EQU $27        ; decimal digit
DIGIT6: .EQU $28        ; decimal digit
DIGIT7: .EQU $29        ; decimal digit
DIGIT8: .EQU $2A        ; decimal digit LSB
COUNTER1: .EQU $2B      ; counter used in decimal
COUNTER2: .EQU $2C      ; counter used in decimal
COUNT0: .EQU $2D        ; counter used in decimal
COUNT1: .EQU $2E        ; counter used in decimal
COUNT2: .EQU $2F        ; counter used in decimal
EVENT:  .EQU $30        ; flag for setting price digit
CELL0:  .EQU $31        ; flag for setting price asterisk
FLASH:  .EQU $32        ; asterisk flag
LOOP:   .EQU $33        ; loop counter 1 - general
CLKCNT: .EQU $34        ; pre-counter for CLOCK
TIMEON: .EQU $35        ; flag for whether external control needed

; max = $3F

W:      .EQU 0
F:      .EQU 1

C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2
WR:     .EQU 1  ;eeprom write initiate flag
WREN:   .EQU 2  ;eeprom write enable flag
RD:     .EQU 0  ;eeprom read enable flag

        .ORG 4
        goto 5
        .ORG 5

        clrf PORTA
        clrf PORTB
        PAGE1
        movlw %00011101
        movwf TRISA     ;Port A0, A2-A4 as input, A1 as output
        clrf TRISB      ;Port B0-B7 as output
        movlw %00000110 ;set timer ratio 1:128
        movwf OPTION
        PAGE0
        goto SETUP

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

CHKVAL: addwf PCL,F     ;table for max count for time values
        retlw %01011001 ;59 secs max
        retlw %01011001 ;59 mins max
        retlw %00100011 ;23 hours max

CELL:   movf EVENT,W
        ADDWF PCL,F     ;asterisk position for changing values
        retlw 0         ;0
        retlw 2         ;1
        retlw 10        ;2
        retlw 11        ;3
        retlw 12        ;4
        retlw 13        ;5
        retlw 15        ;6

SETPERIOD: ADDWF PCL,F  ;SET PERIOD message
        retlw '0'       ;0
        retlw 'm'       ;1
        retlw ' '       ;2
        retlw 'S'       ;3
        retlw 'E'       ;4
        retlw 'T'       ;5
        retlw ' '       ;6
        retlw 'P'       ;7 
        retlw 'E'       ;8 
        retlw 'R'       ;9 
        retlw 'I'       ;10
        retlw 'O'       ;11
        retlw 'D'       ;12

SETPRICE: ADDWF PCL,F   ;SET PRICE message
        retlw 'S'       ;0
        retlw 'E'       ;1
        retlw 'T'       ;2
        retlw ' '       ;3
        retlw 'P'       ;4
        retlw 'R'       ;5
        retlw 'I'       ;6
        retlw 'C'       ;7
        retlw 'E'       ;8

STORED: ADDWF PCL,F     ;STORED message
        retlw 'S'       ;0
        retlw 'T'       ;1
        retlw 'O'       ;2
        retlw 'R'       ;3
        retlw 'E'       ;4
        retlw 'D'       ;5
        retlw ' '       ;6
        retlw ' '       ;7
        retlw ' '       ;8

ENDIT:  ADDWF PCL,F     ;END    message
        retlw 'F'       ;0
        retlw 'I'       ;1
        retlw 'N'       ;2
        retlw 'I'       ;3
        retlw 'S'       ;4
        retlw 'H'       ;5
        retlw 'E'       ;6
        retlw 'D'       ;7

;.............

SETUP:  call PAUSIT     ;1st 1/5th sec delay
LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        call PAUSIT

        movlw $05       ; MSB +1 of $04B0 = 1200 decimal pulses per litre
        movwf SENS1
        movlw $B0       ; LSB of $04B0 = 1200 decimal pulses per litre
        movwf SENS0

        clrf EVENT
        clrf CELL0
        btfsc PORTA,2   ;is RESET called?
        call RESET      ;yes
        call GETDATA
        call CLRLN1
        call CLRLN2

        clrf CLKSEC
        clrf CLKMIN
        clrf CLKHRS
        movf PRDHRS,W
        andlw 15
        movwf PRDHRS
        movf PRDMIN,W
        andlw 15
        movwf PRDMIN

        movlw %10001001 ;
        call LCDLIN     ;set address
        movlw 'E'
        call LCDOUT
        movlw 'n'
        call LCDOUT
        movlw 'd'
        call LCDOUT

        movf PRDHRS,W
        iorwf PRDMIN,W
        movwf TIMEON
        btfss STATUS,Z
        goto TIMEIT

        movlw ' '
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw ' '
        call LCDOUT
        goto START

TIMEIT: movf PRDHRS,W
        iorlw 48
        call LCDOUT
        movlw ':'
        call LCDOUT
        movf PRDMIN,W
        iorlw 48
        call LCDOUT
        movlw '0'
        call LCDOUT

START:  bsf PORTA,1     ; turn on external connection if fitted

        movlw 25        ;initial basic CLKCNT val for secs timing
        movwf CLKCNT

INTRPT: movf PORTA,W
        andlw %00011100
        btfss STATUS,Z
        call SETFAX

        btfsc PORTA,0   ;test bit 0 of Port A, is it clear?
        goto TSTPRV     ;no, it's = 1 so go to TSTPRV
        bcf PULSE,0     ;clear bit 0 of PULSE
        goto INT3       ;jump back to INTCON check
TSTPRV: btfsc PULSE,0   ;test bit 0 of PULSE, is it clear?
        goto INT3       ;no, it's = 1 so jump back to INTCON check
INCLTR: bsf PULSE,0     ;set bit 0 of PULSE
        decfsz SENS0,F
        goto INT3
        decfsz SENS1,F
        goto INT3

        movlw $05       ; MSB + 1 of $04B0 = 1200 decimal pulses per litre
        movwf SENS1
        movlw $B0       ; LSB of $04B0 = 1200 decimal pulses per litre
        movwf SENS0

        incfsz LITRE0,F
        goto COSTIT
        incfsz LITRE1,F
        goto COSTIT
        incf LITRE2,F

COSTIT: movf PRICE0,W    ; add price LSB
        addwf TOTAL0,F
        btfss STATUS,C
        goto COST2
        incfsz TOTAL1,F
        GOTO COST2
        incfsz TOTAL2,F
        GOTO COST2
        incf TOTAL3,F

COST2:  movf PRICE1,W    ; add price NMSB
        addwf TOTAL1,F
        btfss STATUS,C
        goto COST3
        incfsz TOTAL2,F
        goto COST3
        incf TOTAL3,F

COST3:  movf PRICE2,W    ; add price MSB
        addwf TOTAL2,F
        btfss STATUS,C
        goto INT3
        incf TOTAL3,F

INT3:   btfss INTCON,2  ;has a timer time-out been detected?
        goto INTRPT     ;no
        BCF INTCON,2    ;yes
        call CLKADD     ;update time
        goto INTRPT

CLKADD: decfsz CLKCNT,F ;increment system clock counter. Is it = 0?
        RETURN          ;no

        movlw 25        ;yes, reset start value of CLKCNT
        movwf CLKCNT

        movlw CLKSEC    ;get address of CLKSEC
        movwf FSR       ;move it into Indirect address reg
        movlw 3         ;set loop for 3
        movwf LOOP
        clrf STORE1     ;clear STORE1 (table address counter)

ADDCLK: incf INDF,F     ;inc time units - all in BCD, via Indirect reg,
                        ;byte accessed depends on loop value
        movlw 6         ;check units >9
        addwf INDF,W    ;if 6 is added is there a digit carry?
        btfsc STATUS,DC
        movwf INDF      ;yes, store new value
ADDCL2: movf STORE1,W   ;now check if value > allowed value
        call CHKVAL     ;get max val for time byte
        movwf STORE2    ;temp store it
        movf INDF,W     ;get value now in time byte
        subwf STORE2,F  ;is count =<  than allowed?
                        ;(subtract time byte from max val in STORE)
        btfsc STATUS,C  ;is Carry bit set
        goto CLKSHW     ;yes
        clrf INDF       ;no, so time val is greater than max, so clear it
        incf STORE1,F   ;and add 1 to max val loop
        incf FSR,F      ;inc indirect address by 1 byte
        decfsz LOOP,F   ;dec loop, is it zero?
        goto ADDCLK     ;no, so repeat for next time byte

CLKSHW: movlw %10000000 ;show time
        call LCDLIN     ;set address for line 1 (address 0)
        movf CLKHRS,W   ;get hrs
        call LCDFRM     ;format and sent it to LCD
        movlw ':'       ;colon
        call LCDOUT     ;send to LCD
        movf CLKMIN,W   ;get mins
        call LCDFRM     ;format and send to LCD
        movlw '.'       ;decimal point
        call LCDOUT     ;send to LCD
        movf CLKSEC,W   ;get secs
        call LCDFRM     ;format and send to LCD

LTRSHW: movf LITRE0,W
        movwf COUNT0
        movf LITRE1,W
        movwf COUNT1
        movf LITRE2,W
        movwf COUNT2
        call DECIML

        movlw %11000000 ;show litres
        call LCDLIN     ;set address for line 2 (address 0)
        movf DIGIT5,W
        iorlw 48
        call LCDOUT
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movf DIGIT2,W
        iorlw 48
        call LCDOUT
        movf DIGIT1,W
        iorlw 48
        call LCDOUT
        movlw 'L'
        call LCDOUT

CSTSHW: movf TOTAL0,W
        movwf COUNT0
        movf TOTAL1,W
        movwf COUNT1
        movf TOTAL2,W
        movwf COUNT2
        call DECIML

        movlw %11001000 ;show total cost
        call LCDLIN     ;set address
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movf DIGIT7,W
        iorlw 48
        call LCDOUT
        movlw ':'
        call LCDOUT

        movf DIGIT6,W
        iorlw 48
        call LCDOUT
        movf DIGIT5,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT

        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movlw 'T'
        call LCDOUT

        movf TIMEON,W   ; is switch off monitoring needed?
        btfsc STATUS,Z
        return          ; no

        movf CLKHRS,W   ; yes
        andlw 15
        xorwf PRDHRS,W
        btfss STATUS,Z
        return

        swapf CLKMIN,W  ; has switch off time arrived?
        andlw 15
        xorwf PRDMIN,W
        btfss STATUS,Z
        return
        goto ENDALL     ; yes

LCDFRM: movwf STORE2    ;split & format decimal byte for LCD
        swapf STORE2,W  ;swap byte into W to get tens
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value
        call LCDOUT     ;send to LCD
        movf STORE2,W   ;get units
        andlw 15        ;AND to get nibble
        iorlw 48        ;OR with 48 to make ASCII value

LCDOUT: movwf STORE1    ;temp store value that will be output to LCD
        movlw 50        ;set minimum time between sending full bytes to
        movwf LOOPA     ;LCD - value of 50 seems OK for this prog with
DELAY:  decfsz LOOPA,F  ;XTAL clk of upto 5MHz, possibly 5.5MHz
        goto DELAY
        call SENDIT     ;send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ;swap byte nibbles
        movf STORE1,W   ;get nibble (MSB)
        andlw 15        ;AND to isolate nibble
        iorwf RSLINE,W  ;OR the RS bit
        movwf PORTB     ;output the byte
        BSF PORTB,5     ;set E high
        BCF PORTB,5     ;set E low
        return

LCDLIN: BCF RSLINE,4    ;sets LCD command/line
        call LCDOUT     ;and outputs cmmand code to LCD
        BSF RSLINE,4    ;set RS flag
        return

PAUSIT: movlw 5         ;1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ;clear interupt flag
PAUSE:                  ;initial 1/5th sec wait before setting up LCD
        btfss INTCON,2  ;has a timer time-out been detected?
        goto PAUSE      ;no
        BCF INTCON,2    ;yes
        decfsz CLKCNT,F ;dec loop, is it zero?
        goto PAUSE      ;no
        return          ;yes


;............. Modified BIN-DEC ROUTINE from Peter Hemsley 07JUN00
;              converts 24-bit binary (3 bytes) to decimal

DECIML:                   ;decimalise binary number
                          ;on entry COUNT0-2 holds number to be decimalised
                          ;answer goes into DIGIT1-8

        call BINDEC
        call BLANK0       ;blank leading zeros
        return

BINDEC: call CLRDIG       ;reset DIGITs
        movlw 24          ;24 bits to do
        movwf COUNTER1
        goto SHIFT1

ADJBCD  movlw DIGIT1
        movwf FSR         ;pointer to digits
        movlw 7           ;7 digits to do (Digit 8 never >4)
        movwf COUNTER2    ;if Digit > 4 then digit = digit + 3
        movlw 3           ;check for Digit > 4 by adding 3 to it
ADJLOOP: addwf INDF,F     ;and test bit 3 of result
        btfss INDF,3      ;is it greater than 7?
        subwf INDF,F      ;restore to original
        incf FSR,F        ;next digit
        decfsz COUNTER2,F
        goto ADJLOOP

SHIFT1: call SLCNT        ;shift MSB into Carry

SLDEC:  movlw DIGIT1      ;shift Carry and Digits 1 bit left
        movwf FSR         ;pointer to digits
        movlw 8           ;8 Digits to do
        movwf COUNTER2

SLDLOOP:                  ;after RLF if bit 4 is set then shift 1
        rlf INDF,F        ;into LSB of next Digit else shift 0
        btfsc INDF,4      ;test for BCD carry
        bsf STATUS,C      ;set Carry for next Digit (cleared by RLF)
        bcf INDF,4        ;clear BCD overflow (if any)
        incf FSR,F        ;next Digit
        decfsz COUNTER2,F
        goto SLDLOOP

        decfsz COUNTER1,F ;next bit
        goto ADJBCD
        return

SLCNT:  rlf COUNT0,F      ;LSB
        rlf COUNT1,F      ;shift left count 0-2
        rlf COUNT2,F      ;MSB
        return

CLRDIG: clrf DIGIT1       ;lsd
        clrf DIGIT2
        clrf DIGIT3
        clrf DIGIT4
        clrf DIGIT5
        clrf DIGIT6
        clrf DIGIT7
        clrf DIGIT8       ;msd
        return

BLANK0: movlw 8
        movwf LOOPA
        movlw DIGIT8
        movwf FSR
BLANK1: movf INDF,W
        btfss STATUS,Z
        goto BLANK2
        movlw ' '
        movwf INDF
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK1
        movlw 48
        iorwf DIGIT1,F
        return

BLANK2: movlw 48
        iorwf INDF,F
        decf FSR,F
        decfsz LOOPA,F
        goto BLANK2
        return

;............

LCDPX1: iorlw %10000000
        goto LCDLIN
LCDPX2: iorlw %11000000
        goto LCDLIN

GETDATA: movlw 18
        movwf LOOPA
        clrf LOOPB
        movlw PRDMIN
        movwf FSR
PRIME:  movf LOOPB,W    ;get primary data from EEPROM
        call PRMGET
        movwf INDF
        incf FSR,F
        incf LOOPB,F
        decfsz LOOPA,F
        goto PRIME
        return

;...............

;WRITE DATA TO EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;..........

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1           ;
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return

;...............

CLRLN1: movlw 0           ;clear LCD line 1
        call LCDPX1
        goto CLRLIN
CLRLN2: movlw 0           ;clear LCD line 2
        call LCDPX2
CLRLIN: movlw 16
        movwf LOOPB
CLRA:   movlw ' '
        call LCDOUT
        decfsz LOOPB,F
        goto CLRA
        return

;..............

SETFAX: clrf LOOPB        ;sets full variable data into EEPROM
        movlw PRDMIN
        movwf FSR
SETFX2: movf INDF,W
        movwf STORE1
        movf LOOPB,W
        call SETPRM
        incf LOOPB,F
        incf FSR,F
        movf LOOPB,W
        xorlw 16
        btfss STATUS,Z
        goto SETFX2
        movlw 0
        call LCDPX1
        clrf LOOPB

SETFX3: movf LOOPB,W
        call STORED     ;show STORED message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 9
        btfss STATUS,Z
        goto SETFX3
        call PAUSIT
        call PAUSIT
        call PAUSIT
        movlw 25
        movwf CLKCNT
        return

RESET:  clrf LOOPB        ;clear all facts except price and period
        movlw CLKSEC
        movwf FSR
RESET2: clrf INDF
        incf LOOPB,F
        incf FSR,F
        movf LOOPB,W
        xorlw 10
        btfss STATUS,Z
        goto RESET2
        clrf PULSE

        call CLRLN2

        movlw 0
        call LCDPX1
        movf PRDHRS,W
        iorlw 48
        call LCDOUT
        movlw 'h'
        call LCDOUT
        movf PRDMIN,W
        iorlw 48
        call LCDOUT

        clrf LOOPB
SETIT:  movf LOOPB,W
        call SETPERIOD  ;show SET PERIOD message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 13
        btfss STATUS,Z
        goto SETIT

        movlw PRDHRS
        movwf FSR
INCPRD: movlw 0
        call LCDPX2
        movlw ' '
        call LCDOUT

        movf EVENT,W
        xorlw 2
        btfss STATUS,Z
        goto INCP2
WAITP:  btfsc PORTA,2
        goto WAITP
        goto SETPR

INCP2:  call CELL
        movwf CELL0
        call LCDPX2
        movlw '*'
        call LCDOUT

        movlw 12
        movwf CLKCNT

WAITP1: call INCCLK
        btfsc PORTA,2
        goto WAITP1

WAITP2: call INCCLK
        btfss PORTA,2
        goto WAITP2
        decf FSR,F
        incf EVENT,F
        goto INCPRD

;...........

SETPR:  call CLRLN1
        call CLRLN2
        movlw 0
        call LCDPX1
        clrf LOOPB
SETIT2: movf LOOPB,W
        call SETPRICE   ;show SET PRICE message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 9
        btfss STATUS,Z
        goto SETIT2

        call PRICES
        movlw DIGIT4
        movwf FSR

INCVNT: call CELL
        movwf CELL0
        call LCDPX2
        movlw ' '
        call LCDOUT

        incf EVENT,F
        movf EVENT,W
        xorlw 7
        btfss STATUS,Z
        goto INCV2
        call BCDBIN
        call SETFAX
WAITX:  btfsc PORTA,2
        goto WAITX
        return

INCV2:  call CELL
        movwf CELL0
        call LCDPX2
        movlw '*'
        call LCDOUT

        movlw 12
        movwf CLKCNT

WAITR:  call INCCLK
        btfsc PORTA,2
        goto WAITR

WAIT2:  call INCCLK
        btfss PORTA,2
        goto WAIT2
        decf FSR,F
        goto INCVNT

;............

PRICES: movf PRICE0,W
        movwf COUNT0
        movf PRICE1,W
        movwf COUNT1
        movf PRICE2,W
        movwf COUNT2
        call DECIML

PRICEX: movlw %10001011 ;show prices per cubic metre
        call LCDLIN     ;set address
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movf DIGIT3,W
        iorlw 48
        call LCDOUT
        movf DIGIT2,W
        iorlw 48
        call LCDOUT
        movlw '.'       ;decimal point
        call LCDOUT     ;send to LCD
        movf DIGIT1,W
        iorlw 48
        call LCDOUT
        return

INCCLK: btfss INTCON,2  ;has a timer time-out been detected?
        goto INCCLK     ;no
        bcf INTCON,2    ;yes
        decfsz CLKCNT,F ;increment system clock counter. Is it = 0?
        goto INCCLK     ;no

        movlw 12        ;yes, reset start value of CLKCNT
        movwf CLKCNT

INCFL:  incf FLASH,F
        bcf FLASH,1

        movf EVENT,F
        movf CELL0,W
        call LCDPX2
        movlw '*'
        btfss FLASH,0
        movlw ' '
        call LCDOUT
        btfsc PORTA,2
        return

INCIT:  btfss PORTA,3
        goto DECIT
        incf INDF,F        ;increment routine
        movf INDF,W
        addlw 6
        btfsc STATUS,DC
        clrf INDF
        goto SHWIT

DECIT:  btfss PORTA,4
        return
        movlw 1            ;decrement routine
        subwf INDF,F
        btfsc STATUS,DC
        goto SHWIT
        movlw 9
        movwf INDF
SHWIT:  movf EVENT,W
        andlw %11111110
        btfsc STATUS,Z
        goto SHW1
        call PRICEX
        return

SHW1:   movlw %10000000 ;show period
        call LCDLIN     ;set address

        movf PRDMIN,W
        xorlw 6
        btfss STATUS,Z
        goto SHW2
        clrf PRDMIN
        goto SHW3

SHW2:   movf PRDMIN,W
        xorlw 9
        btfss STATUS,Z
        goto SHW3
        movlw 5
        movwf PRDMIN

SHW3:   movf PRDHRS,W
        iorlw 48
        call LCDOUT
        movlw 'h'
        call LCDOUT
        movf PRDMIN,W
        iorlw 48
        call LCDOUT
        return

BCDBIN: clrf PRICE0
        clrf PRICE1
        clrf PRICE2
        movf DIGIT4,W
        andlw 15
        btfsc STATUS,Z
        goto BCD3
        movwf LOOPA
        movlw $03        ; 1000's
        movwf STORE2
        movlw $E8
        movwf STORE1
        call ADDIT

BCD3:   movf DIGIT3,W
        andlw 15
        btfsc STATUS,Z
        goto BCD2
        movwf LOOPA
        clrf STORE2
        movlw 100        ; 100's
        movwf STORE1
        call ADDIT

BCD2:   movf DIGIT2,W
        andlw 15
        btfsc STATUS,Z
        goto BCD1
        movwf LOOPA
        clrf STORE2
        movlw 10         ; 10's
        movwf STORE1
        call ADDIT

BCD1:   movf DIGIT1,W
        andlw 15
        btfsc STATUS,Z
        goto BCD0
        movwf LOOPA
        clrf STORE2
        movlw 1          ; 1's
        movwf STORE1
        call ADDIT
        nop
BCD0:   call PRICES
        return

ADDIT:  movf STORE1,W
        addwf PRICE0,F
        btfsc STATUS,C
        incfsz PRICE1,F
        goto ADD2
        incf PRICE2,F

ADD2:   movf STORE2,W
        addwf PRICE1,F
        btfsc STATUS,C
        incf PRICE2,F
        decfsz LOOPA,F
        goto ADDIT
        return

ENDALL: call SETFAX
        movlw 8
        call LCDPX1
        clrf LOOPB
END2:   movf LOOPB,W
        call ENDIT      ;show END message
        call LCDOUT
        incf LOOPB,F
        movf LOOPB,W
        xorlw 8
        btfss STATUS,Z
        goto END2
        bcf PORTA,1     ; turn off external connection if fitted

END3:   goto END3

        .END            ;Final command



