// driver functions for RTC chip. PCF8583.

//which pins are we going to use?
#ifndef RTC_SDA
#define RTC_SDA  PIN_A5
#define RTC_SCL  PIN_A3
#endif

#use i2c(master,sda=RTC_SDA, scl=RTC_SCL)

// **********************************************************************************
// Memory location write function
void write_rtc(byte address, byte data) 
{
 disable_interrupts(GLOBAL);
 i2c_start();		//I2C Start
 i2c_write(0xa0);	//Chip Address
 i2c_write(address);	//Memory location
 i2c_write(data);	//Data
 i2c_stop();		//I2C Stop
 enable_interrupts(GLOBAL);
 return;
}
// **********************************************************************************
// Memory location read function.
byte read_rtc(byte address) 
{
 byte data;

 disable_interrupts(GLOBAL);
 i2c_start();		//I2C Start
 i2c_write(0xa0);	//Chip address
 i2c_write(address);	//Memory location
 i2c_start();		//I2C Start
 i2c_write(0xa1);	//Read function
 data=i2c_read(0);	//Read 8 bits of data
 i2c_stop();		//I2C Stop
 enable_interrupts(GLOBAL);
 return(data);		//Return with data
}
// **********************************************************************************
// Initialise RTC
void rtc_init() 
{
 output_float(rtc_scl);	//Ensure SCL high
 output_float(rtc_sda);	//Ensure SDA high
 write_rtc(0,0);	//Setup status register
 return;
}
// **********************************************************************************
void rtc_set_datetime(byte day,byte mth,byte year,byte dow,byte hr,byte min) 
{
 int var=0;
//write Year to RAM location
 write_rtc(0x10,year);

//write Year and Day
 write_rtc(0x10,year);
 var=year&0x03;
 write_rtc(0x11,var);
 year=var<<6;
 var=day&0x3F;
 day=year+var;
 write_rtc(0x05,day);

//write Day of week and month
 dow=(dow-1)<<5;
 mth=(mth&0x1F)+dow;
 write_rtc(0x06,mth);
//write hour
 write_rtc(0x04,hr);
//write minute
 write_rtc(0x03,min);
//clear seconds and tenths of seconds
 write_rtc(0x02,0x00);
 write_rtc(0x01,0);
 return;
}
// **********************************************************************************
void rtc_get_date(byte & day,byte & mth,byte & year,byte & dow) 
{
 int var_l=0,var_h=0;
 day  = read_rtc(0x05)&0x3F;
 mth  = read_rtc(0x06)&0x1F;
 //format years. Chip only counts 4 years so hold year in ram 0x10
 // detect year change by comparing with ram 0x11
 year = (read_rtc(0x05)&0xC0)>>6;

 flag=read_rtc(0x11);
 if(year!=flag)
  {flag=year;
   var_l=read_rtc(0x10);
   var_l++;
   if((var_l&0xf)>9)
    {
     var_l=var_l&0xF0;
     var_l=var_l+0x10;
    }
   write_rtc(0x10,var_l);
   write_rtc(0x11,flag);
  }
 year =read_rtc(0x10);

 //format day of weeks
 dow  = (read_rtc(0x06)&0xE0)>>5;
 dow  = dow+1;
 return;
}
// **********************************************************************************
void rtc_get_time(byte & hr,byte & min,byte & sec) 
{
 hr  = read_rtc(0x04)&0x3F;
 min = read_rtc(0x03);
 sec = read_rtc(0x02);
 return;
}
// **********************************************************************************
