;Tophat LED sequencer
;For PIC16C84/PIC16F84
;Andy Flind, 22/8/00
;Oscillator: RC
;Watchdog: OFF
;Startup timer: ON

#DEFINE page0 BCF status,5              
#DEFINE page1 BSF status,5              
		
status: .EQU $03        ;general equates
portA:  .EQU $05        
trisA:  .EQU $05        
portB:  .EQU $06        
trisB:  .EQU $06        
pcl:    .EQU $02        
rtcc:   .EQU $01        
option: .EQU $01        
intcon: .EQU $0B        
f:      .EQU $01        
w:      .EQU $00        
z:      .EQU $02        
c:      .EQU $00                
reps:   .EQU $0C      ;program specific equates
rate:   .EQU $0D
ctr1:   .EQU $0E

	.org $0004    ;interrupt vector
	.org $0005    ;start of program

	page1         ;initialise for operation             
	clrf trisA    ;portA all output
	clrf trisB    ;portB all output
	page0
	clrf portA    ;all leds off
	clrf portB
	
main:   call fl3        ;sequence of        
	call sp3        ;patterns to
	call sp4        ;be executed
	call fl1
	call fl2
	call fl1
	call ro1
	call ro2
	call fl3
	call fl5
	call fl8
	call fl3
	call ro3
	call ro6
	call fl3
	call ro4
	call fl1
	call fl2
	call fl1
	call sp1
	call sp2
	call fl3
	call sp3
	call sp4
	call fl7
	call ro1
	call ro4 
	call fl3
	call fl4
	call ro2
	call ro5

	goto main       ;and do it all again
      
fl1:    movlw 5         ;number of loops
	movwf reps
	movlw 28        ;speed, higher = slower
	movwf rate
fl1r:   movlw 255      
	movwf portB
	movwf portA     ;all LEDs on
	call dly
	clrf portB     
	clrf portA      ;all LEDs off
	call dly
	decfsz reps,f   ;routine complete?
	goto fl1r       ;no, so do again
	return

fl2:    movlw 15        ;same as fl1, but more
	movwf reps      ;reps and faster
	movlw 10
	movwf rate
fl2r:   movlw 255
	movwf portB
	movwf portA
	call dly
	clrf portB
	clrf portA
	call dly
	decfsz reps,f
	goto fl2r
	return

fl3:    movlw 15        ;set up for
	movwf reps      ;rising speed
	movlw 34        ;more than twice 'reps'
	movwf rate      ;as two steps used per rep
rise:   movlw 255
	movwf portA
	movwf portB     ;all on
	call dly
	clrf portA
	clrf portB      ;all off
	call dly
	decf rate,f     ;shorten delay
	decf rate,f     ;by two steps
	decfsz reps,f   ;done?
	goto rise       ;no, do again
	movlw 15        ;set up for
	movwf reps      ;falling speed
fall:   movlw 255
	movwf portA
	movwf portB     ;all on
	call dly
	clrf portA
	clrf portB      ;all off
	call dly
	incf rate,f     ;lengthen delay
	incf rate,f     ;by two steps
	decfsz reps,f   ;all done?
	goto fall       ;no, do again
	return

fl4:    movlw 15
	movwf reps
	movlw 30
	movwf rate
fl4r:   movlw %01010101
	movwf portA
	movwf portB     ;alternate LEDs on
	call dly
	movlw %10101010
	movwf portA
	movwf portB     ;other alternate LEDs on
	call dly
	decfsz reps,f
	goto fl4r
	return

fl5:    movlw 18
	movwf reps
	movlw 28
	movwf rate
fl5r:   movlw %00001111
	movwf portB
	clrf portA      ;first group of four on
	call dly
	movlw %11110000
	movwf portB     ;second group of four on
	call dly                               
	clrf portB
	movlw %00001111 ;third group of four on
	movwf portA
	call dly
	decfsz reps,f
	goto fl5r
	return

fl6:    movlw 10
	movwf reps
	movlw 25
	movwf rate
fl6r:   movlw %00110011
	movwf portB
	movlw %00000011
	movwf portA     ;set up first pattern
	call dly
	movlw %11001100
	movwf portB
	movlw %00001100
	movwf portA     ;set up second pattern
	call dly
	decfsz reps,f
	goto fl6r
	return

fl7:    movlw 12
	movwf reps
	movlw 30
	movwf rate
fl7r:   movlw %00111111
	movwf portB
	movlw %00000000
	movwf portA     ;first pattern
	call dly
	movlw %11000000
	movwf portB
	movlw %00001111
	movwf portA     ;second pattern
	call dly
	decfsz reps,f
	goto fl7r
	return

fl8:    movlw 8
	movwf reps
	movlw 25
	movwf rate
fl8r:   movlw %00111111
	movwf portB
	movlw %00000000
	movwf portA     ;first pattern
	call dly
	movlw %11111000
	movwf portB
	movlw %00000001
	movwf portA     ;second pattern
	call dly
	movlw %11000000
	movwf portB
	movlw %00001111
	movwf portA     ;third pattern               
	call dly
	movlw %00000111
	movwf portB
	movlw %00001110
	movwf portA     ;fourth pattern
	call dly
	decfsz reps,f
	goto fl8r
	return

ro1:    movlw 48        ;12 reps per rotation
	movwf reps      ;of pattern
	movlw 10        ;speed of rotation
	movwf rate      ;(higher = lower speed)
	movlw %11000111 
	movwf portB
	movlw %00000001
	movwf portA     ;starting pattern
ro1r:   bcf status,c    ;clockwise rotation routine    
	btfsc portA,3
	bsf status,c
	rlf portB,f
	rlf portA,f     ;end of rotation routine
	call dly
	decfsz reps,f
	goto ro1r
	return

ro2:    movlw 60        ;as ro1, but different pattern
	movwf reps
	movlw 12
	movwf rate
	movlw %01000100
	movwf portB
	movlw %00000100
	movwf portA
ro2r:   bcf status,c        
	btfsc portA,3
	bsf status,c
	rlf portB,f
	rlf portA,f
	call dly
	decfsz reps,f
	goto ro2r
	return

ro3:    movlw 48        ;as 1, different pattern
	movwf reps
	movlw 15
	movwf rate
	movlw %00111111
	movwf portB
	movlw %00000000
	movwf portA
ro3r:   bcf status,c        
	btfsc portA,3
	bsf status,c
	rlf portB,f
	rlf portA,f
	call dly
	decfsz reps,f
	goto ro3r
	return

ro4:    movlw 60
	movwf reps
	movlw 14
	movwf rate
	movlw %11000111
	movwf portB
	movlw %00000001
	movwf portA     ;enter pattern
ro4r:   rrf portA,f     ;start of anti-clock
	rrf portB,f     ;rotation routine
	bcf portA,3
	btfsc status,c
	bsf portA,3     ;end of anti-clock routine
	call dly
	decfsz reps,f
	goto ro4r
	return

ro5:    movlw 60        ;as ro4, different pattern
	movwf reps
	movlw 13
	movwf rate
	movlw %01000100
	movwf portB
	movlw %00000100
	movwf portA
ro5r:   rrf portA,f
	rrf portB,f
	bcf portA,3
	btfsc status,c
	bsf portA,3
	call dly
	decfsz reps,f
	goto ro5r
	return

ro6:    movlw 48        ;as r04,5, different pattern
	movwf reps
	movlw 15
	movwf rate
	movlw %00111111
	movwf portB
	movlw %00000000
	movwf portA
ro6r:   rrf portA,f
	rrf portB,f
	bcf portA,3
	btfsc status,c
	bsf portA,3
	call dly
	decfsz reps,f
	goto ro6r
	return

sp1:    movlw 5
	movwf reps
	movlw 15
	movwf rate
	clrf portA
	clrf portB      ;all off
sp1r:   bsf portB,0
	bsf portA,3     ;first two on
	call dly
	bsf portB,1
	bsf portA,2     ;second two on
	call dly
	bsf portB,2
	bsf portA,1     ;third pair on
	call dly
	bsf portB,3
	bsf portA,0     ;fourth pair on
	call dly
	movlw %10011111 ;pattern to turn on next two
	movwf portB
	call dly
	movlw 255       ;last two -all portB now on
	movwf portB
	call dly
	bcf portB,0
	bcf portA,3     ;first two off
	call dly
	bcf portB,1
	bcf portA,2     ;second two off
	call dly
	bcf portB,2
	bcf portA,1     ;third two off
	call dly
	bcf portB,3
	clrf portA      ;fourth two, all portA now off
	call dly
	movlw %01100000 ;pattern for next two off
	movwf portB
	call dly
	clrf portB      ;last two off, all portB now off
	call dly
	decfsz reps,f
	goto sp1r
	return

sp2:    movlw 5         ;same principle as sp1
	movwf reps      ;but different pattern sequence
	movlw 15
	movwf rate
	clrf portA
	clrf portB
sp2r:   movlw %01100000
	movwf portB
	call dly
	movlw %11110000
	movwf portB
	call dly
	bsf portB,3
	bsf portA,0
	call dly
	bsf portB,2
	bsf portA,1
	call dly
	bsf portB,1
	bsf portA,2
	call dly
	bsf portB,0
	bsf portA,3
	call dly
	bcf portB,0
	bcf portA,3
	call dly
	bcf portB,1
	bcf portA,2
	call dly
	bcf portB,2
	bcf portA,1
	call dly
	bcf portB,3
	clrf portA
	call dly
	movlw %01100000
	movwf portB
	call dly
	clrf portB
	call dly        
	decfsz reps,f
	goto sp2r
	return

sp3:    movlw 7         ;creates improved rotation
	movwf reps      ;effect using different
	movlw 3         ;sequence to the rotation
	movwf rate      ;patterns
	clrf portA      ;apparent motion is clockwise
	clrf portB
sp3r:   bsf portB,0
	call dly
	bcf portA,1
	call dly
	bsf portB,1
	call dly
	bcf portA,2
	call dly
	bsf portB,2
	call dly
	bcf portA,3
	call dly
	bsf portB,3
	call dly
	bcf portB,0
	call dly
	bsf portB,4
	call dly
	bcf portB,1
	call dly
	bsf portB,5
	call dly
	bcf portB,2
	call dly
	bsf portB,6
	call dly
	bcf portB,3
	call dly
	bsf portB,7
	call dly
	bcf portB,4
	call dly
	bsf portA,0
	call dly
	bcf portB,5
	call dly
	bsf portA,1
	call dly
	bcf portB,6
	call dly
	bsf portA,2
	call dly
	bcf portB,7
	call dly
	bsf portA,3
	call dly
	bcf portA,0
	call dly
	decfsz reps,f
	goto sp3r
	bsf portB,0
	call dly
	clrf portA
	clrf portB
	call dly
	return

sp4:    movlw 7         ;as ro3, but anti-clock
	movwf reps      ;rotation
	movlw 3
	movwf rate
	clrf portA
	clrf portB
sp4r:   bsf portA,3
	call dly
	bcf portB,2
	call dly
	bsf portA,2
	call dly
	bcf portB,1
	call dly
	bsf portA,1
	call dly
	bcf portB,0
	call dly
	bsf portA,0
	call dly
	bcf portA,3
	call dly
	bsf portB,7
	call dly
	bcf portA,2
	call dly
	bsf portB,6
	call dly
	bcf portA,1
	call dly
	bsf portB,5
	call dly
	bcf portA,0
	call dly
	bsf portB,4
	call dly
	bcf portB,7
	call dly
	bsf portB,3
	call dly
	bcf portB,6
	call dly
	bsf portB,2
	call dly
	bcf portB,5
	call dly
	bsf portB,1
	call dly
	bcf portB,4
	call dly
	bsf portB,0
	call dly
	bcf portB,3
	call dly
	decfsz reps,f
	goto sp4r
	clrf portB
	call dly
	return

dly:    movf rate,w
	movwf ctr1
dly1:   decfsz ctr1,f
	goto dly1
	return
	
	.END


