; BAROM632.ASM 31JAN98 - EPE PIC ALTIMETER - COPYRIGHT JOHN BECKER
; PIC16C84 or PIC16F84, 3.2768MHz XTAL, WDT off, POR off
; Written for TASM assembly

#DEFINE PAGE0 BCF 3,5    
#DEFINE PAGE1 BSF 3,5    

INDF:     .EQU $00              
OPTION:   .EQU $01              
PCL:      .EQU $02              
STATUS:   .EQU $03              
FSR:      .EQU $04              
PORTA:    .EQU $05              
TRISA:    .EQU $05              
PORTB:    .EQU $06              
TRISB:    .EQU $06              
EEDATA:   .EQU $08
EECON1:   .EQU $08
EEADR:    .EQU $09
EECON2:   .EQU $09
INTCON:   .EQU $0B

MISC1:    .EQU $0C            ;misc use
MISC2:    .EQU $0D            ;misc use
ALTCNT1:  .EQU $0E            ;counter store for altitude count LSB
ALTCNT2:  .EQU $0F            ;counter store for altitude count MSB
TEMP1:    .EQU $10            ;temperature storage LSB
TEMP2:    .EQU $11            ;temperature storage MSB
EVENT:    .EQU $12            ;mode set by switch press
COUNT0:   .EQU $13            ;input status flag/feet fraction
COUNT1:   .EQU $14            ;input count/feet LSB
COUNT2:   .EQU $15            ;input count/feet MSB
AVAR1:    .EQU $16            ;variable A LSB - once set stays set
AVAR2:    .EQU $17            ;variable A MSB - once set stays set
DVAR1:    .EQU $18            ;variable D/metres LSB
DVAR2:    .EQU $19            ;variable D/metres MSB
REFCNT1:  .EQU $1A            ;counter store for ref count
REFCNT2:  .EQU $1B            ;counter store for ref count
ANSA1:    .EQU $1C            ;answer byte 1 LSB
ANSA2:    .EQU $1D            ;answer byte 2 MSB
ANSA3:    .EQU $1E            ;answer byte 3 MSB
ANSA4:    .EQU $1F            ;answer byte 4 LSB
ANSA5:    .EQU $20            ;answer byte 5 MSB
NEGTIV:   .EQU $21            ;negative flag
FLASH:    .EQU $22            ;flash flag (bit 0), bit 7 used for ref calcs
CLKCNT:   .EQU $23            ;pre-counter for CLOCK
TOP1:     .EQU $24            ;top of division byte 1 LSB
TOP2:     .EQU $25            ;top of division byte 2 MSB
DIV1:     .EQU $26            ;divider byte 1 LSB
DIV2:     .EQU $27            ;divider byte 2 MSB
BAROM1:   .EQU $28            ;height value for mB conversion LSB
BAROM2:   .EQU $29            ;height value for mB conversion MSB
SETIT:    .EQU $2A            ;flag for SETTING routines
LOOPB:    .EQU $2B            ;loop counter B
STORE1:   .EQU $2C            ;general store 1
STORE2:   .EQU $2D            ;general store 2
LOOPA:    .EQU $2E            ;loop counter A - for LCD only
RSLINE:   .EQU $2F            ;bit 4 = RS line flag for LCD
                              ;bit 7 = reference select flag

W:        .EQU 0
F:        .EQU 1                

C:        .EQU 0                
DC:       .EQU 1                
Z:        .EQU 2                

WR:       .EQU 1  ;eeprom write initiate flag
WREN:     .EQU 2  ;eeprom write enable flag
RD:       .EQU 0  ;eeprom read enable flag

          ;EEPROM ADDRESSES
MINCNT1:  .EQU 0            ;MIN COUNT LSB
MINCNT2:  .EQU 1            ;MIN COUNT MSB
MAXCNT1:  .EQU 2            ;MAX COUNT LSB
MAXCNT2:  .EQU 3            ;MAX COUNT MSB
MINHI1:   .EQU 4            ;MIN HEIGHT LSB
MINHI2:   .EQU 5            ;MIN HEIGHT MSB
MAXHI1:   .EQU 6            ;MAX HEIGHT LSB
MAXHI2:   .EQU 7            ;MAX HEIGHT MSB
ADDALT1:  .EQU 8            ;HEIGHT correction LSB
ADDALT2:  .EQU 9            ;HEIGHT correction MSB
ADDBAR1:  .EQU 10           ;BAROMETER correction LSB
ADDBAR2:  .EQU 11           ;BAROMETER correction MSB
DIVISOR1: .EQU 12           ;height divisor LSB
DIVISOR2: .EQU 13           ;height divisor MSB
REF1:     .EQU 14           ;VCO ref LSB
REF2:     .EQU 15           ;VCO ref MSB
DEGREE1:  .EQU 16           ;temperature correction LSB
DEGREE2:  .EQU 17           ;temperature correction MSB (dummy)
SPAN1:    .EQU 18           ;temp span LSB
SPAN2:    .EQU 19           ;temp span MSB (dummy)
CF:       .EQU 20           ;C or F label for degrees
DRIFT1:   .EQU 21           ;temperarture drift factor LSB
DRIFT2:   .EQU 22           ;temperarture drift factor MSB

          ;EEPROM storage locations during setting alignment routine
SETCNT1:  .EQU 23           ;count LSB SAMPLE 1
SETCNT2:  .EQU 24           ;count MSB SAMPLE 1
SETALT1:  .EQU 25           ;height LSB SAMPLE 1
SETALT2:  .EQU 26           ;height MSB SAMPLE 1
SETREF1:  .EQU 27           ;ref LSB SAMPLE 1
SETREF2:  .EQU 28           ;ref MSB SAMPLE 1
SETTMP1:  .EQU 29           ;temperature LSB SAMPLE 1
SETTMP2:  .EQU 30           ;temperature MSB SAMPLE 1
SETAVAR1: .EQU 31           ;AVAR constant LSB
SETAVAR2: .EQU 32           ;AVAR constant MSB

          .ORG $0004
          goto START
          .ORG $0005

START:  CLRF PORTA            
        CLRF PORTB            
        PAGE1
        MOVLW %00011111
        MOVWF TRISA           ;Port A0-A4 as input
        CLRF TRISB            ;Port B0-B7 as output
        MOVLW %00000101       ;set timer ratio 1:64
        MOVWF OPTION          
        PAGE0                 

CLRALL: movlw $0D
        movwf FSR
CLRA2:  clrf INDF
        incf FSR,F
        btfss FSR,4
        goto CLRA2
        btfss FSR,5
        goto CLRA2
        GOTO SETUP            

TABLCD: ADDWF PCL,F           ;LCD initialisation table
        RETLW %00110011       ;initialise lcd - first byte
        RETLW %00110011       ;2nd byte (repeat of first)
        RETLW %00110010       ;set for 4-bit operation
        RETLW %00101100       ;set for 2 lines
        RETLW %00000110       ;set entry mode to increment each address
        RETLW %00001100       ;set display on, cursor off, blink off
        RETLW %00000001       ;clear display
        RETLW %00000010       ;return home, cursor & RAM to zero
                              ;end initialisation table

        ;AUTHOR'S DEFAULT DEFAULT VALUES
TABLE:  addwf PCL,F
        retlw $a2             ;0 MINCNT1 11170
        retlw $2b             ;1 MINCNT2
        retlw $af             ;2 MAXCNT1 11695
        retlw $2d             ;3 MAXCNT2
        retlw 70              ;4 MINHI1  MIN HEIGHT 70 metres
        retlw 0               ;5 MINHI2
        retlw 144             ;6 MAXHI1  MAX HEIGHT 144 metres
        retlw 0               ;7 MAXHI2
        retlw 0               ;8 ADDALT1 HEIGHT correction LSB
        retlw 0               ;9 ADDALT2 HEIGHT correction MSB
        retlw 15              ;10 ADDBAR1 BAROMETER correction LSB
        retlw 0               ;11 ADDBAR2 BAROMETER correction MSB
        retlw 0               ;12 DIVISOR1 height divisor LSB
        retlw 0               ;13 DIVISOR2 height divisor MSB
        retlw $ef             ;14 REF1 temperature ref LSB 15087
        retlw $3a             ;15 REF2 temperature ref MSB
        retlw 58              ;16 temp correction 58F
        retlw 0               ;17 temp correction
        retlw 23              ;18 temp span LSB
        retlw 0               ;19 temp span MSB
        retlw 'F'             ;20 C or F label for degrees
        retlw 14              ;21 drift LSB
        retlw 0               ;22 drift MSB

TABSET1:addwf PCL,F         ;settings change message
        retlw 'H'
        retlw '1'
        retlw ' '
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw ' '

TBDEC1: ADDWF PCL,F     ;table for decimalisation lsb
        retlw $0A       ;lsb of 10
        retlw $64       ;lsb of 100
        retlw $E8       ;lsb of 1000
        retlw $10       ;lsb of 10000

TBDEC2: ADDWF PCL,F     ;table for decimalisation msb
        retlw 0         ;msb of 10
        retlw 0         ;msb of 100
        retlw $03       ;msb of 1000
        retlw $27       ;msb of 10000

ROUTE:  movf EVENT,W
        addwf PCL,F
        goto HEIGHT          ;0 normal display
        goto INCDATA         ;1
        goto INCDATA         ;2
        goto INCDATA         ;3
        goto SETCF           ;4 set C or F for degrees
        goto INCDATA         ;5
        goto INCDATA         ;6
        goto SHWMAX          ;7 show stored barom/height min/max

ROUTE2:  movf EVENT,W         ;address for routine to be shown during +/-
         addwf PCL,F
         RETURN               ;0 route number not used
         goto HEIGHT          ;1
         goto CALCBAR         ;2
         goto GETTEMP         ;3
         RETURN               ;4 route number not used
         goto RANGE           ;5 
         goto DRIFT           ;6

ROUTE3:  movf EVENT,W         ;get eeprom location for +/- routines
         addwf PCL,F
         RETURN               ;0 route number not used
         retlw ADDALT1        ;1
         retlw ADDBAR1        ;2
         retlw DEGREE1        ;3
         RETURN               ;4 route number not used 
         retlw SPAN1          ;5 
         retlw DRIFT1         ;6

SETUP:  CALL PAUSIT           ;1/5 sec delay

LCDSET: CLRF LOOPB            ;clr LCD set-up loop
LCDST2: MOVF LOOPB,W          ;get table address
        CALL TABLCD           ;get set-up instruction
        CALL LCDLIN           ;perform it
        INCF LOOPB,F          ;inc loop
        BTFSS LOOPB,3         ;has last LCD set-up instruction now been done?
        GOTO LCDST2           ;no
        CALL PAUSIT           ;1/5 sec delay

        btfsc PORTA,0         ;is PORTA bit 0 pressed?
        call SETEPRM          ;yes, so store default data in EEPROM

        movlw MAXHI1          ;recall default values
        movwf EEADR
        movlw ALTCNT1
        call GETWORD
        movlw REF1
        movwf EEADR
        movlw REFCNT1
        call GETWORD
        movlw SETAVAR1
        movwf EEADR
        movlw AVAR1
        call GETWORD

        MOVLW 50              ;initial basic CLKCNT val for secs timing
        MOVWF CLKCNT          
        
INTCLR: bcf INTCON,2
INTRPT: movf PORTA,W
        andlw %00010000
        movwf STORE1
        xorwf COUNT0,W        ;is PORTA bit 4 = COUNT0 bit 4?
        btfsc STATUS,Z
        goto INT2             ;yes
        incfsz COUNT1,F       ;no
        goto INT2
        incf COUNT2,F

INT2:   movf STORE1,W
        movwf COUNT0
        BTFSS INTCON,2        ;has a timer time-out been detected?
        GOTO INTRPT           ;no
        call GETKEY
        movf CLKCNT,F         ;has CLKCNT been set to 0?
        btfsc STATUS,Z
        goto INT5             ;yes

        DECFSZ CLKCNT,F       ;decrement system clock counter. Is it = 0?
        goto INTCLR

        bcf STATUS,C          ;divide answer by 2 (to give Hz) 
        rrf COUNT2,F
        rrf COUNT1,F

        movlw 128             ;inc reference select flag
        addwf RSLINE,F
        movf RSLINE,W
        movwf PORTB

INT4:   movlw REFCNT1         ;store COUNT in selected destination
        btfsc RSLINE,7
        movlw ALTCNT1
        movwf FSR
        movf COUNT1,W
        movwf INDF
        incf FSR,F
        movf COUNT2,W
        movwf INDF
        call GETKEY3
INT5:   call LCD1
        movlw 0
        call FLASHIT
        call PAUSIT           ;1/5th sec VCO stabilisation delay
        MOVLW 50              ;reset start value of CLKCNT
        MOVWF CLKCNT          
        clrf COUNT0
        clrf COUNT1
        clrf COUNT2
        BCF INTCON,2
INTRP2: BTFSS INTCON,2        ;has a timer time-out been detected?
        GOTO INTRP2           ;no
        GOTO INTCLR           ;yes

SHWDMP: CALL LCD1            ;show various counts
        call CLR1
        movlw REFCNT1        ;ref count
        call DECIMAL
        movlw 'R'
        call LCDOUT
        call CLR2

        movlw ALTCNT1        ;pressure count
        call DECIMAL
        movlw 'H'
        call LCDOUT
        call CLR1

        call GETDRIFT        ;ALTCNT amended for drift
        call LCD28
        call CLR1
        movlw TOP1
        call DECIMAL
        movlw 'D'
        call LCDOUT
        goto CLR1

SHWMAX: movlw MAXCNT1        ;show min/max count values at min/max height
        call GETTOP
        CALL LCD1
        call CLR1
        movlw TOP1
        call DECIMAL
        call CLR2

        movlw MINCNT1
        call GETTOP 
        movlw TOP1
        call DECIMAL
        call CLR2
        movlw 'B'
        call LCDOUT

        movlw MINHI1         ;show min/max height values
        call GETTOP 
        CALL LCD21
        call CLR1
        movlw TOP1
        call DECIMAL
        call CLR2

        movlw MAXHI1
        call GETTOP 
        movlw TOP1
        call DECIMAL
        call CLR2
        movlw 'H'
        goto LCDOUT
         
LCD28:  movlw %11001000
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD1:   movlw %10000000

LCDLIN: BCF RSLINE,4          ;clear RS flag - sets LCD command/line

LCDOUT: MOVWF STORE1          ;temp store data for LCD
        MOVLW 20              ;set min time between sending full bytes to LCD
        MOVWF LOOPA
DELAY:  DECFSZ LOOPA,F
        GOTO DELAY            
        CALL SENDIT           ;send MSB
        CALL SENDIT           ;send LSB
        BSF RSLINE,4          ;set RS flag (default is flag set)
        return

SENDIT: SWAPF STORE1,F        ;get and send data nibble
        MOVF STORE1,W         
        ANDLW 15              
        IORWF RSLINE,W        ;OR the RS bit
        MOVWF PORTB           ;output the byte
        BSF PORTB,5           ;set E high
        BCF PORTB,5           ;set E low
        RETURN                

GETKEY: btfsc PORTA,3
        goto GETKEY4
        btfss PORTA,0
        return
        incf EVENT,F
        movf EVENT,W
        xorlw 8
        btfsc STATUS,Z        ;limit of 7 events max
GETKEY4:call CLRMODE
        clrf CLKCNT
GETKEY3:call ROUTE
GK2:    btfsc PORTA,0         ;wait till Mode switch released
        goto GK2
        return

PAUSIT: MOVLW 10              ;1/5th sec wait set
        MOVWF CLKCNT          
        CLRF INTCON
PAUSE:  BTFSS INTCON,2        ;has a timer time-out been detected?
        GOTO PAUSE            ;no
        BCF INTCON,2          ;yes
        DECFSZ CLKCNT,F       ;dec loop, is it zero?
        GOTO PAUSE            ;no
        RETURN                ;yes

HEIGHT: call GETDRIFT         ;CALCULATE HEIGHT VALUES
        clrf COUNT1
        clrf COUNT2
        movlw DIVISOR1
        call GETDIV
        call CALCDIV1         ;get value for d
         
HIGH1:   movf AVAR1,W         ;d = d - a
         subwf ANSA1,F 
         btfss STATUS,C
         decf ANSA2,F
         movf AVAR2,W
         subwf ANSA2,F

         movlw MAXHI1         ;d = max height - d
         call GETDIV
         movf ANSA1,W
         subwf DIV1,F
         btfss STATUS,C
         decf DIV2,F
         movf ANSA2,W
         subwf DIV2,F

HIGH3:   movf DIV2,W       ;store answer for barometer calcs
         movwf BAROM2
         movf DIV1,W
         movwf BAROM1

ADDALT:  movlw ADDALT1     ;add eeprom correction value
         movwf EEADR
         movlw DIV1
         call ADDWORD

         clrf NEGTIV
         movf DIV2,W       ;check for negative value
         addlw 128         ;(if byte 2 is > 128 then val is neg)
         btfss STATUS,C
         goto FEET
         comf DIV1,F       ;invert value and set negative ffag           
         incf DIV1,F
         btfsc STATUS,Z
         decf DIV2,F
         comf DIV2,F
         bsf NEGTIV,7      ;set negative flag         

FEET:    movf DIV1,W       ;convert metres to feet (* 3.28)
         movwf DVAR1       ;first storing metres answer into DVAR
         movf DIV2,W
         movwf DVAR2
         clrf COUNT0
         clrf COUNT1
         clrf COUNT2
         movf DIV1,W        ;check for zero value
         iorwf DIV2,W
         btfsc STATUS,Z
         goto VF4

VF2:     movlw 72           ;0.28 decimal as binary fraction of 256
         addwf COUNT0,F
         btfss STATUS,C
         goto VF3
         incfsz COUNT1,F
         goto VF3
         incf COUNT2,F

VF3:     movlw 3            ;3 feet for 1 metre (plus above 0.28)
         addwf COUNT1,F
         btfsc STATUS,C
         incf COUNT2,F
         decfsz DIV1,F
         goto VF2
         movf DIV2,F
         btfsc STATUS,Z
         goto VF4
         decf DIV2,F
         goto VF2
VF4:     call SHOWALT       ;show height

CALCBAR: movf BAROM1,W    ;CALCULATE BAROMETER VALUE
         movwf TOP1       ;(metres height / 10) + 1013 - correction
         movf BAROM2,W
         movwf TOP2
         clrf NEGTIV
         movf TOP2,W      ;check for negative value
         addlw 128        ;(if byte 2 is > 128 then val is neg)
         btfss STATUS,C
         goto CALCB1
         call INVERT      ;invert TOP
         bsf NEGTIV,0     ;set negative flag

CALCB1:  clrf DVAR1
         clrf DVAR2
CALCB2:  movlw 10         ;divide metres by 10
         subwf TOP1,F
         btfsc STATUS,C
         goto CALCB3
         movf TOP2,F
         btfsc STATUS,Z
         goto CALCB31
         decf TOP2,F
CALCB3:  incfsz DVAR1,F
         goto CALCB2    
         incfsz DVAR2,F
         goto CALCB2

CALCB31: btfss NEGTIV,0   ;is it negative?
         goto CALCB5      ;no

CALCB4:  movlw $F5        ;yes, add to 1013 (mB) $03F5 (normal atmos)
         addwf DVAR1,F
         btfsc STATUS,C
         incf DVAR2,F
         movlw 3
         addwf DVAR2,F
         goto CALCB6

CALCB5:  movf DVAR1,W     ;subtract from 1013 (mB) $03F5 (normal atmos)
         sublw $F5        ;n.b. W is subtracted from literal!
         movwf DVAR1
         btfss STATUS,C
         decf DVAR2,F
         movf DVAR2,W
         sublw 3
         movwf DVAR2

CALCB6:  movlw ADDBAR1    ;add eeprom correction value
         movwf EEADR
         movlw DVAR1
         call ADDWORD
         call SHOWBAR     ;show barometer

GETTEMP: call REFCALC     ;get reference change as temperature value
         call GETNEG      
         clrf MISC1       ;ref diff is held in TOP
         clrf MISC2
         movf TOP1,W      ;is TOP = zero?
         iorwf TOP2,W
         btfsc STATUS,Z
         goto GETTMP3     ;yes
         call INVERT      ;invert TOP for adding instead of subtraction
         movlw SPAN1      ;divisor store for temperature
         call GETDIV      ;set the divisor into DIV
         movf DIV1,W      ;is the divisor = zero ?
         iorwf DIV2,W
         btfsc STATUS,Z
         goto GETTMP3     ;yes, so bypass division routine

GETTMP2: movf DIV1,W      ;add lsb of DIV to lsb of TOP
         addwf TOP1,F
         movlw 1
         andwf STATUS,C   ;add carry flag to msb of TOP
         addwf TOP2,F
         btfsc STATUS,C   ;is there a carry?
         goto GETTMP3     ;yes
         movf DIV2,W      ;no, add msb of DIV to msb of TOP
         addwf TOP2,F
         btfsc STATUS,C   ;is there a carry?
         goto GETTMP3     ;yes
         incfsz MISC1,F   ;no, inc counter lsb, is there a zero rollover?
         goto GETTMP2     ;no
         incf MISC2,F     ;yes, inc counter msb
         goto GETTMP2         

GETTMP3: movf MISC1,W
         movwf TOP1
         movf MISC2,W
         movwf TOP2
         btfss NEGTIV,7
         goto GETTMP4
         call INVERT

GETTMP4: movf TOP1,W          ;store uncorrected temperature value
         movwf TEMP1
         movf TOP2,W
         movwf TEMP2

         movlw DEGREE1        ;add degrees correction value
         movwf EEADR
         movlw TOP1
         call ADDWORD
         call GETNEG
         movf EVENT,W
         xorlw 6
         btfss STATUS,Z
         goto TEMPSHW         ;show temperature
         return               ;don't show temp in mode 6

GETDRIFT: call GETTEMP        ;get temperature value, held in TEMP1/2
         clrf TOP1            ;clear counter
         clrf TOP2 
         movf TEMP1,W         ;is temp change = 0?
         iorwf TEMP2,W
         btfsc STATUS,Z
         goto GDRIFT3         ;yes

         movlw DRIFT1
         call GETDIV          ;get multiplier into DIV
         movf DIV1,W          ;is it = 0?
         iorwf DIV2,W
         btfsc STATUS,Z
         goto GDRIFT3         ;yes

         clrf STORE1
         movf DIV2,W
         addlw 128
         btfsc STATUS,C
         goto GDRIFT2

         comf DIV1,F          ;invert multiplier if not negative
         incf DIV1,F
         btfsc STATUS,Z
         decf DIV2,F
         comf DIV2,F
         bsf STORE1,0         ;inversion flag

GDRIFT2: movf TEMP1,W
         addwf TOP1,F
         btfsc STATUS,C
         incf TOP2,F
         movf TEMP2,W
         addwf TOP2,F
         incfsz DIV1,F
         goto GDRIFT2
         incfsz DIV2,F
         goto GDRIFT2
         btfss STORE1,0      ;if divisor was NOT inverted, invert answer
         call INVERT
GDRIFT3: movf ALTCNT1,W        ;add drift correction to ALTCNT
         addwf TOP1,F      
         btfsc STATUS,C
         incf TOP2,F
         movf ALTCNT2,W
         addwf TOP2,F
         return

CALCDIV1: bcf STATUS,C         ;(AVAR = AVAR * 4)
         rlf TOP1,F
         rlf TOP2,F
         bcf STATUS,C
         rlf TOP1,F
         rlf TOP2,F
         clrf ANSA1
         clrf ANSA2
                              ;DIVIDE TOP by DIV (AVAR / DVAR)
calcdiv2: movf DIV1,W          ;subtract div lsb from top lsb
         subwf TOP1,F
         btfsc STATUS,C       ;is there a borrow?
         goto calcdiv3        ;no
         movf TOP2,F          ;yes, so is TOP2 = 0?
         btfsc STATUS,Z
         goto enddiv          ;yes, so return
         decf TOP2,F          ;no

calcdiv3: movf DIV2,W          ;subtract height diff msb from countdiff msb
         subwf TOP2,F
         btfss STATUS,C       ;is there a borrow?
         goto enddiv          ;yes, so return
         incfsz ANSA1,F       ;no, so inc answer count lsb, is it = 0?
         goto calcdiv2         ;no, so do next subtraction
         incfsz ANSA2,F       ;yes, so inc msb, is it = 0
         goto calcdiv2         ;no, so do next subtraction
enddiv:  return               ;yes, so return

SHOWALT: CALL LCD1            ;show altitude values (metres first)
         call CLR1
         movlw DVAR1
         call DECIMAL
         movlw 'M'
         call LCDOUT
         movlw 1
         call FLASHIT
         MOVLW %10000000
         call NEGIT

         CALL LCD8
         call CLR1
         movlw COUNT1
         call DECIMAL
         movlw 'f'
         call LCDOUT
         movlw 't'
         call LCDOUT
         MOVLW %10001000
         goto NEGIT

SHOWBAR: CALL LCD21       ;show barometer reading
         movlw DVAR1
         call DECIMAL
         movlw 'm'            
         call LCDOUT
         movlw 'B'            
         call LCDOUT
         movlw 2
         call FLASHIT
         goto CLR1

TEMPSHW: CALL LCD28           ;show temp reading
         movlw TOP1
         call DECIMAL
         movlw 223            ;degrees symbol
         call LCDOUT
         movlw CF             ;C or F label
         movwf EEADR
         call PRMGET
         call LCDOUT
         movlw 3
         call FLASHIT
         call CLR1
         MOVLW %11001000
         goto NEGIT

SETEPRM: clrf EEADR
SET2:    movf EEADR,W
         call TABLE
         call SETPRM
         incf EEADR,F
         movf EEADR,W
         xorlw 23
         btfss STATUS,Z
         goto SET2
SET3:    btfsc PORTA,0
         goto SET3
         goto CALCFACT         ;calculate division factor from eeprom

;...............

;WRITE DATA TO EEPROM ROUTINE
;This routine is entered with EEADR already holding the store address.
;W holds the data to be stored

SETPRM: PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movwf EEDATA

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;..........

;READ DATA FROM EEPROM ROUTINE
;This routine is entered with the eeprom address already set into EEADR

PRMGET: PAGE1
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return

;..........

CALCFACT:                    :GET DIVISOR FACTOR VALUE
         movlw MAXCNT1       ;get countdiff (AVAR = maxcount - mincount)
         movwf EEADR
         movlw AVAR1
         call GETWORD
         movlw MINCNT1
         movwf EEADR
         movlw AVAR1
         call SUBWORD

         movlw MAXHI1       ;get height diff (DVAR = maxheight - minheight)
         movwf EEADR
         movlw DVAR1
         call GETWORD
         movlw MINHI1
         movwf EEADR
         movlw DVAR1
         call SUBWORD
         
         movf AVAR1,W      ;get divisor (DIVISOR = AVAR / DVAR)
         movwf TOP1        ;TOP = AVAR
         movf AVAR2,W
         movwf TOP2
         movf DVAR1,W      ;DIV = DVAR
         movwf DIV1
         movf DVAR2,W
         movwf DIV2
         call CALCDIV1      ;(in CALCDIV1 AVAR = AVAR * 4) (answer in ANSA)
         movlw DIVISOR1     ;store divisor in eeprom
         movwf EEADR
         movlw ANSA1
         call SETWORD

getvara: movlw MINCNT1      ;(AVAR = mincount / DIVISOR)
         call GETTOP 
         movlw DIVISOR1     ;DIV = DIVISOR, TOP = mincount
         call GETDIV
         call CALCDIV1      ;(in CALCDIV1 TOP = TOP * 4)
         movf ANSA1,W       ;(i.e. mincount = mincount * 4)
         movwf AVAR1
         movf ANSA2,W
         movwf AVAR2
         movlw SETAVAR1
         movwf EEADR
         movlw AVAR1
         goto SETWORD

DECIMAL: clrf ANSA1
         clrf ANSA2
         clrf ANSA3
         clrf ANSA4
         clrf ANSA5
         movwf FSR

         movf INDF,W           ;check for zero value
         incf FSR,F
         iorwf INDF,W
         btfsc STATUS,Z
         goto DEC4
         
         movf INDF,W           ;copy value into TOP
         movwf TOP2
         decf FSR,F
         movf INDF,W
         movwf TOP1
         movlw 4
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DECA1:   clrf STORE2
         decf LOOPB,W
         call TBDEC1
         movwf MISC1
         decf LOOPB,W
         call TBDEC2
         movwf MISC2
         call ADDIT
         movwf INDF
         decf FSR,F
         decfsz LOOPB,F
         goto DECA1
         movf TOP1,W
         movwf INDF

DECA2:   addlw 6
         btfss STATUS,DC
         goto DEC4
         clrf INDF
         incf FSR,F
         incf INDF,F
         movf INDF,W
         goto DECA2

ADDIT:   call INVERT           ;invert to allow adding
ADDIT2:  incf STORE2,F
         movf MISC1,W
         addwf TOP1,F
         movlw 1
         andwf STATUS,W
         addwf MISC2,W
         addwf TOP2,F
         btfss STATUS,C
         goto ADDIT2
                              
         call INVERT           ;invert to allow adding
         movf MISC1,W          ;subtract last addition value
         addwf TOP1,F
         btfsc STATUS,C
         incf TOP2,F
         movf MISC2,W
         addwf TOP2,F
         decf STORE2,W
         return

DEC4:    clrf STORE1         ;blank leading zeros
         movlw 4
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DEC5:    movf INDF,W
         btfss STATUS,Z
         goto DEC6
         movlw ' '
         movwf INDF
         decf FSR,F
         incf STORE1,F
         decfsz LOOPB,F
         goto DEC5
         
DEC6:    movf STORE1,W    ;store value of last leading zero
         iorwf NEGTIV,F
         movlw 5
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DEC7:    movf INDF,W
         btfss INDF,5     ;is it a blank (32)?
         iorlw 48         ;no, so it's a numeral
         call LCDOUT
         decf FSR,F
         decfsz LOOPB,F
         goto DEC7
         return

INVERT:  comf TOP1,F           
         incf TOP1,F
         btfsc STATUS,Z
         decf TOP2,F
         comf TOP2,F
         return

INCDATA: call HEIGHT      ;clear previous flash star
         call ROUTE2      ;show next field for correction

INCALTA: btfsc PORTA,0
         goto INCALTA

INCALT2: btfsc PORTA,1    ;is + pressed?
         call INCPRM      ;yes
         btfsc PORTA,2    ;is - pressed?
         call DECPRM      ;yes
         call ROUTE2      ;show the result
         movlw 13         ;increase action rate (0.25 sec approx)
         movwf CLKCNT
INCALT8: BCF INTCON,2
INCALT7: BTFSS INTCON,2   ;has a timer time-out been detected?
         GOTO INCALT7     ;no
         btfss PORTA,3    ;is SET switch pressed?
         goto INCALT4     ;no
         movf EVENT,W     ;yes, so is EVENT = 1?
         xorlw 1           
         btfss STATUS,Z
         goto INCALT5     ;no

INCALT3: btfsc PORTA,0    ;yes, is MODE switch pressed?
         goto SETTING     ;yes
         btfsc PORTA,3    ;no, is SET switch still pressed?
         goto INCALT3     ;yes
INCALT5: goto CLRMODE

INCALT4: btfsc PORTA,0    ;is MODE switch pressed?
         goto ENDADD      ;yes
         decfsz CLKCNT,F  ;no
         goto INCALT8
         goto INCALT2

INCPRM:  call GETDBYT     ;inc double byte in eeprom
         incf DIV1,F
         btfsc STATUS,Z
         incf DIV2,F
         goto SETDBYT

DECPRM:  call GETDBYT     ;dec double byte in eeprom
         movlw 1
         subwf DIV1,F
         btfss STATUS,C
         decf DIV2,F
         goto SETDBYT

GETDBYT: call ROUTE3      ;also accessed at GETDIV
GETDIV:  movwf EEADR      ;get double byte from eeprom
         movlw DIV1
         goto GETWORD

SETDBYT: movf DIV2,W
         call SETPRM
         decf EEADR,F
         movf DIV1,W
         goto SETPRM
              
SETTING: clrf LOOPB        ;alignment setting routines
         CALL LCD28
SETA2:   movf LOOPB,W
         call TABSET1
         call LCDOUT
         incf LOOPB,F
         btfss LOOPB,3
         goto SETA2

         movlw ADDALT1    ;add height correction value
         call GETTOP
         movf BAROM1,W
         addwf TOP1,F
         btfsc STATUS,C
         incf TOP2,F
         movf BAROM2,W
         addwf TOP2,F

SETA3:   btfsc SETIT,0
         goto SETA4
         call SETHI1
         goto SETA5
SETA4:   call SETHI2      
SETA5:   btfsc PORTA,3    ;is SET switch still pressed?
         goto SETA5       ;yes
         goto CLRMODE

SETHI1:  bsf SETIT,0      ;sample 1 readings
         movlw SETCNT1    ;store current ALTCNT value
         call STORALT
         movlw SETALT1    ;store current height value
         call STORTOP
         movlw SETREF1    ;store current REFCNT value
         movwf EEADR
         movlw REFCNT1
         call SETWORD
         movlw SETTMP1    ;store current temperature
         movwf EEADR
         movlw TEMP1
         goto SETWORD

SETHI2:  MOVLW %11001001   ;sample 2 readings
         CALL LCDLIN
         movlw '2'
         call LCDOUT

         movlw SETCNT2     ;get msb of sample 1 SETCNT (its ALTCNT)
         movwf EEADR
         call PRMGET
         subwf ALTCNT2,W   ;subtract msb of sample 2 ALTCNT
         btfsc STATUS,C    ;is there a borrow?
         goto SWAPIT       ;no, so swap samples 1 & 2

CORRECT: movlw MAXHI1      ;no, store current height as correct sample
         call STORTOP
         movlw MINCNT1     ;store current ALTCNT value as minimum sample
         call STORALT

         movlw SETCNT1     ;transfer sample 1 readings
         call GETTOP       ;transfer count as maximum sample
         movlw MAXCNT1
         call STORTOP
         movlw SETALT1     ;transfer height as minimum sample
         call GETTOP
         movlw MINHI1
         call STORTOP
         goto ENDTRS

SWAPIT:  movlw MINHI1      ;store current height value as swapped sample 
         call STORTOP
         movlw MAXCNT1     ;store current ALTCNT value as maximum sample
         call STORALT
         movlw SETCNT1     ;transfer sample 1 readings
         call GETTOP       ;transfer count as minimum sample
         movlw MINCNT1
         call STORTOP
         movlw SETALT1     ;transfer height as maximum sample
         call GETTOP
         movlw MAXHI1
         call STORTOP

ENDTRS:  movlw SETREF1     ;transfer reference
         call GETTOP
         movlw REF1
         call STORTOP
         movlw SETTMP1     ;transfer temperature
         call GETTOP
         movlw DEGREE1
         call STORTOP
         call CLRALTA      ;clear altitude correction value
         clrf SETIT
         goto CALCFACT     ;recalculate division factor

;...............

STORALT: movwf EEADR
         movlw ALTCNT1
         goto SETWORD

GETTOP:  movwf EEADR
         movlw TOP1
         goto GETWORD

STORTOP: movwf EEADR
         movlw TOP1
         goto SETWORD

CLRALTA: movlw ADDALT1    ;clear correction value
         movwf EEADR
         movlw 0
         call SETPRM
         incf EEADR,F
         movlw 0     
         goto SETPRM

REFCALC: movf REFCNT1,W   ;calculate diff between orig & current refs
         movwf TOP1
         movf REFCNT2,W
         movwf TOP2
         movlw REF1
         movwf EEADR
         movlw TOP1
         goto SUBWORD

GETNEG:  clrf NEGTIV      ;check for negative value
         movf TOP2,W
         addlw 128        ;(if byte 2 is > 128 then val is neg)
         btfss STATUS,C
         return    
         call INVERT      ;invert TOP
         bsf NEGTIV,7     ;set negative flag
         return

CLR3:    movlw ' '
         call LCDOUT
CLR2:    movlw ' '
         call LCDOUT
CLR1:    movlw ' '
         goto LCDOUT

ENDADD:  incf EVENT,F
         movf EVENT,W
         xorlw 8
         btfsc STATUS,Z        ;limit of 7 events max
         clrf EVENT
ENDADD2: btfsc PORTA,0
         goto ENDADD2
         clrf CLKCNT
         goto ROUTE

FLASHIT: xorwf EVENT,W
         btfss STATUS,Z
         goto FLASH2
         incf FLASH,F
         bcf FLASH,1
         movlw '*'
         btfsc FLASH,0
FLASH2:  movlw ' '
         goto LCDOUT

NEGIT:   btfss NEGTIV,7
         goto NEG2
         iorwf NEGTIV,W
         CALL LCDLIN
         movlw '-'
         call LCDOUT
NEG2:    movlw %10000000
         andwf NEGTIV,F
         return

SETCF:   btfsc PORTA,0
         goto SETCF
         movlw %11001111
         call LCDLIN
         movlw '?'
         call LCDOUT

SETCF2:  btfsc PORTA,0
         goto ENDADD
         btfsc PORTA,3
         goto CLRMODE
         btfss PORTA,1
         goto SETCF2
         movlw CF
         movwf EEADR
         call PRMGET
         xorlw 'F'
         movlw 'C'
         btfss STATUS,Z
         movlw 'F'
         movwf MISC1
         call SETPRM
         movlw %11001110
         call LCDLIN
         movf MISC1,W     ;show label
         goto LCDOUT

RANGE:   movlw SPAN1      ;show temp range value
         call RANGE1
         movlw 5
         call RANGE2
         movlw 'T'
         goto RANGE3

RANGE1:  call GETTOP
         movlw %11000001
         call LCDLIN
         call GETNEG
         movlw TOP1
         goto DECIMAL

RANGE2:  call FLASHIT
         movlw '>'
         call LCDOUT
         movlw %11000000
         call NEGIT
         call LCD21
         movlw '<'
         goto LCDOUT

RANGE3:  call LCDOUT
         movlw $FD         ;division symbol
RANGE4:  call LCDOUT
         goto GETTEMP

DRIFT:    call SHWDMP
          movlw DRIFT1     ;show DRIFT range value
          call RANGE1
          movlw 6
          call RANGE2
          movlw 'D'
          call LCDOUT
          movlw 120
          goto RANGE4

GETWORD: movwf FSR
         call PRMGET
         movwf INDF
         incf EEADR,F
         incf FSR,F
         call PRMGET
         movwf INDF
         return

SETWORD: movwf FSR
         movf INDF,W
         call SETPRM
         incf FSR,F
         incf EEADR,F
         movf INDF,W
         goto SETPRM

SUBWORD: movwf FSR
         call PRMGET
         subwf INDF,F
         incf FSR,F
         btfss STATUS,C
         decf INDF,F
         incf EEADR,F
         call PRMGET
         subwf INDF,F
         return

ADDWORD: movwf FSR
         call PRMGET
         addwf INDF,F
         incf FSR,F
         btfsc STATUS,C
         incf INDF,F
         incf EEADR,F
         call PRMGET
         addwf INDF,F
         return

CLRMODE: clrf EVENT
         clrf CLKCNT
         goto ROUTE



        .END

