;RCMETER.ASM	24 Jun 1997




;HARDWARE DETAILS

;RA0	INPUT   SW1
;RA1    INPUT   SW2
;RA2	OUTPUT - POWER SUPPLY LATCH
;RA3	SHORTED TO RTCC
;RA4    RTCC 

;RB0	MODE 2 RX INPUT, MODE 3 SERVO OUTPUT 
;RB1	OUTPUT 	LCD D4
;RB2	OUTPUT  LCD D5
;RB3    OUTPUT  LCD D6
;RB4    OUTPUT  LCD D7
;RB5    OUTPUT  LCD RS
;RB6	OUTPUT  LCD E
;RB7    I/O - not used


;PROGRAM PIC CHIP WITH AS FOLLOWS:-

;               WdT on  Watchdog timer off
;               PuT on  power up timer on
;               Osc HS
;               CP  ?   Code Protect ?

;set for 10MHz XTAL


;setup of address registers

;file registers        ;bank

INDF:	EQU 00h        ;0 & 1
TMR:    EQU 01h        ;0
OPTIO:  EQU 01h        ;1
PCL:    EQU 02h        ;0 & 1
STATUS: EQU 03h        ;0 & 1
FSR:    EQU 04h        ;0 & 1
PORTA:  EQU 05h        ;0
TRISA:  EQU 05h        ;1
PORTB:  EQU 06h        ;0
TRISB:  EQU 06h        ;1
EEDATA: EQU 08h        ;0
EECON1: EQU 08h        ;1
EEADR:  EQU 09h        ;0
EECON2: EQU 09h        ;1
PCLATH: EQU 0Ah        ;0 & 1
INTCON: EQU 0Bh        ;0 & 1

;ram 

SAVEW:		EQU 0Ch	      	;push and pop
SAVEPSW: 	EQU 0Dh       	;push and pop
FLAGS	EQU 0Eh       	;
COUNTL:	EQU 0Fh       	;
COUNTH:	EQU 10h	      	;
AUTO0: 	EQU 11h       	;
AUTO1: 	EQU 12h       	;
R0: 	EQU 13h       	;
R1: 	EQU 14h      	; 
R2: 	EQU 15h		;
BYTE0 	EQU 16h        	;
BYTE1: 	EQU 17h        	;
BYTE2: 	EQU 18h        	;
BYTE3: 	EQU 19h        	;
BYTE4: 	EQU 1Ah        	;
BYTE5:	EQU 1Bh        	;
BYTE6: 	EQU 1Ch        	;
BYTE7: 	EQU 1Dh        	;
BYTE8: 	EQU 1Eh        	;
CHAN:	EQU 1Fh		;
BYTE0H:	EQU 20h		;
MODE:	EQU 21h		;
LSB:	EQU 22h		;
MSB:	EQU 23h		;
FREQL:	EQU 24h		;
FREQH:	EQU 25h		;
;:	EQU 26h		;

;FILES USED FOR LCD DRIVER 27h to 2Fh
;see LCDSETUP routine



W:      EQU 0  ;Result to go into working register (accumulator)
F:      EQU 1  ;Result to go into a file register.

;STATUS FLAGS

C:      EQU 0  ;Carry flag  (located in STATUS register)
CY:	EQU 0  ;  "
DC:     EQU 1  ;Digit carry            "
Z:      EQU 2  ;Zero flag              "
PD:     EQU 3  ;Power Down bit         "
TO:     EQU 4  ;Time-out bit           "

;INTCON FLAGS
TOIF:	EQU 2  ;tmr0 int INTCON reg  
INTF:	EQU 1  ;Int interrupt flag
GIE:    EQU 7  ;GIE bit in INTCON reg

;FLAGS register

msg:	EQU	0
cont:	EQU	1
disp:	EQU	2
sync    EQU     3
rfon:	EQU	4
gen:	EQU	5



SW1:	EQU	0
SW2:	EQU	1

;CONSTANTS

SYNCVAL	EQU	.64

;***************************************************************************

;macro definitions

;***************************************************************************


;these use two registers 'savew' and 'savepsw'


push    MACRO
	movwf   SAVEW           ;save W
	swapf   STATUS,w        ;move status without altering flags
	movwf   SAVEPSW         ;save STATUS
	ENDM

pop     MACRO
	swapf   SAVEPSW,w
	movwf   STATUS          ;restore STATUS without altering flags 
	swapf   SAVEW
	swapf   SAVEW,w         ;restore W without altering flags
	ENDM




ei      MACRO
	bsf     INTCON,7      	;enable interrupts
	ENDM
	
di      MACRO
	bcf     INTCON,7     	;disable interrupts
	ENDM


#DEFINE	BANK0	bcf	STATUS,5
#DEFINE	BANK1   bsf	STATUS,5

; #define PAGE0	bcf     PCLATH,3        ;select page 0 memory 000-7FF
; #define PAGE1	bsf     PCLATH,3        ;select page 1 memory 800-FFF






        org 0000h
	goto	SETUP
	
        ORG 0004h     	;Interrupt vector address
        GOTO INTERRUPT 	;Jump to interrupt routine on interrupt
	
SETUP:
 	call	LCDSETUP 		;set up LCD display and ports
	clrf	FLAGS
	clrf	AUTO0
	clrf	AUTO1
	clrf	MODE			;initialise mode to mode 0
	bsf	FLAGS,msg		;display mode 0 msg
	goto	MAIN






;mode0	MEASURE TRANSMITTER FREQUENCY ,CHANNELS and FRAME LENGTH
;mode1  MEASURE TRANSMITTER CHANNEL PULSE WIDTHS
;mode2  MEASURE RECEIVER CHANNEL PULSE WIDTH
;mode3  GENERATE SERVO PULSE inc/dec (nominal 1.5ms every 18ms)


MAIN:	
	di  
	call	chgmode

	movf	MODE,w		;mode jump table
	btfsc	STATUS,Z
	goto	mode0
	
	xorlw	1
	btfsc	STATUS,Z
	goto	mode1
	
	movf	MODE,w
	xorlw	2
	btfsc	STATUS,Z
	goto	mode2
	
	movf	MODE,w
	xorlw	3
	btfsc	STATUS,Z
	goto	mode3
		
	clrf	MODE		;if any other mode clear to mode 0
	goto	MAIN		


chgmode:
	movf	PORTA,w
	andlw	3		;set Z if both keys pressed
	btfsc	STATUS,Z	
	goto	POFF1		;turn power off if both pressed	or reset 
				;to mode 0 if in mode 3
	
	xorlw	3
	btfsc	STATUS,Z	
	goto	chklow		;no keys pressed so check POFF timers 		
					
				;if here one key is pressed
	
	
				;SW1 or 2 pressed so inc/dec mode
				;except in mode 3
	btfsc	FLAGS,cont	;once only - contact bounce
	return
	bsf	FLAGS,msg	;display new mode message
	bsf	FLAGS,cont	;set flag to prevent key bounce
	
	clrf	AUTO0
	clrf	AUTO1		;reset auto power timers
	movf	MODE,w		
	xorlw	3
	btfsc	STATUS,Z	;bypass if mode 3
	return

	btfss	PORTA,SW1	;inc mode if sw1, dec if sw2
	incf	MODE
	btfss	PORTA,SW2
	decf	MODE

	return
	
			
chklow				;here if no keys pressed

	bcf	FLAGS,cont	;reset contact bounce flag
	incf	AUTO0
	btfsc	STATUS,Z
	incf	AUTO1		;inc auto power off timers

	movf	MODE,w
	xorlw	3
	btfsc	STATUS,Z
	goto	tmode3		;check mode 3 timer
			
	movf	AUTO0,w
	xorlw	80h
	btfss	STATUS,Z	;check mode 0,1,2 timers
	return
	goto	POFF
	
tmode3	movf	AUTO1,w
	xorlw	8h
	btfsc	STATUS,Z
	goto	POFF
	return

POFF1	clrf	MODE		;reset mode if in mode 3
POFF	bcf	PORTA,2		;turn power off 
	
	return			
	
	
	
mode0	btfsc	FLAGS,msg
	call	DISPLAYM0
	call	MEASURE
	call	DISPLAYL1	;display freq on LCD line 1
	movf	CHAN,w
	btfss	STATUS,Z	;bypass 2nd line if no PW data
	call	DISPLAYL2	;display frame
	call	DELAY
	call	DELAY
	goto	MAIN

mode1	btfss	FLAGS,msg
	goto	mode1a
	clrf	BYTE0
	clrf	BYTE1	
	call	DISPLAYM1
mode1a	call	MEASURE
	call	DISPLAY3	;display transmit channel
	call	DELAY		;pulse widths
	call	DELAY
	goto	MAIN

mode2	btfsc	FLAGS,msg
	call	DISPLAYM2
	call	PWIDTH
	call	DELAY
	di	
	call	mod2disp
	goto	MAIN	
	
mod2disp
	call	LINE2
	bsf	FLAGS,disp	;display width and period
	
	movf	BYTE1,w		;received pulse width
	call	DISBCD
	
	movlw	' '
  	call	LCDOUT
				;received frame
	
	movf	BYTE0,w
	movwf	LSB		;convert countl,h
	movf	BYTE0H,w
	movwf	MSB		;to 5 digit BCD
	call	BIN2BCD		;result in R0,R1,R2
	call	DIS5BCD		;display digits
	movlw	'm'
	call	LCDOUT
	movlw	's'
	call	LCDOUT
	call	DELAYS
	return


mode3	btfsc	FLAGS,msg
	call	DISPLAYM3
			
				;setup frame and pw
				;on first entry to mode 3
				
	movlw	7		;set frame=18ms
	movwf	BYTE0H		
	movlw	08h
	movwf	BYTE0		;1800 * 10us or 708h*10us 
	
	movlw	.150
	movwf	BYTE1		;set pulse width=1.5ms
	bsf	FLAGS,gen
																		
	di   
	BANK1           	;Defined above.
        MOVLW b'00000000'
        MOVWF TRISB     	;Configure port B0-B7 as output
	BANK0

	
mod3	;The routine loops to here continuously without
	;going back to main - hence need to look for
	;a mode change within the loop 

;	call	chgmode

	movf	MODE,w
	xorlw	3
	btfss	STATUS,Z
	goto	MAIN
	

		
mod3go	ei			;inc count every 10us 
				;using interrupt
				;
	;generate pw every 18ms
	
	movf	COUNTH,w
	btfsc	STATUS,Z
	goto	phigh

	movf	BYTE0H,w
	subwf	COUNTH,w	;c=0 if counth<byte0h
	btfss	STATUS,CY	;c=1 if counth>=byte0h
	goto	ntend	
	movf	BYTE0,w
	subwf	COUNTL,w	;c=0 if countl<byte0
	btfss	STATUS,CY	;c=1 if countl>=byte0
	goto	ntend
	clrf	COUNTL
	clrf	COUNTH
	bsf	PORTB,0	
	call	chgmode		
	goto	ntend

phigh	movf	BYTE1,w		;counth=0
	subwf	COUNTL,w	;c=1 if countl>=byte1
	btfss	STATUS,CY
	goto	mod3		;leave pulse on
	
	bcf	PORTB,0		;pulse off
	
	;lcd update

	decfsz	BYTE7		;update lcd every ff frames		
	goto	mod3

	movlw	0FFh
	movwf	BYTE7
	
	btfss	FLAGS,gen	;update only if key was pressed
	goto	mod3		;loop round
	bcf	FLAGS,gen	
	call	mod2disp	;display if key pressed	
	
ntend	
	call	changepw
	goto	mod3		;loop round


changepw	;inc or dec pw
	
	;byte1 used as pw
	;byte8 used as a counter
	
	btfsc	PORTA,SW1
	goto	mod31
				;increase pw
	decfsz	BYTE8			
	return
	
	bsf	FLAGS,gen	
	movf	BYTE1,w
	sublw	.224
	btfsc	STATUS,CY	;ncy if byte1 > 224
	incf	BYTE1		;cy  if byte1 <=224
	goto	mod32
	
mod31	btfsc	PORTA,SW2
	goto	mod32
				;decrease pw
	decfsz	BYTE8		
	return
	bsf	FLAGS,gen
	movf	BYTE1,w
	sublw	.75
	btfss	STATUS,CY	;ncy if byte1 > 0.75ms
	decf	BYTE1		;cy  if byte1 <=0.75ms
	
	
mod32	movlw	60h		;adjust response
	movwf	BYTE8   	
	return
		

	
	

	

PWIDTH:
	call	INTSETUP	;enable tmr0 interrupt
	clrf	COUNTL
	movlw	01h
	movwf	COUNTH
	
ploop1	
	movf	COUNTH,w
	btfsc	STATUS,Z
	return			;ret if rollover-no input
	btfsc	PORTB,0
	goto	ploop1		;wait for low
	
	
	
ploop2	movf	COUNTH,w
	btfsc	STATUS,Z
	return			;ret if rollover-no input
	btfss	PORTB,0		;wait for high
	goto	ploop2
	
	
dethi1	clrf	COUNTL
	clrf	COUNTH
	incf	COUNTH


detlo	movf	COUNTH,w
	btfsc	STATUS,Z
	return			;ret if rollover-no input
	btfsc	PORTB,0		;wait for low
	goto	detlo
	
	movf	COUNTL,w
	movwf	BYTE1		;capture pulse width
	
dethi2	movf	COUNTH,w
	btfsc	STATUS,Z
	return			;ret if rollover-no input
	btfss	PORTB,0		;wait for high
	goto	dethi2	
	
	di
	movf	COUNTL,w
	movwf	BYTE0
	decf	COUNTH,w
	movwf	BYTE0H		;capture pulse frame period
	return


MEASURE:
	call	RFSETUP

	movlw	040h
	movwf	GEN1
	movwf	GEN2
meas1	decf	GEN1		;loop until approx 2.5ms	
	btfsc	STATUS,Z	;after last rfoff period	
	decf	GEN2
	movf	GEN2,w
	btfsc	STATUS,Z
	goto	measend		;exit if excessive looping>160ms


	movlw	70h		;2.5ms delay 
	movwf	DELAY1
	movlw	02h		
	movwf	DELAY2
ms25	call	RFACTIVITY	
	btfss	FLAGS,gen		;
	goto 	meas1		;rfoff detected - loop again
	decfsz	DELAY1		;2.5ms delay so that freq 
	goto	ms25		;measurement is done at end
	decfsz	DELAY2		;of frame - 		
	goto	ms25	

		
	call	FMETER		;measure frequency (1ms gate)
	call	PULSES		;measure channel pulses																											
measend	return


PULSES:	
	call	RFSETUP
	clrf	FLAGS
	clrf	COUNTL
	clrf	COUNTH
	clrf	STORE1
	clrf	STORE2
	movlw	4h
	movwf	GEN1
	clrf	CHAN
	clrf	BYTE0
	clrf	BYTE0H
	clrf	BYTE1
	clrf	BYTE2
	clrf	BYTE3
	clrf	BYTE4
	clrf	BYTE5
	clrf	BYTE6
	clrf	BYTE7
	clrf	BYTE8
	
PUL1:			
	movlw	.31		;this delay sets the loop time to		
	movwf	DELAY1		;approx 50us	
del3	decfsz	DELAY1	
	goto	del3	

	nop
	nop			;fine tuning

	call	RFACTIVITY	
	btfsc	FLAGS,gen
	goto	rfonn
rfoff	bcf	FLAGS,rfon		
	goto	DOLOOP
			
rfonn	btfsc	FLAGS,rfon
	goto	DOLOOP
	bsf	FLAGS,rfon
	movf	STORE1,w
	sublw	SYNCVAL		;ncy if store1>sync value (about 3ms)
	btfss	STATUS,CY
	goto	syndet
	movf	FSR,w		
	xorlw	BYTE8+1		;limit to 8 channels
	btfsc	STATUS,Z
	goto	doloop1
	movf	STORE1,w
	movwf	INDF		;save count in BYTE N
	incf	FSR
doloop1	clrf	STORE1		;clear count on rising edge	
	goto	DOLOOP		;of rfon
	
syndet		
	btfsc	FLAGS,sync
	goto	getperiod	;second time at sync det
	bsf	FLAGS,sync	;first time at sync det
	clrf	COUNTL
	clrf	COUNTH
	goto	doloop2
			
getperiod
	bcf	FLAGS,sync
	movf	COUNTL,w	;save frame time
	movwf	BYTE0
	movf	COUNTH,w
	movwf	BYTE0H
	
	movlw	BYTE1
	subwf	FSR,w
	movwf	CHAN		;get no of channels
	goto	endpul1
			
doloop2	movlw	BYTE1
	movwf	FSR		;initiate FSR to first byte
	clrf	STORE1		;clear count on rising edge 
				;of rfon				
		
DOLOOP	movlw	1		;inc countl,h for frame
	addwf	COUNTL		;value
	btfsc	STATUS,CY
	incf	COUNTH

	incf	STORE1		;inc store1 for pulse value							
	btfsc	STATUS,Z
	decf	STORE1		;inc up to ff

	decfsz	STORE2		;do loop 256 times
	goto	PUL1						
	decfsz	GEN1
	goto	PUL1

endpul	return

endpul1	
	
  	;divide values by 2 before converting to bcd
  	;in display routine 
	
	bcf	STATUS,CY
	rrf	BYTE0H
	rrf	BYTE0	
  	bcf	STATUS,CY
	rrf	BYTE1	 
	bcf	STATUS,CY
	rrf	BYTE2
	bcf	STATUS,CY
	rrf	BYTE3	 
	bcf	STATUS,CY
	rrf	BYTE4	 
  	bcf	STATUS,CY
	rrf	BYTE5	
  	bcf	STATUS,CY
	rrf	BYTE6	
  	bcf	STATUS,CY
	rrf	BYTE7	
  	bcf	STATUS,CY
	rrf	BYTE8	
  	
  	return
  	
 
RFACTIVITY:			

	
	movlw	0FFh
	bcf	INTCON,2						
	movwf	TMR		;seed timer and clear prescaler	
	nop
	nop

	bcf	FLAGS,gen															
	btfsc	INTCON,2
	bsf	FLAGS,gen	;set bit7 if rf detected												
			
	return
																																										
						
								
GATE1L	EQU	0F4h
GATE1H	EQU	1h	;500d * 5=2500 *.4us = 1ms (10mhz xtal)


												
FMETER:	call	FREQSETUP		
	
	movlw	GATE1L	
	movwf	COUNTL
	movlw	GATE1H
	movwf	COUNTH		;set gate time to 2500 cycles=1ms

	call	GATE
	return
	




GATE:	
	bsf	INTCON,5	
	bcf	INTCON,7	;no interrupts
	bcf	INTCON,2	;reset o/f flag
	
	bcf	PORTA,3	
	BANK1
	movlw	b'10011'
	movwf	TRISA		
	BANK0			;PortA bit3 = 0 
	
	clrf	TMR		;clear tmr0 and short input to gnd via res
	nop
	nop
	
	BANK1
	incf	COUNTH
	movlw	b'11011'	;force PORTA.3 to hiz- 
	movwf	TRISA	        ;allow tmr to clock		
	

;GATE OPEN   - the value in countl,h is decremented to zero
;              this results in exactly 2500 cycles
;	       or 1ms with a 10Mhz clock


			        	
loop1:	decfsz	COUNTL		;dec countl and counth in 5 cycles
	goto	loop1a
	decfsz	COUNTH
loop1a:	goto	loop1	
	
	
	movlw	b'10011'
	movwf	TRISA   	;force PORTA.3 to 0 -stop count				
	
;GATE CLOSED

						
	BANK0
		
	movf	TMR,w
	movwf	FREQH		;capture high count
	bcf	FLAGS,gen
	btfsc	INTCON,2	;test if tmr overflowed
	bsf	FLAGS,gen	;set flags.7 if overflow
	
		
	clrf	FREQL
loop2:	bsf	PORTA,3
	bcf	PORTA,3		;generate pulse to increment prescaler
	incf	FREQL
	movf	FREQH,w
	xorwf	TMR,w		;check if TMR has incremented
	btfsc	STATUS,Z	;z set if not - pulse again
	goto	loop2																			
	comf	FREQL
	incf	FREQL		;2's complement -equiv of FF-pulses	
	
	BANK1
	movlw	b'11011'
	movwf	TRISA		;set porta.3 back to i/p	
	BANK0
	
	return
	



	
FREQSETUP:
	BANK1
	movlw	b'00100111'	;tmr0 source-tocki pin,
	movwf	OPTIO		;pos edge,prescale=256			
	BANK0
	return
	
RFSETUP:
	BANK1
	clrf	INTCON		;allow no interrupts
	movlw	b'00100011'	;tmr0 source-tocki pin,
	movwf	OPTIO		;pos edge,prescale=16		
	BANK0
	return

			
INTSETUP:
	BANK1
	movlw	b'01001000'	;tmr0 rate 1:1
	movwf	OPTIO		;int on rising edge
	movlw	b'10100000'	;enable tmr0 interupts
	movwf	INTCON
	BANK0
	return
					
	
INTERRUPT:	;inc COUNT every 10us (with 10MHZ XTAL)		

	push			
	movlw	.242		;10us
;	movlw	.217		;20us
	movwf	TMR		;seed timer
	incf	COUNTL	
	btfsc	STATUS,Z
	incf	COUNTH		;increment 16 bit counter
		
intend	bcf	INTCON,2
	pop
	retfie



;****************************************************************

LCDSETUP:

;This routine assumes the LCD hardware is connected as follows:-

;RB0	I/O
;RB1	OUTPUT 	LCD D4
;RB2	OUTPUT  LCD D5
;RB3    OUTPUT  LCD D6
;RB4    OUTPUT  LCD D7
;RB5    OUTPUT  LCD RS
;RB6	OUTPUT  LCD E
;RB7    I/O

;The LCD R/W line is at gnd - write only

;FILES USED FOR LCD DRIVER

TEMP1:	EQU 27h		;
TEMP2:	EQU 28h		;
DELAY1: EQU 29h        	;
DELAY2: EQU 2Ah        	;
STORE1: EQU 2Bh        	;
STORE2: EQU 2Ch        	;
GEN1: 	EQU 2Dh        	;
GEN2:  	EQU 2Eh  	;
MASK:   EQU 2Fh         ;


;MASK USE:
;bit 0
;bit 1
;bit 2
;bit 3
;bit 4
;bit 5 RS flag for LCD
;bit 6
;bit 7

RS:	EQU 	5
E:	EQU	6


;initialise LCD display  


	
;LCD control   reset RS bit  (bcf MASK,RS)

;  d7  d6  d5  d4  d3  d2  d1  d0

;  0   0   0   0   0   0   0   1   clear display (LCDCLR)        

;  0   0   0   0   0   0   1   0   home cursor (LCDHOME)

;  0   0   0   0   0   1  I/D  S   Inc(1)/Dec(0),with Shift(1) (LCDENTRY)

;  0   0   0   0   1   D   C   B   Disp on(1), Cursor on(1), Blink(1) (LCDON)          

;  0   0   0   1  S/C R/L  0   0   S/C(1) disp shift,S/C(0) cursor shift  
;                                  R/L(1) right, R/L(0) left (LCDSHIFT)

;  0   0   1  DL   N   F   0   0   DL(1)-8 bits,DL(0)-4 bits (LCDFUNCT)
;                                  N(1)-2 lines, N(0)-1 line
;                                  F(1)-5x10 dots,F(0)-0.5x7dots font

;  1   0   0   0   0   0   0   0   cursor to start of first  line
;  1   1   0   0   0   0   0   0   cursor to start of second line
;  1   0   0   1   0   0   0   0   cursor to start of third  line
;  1   1   0   1   0   0   0   0   cursor to start of fourth line
 
LCLR:	EQU	B'00000001'  ;clear display
LHOME:	EQU	B'00000010'  ;home display
LENTRY:	EQU	B'00000110'  ;inc dd address
LON:	EQU	B'00001100'  ;display on, cursor off, blink off
LFUNCT:	EQU	B'00101000'  ;4 bit i/f, 2/4 line, 5x7 dots	
LSHIFT:	EQU	B'00010100'  ;shift cursor, right
LLINE1:	EQU	B'10000000'  ;line 1
LLINE2:	EQU	B'11000000'  ;line 2
LLINE3:	EQU	B'10010000'  ;line 3
LLINE4:	EQU	B'11010000'  ;line 4

  	
 
        BANK1           	;Defined above.
        MOVLW b'00000001'
        MOVWF TRISB     	;Configure port B1-B7 as output, B0 as input

        movlw b'00011011'
        MOVWF TRISA     	; A0-A4 as input, A2=o/p
        
        MOVLW b'00000110' 	;set timer ratio 1:128, en PORTB pullup
        MOVWF OPTIO
        BANK0

        clrf	INTCON	;no interrupts
                       
	
	movlw	04h
	movwf	PORTA		;latch power on
        clrf	PORTB
        call 	RESREG     	;reset all working bytes
       
SETLCD: bcf 	MASK,RS   	;clear RS flag
      	call	DELAY
      	call	DELAY
      	call	DELAY
  
        movlw	LFUNCT		;4 bits, 2 lines, 5x7 dots
        call	LCDOUT
        movlw	LON   		;disp on, cursor on, blink on
        call	LCDOUT
        movlw	LENTRY		;inc display address
        call	LCDOUT
	movlw	LCLR   		;clear display
        call	LCDOUT
	call	DELAY
        movlw	LHOME 		;home display 
        call	LCDOUT          
	call	DELAY
	return
	 

                         
                                                          
LCDCLR:	bcf     MASK,RS   	;clear RS flag
      	movlw	LCLR   		;clear display
        call	LCDOUT
	call	DELAY
        bsf     MASK,RS
        return
	

      

LCDOUT: movwf STORE1
	movf  MASK,W   		;get RS and store it in STORE2
        andlw b'00100000' 	;(RS = bit 5)
        movwf STORE2    	
        bcf 	STORE2,0
        btfsc	PORTB,0
        bsf	STORE2,0	;include existing pb0
           	
	movlw	50h		;set min time between sending full
        movwf GEN2      	;bytes to LCD 
DLAY:   decfsz GEN2,F   
        goto DLAY       
        call SENDNIB    	;send MS nibble
        call SENDNIB    	;send LS nibble
        RETURN

SENDNIB:                	;get and send data nibble
        swapf STORE1,F  	;get nibble
        rlf STORE1,W    	;rotate left as data goes to PORT B1-B4
        andlw b'00011110'
        iorwf STORE2,W  	;OR the RS bit and bit0 
	movwf PORTB     	;output the byte
        bsf PORTB,E     	;set E high
        bcf PORTB,E     	;set E low
        return
        
RESREG: movlw 20h		;reset all user register files to 0
        movwf GEN1
        movlw 0Dh
        movwf FSR
RESR    clrf INDF
        incf FSR,F
        decfsz GEN1,F
        goto RESR
        return
        
        

DELAYS:	
	
	movlw	40h		;19ms delay with 10mhz clock
	goto	DELAY+1	
DELAY:	movlw	0FFh		;78ms delay with 10mhz clock
	movwf	DELAY2
del2	movwf	DELAY1
del1	decfsz	DELAY1
	goto	del1	
	decfsz	DELAY2
	goto	del2
	return	

WAIT:	movlw	10h
	movwf	TEMP1
del10	call	DELAY
	decfsz	TEMP1
	goto	del10
	return
	
			
DISPLAYL2:
	call	LINE2
		
	movlw	'F'
	call	LCDOUT
	movlw	'R'
	call	LCDOUT
	movlw	'A'
	call	LCDOUT
	movlw	'M' 
	call	LCDOUT
	movlw	'E'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	bcf	FLAGS,disp
	movf	BYTE0,w
	call	DISBCD
	return
	
	
DISBCD:	movwf	LSB
	call	BIN8BCD3    
	
	movf	R0,w
        andlw	0Fh
        addlw	30h
        call	LCDOUT
	
	btfss	FLAGS,disp
	goto	by11
	movlw	'.'
	call	LCDOUT

by11	swapf	R1,w
        andlw	0fh
        addlw	30h
        call	LCDOUT
	
	btfsc	FLAGS,disp
	goto	by12
	movlw	'.'
	call	LCDOUT

by12  	movf	R1,w
        andlw	0Fh
        addlw	30h
        call	LCDOUT
	movlw	'm'
	call	LCDOUT
	movlw	's'
	call	LCDOUT
      	     	
      	RETURN 	  		  		  	
        	  		  		  	        	  		  		  	        	  		  		  	
DISPLAY3:
  	
  	call	LINE1
  		
  	movf	BYTE1,w
	call	DISPWID

	movf	CHAN,w
	xorlw	0
	btfsc	STATUS,Z
	goto	fill1

	movf	CHAN,w
	xorlw	1
	btfsc	STATUS,Z
	goto	fill1
  	
  	movf	BYTE2,w
  	call	DISPWID
        
	movf	CHAN,w
	xorlw	2
	btfsc	STATUS,Z
	goto	fill1
	
  	
  	movf	BYTE3,w
	call	DISPWID
	
	movf	CHAN,w
	xorlw	3
	btfsc	STATUS,Z
	goto	fill1
	
	movf	BYTE4,w
	call	DISPWID
	call	LINE2
		
	movf	CHAN,w
	xorlw	4
	btfsc	STATUS,Z
	goto	fill2
	
	movf	BYTE5,w
	call	DISPWID
	
	movf	CHAN,w
	xorlw	5
	btfsc	STATUS,Z
	goto	fill2
	
	movf	BYTE6,w
	call	DISPWID
	
	movf	CHAN,w
	xorlw	6
	btfsc	STATUS,Z
	goto	fill2
	
	movf	BYTE7,w
	call	DISPWID
	
	movf	CHAN,w
	xorlw	7
	btfsc	STATUS,Z
	goto	fill2
	
	movf	BYTE8,w
	call	DISPWID    
	
	return
	
	
fill1:	call	CLLINE
	call	LINE2
	call	CLLINE
    	return

fill2:	call	CLLINE
    	return   	
 
DISPWID:
		
	call	B8TOBCD    
	movf	R0,w
        call	LCDOUT
	movlw	'.'
	call	LCDOUT
	movf	R1,w
        call	LCDOUT	
	movlw	' ' 
	call	LCDOUT
	return
	   	
    
    
    
CLLINE:	;write 16 spaces to current line

	movlw	10h
	movwf	TEMP1
clr1	movlw	' '
	call	LCDOUT
	decfsz	TEMP1
	goto	clr1
	return
	
	

LINE1:	bcf	MASK,RS
	movlw	LLINE1
	call	LCDOUT
	bsf	MASK,RS
	return

LINE2:	bcf	MASK,RS
	movlw	LLINE2
	call	LCDOUT
	bsf	MASK,RS
	return

DISPLAYL1:	
	call	LINE1
	bcf	FLAGS,disp		;display freq
		
	movf	FREQL,w		;convert freqh,freql
	movwf	LSB		;to 5 digit BCD
	movf	FREQH,w		;
	movwf	MSB		;
	call	BIN2BCD		;result in R0,R1,R2
	call	DIS5BCD	

	
	movlw	'M'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'z'
	call	LCDOUT		;print mhz	
	
	movlw	' '
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movf	CHAN,w
	btfsc	STATUS,Z
	goto	fill1		;clear line if ch=0 and return
	call	BIN2ASC
	movf	TEMP2,w
        call	LCDOUT
	movlw	'c'
	call	LCDOUT
	movlw	'h'		
	call	LCDOUT
	movlw	'a'
	call	LCDOUT
	movlw	'n'		
	call	LCDOUT
	
	return	


DIS5BCD  	;Display 5 digit BCD value stored in R0,R1,R2
		;                                    06 55 35
	
	btfsc	FLAGS,disp	;if flag.disp set 
	goto	byp11		;miss 1st digit and change dec point
	movf	R0,w		
	andlw	0Fh
	addlw	30h
	call	LCDOUT		;print digit 5
byp11	swapf	R1,w
	andlw	0Fh
	addlw	30h
	call	LCDOUT		;print digit 4

	btfsc	FLAGS,disp
	goto	byp12
	movlw	'.'
	call	LCDOUT		;print dec point
byp12	
	movf	R1,w	
	andlw	0Fh
	addlw	30h
	call	LCDOUT		;print digit 3

	btfss	FLAGS,disp
	goto	byp13
	movlw	'.'
	call	LCDOUT		;print dec point
byp13			
	swapf	R2,w
	andlw	0Fh
	addlw	30h
	call	LCDOUT		;print digit 2
	
	movf	R2,w
	andlw	0Fh
	addlw	30h
	call	LCDOUT		;print digit 1
	return
	
DISPLAYM0:
	call	LCDCLR
	call	LINE1
		
	movlw	'T'
	call	LCDOUT
	movlw	'X'
	call	LCDOUT	
	movlw	' '
	call	LCDOUT
	movlw	'F'
	call	LCDOUT
	movlw	'R'
	call	LCDOUT
	movlw	'E'
	call	LCDOUT
	movlw	'Q'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'H'
	call	LCDOUT
	movlw	'A'
	call	LCDOUT
	movlw	'N'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'N'
	call	LCDOUT
	movlw	'O'
	call	LCDOUT
	
	call	LINE2
	movlw	'F'
	call	LCDOUT
	movlw	'R'
	call	LCDOUT
	movlw	'A'
	call	LCDOUT
	movlw	'M'
	call	LCDOUT
	movlw	'E'
	call	LCDOUT

	call	WAIT
	
	bcf	FLAGS,msg
	call	LCDCLR
	
	return

	
DISPLAYM1
	call	LCDCLR
	call	LINE1
	
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT	
	movlw	'1'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'2'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'3'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'4'	
	call	LCDOUT
	
	call	LINE2
	
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT	
	movlw	'5'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'6'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'7'
	call	LCDOUT
	movlw	' '
	call	LCDOUT
	movlw	'C'
	call	LCDOUT
	movlw	'h'
	call	LCDOUT
	movlw	'8'	
	call	LCDOUT
	
	call	WAIT
	
	bcf	FLAGS,msg
	call	LCDCLR
	
	return
		
DISPLAYM2
	call	LCDCLR
	call	LINE1
		
	movlw	'R'
	call	LCDOUT
	movlw	'X'
	call	LCDOUT	
	movlw	' '			
	call	LCDOUT
	movlw	'O'
	call	LCDOUT
	movlw	'U'
	call	LCDOUT	
	movlw	'T'			
	call	LCDOUT
	movlw	'P'
	call	LCDOUT
	movlw	'U'
	call	LCDOUT	
	movlw	'T'			
	call	LCDOUT
	
	
	
	bcf	FLAGS,msg

	
	return			
	
DISPLAYM3
	call	LCDCLR
	call	LINE1
		
	movlw	'S'
	call	LCDOUT
	movlw	'E'
	call	LCDOUT	
	movlw	'R'			
	call	LCDOUT
	movlw	'V'
	call	LCDOUT
	movlw	'O'
	call	LCDOUT	
	movlw	' '			
	call	LCDOUT	
	movlw	'T'
	call	LCDOUT
	movlw	'E'
	call	LCDOUT	
	movlw	'S'			
	call	LCDOUT
	movlw	'T'
	call	LCDOUT
	
	
	bcf	FLAGS,msg

	return			
							
																
BIN2ASC:
	movwf   TEMP1           ;enter with bin in w
	movwf   TEMP2
	swapf   TEMP1
	movlw   0fh             
	andwf   TEMP1           ;high nibble
	andwf   TEMP2           ;low  nibble

	movlw   0Ah
	subwf   TEMP1,w         ;ncy if nibble <10
	bnc     bin1
	movlw   7
	addwf   TEMP1
bin1    movlw   30h
	addwf   TEMP1           ;temp1=asc high nibble

	movlw   0Ah
	subwf   TEMP2,w         ;ncy if nibble <10
	bnc     bin2
	movlw   7
	addwf   TEMP2
bin2    movlw   30h
	addwf   TEMP2           ;TEMP2=asc low nibble
	return



	
;MATHS ROUTINES

BIN2BCD:
	;16 bit binary to 5 digit BCD 
	;e.g    MSB LSB      R0 R1 R2
	;         FFFF       06 55 35
	
	;uses TEMP1,TEMP2,R0,R1,R2,MSB,LSB

	bcf	STATUS,CY
	movlw	.16
	movwf	TEMP1
	clrf	R0
	clrf	R1
	clrf	R2
loop16	rlf	LSB
	rlf	MSB
	rlf	R2
	rlf	R1
	rlf	R0
	decfsz	TEMP1
	goto	adjdec
	retlw	0
	
adjdec	movlw	R2
	movwf	FSR
	call	adjbcd
	movlw	R1
	movwf	FSR
	call	adjbcd
	movlw	R0
	movwf	FSR
	call	adjbcd
	goto	loop16
	
adjbcd	movlw	3
	addwf	0,w
	movwf	TEMP2
	btfsc	TEMP2,3
	movwf	0
	movlw	30h
	addwf	0,w
	movwf	TEMP2
	btfsc	TEMP2,7
	movwf	0
	retlw	0
	
BIN8BCD3:
	;8 bit binary to 3 digit BCD 
	;e.g   LSB     R0 R1
	;       FF     02 55
	
	;uses TEMP1,TEMP2,R0,R1,R2,LSB
	
	bcf	STATUS,CY
	movlw	.8
	movwf	TEMP1
	clrf	R0
	clrf	R1

loop161	rlf	LSB
	rlf	R1
	rlf	R0
	decfsz	TEMP1
	goto	adjdec1
	retlw	0
	
adjdec1	movlw	R1
	movwf	FSR
	call	adjbcd
	movlw	R0
	movwf	FSR
	call	adjbcd
	goto	loop161
	

	

B8TOBCD:

	;8 bit binary to 2 digit BCD 
	;e.g    W   R0 R1
	;       63  09 09																																																											
	
	movwf	R1	;lsb
	clrf	R0	;msb
gtenth	movlw	.10
	subwf	R1,w
	btfss	STATUS,CY
	goto	over
	movwf	R1	
	incf	R0
	goto	gtenth
over	movlw	30h
	addwf	R0
	addwf	R1	;convert to ascii	
	retlw	0	
	


	END
