; TEACHIND01.ASM 25MAY07 - TEACH IN 2008 PT4

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           list p=16f628       ; tell MPASM-type programmer to create a
                               ; list (LST) file

           include p16f628.inc ; bring in all standard register values

           CBLOCK h'20'
RSLINE
STORE
LOOP
LOOPA
CLKCNT
	   ENDC

           __config  $3F30     ; internal 4MHz oscillator

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

           include LCDheader.inc

MESSAG     addwf PCL,F
           retlw 'R'
           retlw 'E'
           retlw 'A'
           retlw 'D'
           retlw ' '
           retlw 'E'
           retlw 'P'
           retlw 'E'

;           include LCDroutines.inc ; (command could be placed later)

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           movlw $07           ; needed by some PICs, including PIC16F628
           movwf CMCON         ; so that PORTA is treated as digital port

           BANK1
           movlw b'00000000'   ; all PORTA as output
           movwf TRISA         ; data direction register for PORTA
           movlw b'00000000'   ; PORTB as output
           movwf TRISB         ; data direction register for PORTB
           movlw b'10000110'   ; timer 1:128, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0

           call PAUSIT
    
MAIN       call LCDSET
	   call PAUSIT

	   call LCDMSG

NOMORE     goto NOMORE             ; yes, so hold here ad infinitum!

LCDMSG     clrf LOOP               ; clear loop
           bsf RSLINE,4            ; set RS for data send
LCDMS2     movf LOOP,W             ; get table address
           call MESSAG             ; get message letter
           call LCDOUT             ; show it
           incf LOOP,F             ; inc loop
           btfss LOOP,3            ; has last LCD letter been sent?
           goto LCDMS2             ; no, so repeat for next one
	   return                  ; return to the main program

PAUSIT     movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

           include LCDroutines.inc

           END
