; TEACHINE03.ASM 10JUN07 - TEACH IN 2008 PT3
; Use of Timer at set rate, with BCD counting on LEDs

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

           include p16f628.inc

           __config $3F21     ;  external XT oscillator (3.2768MHz)

	   CBLOCK h'20'
COUNT                         ; general counter
	   ENDC

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT    clrf PORTA
           clrf PORTB
           BANK1
           clrf TRISA	           ; PORTA as output
           clrf TRISB		   ; PORTB as output
           movlw B'10000110'       ; move ratio value into W
           movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
           BANK0                   ; (light pull-ups off - bit 7 high)

           clrf COUNT              ; clear COUNT
           bcf INTCON,2            ; clear interrupt bit 2 of INTCON
                 
MAIN       btfss INTCON,2          ; has a timer time-out been detected?
           goto MAIN               ; no, so keep on reading bit 2
           bcf INTCON,2            ; yes, clear interrupt flag on bit 2
           incf COUNT,F            ; inc count
           movf COUNT,W            ; copy COUNT value into W
           addlw 6                 ; add 6 to it (check for >9)
           btfss STATUS,DC         ; is there a digit carry (is answer >15)?
           goto OUTPUT             ; no, so bypass next section
           movwf COUNT             ; yes, move new value into COUNT
           addlw 96                ; add 96 to new val (check for >90)
           btfsc STATUS,C          ; is there a byte carry (is answer > 255)
           clrf COUNT              ; yes, clear COUNT
OUTPUT     movf COUNT,W            ; get val of COUNT
           movwf PORTB             ; output it to PORTB
           goto MAIN               ; go wait for another time-out
                 
           end                     ; final line
