; TEACHINB02.ASM 07JUN07 - TEACH IN 2008 PT2

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

           include p16f628.inc

           __config  $3F30    ;  internal 4MHz oscillator

	   CBLOCK h'20'
CLKCNT
	   ENDC

           ORG 0              ; reset vector
           goto STARTIT
           ORG 4              ; Interrupt vector address
           goto STARTIT
           ORG 5              ; PIC program memory location at which to start 

STARTIT    clrf PORTA              ; clear Port A data register
           clrf PORTB              ; clear Port B data register
           BANK1                   ; BANK 1
           clrf TRISA              ; Port A direction register for output
           clrf TRISB              ; Port B direction register for output
           movlw b'10000111'  ; timer 1:256, pull-ups off (bit 7 = 1)
           movwf OPTION_REG
           BANK0                   ; BANK 0

	   call DELAY
                 
           bsf STATUS,C            ; set the Carry bit in STATUS
                 
LOOP       rlf PORTB,F             ; rotate left PORTB
	   call DELAY
           goto LOOP               ; repeat

DELAY      movlw 25                 ; set delay counter to 25
           movwf CLKCNT            ; (for 1/25th sec x 5)
           clrf INTCON             ; clear interupt flag
DELAY2                             ; 
           btfss INTCON,2          ; has a timer time-out been detected?
           goto DELAY2             ; no
           bcf INTCON,2            ; yes
           decfsz CLKCNT,F         ; dec counter, is it zero?
           goto DELAY2             ; no
           return                  ; yes

           END
