; TEACHINF05.ASM 14JUN07 - TEACH IN 2008 PT2
; sound generation demo 4

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           include p16f628.inc

           __config  h'3F21'    ; standard XT osc (3.2768MHz)

           CBLOCK h'20'
NOTELSB1
NOTEMSB1
NOTELOW1
NOTEHIGH1
FREQ
STOREA
STOREB
STOREC
LOOP
CLKCNT
DELAYVAL

DELAYCOUNT
STORE
COUNT
        ENDC

PROMVAL EQU h'70'          ; in both pages

        ORG 0              ; reset vector
        goto STARTIT
        ORG 4              ; Interrupt vector address
        goto STARTIT
        ORG 5              ; PIC program memory location at which to start 
        goto STARTIT

NOTEFREQMSB:
        andlw 15
        addwf PCL,F
        retlw 0  ; nil    0
        retlw h'41' ; * 440  1 A
        retlw 0     ; * 466  2 As
        retlw h'49' ; * 493  3 B
        retlw h'4E' ; * 523  4 C
        retlw 0     ; * 554  5 Cs
        retlw h'58' ; * 587  6 D
        retlw 0     ; * 622  7 Ds
        retlw h'62' ; * 659  8 E
        retlw h'68' ; * 699  9 F
        retlw 0     ; * 739 10 Fs
        retlw h'75' ; * 784 11 G
        retlw 0     ; * 830 12 Gs
        retlw 0     ; nil    13
        retlw 0     ; nil    14
        retlw 0     ; nil    15

NOTEFREQLSB:
        andlw 15
        addwf PCL,F
        retlw 0     ; 0  nil
        retlw h'FE' ; 1  A
        retlw 0     ; 2  As
        retlw h'F0' ; 3  B
        retlw h'72' ; 4  C
        retlw 0     ; 5  Cs
        retlw h'0A' ; 6  D
        retlw 0     ; 7  Ds
        retlw h'D8' ; 8  E
        retlw h'D8' ; 9  F
        retlw 0     ; 10 Fs
        retlw h'98' ; 11 G
        retlw 0     ; 12 Gs
        retlw 0     ; 13 nil
        retlw 0     ; 14 nil
        retlw 0     ; 15 nil

STARTIT movlw 7             ; needed by some PICs, including PIC16F628
        movwf CMCON         ; so that PORTA is treated as digital port
        clrf PORTA
        clrf PORTB

        BANK1
        movlw b'00011110'  ; RA1-RA4 as input, RA1 as output
        movwf TRISA        ; data direction register for PORTA
        movlw b'11111111'  ; all PORTB as input
        movwf TRISB        ; data direction register for PORTB
        movlw b'00000110'  ; pull-ups on (bit 7 = 0)
        movwf OPTION_REG
        BANK0 
        call PAUSIT

        clrf NOTELOW1
        clrf NOTEHIGH1
        clrf FREQ
MAIN    btfsc PORTB,0      ; is PORTB,0 low (S1 pressed)?
        goto MAIN          ; no

        clrf LOOP          ; yes
        movf LOOP,W
        call PRMGET
        movwf COUNT
        incf LOOP,F

PLAYIT  movlw 0            ; 0 sets for count of 256
        movwf CLKCNT
        movf LOOP,W
        call PRMGET
        call OUTPUT     
        incf LOOP,F
        movf LOOP,W
        xorwf COUNT,W
        btfss STATUS,Z
        goto PLAYIT

PL2     btfss PORTB,0     ; is S1 stll pressed?
        goto PL2          ; no, wait switch release
        return

OUTPUT  bcf PORTA,0
        movwf STOREC
        call NOTEFREQMSB
        movwf NOTEMSB1
        movf STOREC,W
        call NOTEFREQLSB
        movwf NOTELSB1

NOTELEN call LOOPIT
        btfss INTCON,2      ; has a timer time-out been detected?
        goto NOTELEN        ; no
        bcf INTCON,2        ; yes
        decfsz CLKCNT,F     ; dec counter, is it zero?
        goto NOTELEN        ; no
        return              ; yes

LOOPIT  movf NOTELSB1,W         ; get fixed val LSB
        addwf NOTELOW1,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH1,F       ; carry (if any) add to counter MSB

        movf NOTEMSB1,W         ; get fixed val MSB
        addwf NOTEHIGH1,F       ; add to counter MSB
        movf STATUS,W
        andlw 1
        addwf PORTA,F

        movlw 71
        movwf DELAYCOUNT

DEL2    decfsz DELAYCOUNT,F
        goto DEL2
        return

PAUSIT  movlw 5             ; set delay counter to 5
        movwf CLKCNT        ; (for 1/25th sec x 5)
        clrf INTCON         ; clear interupt flag
PAUSE                       ; initial 1/5th sec wait before setting up LCD
        btfss INTCON,2      ; has a timer time-out been detected?
        goto PAUSE          ; no
        bcf INTCON,2        ; yes
        decfsz CLKCNT,F     ; dec counter, is it zero?
        goto PAUSE          ; no
        return              ; yes

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above h'70'
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw h'55'     ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw h'AA'     ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x    retlwvices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

        org H'2100'      ; data eeprom address
        DE 14            ; 0 number of eeprom addresses needed
        DE 1             ; 1 note 1
        DE 3             ; 2 note 2
        DE 4             ; 3 note 3
        DE 6             ; 4 note 4
        DE 8             ; 5 note 5
        DE 9             ; 6 note 6
        DE 11            ; 7 note 7
        DE 9             ; 8 note 8
        DE 8             ; 9 note 9
        DE 6             ; 10 note 10
        DE 4             ; 11 note 11
        DE 3             ; 12 note 12
        DE 1             ; 13 note 13
        DE 0             ; 14 not used
        END
