; TEACHINF04.ASM 14JUN07 - TEACH IN 2008 PT2
; sound generation demo 3

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

           include p16f628.inc

           __config  h'3F21'    ; standard XT osc (3.2768MHz)

           CBLOCK h'20'
NOTELSB1
NOTEMSB1
NOTELOW1
NOTEHIGH1
FREQ
STOREA
STOREB
STOREC
LOOP
CLKCNT
DELAYVAL

DELAYCOUNT
STORE
        ENDC

        ORG 0              ; reset vector
        goto STARTIT
        ORG 4              ; Interrupt vector address
        goto STARTIT
        ORG 5              ; PIC program memory location at which to start 
        goto STARTIT

NOTEFREQMSB:
        andlw 15
        addwf PCL,F
        retlw 0  ; nil    0
        retlw h'41' ; * 440  1 A
        retlw 0     ; * 466  2 As
        retlw h'49' ; * 493  3 B
        retlw h'4E' ; * 523  4 C
        retlw 0     ; * 554  5 Cs
        retlw h'58' ; * 587  6 D
        retlw 0     ; * 622  7 Ds
        retlw h'62' ; * 659  8 E
        retlw h'68' ; * 699  9 F
        retlw 0     ; * 739 10 Fs
        retlw h'75' ; * 784 11 G
        retlw 0     ; * 830 12 Gs
        retlw 0     ; nil    13
        retlw 0     ; nil    14
        retlw 0     ; nil    15

NOTEFREQLSB:
        andlw 15
        addwf PCL,F
        retlw 0     ; 0  nil
        retlw h'FE' ; 1  A
        retlw 0     ; 2  As
        retlw h'F0' ; 3  B
        retlw h'72' ; 4  C
        retlw 0     ; 5  Cs
        retlw h'0A' ; 6  D
        retlw 0     ; 7  Ds
        retlw h'D8' ; 8  E
        retlw h'D8' ; 9  F
        retlw 0     ; 10 Fs
        retlw h'98' ; 11 G
        retlw 0     ; 12 Gs
        retlw 0     ; 13 nil
        retlw 0     ; 14 nil
        retlw 0     ; 15 nil

STARTIT movlw 7             ; needed by some PICs, including PIC16F628
        movwf CMCON         ; so that PORTA is treated as digital port
        clrf PORTA
        clrf PORTB

        BANK1
        movlw b'00011110'  ; RA1-RA4 as input, RA1 as output
        movwf TRISA        ; data direction register for PORTA
        movlw b'11111111'  ; all PORTB as input
        movwf TRISB        ; data direction register for PORTB
        movlw b'00000110'  ; pull-ups on (bit 7 = 0)
        movwf OPTION_REG
        BANK0 
        call PAUSIT

        clrf NOTELOW1
        clrf NOTEHIGH1
        clrf FREQ

MAIN    comf PORTA,W      ; get PORTA, inverted
        andlw b'00011110' ; select only RA4-RA1
        btfss STATUS,Z
        goto TRYA
        comf PORTB,W      ; get PORTB, inverted
        btfss STATUS,Z
        goto TRYB
        goto MAIN

TRYA    movwf STOREB      ; store it
AM0     btfss STOREB,1
        goto AM1
        movlw 2 ; A#
        goto OUTPUT
AM1     btfss STOREB,2
        goto AM2
        movlw 5 ; C#
        goto OUTPUT
AM2     btfss STOREB,3
        goto AM3
        movlw 7 ; D#
        goto OUTPUT
AM3     btfss STOREB,4
        goto MAIN
        movlw 10 ; F#
        goto OUTPUT

TRYB    movwf STOREB      ; store it
M0      btfss STOREB,0
        goto M1
        movlw 1 ; A
        goto OUTPUT

M1      btfss STOREB,1
        goto M2
        movlw 3  ; B
        goto OUTPUT

M2      btfss STOREB,2
        goto M3
        movlw 4  ; C
        goto OUTPUT

M3      btfss STOREB,3
        goto M4
        movlw 6  ; D
        goto OUTPUT

M4      btfss STOREB,4
        goto M5
        movlw 8  ; E
        goto OUTPUT

M5      btfss STOREB,5
        goto M6
        movlw 9  ; F
        goto OUTPUT

M6      btfss STOREB,6
        goto M7
        movlw 11 ; G
        goto OUTPUT

M7      btfss STOREB,7
        goto MAIN
        movlw 12 ; G#
        goto OUTPUT

OUTPUT  bcf PORTA,0
        movwf STOREC
        call NOTEFREQMSB
        movwf NOTEMSB1
        movf STOREC,W
        call NOTEFREQLSB
        movwf NOTELSB1

OP2     call LOOPIT
        comf PORTB,W
        movwf STORE
        comf PORTA,W
        andlw b'00011110'
        iorwf STORE,W
        btfss STATUS,Z
        goto OP2
        bcf PORTA,0
        goto MAIN

LOOPIT  movf NOTELSB1,W         ; get fixed val LSB
        addwf NOTELOW1,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH1,F       ; carry (if any) add to counter MSB

        movf NOTEMSB1,W         ; get fixed val MSB
        addwf NOTEHIGH1,F       ; add to counter MSB
        movf STATUS,W
        andlw 1
        addwf PORTA,F

        movlw 71 ;2
        movwf DELAYCOUNT

DEL2    decfsz DELAYCOUNT,F
        goto DEL2
        return

PAUSIT  movlw 5             ; set delay counter to 5
        movwf CLKCNT        ; (for 1/25th sec x 5)
        clrf INTCON         ; clear interupt flag
PAUSE                       ; initial 1/5th sec wait before setting up LCD
        btfss INTCON,2      ; has a timer time-out been detected?
        goto PAUSE          ; no
        bcf INTCON,2        ; yes
        decfsz CLKCNT,F     ; dec counter, is it zero?
        goto PAUSE          ; no
        return              ; yes

        END
