; Final issue of Battery operated tilt module software. (Ident 2)
; Transmits NRZ Unipolar Serial comms to RXR at 300baud
; Transmits ten byte packet inc. ident, tx number, analogue
; values and calculated CRC byte.
; James Humphris
; 29th March 1998.
; Version 4.17

list P=PIC16C71
include "P16C71.INC"



; Define all bits required for use as follows :

Intcon		equ 0B	; Interrupt register
Status		equ 3	; Status Register
PortA		equ 5   ; Port A
PortB		equ 6	; Port B
Option1 	equ 4	; Option reg 1 RB
Option2		equ 5	; Option reg 2 RB
Option3		equ 6	; Option reg 3 RB

Adcon		equ 8	; Adcon registers
Adres		equ 9	; ADC result register
c		equ 0 	; Carry bit

Tilt		equ 2	; RA2
Temp		equ 3	; RA3
Transmit	equ 7	; RB7
StatusLED	equ 0	; RB0

TXByte 		equ 20	; Register for TXbyte.
intindex1	equ 21	; delay register 1
intindex2	equ 22	; delay register 2
Bitcounter 	equ 23	; bit counter register
temp		equ 24	; temp reg
temp2		equ 25	; temp reg 2
temp3		equ 26	; temp reg 3
ident		equ 27	; ident code register
number		equ 28	; tx number register
Data1		equ 29 	; analogue channel 1 result register
Data2		equ 2A	; analogue channel 2 result register
Data3		equ 2B	; Pad character 1
Data4		equ 2C	; Pad character 2
Data5		equ 2D	; Pad character 3
CRCByte		equ 1D  ; CRC Result register
CRCCounter	equ 1E	; CRC Bit counter
CRCWorking	equ 1F	; CRC working register
OldData		equ 2E	; Old Temp value
OldData2	equ 2F	; Option Registers
LngDelay	equ 1C	; Long Wait Register

org 0x000		; Organise code as appropiate

; Initialise and Setup ports

	BSF	Status, RP0		; Select register bank 1
	MOVLW	0x00			
	MOVWF	Adcon			; Setup port A as all Analogue
	BCF 	Status, RP0		; Select Register Bank 0
	CLRF	Status			; Clear Status Reg	
	CLRF	Intcon			; No interrupts
	CLRF 	PortA			; Clear Port A
	CLRF 	PortB			; Clear Port B	
	BSF	Status, RP0		; Select Register Bank 1
	MOVLW  	0xFF		 
 	MOVWF	TRISA			; Set Port A as inputs.
	MOVLW	0x7E 
	MOVWF	TRISB			; Set Port B as outputs.
	BCF	OPTION_REG,7		; Switch on internal pull up's
	BCF 	Status, RP0		; Select Register Bank 0
	MOVLW	0xFF			; test TX bit
	MOVWF	temp			; test TX bit
	MOVLW	0x00
	MOVWF	temp2
	MOVLW	0x00			; Setup tx number register
	MOVWF	number

Start:	MOVLW	0x00			; Init Data to Zero
	MOVWF	Data1
	MOVWF	Data2
	MOVWF	Data3
	MOVWF	Data4
	MOVWF	Data5

; If Running two sensors simultaneously, one must use OldData1 and the other OldData2.
	
	call	RDTilt
	goto 	Start


; Device driver interface for TILT ALARM

RDTilt:		BSF 	Status, RP0		; Select Register Bank 1
		MOVLW	0x02			; setup for digital input !
		MOVWF	Adcon
		BCF 	Status, RP0		; Select Register Bank 0
		MOVLW	0x02			; Setup ident register	!!!!! IDENT = 02 !!!!!
		MOVWF	ident
	
		BCF 	Status,RP0		; Clear Carry
		BTFSS	PortA,2			; If bit not set then alarm !!
		return
		Call	LongDelay
		MOVLW	0xFF
		MOVWF	Data1
		MOVWF	Data2
		MOVWF	Data3
		MOVWF	Data4
		MOVWF	Data5
		Call	TXpacket
		return



; This  subroutine transmits a packet of nine bytes as follows: 
				
;				Sync 		 (1) Byte 	Fixed 55h (no register)
;				Ident 		 (1) byte	ident
; 				Tx number 	 (1) byte	number (cyclic)
;				Analogue results (2) bytes	Analogue1, Analogue2
;				pad characters 	 (3) bytes	Pad1 }
;								Pad2 }	(for future use)
;								Pad3 }
;				CRC Checksum 	 (1) byte	CRCByte

; All byte values need to be present in registers before calling the routine.
; Packet consists of nine bytes transmitted sequentially MSB -> LSB seperated by 
; a single bit time.

TXpacket:       INCF	number		; increment TX number
		MOVLW	0x55		; setup sunc byte
		MOVWF	TXByte
		call	TransmitByte	; Transmit sync byte
		MOVLW	0x00
		MOVWF	CRCByte		; Setup CRC byte to zero
		MOVWF	CRCWorking	; Setup working to zero
		MOVFW	ident
		MOVWF	TXByte
		call	TransmitByte	; Transmit ident
		MOVFW	number		
		MOVWF	TXByte
		call	TransmitByte	; Transmit TX number
		MOVFW	Data1	
		MOVWF	TXByte		
		call	TransmitByte	; Transmit Data
		MOVFW	Data2	
		MOVWF	TXByte		
		call	TransmitByte	; Transmit Data
		MOVFW	Data3
		MOVWF	TXByte		
		call	TransmitByte	; Transmit Data
		MOVFW	Data4
		MOVWF	TXByte		
		call	TransmitByte	; Transmit Data
		MOVFW	Data5
		MOVWF	TXByte		
		call	TransmitByte	; Transmit Data
		MOVLW	0x06		; Calculate final CRC
		MOVWF	CRCCounter
		MOVLW	0x00	
		MOVWF	CRCWorking
		call 	CRC		; finish off CRC procedure
		MOVFW	CRCByte
		MOVWF	TXByte		
		call	TransmitByte	; Transmit CRC Checksum
		MOVLW	0x00
		MOVWF	CRCByte		; Setup CRC byte to zero
	
		return
		
; This routine transmits the byte held in TXByte register. The timing is set for approximatly
; 300bps. A byte structure is as follows :
;
;		/-----0000011111222223333344444555556666677777_____/

; Start bit, eight data bits and a delay (stop bit) before next transmission

CRC:		BCF	Status,C	; Clear carry ready for CRC
		MOVFW	CRCCounter
		MOVWF	intindex1	; Setup eight bytes
NextCRCBit:	DECF	intindex1
		SKPNZ	
		goto    EndOfCRC	; end
		RLF	CRCWorking		
		RLF	CRCByte		; Transfer MSB into CRC byte
		BTFSS	CRCByte,4	; Test Pop ! bit
		Goto 	NextCRCBit	; If Pop bit '0' goto next bit
		MOVLW	0x17		; If Pop bit '1' Move Poly into W
		XORWF	CRCByte		; XOR Poly and CRCByte
		Goto	NextCRCBit	
EndOfCRC:	Return			;

			

TransmitByte:	MOVLW	0x09
		MOVWF	CRCCounter
		MOVFW	TXByte
		MOVWF	CRCWorking		; Copy byte into CRC working register
		Call	CRC
		BCF	Status,c		; Clear carry
		BCF	PortB,StatusLED		; Switch on status LED
		MOVLW	0x08			; Eight bits per word
		MOVWF	Bitcounter
nextbit:	BSF	PortB,Transmit		; beginning of start bit
		call 	delaybit 		
nextbit2:	RRF	TXByte			; Rotate TXbyte bit into carry.
		BTFSC	Status,c		; Test carry clear
		BSF	PortB,Transmit		; Set bit if carry set	
		BTFSS	Status,c		; Test carry set
		BCF	PortB,Transmit		; Clear bit if carry clear
		call 	delaybit		; wait between bits sent
		decfsz	Bitcounter		; test number of bits sent
		goto 	nextbit2		; Jump if eight bits sent	
		BCF	PortB,Transmit		; Ensure TXR is off for delay
		BSF	PortB,StatusLED		; Switch off Status LED
		call 	delaybit		; wait for a while
		return				; go back


;Delay routines:
;-----------------------------------------------------------------------------------
delaybit:				; A bit is 3087 instructions long at 300bps.
		movlw 	0x5A		; This routine delays for 3065 instructions.
		movwf 	intindex2
		
redelay14:	movlw 	0x0A		
		movwf	intindex1

delay14:	decfsz 	intindex1
		goto 	delay14
	
		decfsz	intindex2
		goto 	redelay14
		return

LongDelay:
		movLW	0xFF
		MOVWF	LngDelay
Dly:		call	delaybit
		decfsz	LngDelay
		goto 	Dly	
		return
end
