

;	ͻ
;	 WRITTEN BY            M.DELANEY      
;	 DATE                  SEPT 21 1999   
;	 FILE SAVED AS         AAVIS.ASM      
;	 FOR PIC 16f83         18 PIN DEVICE  
;	 RESONATOR             10MHz Crystal  
;	 WATCHDOG              DISABLED       
;	 START-UP DELAY        ON             
;	ͼ

 TITLE "VIDEO CLEANER"

;ENABLE THIS FOR MPASM.EXE
	LIST	P=16F83, F=INHX8M, N=0, C=100, R=HEX, T=ON


; ********************* EQUATES **********************

OPTINI	EQU	B'01000000'

TMR0	EQU	001H	; TIMER
PC	EQU	002H	; PROGRAM COUNTER
STATUS	EQU	003H	; STATUS REGISTER
WATDOG	EQU	004H	; WATCHDOG TIMEOUT BIT
FSR	EQU	004H	; FILE SELECT REGISTER
PAGE1	EQU	005H	; PAGE TOGGLE
Z	EQU	002H	; ZERO BIT IN STATUS

PORTA	EQU	005H	; PORT A ADDRESS

PORTB	EQU	006H	; PORT B ADDRESS
VSYNC	EQU	000H
HSYNC	EQU	002H

OPTN	EQU	081H
TRISA	EQU	085H
TRISB	EQU	086H

INTCON	EQU	00BH	; INTERRUPT SETUP REG
GIE	EQU	007H	; GLOBAL INT ENABLE FLAG IN INTCON
RBIF	EQU	000H	; RB PORT CHANGE INT FLAG
INTF	EQU	001H	; R0 INT FLAG
TOIF	EQU	002H	; TMR0 OVERFLOW FLAG

LINECOUNT	EQU	000CH	; COUNTS NO. OF LINES
NEWFRAME	EQU	000DH	; TIMES ROUND COUNT WHICH
SLOWA	EQU	000EH	; COUNTER
TIMEOUT	EQU	000FH	; HSYNC TIMER

; *********************************************************
;		MACROS
; *********************************************************


ALLOW	MACRO		; MACRO TO ALLOW VIDEO SIGNAL TO PASS
	MOVLW	B'00000100'	; SET BITS
	MOVWF	PORTA	; DRIVE TO ENABLE VIDEO
	ENDM

BLOCK	MACRO		; MACRO TO BLOCK VIDEO SIGNALS
	MOVLW	B'000001000'	; SET BITS
	MOVWF	PORTA	; DRIVE TO BLOCK VIDEO
	ENDM


	ORG	00H
	GOTO	INIT

; *********************************************************
;		INITIALISE PORTS
; *********************************************************

INIT	CLRF	PORTA
	BSF	STATUS,PAGE1
	MOVLW	B'00000000'

	MOVWF	TRISA
	BCF	STATUS,PAGE1

	CLRF	PORTB
	BSF	STATUS,PAGE1
	MOVLW	B'00000101'


	MOVWF	TRISB
	BCF	STATUS,PAGE1

	BSF	STATUS,PAGE1
	MOVLW	OPTINI
	MOVWF	OPTN


	BCF	STATUS,PAGE1
	GOTO	MAIN


;		CALLED SUBROUTINES - TIMERS
; *********************************************************

US63
	MOVLW	D'39'
	MOVWF	SLOWA
	DECFSZ	SLOWA,F
	GOTO	$-1
	RETURN

US633
	MOVLW	D'38'
	MOVWF	SLOWA
	DECFSZ	SLOWA,F
	GOTO	$-1
	RETURN

US634
	MOVLW	D'43'
	MOVWF	SLOWA
	DECFSZ	SLOWA,F
	GOTO	$-1
	RETURN

; *********************************************************
;		CALLED SUBROUTINES END
; *********************************************************

; ͸
;                                                        
;               PROGRAMME LOOP BEGINS HERE               
;                                                        
; ;


MAIN;	ENDLESS LOOP, AWAITING FRAME SYNC
	ALLOW
	MOVLW	D'0'
	MOVWF	LINECOUNT
AGIN01	BTFSC	PORTB,VSYNC
	GOTO	AGIN01

; FRAME SYNC HAS GONE LOW, NOW WAIT FOR IT TO GO HIGH

AGIN02	BTFSS	PORTB,VSYNC
	GOTO	AGIN02


AGIN03A	BTFSC	PORTB,HSYNC
	GOTO	AGIN03A
	BLOCK

ALLAGIN; PROGRAMME LOOPS ROUND HERE
	CALL	US63
	ALLOW

AGIN03	BTFSC	PORTB,HSYNC
	GOTO	AGIN03

	NOP
	NOP
	NOP
	NOP
	NOP
	BLOCK
	NOP
	NOP
	NOP
	ALLOW
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	BLOCK

	INCF	LINECOUNT,F
	MOVLW	D'19'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	SECOND
	GOTO	ALLAGIN


SECOND
	ALLOW

ALLAGIN2; PROGRAMME LOOPS ROUND HERE

	CALL	US63

AGIN06	BTFSC	PORTB,HSYNC
	GOTO	AGIN06

	INCF	LINECOUNT,F
	MOVLW	D'200'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	LOOP01
	GOTO	ALLAGIN2

LOOP01; W CONTAINS ZERO
	ANDWF	LINECOUNT,F

OVER200
	CALL	US63

AGIN07	BTFSC	PORTB,HSYNC
	GOTO	AGIN07

; INCREMENT LINE COUNTER
	INCF	LINECOUNT,F
	MOVLW	D'92'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	LOOP02
	GOTO	OVER200

LOOP02; W CONTAINS ZERO
	ANDWF	LINECOUNT,F

ALLAGIN3	CALL	US633
	ALLOW
AGIN09	BTFSC	PORTB,HSYNC
	GOTO	AGIN09
	NOP

	BLOCK

; WAIT TILL BURST IS FINISHED BY USING NOPS

	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	ALLOW

; INCREMENT LINE COUNTER
	INCF	LINECOUNT,F
	MOVLW	D'7'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	FOURTH
	GOTO	ALLAGIN3


FOURTH

LOOP03; W ALREADY CONTAINS ZERO
	ANDWF	LINECOUNT,F
	CALL	US633
	ALLOW
	GOTO	AGIN10

ALLAGIN4	CALL	US634
	ALLOW
AGIN10	BTFSC	PORTB,HSYNC
	GOTO	AGIN10
	NOP
	NOP
	NOP
	BLOCK

	INCF	LINECOUNT,F
	MOVLW	D'5'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	FIVE
	GOTO	ALLAGIN4


FIVE
	ANDWF	LINECOUNT,F
	CALL	US634
	ALLOW
	GOTO	AGIN11

ALLAGIN5	CALL	US633
	ALLOW
AGIN11	BTFSC	PORTB,HSYNC
	GOTO	AGIN11

	NOP
	BLOCK
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP

	ALLOW


	INCF	LINECOUNT,F
	MOVLW	D'3'
	SUBWF	LINECOUNT,0
	BTFSC	STATUS,Z
	GOTO	MAIN
	GOTO	ALLAGIN5

; ͸
;                                                        
;               END OF MAIN PROGRAMME LOOP               
;                                                        
; ;

	END
