;POLYW132.ASM 29SEP01 - COPYRIGHT JOHN BECKER - EPE PIC POLYWHATSIT

;PIC16F877-20, WDT OFF, POR ON, HS XTAL

;Config register bits (all PIC Toolkit Mk2 defaults except for OS1 & OS0)
; CP1 CP0 DBG NIL WRT CPD LVP BOR CP1 CP0 POR WDT OS1 OS0
   1   1   1   1   1   1   0   0   1   1   0   0   1   0 = h'3F32'
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '87 data sheet.

	list	p=16F877,r=dec
        __config        h'3F32'

#DEFINE PAGE0   BCF $03,5
#DEFINE PAGE1   BSF $03,5

INDF:    .EQU $00
OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3
FSR:     .EQU $04
PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1

INTCON:  .EQU $0B  ;page 0, 1, 2, 3
ADRESH:  .EQU $1E  ;page 0
ADRESL:  .EQU $1E  ;page 1

ADCON0:  .EQU $1F  ;page 0
ADCON1:  .EQU $1F  ;page 1

RATE:    .EQU $30       ; delay/modulation rate MSB
RECORD0: .EQU $31       ; address for storing sample LSB
RECORD1: .EQU $32       ; address for storing sample MSB
REPLAY0: .EQU $33       ; address for recalling sample LSB
REPLAY1: .EQU $34       ; address for recalling sample MSB
HALF:    .EQU $35       ; half counter for use with low pitch
HALF2:   .EQU $36       ; half counter for use with low pitch
FREQ:    .EQU $37       ; modulation waveform counter for chorus
UP:      .EQU $38       ; waveform up/down flag
STORE0:  .EQU $39       ; general store 0
STORE1:  .EQU $3A       ; general store 1
STORE2:  .EQU $3B       ; general store 1
LOOPA:   .EQU $3C       ; general loop
MODULATE: .EQU $3D      ; modulation level for chorus
MODE:    .EQU $3E       ; path flag
RATE2:   .EQU $3F       ; delay rate LSB

          ; locations up to $7F are available

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

W:      .EQU 0
F:      .EQU 1
C:      .EQU 0
DC:     .EQU 1
Z:      .EQU 2

RP0:    .EQU 5           ;STATUS reg
RP1:    .EQU 6           ;STATUS reg
GIE:    .EQU 7           ;INTCON reg
GO:     .EQU 2           ;ADCON0 reg

        .ORG $0004      ;Interrupt vector address
        GOTO GIEOFF     ;Jump to interrupt routine on interrupt
        .ORG $0005      ;Start of program memory

GIEOFF: BCF INTCON,GIE  ;turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ROUTEIT: movf PORTE,W
         andlw 7
         addwf PCL,F
         goto DELAYPATH  ; 0
         goto PHASER     ; 5
         goto CHORUS     ; 2
         goto LOPITCH    ; 3
         goto BACKWARDS  ; 4
         goto HIPITCH    ; 5
         goto HIPITCH2   ; 6
         goto DELAYPATH  ; 7


START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        clrf PORTC
        clrf PORTD
        clrf PORTE
        PAGE1
        movlw %00001011     ;RA0, RA1, RA3 as inputs, RA2, RA4-RA5 as output
        movwf TRISA
        clrf TRISB          ;PORTB as output
        clrf TRISC          ;PORTC as output
        clrf TRISD          ;PORTD as output
        movlw 7
        movwf TRISE         ;PORTE as input

        movlw %00000100     ;set LHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1        ;with RA2, RA5, RE0-2 digital, ref to +VE and 0V
        movlw %00000101     ;timer 1:64 (1/50th sec)
        movwf OPTION
        PAGE0
;        movlw %01000001     ;set Fosc/8, ADC on
        movlw %10000001     ;set Fosc/32, ADC on
        movwf ADCON0

        clrf RECORD0
        clrf RECORD1
        clrf REPLAY0
        clrf REPLAY1
        movlw 1
        movwf RATE
        goto ROUTEIT

;............................ END OF SETUP

DELAYPATH: movf PORTE,W
         andlw 7
         movwf MODE
         movlw 1
         movwf RATE
         clrf PORTB
         movlw 128
         movwf PORTC

PATH0:   PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         movf RATE2,W
         addwf RECORD0,W
         movwf PORTB
         movf STATUS,W
         andlw 1
         movwf STORE1
         movf RATE,W
         addwf STORE1,W
         addwf RECORD1,W
         iorlw %10000000
         movwf PORTC

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         PAGE1               ; set for recording
         clrf TRISD          ; PORTD as outputs
         PAGE0
         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB
         movf RECORD1,W
         movwf PORTC

PATH0A:  bsf ADCON0,GO       ; start data conversion
WAITAD0: btfsc ADCON0,GO
         goto WAITAD0

         movf ADRESH,W       ; get audio ADC val
         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

         incfsz RECORD0,F    ; increment recording counter
         goto PATH0
         incfsz RECORD1,F
         goto PATH0
         bsf RECORD1,7

GETDLY:  bsf ADCON0,3        ; set for sample RA1 (delay value)
         call DELAYB

         bsf ADCON0,GO       ; start data conversion RA1
WAITAD1: btfsc ADCON0,GO      
         goto WAITAD1

         comf ADRESH,W        ; get and invert RATE val
         movwf RATE
         PAGE1
         comf ADRESL,W
         andlw %11000000
         PAGE0
         movwf RATE2
         bcf STATUS,C
         rrf RATE,F
         rrf RATE2,F

         bcf ADCON0,3        ; set for sample RA0
         call DELAYB

         movf PORTE,W
         andlw 7
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH0

;.............

HIPITCH: movf PORTE,W
         andlw 7
         movwf MODE
         movf RECORD0,W
         movwf REPLAY0
         movf RECORD1,W
         movwf REPLAY1
         clrf RATE
         clrf HALF
         movlw 128
         movwf PORTC

PATH1:   PAGE1               ; set for record
         clrf TRISD          ; PORTD as outputs
         PAGE0

         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB

         bsf ADCON0,GO       ; start data conversion
WAITAD2: btfsc ADCON0,GO
         goto WAITAD2

         movf ADRESH,W       ; get ADC val
         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

         PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         movf REPLAY0,W
         movwf PORTB

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         movlw 2
         addwf REPLAY0,F     ; increment replay counter
         btfsc STATUS,C      ; is there a carry?
         incf REPLAY1,F      ; 

         incfsz RECORD0,F    ; increment recording counter
         goto PATH1

         movf PORTE,W
         andlw 7
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH1

;...........

LOPITCH: movf PORTE,W
         andlw 7
         movwf MODE

         movf RECORD0,W
         movwf REPLAY0
         movf RECORD1,W
         movwf REPLAY1
         clrf HALF

PATH2:   PAGE1               ; set for record
         clrf TRISD          ; PORTD as outputs
         PAGE0

         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB
         movf RECORD1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bsf ADCON0,GO       ; start data conversion
WAITAD3: btfsc ADCON0,GO
         goto WAITAD3

         movf ADRESH,W       ; get ADC val
         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

         PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         movf REPLAY0,W
         movwf PORTB
         movf REPLAY1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         incf HALF,F
         btfss HALF,0
         goto INC3
         incfsz REPLAY0,F    ; increment replay counter
         goto INC3
         incf REPLAY1,F

INC3:    incfsz RECORD0,F    ; increment recording counter
         goto PATH2
         incf RECORD1,F
         movf PORTE,W
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH2

;..........

BACKWARDS: movf PORTE,W
         andlw 7
         movwf MODE

         movf RECORD0,W
         movwf REPLAY0
         movf RECORD1,W
         movwf REPLAY1

PATH3:   PAGE1               ; set for recording
         clrf TRISD          ; PORTD as outputs
         PAGE0
         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB
         movf RECORD1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC
                               
         bsf ADCON0,GO       ; start data conversion
WAITAD4: btfsc ADCON0,GO
         goto WAITAD4

         movf ADRESH,W       ; get ADC val
         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

         PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         movf REPLAY0,W
         movwf PORTB
         movf REPLAY1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         decfsz REPLAY0,F    ; decrement replay counter
         goto INC4
         decf REPLAY1,F

INC4:    incfsz RECORD0,F    ; increment recording counter
         goto PATH3
         incf RECORD1,F
         movf PORTE,W
         andlw 7
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH3

;........

CHORUS:  movf PORTE,W
         andlw 7
         movwf MODE

         movlw 1
         movwf UP
         clrf FREQ
         clrf HALF
         clrf HALF2

         movlw 1
         movwf MODULATE
         bcf ADCON0,3        ; sample RA0
         call DELAYB

PATH5A:  movf RATE,W         ; modulation rate set by val of RATE
         addwf HALF,F
         btfss STATUS,C
         goto RECORD6A

UPIT2:   btfss UP,0
         goto DOWN2

         incfsz FREQ,F
         goto RECORD6A
         clrf UP

DOWN2:   decfsz FREQ,F
         goto RECORD6A
         bsf UP,0

RECORD6A: PAGE1               ; set for record
         clrf TRISD          ; PORTD as outputs
         PAGE0
         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB
         movf RECORD1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bsf ADCON0,GO       ; start data conversion
WAITAD8A: btfsc ADCON0,GO
         goto WAITAD8A

         movf ADRESH,W       ; get ADC val

         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

RECALL7A: PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         clrf STORE1
         movf FREQ,W
         movwf STORE2
         movf MODULATE,W

         movwf LOOPA
         bcf STATUS,C
LOOP2:   rlf LOOPA,F
         btfsc STATUS,C
         goto LOOP2A
         rrf STORE2,F
         goto LOOP2
LOOP2A:  movf STORE2,W

         subwf RECORD0,W
         movwf PORTB
         btfss STATUS,C      ; is there a borrow?
         incf STORE1,F

         movf STORE1,W
         subwf RECORD1,W     ; subtract Rate for Record1
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         incfsz RECORD0,F    ; increment recording counter
         goto PATH5A

         bsf ADCON0,3        ; sample RA1 (delay value)
         call DELAYB

         bsf ADCON0,GO       ; start data conversion
WAITAD7A: btfsc ADCON0,GO
         goto WAITAD7A
         movf ADRESH,W       ; get ADC val 
         btfsc STATUS,Z
         movlw 1
         movwf RATE

         bsf ADCON0,4        ; sample RA3 (delay value)
         call DELAYB

         bsf ADCON0,GO       ; start data conversion
WAITAD9A: btfsc ADCON0,GO
         goto WAITAD9A
         movf ADRESH,W       ; get ADC val 
         movwf MODULATE
         btfsc STATUS,Z
         movlw 1
         movwf MODULATE

         bcf ADCON0,3        ; 
         bcf ADCON0,4        ; sample RA0
         call DELAYB

         incf RECORD1,F

         movf PORTE,W
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH5A

;..........

PHASER:  movf PORTE,W
         andlw 7
         movwf MODE

         movlw 1
         movwf UP
         clrf FREQ
         clrf HALF
         clrf HALF2

         movlw 1
         movwf MODULATE
         bcf ADCON0,3        ; sample RA0
         call DELAYB

PATH5:   movf RATE,W         ; modulation rate set by val of RATE
         addwf HALF,F
         btfss STATUS,C
         goto RECORD6

         movlw 1
         addwf HALF2,F
         btfss STATUS,DC
         goto RECORD6

UPIT:    btfss UP,0
         goto DOWN

         incfsz FREQ,F
         goto RECORD6
         clrf UP

DOWN:    decfsz FREQ,F
         goto RECORD6
         bsf UP,0

RECORD6: PAGE1               ; set for record
         clrf TRISD          ; PORTD as outputs
         PAGE0
         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB
         movf RECORD1,W
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bsf ADCON0,GO       ; start data conversion
WAITAD8: btfsc ADCON0,GO
         goto WAITAD8

         movf ADRESH,W       ; get ADC val

         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

RECALL7: PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         clrf STORE1
         movf FREQ,W
         movwf STORE2
         movf MODULATE,W

         movwf LOOPA
         bcf STATUS,C
LOOP:    rlf LOOPA,F
         btfsc STATUS,C
         goto LOOP1
         rrf STORE2,F
         goto LOOP
LOOP1:   movf STORE2,W

         subwf RECORD0,W
         movwf PORTB
         btfss STATUS,C      ; is there a borrow?
         incf STORE1,F

         movf STORE1,W
         subwf RECORD1,W     ; subtract Rate for Record1
         iorlw %10000000     ; keep DAC WR high
         movwf PORTC

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         incfsz RECORD0,F    ; increment recording counter
         goto PATH5

         bsf ADCON0,3        ; sample RA1 (delay value)
         call DELAYB

         bsf ADCON0,GO       ; start data conversion
WAITAD7: btfsc ADCON0,GO
         goto WAITAD7
         movf ADRESH,W       ; get ADC val 
         btfsc STATUS,Z
         movlw 1
         movwf RATE

         bsf ADCON0,4        ; sample RA3 (delay value)
         call DELAYB

         bsf ADCON0,GO       ; start data conversion
WAITAD9: btfsc ADCON0,GO
         goto WAITAD9
         movf ADRESH,W       ; get ADC val 
         movwf MODULATE
         btfsc STATUS,Z
         movlw 1
         movwf MODULATE

         bcf ADCON0,3        ; 
         bcf ADCON0,4        ; sample RA0
         call DELAYB

         incf RECORD1,F

         movf PORTE,W
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH5

;.............

HIPITCH2: movf PORTE,W
         andlw 7
         movwf MODE
         movf RECORD0,W
         movwf REPLAY0
         movf RECORD1,W
         movwf REPLAY1
         clrf RATE
         clrf HALF
         movlw 128
         movwf PORTC

PATH6:   PAGE1               ; set for record
         clrf TRISD          ; PORTD as outputs
         PAGE0

         movlw %00110000     ; set mem WE hi, OE hi
         movwf PORTA
         movf RECORD0,W
         movwf PORTB

         bsf ADCON0,GO       ; start data conversion
WAITADB: btfsc ADCON0,GO
         goto WAITADB

         movf ADRESH,W       ; get ADC val
         movwf PORTD         ; put it out to mem
         bcf PORTA,4         ; toggle mem WE down, up
         bsf PORTA,4

         PAGE1               ; set for recall
         decf TRISD,F        ; set PORTD 255 - for high impedance (input)
         PAGE0

         movf REPLAY0,W
         movwf PORTB

         bcf PORTA,5         ; set mem for OE low
         bcf PORTC,7         ; set DAC WR low to latch in data from mem
         bsf PORTC,7         ; set DAC WR high again
         bsf PORTA,5         ; set mem for OE high

         movlw 3
         addwf REPLAY0,F     ; increment replay counter
         btfsc STATUS,C      ; is there a carry?
         incf REPLAY1,F      ;

         incfsz RECORD0,F    ; increment recording counter
         goto PATH6

         movf PORTE,W
         andlw 7
         xorwf MODE,W
         btfss STATUS,Z
         goto ROUTEIT
         goto PATH6

;.......

DELAYB:  movlw 8
         movwf LOOPA
DELAYx:  decfsz LOOPA,F
         goto DELAYx
         return


         .END

