;National Lottery Predictor
;by Julyan Ilett

list	p=16C54		;tells assembler to generate code for this device

c	equ	0	;carry flag, bit 0 in status register
z	equ	2 	;zero flag, bit 2 in status register


ind	equ	00	;indirect register pointed to by fsr
rtcc	equ	01	;real time clock register, not used in this program
pc	equ	02	;program counter
status	equ	03	;status register, contains zero and carry bits etc.
fsr	equ	04	;file select register for indirect addressing
portA	equ	05	;I/O port A
portB	equ	06 	;I/O port B
unused	equ	07	;I/O port C only on PIC16C55 and 16C57
flag_bits	equ	08	;status bits, 0=digit select, 1=button release enable
grid_pointer	equ	09	;points to appropriate register in number grid
grid_mask	equ	0A	;points to appropriate bit in grid register
random_number	equ	0B	;random number, cycles between 1 and 49
switch_data	equ	0C	;holds value of previous read, bit 3 only used
switch_timer	equ	0D	;times duration for which switch held down
gp_counter	equ	0E	;general purpose counter, various uses
gp_register	equ	0F	;general purpose register, various uses
sleep_lo	equ	1C	;low byte of 16 bit sleep timer
sleep_hi	equ	1D	;high byte of 16 bit sleep timer
digit0	equ	1E	;current digit 0 data
digit1	equ	1F 	;current digit 1 data

	org	1FF	;START

	goto	initialise

	org	100	;INITIALISATION SECTION

initialise	clrf	flag_bits 	;initialise all registers to starting values
	clrf	switch_data
	clrf	switch_timer
	clrf	gp_counter
	clrf	gp_register
	clrf	sleep_lo
	clrf	sleep_hi
	call	randominit	;call last part of 'random' subroutine

	movlw	0FF
	movwf	portA 	;port A starts with all bits set
	movwf	portB	;port B starts with all bits set

	movlw	0F8
	tris	portA 	;setup bits 0,1 and 2 in port A as outputs
	movlw	00
	tris	portB	;setup all bits in port B as outputs

	call	reset	;set both digits to dashes and clear grid
	call	switch	;get initial switch data

			;MAIN LOOP

loop	movlw	0FF	;blank both display digits
	movwf	portA
	btfsc	flag_bits,0	;determine which digit to display next
	goto	display1
display0	comf	digit0,w	;get digit0 segment data, invert and
	movwf	portB	;write to port B
	bcf	portA,0	;turn on digit0 via transistor TR2
	bsf	flag_bits,0	;set bit 0 in flag_bits to select digit 1 next time
	goto	delay
display1	comf	digit1,w 	;get digit1 segment data, invert and
	movwf	portB 	;write to port B
	bcf	portA,1 	;turn on digit1 via transistor TR1
	bcf	flag_bits,0 	;reset bit 0 in flag_bits to select digit 0 next time

delay	movlw	7F	;add small time delay to control multiplex rate
	movwf	gp_counter
delayloop	decfsz	gp_counter,f
	goto	delayloop

	call	random	;each time round loop, increment random_number

	incf	sleep_lo,f	;each time round loop, increment sleep timer
	btfss	status,z
	goto	button
	incf	sleep_hi,f
	btfss	status,z 	;has sleep timer overflowed?
	goto	button
	movlw	0FF	;set all portB bits high for minimum current
	movwf	portB
	movlw	0FB 	;set portA bits high for minimum current
	movwf	portA	;set switch output low for wake up enable
	sleep		;don't let the bed-bugs byte!

button	call	switch
	btfss	status,z	;is new switch data same as old?
	goto	state
	btfss	switch_data,3	;if data is same, is button held down?
	goto	restart
	incf	switch_timer,f	;if button is held down, increment timer
	btfss	status,z	;has switch_timer overflowed?
	goto	loop
	bcf	flag_bits,1	;if switch_timer has overflowed, reset enable flag
	call	reset	;display two dashes and clear grid
	goto	restart

state	clrf	sleep_hi	;switch activity clears sleep timer
	btfss	switch_data,3 	;switch data has changed, but is button depressed?
	goto	released
	bsf	flag_bits,1	;if button is depressed, set enable flag
	goto	restart

released	btfss	flag_bits,1	;is the switch enable bit set?
	goto	restart
	movf	random_number,w	;if so, get random_number
	movwf	gp_register
test	movf	grid_pointer,w
	movwf	fsr
	movf	grid_mask,w
	andwf	ind,w
	btfsc	status,z	;is the bit in this grid position already set?
	goto	show
	call	random	;if so, try next grid position
	movf	gp_register,w
	xorwf	random_number,w
	btfss	status,z 	;have all grid positions been tried?
	goto	test
	goto	complete	;if so, game is complete

show	movf	random_number,w
	call	convert	;convert random_number into two 7-seg digits
	movf	grid_pointer,w
	movwf	fsr
	movf	grid_mask,w
	iorwf	ind,f	;set bit in grid
	goto	restart

complete	movlw	08	;put two dots on the display
	movwf	digit0
	movwf	digit1
restart	clrf	switch_timer	;set switch_timer back to zero
	goto	loop

	org	00	;SUBROUTINES

switch	bcf	portA,2	;Subroutine to read switch status and detect changes
	comf	portA,w	;read switch input into W and invert
	bsf	portA,2	;disable switch
	andlw	08	;mask out all bits except bit 3
	xorwf	switch_data,f	;compare old switch data with new
	movwf	switch_data 	;replace old switch data with new
	retlw	0	;returns with zero flag set if data changed

convert	movwf	gp_register	;Subroutine to convert value in w to two 7-seg digits
	clrf	gp_counter
	movlw	.10
next	subwf	gp_register,f	;subtract ten from number
	btfss	status,c	;test whether number has underflowed
	goto	done
	incf	gp_counter,f	;if not, increment 'tens' value
	goto	next
done	addwf	gp_register,w	;add ten to number to restore remainder
	call	table	;convert 'units' value into 7-seg pattern
	movwf	digit0	;store 'units' pattern for display on digit 0
	clrw
	xorwf	gp_counter,w	;compare leading digit value with zero
	btfss	status,z	;skip call to suppress leading zero
	call	table 	;convert 'tens' value into 7-seg pattern
	movwf	digit1 	;store 'tens' pattern for display on digit 1
	retlw	0

reset	movlw	10	;Subroutine to reset all bits in grid
	movwf	fsr	;set fsr to point at register 16
	movlw	07
	movwf	gp_counter 	;set gp_counter to 7, 7 registers to clear
clearreg	clrf	ind	;clear the register
	decf	gp_counter,f	;decrement gp_counter
	btfsc	status,z	;test gp_counter for zero
	goto	alldone
	incf	fsr,f	;point to next register to be cleared
	goto	clearreg
alldone 	movlw	40	;put two dashes on the display
	movwf	digit0
	movwf	digit1
	retlw	0

random	incf	random_number,f	;Subroutine to increment random_number
	movlw	.50
	xorwf	random_number,w 	;has random_number reached 50?
	btfsc	status,z
	goto	randominit
	bcf	status,c	;clear carry bit
	rlf	grid_mask,f	;rotate grid_mask left, carry bit into bit 0
	btfss	status,c	;test carry bit which came from grid_mask bit 7
	goto	randomend
	rlf	grid_mask,f	;rotate mask bit back into bit 0
	incf	grid_pointer,f	;move grid_pointer to next grid register
	goto	randomend
randominit	movlw	1
	movwf	random_number	;set random_number back to 1
	movlw	10
	movwf	grid_pointer 	;set grid_pointer back to register 10
	movlw	01
	movwf	grid_mask 	;put grid_mask bit back into bit 0
randomend	retlw	0

table	addwf	pc,f	;Table of 7-segment character data
	retlw	0B7	;data for character 0
	retlw	05 	;data for character 1
	retlw	73	;data for character 2
	retlw	57	;data for character 3
	retlw	0C5	;data for character 4
	retlw	0D6	;data for character 5
	retlw	0F6	;data for character 6
	retlw	07 	;data for character 7
	retlw	0F7	;data for character 8
	retlw	0D7	;data for character 9

end
