// interrupt routines for intlight.c
// sc 5/5/99
int pw,duty_cycle,side_lamps=0,ign=0;
long loop_time=0,buzz_time=0,main_counter=0,seconds=0,seconds1=0,fade_off=500;

/* ---------------------------------------------------------------------- */
#int_rtcc                          
clock_isr()
 {
  // generate pwm from (duty_cycle)
  if(pw >= duty_cycle)      
    {output_bit(PIN_b7,0);}
  else
    {output_bit(PIN_b7,1);}

  loop_time++;
  buzz_time++;

  pw++; 
  if(pw>100) {pw=0;}

  main_counter++;  
  if(main_counter>0x2000)  
    {seconds++;
     seconds1++;
     main_counter=0;
     if(side_lamps>0) 
       {side_lamps--;}
     else
       {ign=0;}
    }

  set_rtcc(200);
  return;
 }
/* ---------------------------------------------------------------------- */
void buzzer(int mode)
{
 // control buzzer
 if(mode==1)
  {
   if((buzz_time&0x1000)==0x1000)
    {
     if((buzz_time&0x0200)==0x0200)
      output_bit(pin_b5,1);
     else 
      output_bit(pin_b5,0);
    }
   else
    output_bit(pin_b5,0);
  }
 else
  output_bit(pin_b5,0);

 return;
}
/* ---------------------------------------------------------------------- */
void lamp(int mode)
{
 // control interior lamp pwm
 if(mode==0)   {duty_cycle=0;loop_time=0;}	//switch lamp off immediatly
 if(mode==1)   {duty_cycle=101;loop_time=0;}	//switch lamp on immediatly
 if(mode==2)					//fade lamp on
   {if((loop_time>100)&(duty_cycle<=100))
     {if(duty_cycle<10) {duty_cycle=10;}
       duty_cycle ++;loop_time=0;
     }
   }  
 if(mode==3)					//fade lamp off 
    {if((loop_time>fade_off)&(duty_cycle>=1))
     {duty_cycle --;loop_time=0;}
   }
 return;
}
