/////////////////////////////////////////////////////////////////////////
////                           intlight.C                            ////
////  This program uses the RTCC (timer0) and interrupts to generate ////
////  a PWM signal for theater dimming of the interior lamps.        ////
////  A timeout of 5 minutes is provided to reduce battery drain     ////
////  when the doors are left open.                                  ////
/////////////////////////////////////////////////////////////////////////

#include <16C84.H> 
#include "int_rpt.c"

#fuses HS,WDT,NOPROTECT

#byte port_a=5
#byte port_b=6
#use delay(clock=4000000,restart_wdt)

#define DELAY 30	// interior lamp delay time
#define BATTSAVE 300	// battery saver timeout

/* ---------------------------------------------------------------------- */

main() 
  {int bulb=0,buzz=0,lock=0;
   set_tris_a(0x00);
   set_tris_b(0x0F);
   set_rtcc(0);
   
   setup_counters(RTCC_INTERNAL,WDT_72MS);
   enable_interrupts(RTCC_ZERO);
   enable_interrupts(GLOBAL);

   duty_cycle=0;
   loop_time=0;
   port_a = 0;
   port_b = 0;

   do {
       if(input(PIN_a2)) 
         {seconds = 0;}				//doors closed so reset battery saver

       if(input(PIN_a3))			//side lamp strategy. If side lamps on
         {side_lamps=10; 			//then allow a delay of 10 seconds before
         }					//declaring side lamps off. Key off logic
            
       if(!input(PIN_a2)&seconds<BATTSAVE)      
         {bulb=1;seconds1=0;}			//doors opened so lamp on 

       if(!input(PIN_b0)&ign==1&side_lamps>0)
         {bulb=2;lock=0;seconds1=0;             //side lamps been on within last
          ign=0;}         			//10 seconds and then 
          					//ign switched off so lamps on

       if(seconds1>DELAY&!input(PIN_b0)) 
         {fade_off=500;seconds1=100;bulb=3;}	//fade off lamp igntion OFF

       if(seconds1>2&input(PIN_b0)) 
         {fade_off=100;seconds1=100;bulb=3;
          ign=1;} 				//fade off lamp igntion ON

       if(seconds>BATTSAVE) 
         {seconds=500;bulb=0;} 			//door open too long lamps off

       if(input(PIN_b1)&lock==1)
         {bulb=1;lock=0;seconds1=0;}		//unlock doors so lamps on

       if(!input(PIN_b1))
         {bulb=0;lock=1;}			//doors locked so bulb off
         
       if(input(PIN_a3)&!input(PIN_b0)&!input(PIN_a2)&seconds<10)
         {buzz=1;}
       else
         {buzz=0;}

       lamp(bulb);
       buzzer(buzz);  
       restart_wdt();
      } while (TRUE);
   }
