;GRAPHEPE.ASM 06SEP00 - JOHN BECKER - EPE LCD GRAPH DEMO 

#DEFINE PAGE0   BCF $03,5   ;STATUS bit 5
#DEFINE PAGE1   BSF $03,5   ;STATUS bit 5

OPTION:  .EQU $01  ;page 1, 3
PCL:     .EQU $02  ;page 0, 1, 2, 3
STATUS:  .EQU $03  ;page 0, 1, 2, 3

PORTA:   .EQU $05  ;page 0
TRISA:   .EQU $05  ;page 1
PORTB:   .EQU $06  ;page 0, 2
TRISB:   .EQU $06  ;page 1, 3
PORTC:   .EQU $07  ;page 0
TRISC:   .EQU $07  ;page 1
PORTD:   .EQU $08  ;page 0
TRISD:   .EQU $08  ;page 1
PORTE:   .EQU $09  ;page 0
TRISE:   .EQU $09  ;page 1
INTCON:  .EQU $0B  ;page 0, 1, 2, 3

LOOPB:  .EQU $20   ;general loop
CLKCNT: .EQU $21   ;counter for PAUSE val
STORE:  .EQU $22   ;temporary store
ADRLSB: .EQU $23   ;low address
ADRMSB: .EQU $24   ;high address
TEMPA:  .EQU $25   ;store (in place of accumulator)
COLUMN: .EQU $26   ;column length store
LOOPC:  .EQU $27   ;general loop

;........FIXED VALUES OF VARIABLES

TXHOME: .EQU $40
TXAREA: .EQU $41
GRHOME: .EQU $42
GRAREA: .EQU $43
AWRON:  .EQU $B0
AWROFF: .EQU $B2
OFFSET: .EQU $22
ADPSET: .EQU $24
PEEK:   .EQU $E0

;........BIT VALUES

W:      .EQU 0
F:      .EQU 1
Z:      .EQU 2                
C:      .EQU 0
RP0:    .EQU 5          ;STATUS reg
RP1:    .EQU 6          ;STATUS reg
FS:     .EQU %00100000  ;FS mode set by bit 5: 1= 6x8, 0=8x8
                        ;6x8 needed for Toshiba demo

;..........

        .ORG $04
        GOTO 5
        .ORG $05

        bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA
        clrf PORTB
        movlw %00001111     ; RST low, CD CE RD WR high
        movwf PORTC
        clrf PORTD
        clrf PORTE
        PAGE1
        clrf TRISA          ; PORTA as output
        clrf TRISB          ; PORTB as output
        movlw FS
        movwf TRISC         ; PORTC as output, but bit 5 set as FS
        clrf TRISD          ; PORTD as output
        clrf TRISE          ; PORTE as output
        movlw %10000110     ; pull-up Rs off (bit 7 hi), timer 1/25 sec
        movwf OPTION        ; (for 3.2768MHz xtal)
        PAGE0
        movlw %00011111     ; RST CD CE RD WR high
        movwf PORTC

        call PAUSIT
        movlw 20
        movwf COLUMN
        goto GRAPHIC

TXPRT:  ADDWF PCL,F     ; INTERNAL CG CODE
        retlw $34
        retlw $00
        retlw $2F
        retlw $00
        retlw $33
        retlw $00

        retlw $28
        retlw $00
        retlw $29
        retlw $00
        retlw $22
        retlw $00
        retlw $21

EXPRT1: ADDWF PCL,F     ; EXTERNAL CG CODE 1
        retlw $80
        retlw $81
        retlw $00
        retlw $00
        retlw $84
        retlw $85

EXPRT2: ADDWF PCL,F     ; EXTERNAL CG CODE 2
        retlw $82
        retlw $83
        retlw $00
        retlw $00
        retlw $84
        retlw $87

EXTCG:  ADDWF PCL,F     ; EXTERNAL CG FONT DATA
        retlw $01       ; UPPER LEFT, CHARACTER CODE 80H
        retlw $01
        retlw $FF
        retlw $01
        retlw $3F
        retlw $21
        retlw $3F
        retlw $21

        retlw $00       ; UPPER RIGHT CHARACTER CODE 81H
        retlw $00
        retlw $FF
        retlw $00
        retlw $FC
        retlw $04
        retlw $FC
        retlw $04

        retlw $21       ; LOWER LEFT CHARACTER CODE 82H
        retlw $3F
        retlw $05
        retlw $0D
        retlw $19
        retlw $31
        retlw $E1
        retlw $01

        retlw $04       ; LOWER RIGHT CHARACTER CODE 83H
        retlw $FC
        retlw $40
        retlw $60
        retlw $30
        retlw $1C
        retlw $07
        retlw $00

        retlw $08       ; UPPER LEFT CHARACTER CODE 84H
        retlw $08
        retlw $FF
        retlw $08
        retlw $09
        retlw $01
        retlw $01
        retlw $7F

        retlw $10       ; UPPER RIGHT CHARACTER CODE 85H
        retlw $10
        retlw $FF
        retlw $10
        retlw $10
        retlw $00
        retlw $00
        retlw $FC

        retlw $00       ; LOWER LEFT CHARACTER CODE 86H
        retlw $00
        retlw $00
        retlw $01
        retlw $07
        retlw $3C
        retlw $E7
        retlw $00

        retlw $18       ; LOWER RIGHT CHARACTER CODE 87H
        retlw $30
        retlw $60
        retlw $C0
        retlw $00
        retlw $00
        retlw $E0
        retlw $3F

;...........

CHECK3: PAGE1             ; STATUS CHECK for DA0/DA1 = 3
        movlw 255         ;
        movwf TRISD       ; set PORTD as inputs
        PAGE0             ; RST  CD  CE  RD  WR  
        movlw %00011001   ;  1   1   0   0   1  
        movwf PORTC       ; set CE, RD low
        nop
CK3:    btfss PORTD,0     ; IN A,(CMDP)
        goto CK3
CK3A:   btfss PORTD,1
        goto CK3A
                          ; RST  CD  CE  RD  WR  
        movlw %00011111   ;  1   1   1   1   1
        movwf PORTC       ; set controls
        nop
        PAGE1             ;
        clrf TRISD        ; set PORTD as outputs
        PAGE0             ;
        return

;............


CHECK6: PAGE1             ; STATUS CHECK for STA6 low
        movlw 255         ;
        movwf TRISD       ; set PORTD as inputs
        PAGE0             ; RST  CD  CE  RD  WR
        movlw %00011001   ;  1   1   0   0   1
        movwf PORTC       ; set CE, RD low
        nop

CK6:    movf PORTD,W      ; IN A,(CMDP)
        andlw %01000000   ;
        btfss STATUS,Z    ; is it zero?
        goto CK6          ; no RST  CD  CE  RD  WR
        movlw %00011111   ;     1   1   1   1   1
        movwf PORTC       ; set controls
        nop
        PAGE1             ;
        clrf TRISD        ; set PORTD as outputs
        PAGE0             ;
        return

;............

CHECK8: PAGE1             ; STATUS CHECK for DA3 = 8
        movlw 255         ;
        movwf TRISD       ; set PORTD as inputs
        PAGE0             ; RST  CD  CE  RD  WR
        movlw %00011001   ;  1   1   0   0   1
        movwf PORTC       ; set CE, RD low
        nop
CK8:    movf PORTD,W      ; IN A,(CMDP)
        andlw $08         ;
        xorlw $08         ; is it = 8?
        btfss STATUS,Z    ;
        goto CK8          ; no  RST  CD  CE  RD  WR
        movlw %00011111   ;      1   1   1   1   1
        movwf PORTC       ; set controls
        nop
        PAGE1             ;
        clrf TRISD        ; set PORTD as outputs
        PAGE0             ;
        return

;............

AUTOWRITE: ; ** AUTO WRITE ROUTINE **
        movwf TEMPA       ; temp store value brought in on W
        call CHECK8       ; read status for DA3 = 8
        movf TEMPA,W      ; OUT (DP),A  WRITE DATA
        call OUTDATA      ;
        return            ;

;..............

OUTDATA:  ; ** SEND DATA ROUTINE **
        movwf TEMPA       ; temp store val brought in on W
                          ; RST  CD  CE  RD  WR
        movlw %00010111   ;  1   0   1   1   1
        movwf PORTC       ; set CD low
        movf TEMPA,W      ; get stored data
        movwf PORTD       ; send data
        nop               ; RST  CD  CE  RD  WR
        movlw %00010010   ;  1   0   0   1   0
        movwf PORTC       ; set CD, CE, WR low
        nop
        movlw %00010111
        movwf PORTC       ; set CE, WR high
        nop
        movlw %00011111
        movwf PORTC       ; set CD high
        return

;..........

SENDCMD: ;  ** COMMAND WRITE ROUTINE **
        movwf TEMPA       ; temp store val brough in on W
        call CHECK3       ; read status for DA0/DA1 = 3
        movf TEMPA,W      ; OUT (CMDP),A  WRITE COMMAND
        movwf PORTD       ; send stored data
        nop               ; RST  CD  CE  RD  WR
        movlw %00011010   ;  1   1   0   1   0
        movwf PORTC       ; set CE, WR low
        nop
        movlw %00011111   ; RST  CD  CE  RD  WR
        movwf PORTC       ; set all high
        return

;.............

DATAREAD ;  ** DATA READ ROUTINE **
        call CHECK6       ; read status for DA = 6
        call CHECK3       ; read status for DA = 3
        PAGE1             ; STATUS CHECK for DA0/DA1 = 3
        movlw 255         ;
        movwf TRISD       ; set PORTD as inputs
        PAGE0             ; RST  CD  CE  RD  WR  
        movlw %00010111   ;  1   0   1   1   1  
        movwf PORTC       ; set CD low
        nop               ; RST  CD  CE  RD  WR
        movlw %00010001   ;  1   0   0   0   1  
        movwf PORTC       ; set CE, RD low
        nop
        movf PORTD,W      ; IN A,(CMDP)
        movwf STORE

                          ; RST  CD  CE  RD  WR  
        movlw %00011111   ;  1   1   1   1   1
        movwf PORTC       ; set controls
        nop
        PAGE1             ;
        clrf TRISD        ; set PORTD as outputs
        PAGE0             ;
        return

;.............

GRAPHIC:                  ; RST  CD  CE  RD  WR
        movlw %00011111   ;  1   1   1   1   1
        movwf PORTC       ; set controls

        call TEXTHOME     ; SET TEXT HOME ADDRESS
        call GRAPHHOME    ; SET GRAPHIC HOME ADDRESS
        call TEXTAREA     ; SET TEXT AREA
        call GRAPHAREA    ; SET GRAPHIC AREA
        bcf PORTE,0       ; turn off monitor l.e.d.
        call SETMODE      ; SET MODE (OR MODE, Int Character Generator MODE)
        call SETOFFSET    ; SET OFFSET REGISTER CHARACTER CODE 80H
                          ; (00010 10000000 000 = 1400H CG RAM START ADDRESS)
        call SETDISPLAY   ; DISPLAY MODE (TEXT ON, GRAPHICS OFF, CURSOR OFF)
        call CLRTXT       ; WRITE TEXT BLANK CODE
        call WXCG         ; WRITE EXTERNAL CHARACTER GENERATOR RAM
        call WTDD         ; WRITE TEXT DISPLAY DATA (INTERNAL CG)
        call WTDD2        ; WRITE TEXT DISPLAY DATA (EXTERNAL CG upper part)
        call WTDD3        ; WRITE TEXT DISPLAY DATA (EXTERNAL CG lower part)
        bsf PORTE,0       ; turn on monitor l.e.d.

ENDIT:  goto ENDIT        ; PROGRAM END - continuous hold

;.............

TEXTHOME: ; ** SET TEXT HOME ADDRESS **
        clrf ADRMSB       ; LD HL,0000H    TEXT HOME ADDRESS 0000H
        clrf ADRLSB        ;
        call CMDADR       ; set 2 bytes of data
        movlw TXHOME      ; LD A,TXHOME
        call SENDCMD      ; send command
        return

;...........

GRAPHHOME:   ;  ** SET GRAPHIC HOME ADDRESS **
        movlw $02         ; LD HL,0200H    GRAPHIC HOME ADDRESS 0200H
        movwf ADRMSB
        clrf ADRLSB
        call CMDADR       ; set 2 bytes of data
        movlw GRHOME      ; LD A,GRHOME
        call SENDCMD      ; send command
        return

;...........

TEXTAREA:    ;  ** SET TEXT AREA **
        clrf ADRMSB       ; LD HL,0014H    TEXT AREA 20 ($14) columns
        movlw $14         ;
        movwf ADRLSB       ;
        call CMDADR       ; set 2 bytes of data
        movlw TXAREA      ; LD A,TXAREA
        call SENDCMD      ; send command
        return

;...........

GRAPHAREA:    ;  ** SET GRAPHIC AREA **
        clrf ADRMSB       ; LD HL,0014H    GRAPHIC AREA 20 ($14) columns
        movf COLUMN,W    ;
        movwf ADRLSB       ;
        call CMDADR       ; set 2 bytes of data
        movlw GRAREA      ; LD A,GRAREA
        call SENDCMD      ; send command
        return

;...........

SETMODE:    ;  ** SET MODE (OR MODE, Internal Character Generator MODE)
        movlw $80         ; LD A,80H (%10000000)
        call SENDCMD      ; send command
        return

;...........

SETOFFSET:    ; ** SET OFFSET REGISTER **      CHARACTER CODE 80H
        ; (00010 10000000 000 = 1400H CG RAM START ADDRESS)
        clrf ADRMSB       ; LD HL,0002H
        movlw $02         ;
        movwf ADRLSB       ;
        call CMDADR       ; set 2 bytes of data
        movlw OFFSET      ; LD A,OFFSET
        call SENDCMD      ; send command
        return

;...........

SETDISPLAY:    ;  ** DISPLAY MODE (TEXT ON, GRAPHICS OFF, CURSOR OFF) **
        movlw $94         ; LD A,94H (%10010100)
        call SENDCMD      ; send command
        return

;...........

CLRTXT: ;  ** WRITE TEXT BLANK CODE **
        clrf ADRMSB       ; LD HL,0000H
        clrf ADRLSB       ;
        call SCREENADR    ; set 2 bytes of data

        movlw AWRON       ; SET DATA AUTO WRITE
        call SENDCMD      ; send command

        movlw 8           ; number of lines to clear
        movwf LOOPC       ;
CLR2:   movf COLUMN,W     ; column length

CLR3:   movlw 0           ; LD A,00H WRITE DATA 00H (WRITE BLANK CODE)
        call AUTOWRITE    ; auto write and increment
        decfsz LOOPB,F    ; DEC BC: LD A,B: OR C
        goto CLR3         ; JR NZ,TXCR
        decfsz LOOPC,F
        goto CLR2
        movlw AWROFF      ; LD A,AWROFF   AUTO RESET
        call SENDCMD      ; send command
        return

;............

READIT: ;  ** READ SCREEN CODE
        clrf ADRMSB       ;
        movlw $6D
        movwf ADRLSB
        call SCREENADR    ; set 2 bytes of data
        movlw PEEK        ;
        call SENDCMD      ; send command
        call DATAREAD
        return

;............

WXCG:   ;  ** WRITE EXTERNAL CHARACTER GENERATOR RAM **
                          ; LD DE,EXTCG       ; CG data address in Program
                          ; Replaced by LOOPB and STORE
        movlw $14         ; LD HL,1400H  CG RAM start address
        movwf ADRMSB      ;
        clrf ADRLSB        ;
        call SCREENADR    ; set 2 bytes of data
        movlw AWRON       ; LD A,AWRON   SET DATA AUTO WRITE ON
        call SENDCMD      ; send command
        movlw $40         ; LD B,40H     8 char x 8 byte (64=40H)
        movwf STORE       ;
        clrf LOOPB        ;

EXCG:   movf LOOPB,W      ; LD A,(DE)  WRITE TO EXTERNAL RAM
        call EXTCG        ; get table data
        call AUTOWRITE    ; auto write and increment
        incf LOOPB,F      ; INC DE  (INC HL - omitted)
        decfsz STORE,F    ;
        goto EXCG         ;
        movlw AWROFF      ; LD A,AWROFF   AUTO WRITE OFF
        call SENDCMD      ; send command
        return

;..............

WTDD:   ;  ** WRITE TEXT DISPLAY DATA (INTERNAL CG) **
        clrf ADRMSB       ; LD HL,0040H   Address pointer line 3 col 4
        movlw $40         ;
        movwf ADRLSB       ;
        call SCREENADR    ; set 2 bytes of data
        movlw AWRON       ; LD A,AWRON    SET AUTO WRITE ON
        call SENDCMD      ; send command
        movlw $0D         ; LD B,0DH      13 characters
        movwf STORE       ;
        clrf LOOPB        ; LD DE,TXPRT   Replaced by LOOPB & STORE
TXLP1:  movf LOOPB,W      ; LD A,(DE)
        call TXPRT        ; get table data
        call AUTOWRITE    ; auto write and increment
        incf LOOPB,F      ;
        decfsz STORE,F    ;
        goto TXLP1        ;
        movlw AWROFF      ; LD A, AWROFF   AUTO WRITE OFF
        call SENDCMD      ; send command
        return

;............

WTDD2:  ;  ** WRITE TEXT DISPLAY DATA (EXTERNAL CG upper part) **
        clrf ADRMSB       ; LD HL,006CH  Address pointer line 5 col 8
        movlw $6C         ;
        movwf ADRLSB       ;
        call SCREENADR    ; set 2 bytes of data
        movlw AWRON       ; LD A, AWRON  SET DATA AUTO WRITE ON
        call SENDCMD      ; send command
        movlw $06         ; LD B,06H      send 6 characters
        movwf STORE       ;
        clrf LOOPB        ; LD DE,TXPRT   Replaced by LOOPB & STORE

TXLP2:  movf LOOPB,W      ; LD A,(DE)
        call EXPRT1       ; get table data
        call AUTOWRITE    ; auto write and increment
        incf LOOPB,F      ;
        decfsz STORE,F    ;
        goto TXLP2        ;
        movlw AWROFF      ; LD A, AWROFF   AUTO WRITE OFF
        call SENDCMD      ; send command
        return

;............

WTDD3:  ;  ** WRITE TEXT DISPLAY DATA (EXTERNAL CG lower part) **
        clrf ADRMSB       ; LD HL,0080H  Address pointer line 6 col 8
        movlw $80         ;
        movwf ADRLSB       ;
        call SCREENADR    ; set 2 bytes of data
        movlw AWRON       ; LD A, AWRON  SET DATA AUTO WRITE ON
        call SENDCMD      ; send command
        movlw $06         ; LD B,06H      send 6 characters
        movwf STORE       ;
        clrf LOOPB        ; LD DE,TXPRT   Replaced by LOOPB & STORE

TXLP3:  movf LOOPB,W      ; LD A,(DE)
        call EXPRT2       ; get table data
        call AUTOWRITE    ; auto write and increment
        incf LOOPB,F      ;
        decfsz STORE,F    ;
        goto TXLP3        ;
        movlw AWROFF      ; LD A, AWROFF   AUTO WRITE OFF
        call SENDCMD      ; send command
        return


CMDADR: ; ** SET ADDRESS FOR COMMAND SENDING **
        call CHECK3       ; read status for DA0/DA1 = 3
        movf ADRLSB,W     ; WRITE DATA D1
        call OUTDATA      ;
        call CHECK3       ; read status for DA0/DA1 = 3
        movf ADRMSB,W     ; WRITE DATA D2
        call OUTDATA      ;
        return            ;

;.........

SCREENADR: ; ** SET ADDRESS FOR WRITE/READ TO/FROM SCREEN
        call CHECK3       ; read status for DA0/DA1 = 3
        movf ADRLSB,W     ; WRITE ADDRESS LSB
        call OUTDATA      ;
        call CHECK3       ; read status for DA0/DA1 = 3
        movf ADRMSB,W     ; WRITE ADDRESS MSB
        call OUTDATA      ;
        movlw ADPSET      ; SET ADDRESS POINTER
        call SENDCMD      ; send command
        return            ;


;.............

PAUSIT: movlw 5           ; pause routine, 1/5th sec
        movwf CLKCNT
        clrf INTCON
PAUSE:  btfss INTCON,2
        goto PAUSE
        BCF INTCON,2
        decfsz CLKCNT,F
        goto PAUSE
        return

        .END
