;BUGGY500.ASM 15MAR08 prev 491 19AUG7
;set for 3.2768MHz XTAL

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

;        List P = PIC16F876A, R=DEC; 
        List P = PIC16F876, R=DEC; 
        __CONFIG h'3F31'  ; 3.2768MHz
;        include P16F876A.inc
        include P16F876.inc

           CBLOCK h'20'
RSLINE
LOOP
LOOPA
STORE
STORE1
STORE2

REGA0         ; used by maths routines
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3

DCOUNT        ; used by BIN2DEC routines
DSIGN
MTEMP  
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
MCOUNT

TURNS         ; wheel turns counted
WHEELMSB      ; wheel diameter in mm
WHEELLSB

CIRCINT0      ; circumference integer
CIRCINT1
CIRCINT2
CIRCINT3

ADDERINT0     ; circumference adder integer
ADDERINT1
ADDERINT2
ADDERINT3

CLKSEC        ; CLOCK main counter - secs
CLKMIN        ; CLOCK - mins
CLKHRS        ; CLOCK - hours
CLKCNT        ; pre-counter for CLOCK

BINTIMEMSB    ; binary value of time count
BINTIMENSB
BINTIMELSB
MILESFLAG
CENTIFLAG
WHEELSENSOR
STOREX

TURNS10MSB       ; used for speed/10 secs
TURNS10LSB       ; used for speed/10 secs
SECSCOUNT

TEMPCORRECT

           ENDC

PROMVAL EQU h'70'              ; in both pages

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

TABLCD:    addwf PCL,F         ; LCD initialisation table
           retlw b'00110011'   ; initialise lcd - first byte
           retlw b'00110011'   ; 2nd byte (repeat of first)
           retlw b'00110010'   ; set for 4-bit operation
           retlw b'00101100'   ; set for 2 lines
           retlw b'00000110'   ; set entry mode to increment each address
           retlw b'00001100'   ; set display on, cursor off, blink off
           retlw b'00000001'   ; clear display
           retlw b'00000010'   ; return home, cursor & RAM to zero
                               ; end inititalisation table

CHKVAL     addwf PCL,F
           retlw B'01011001'   ; 59 secs max
           retlw B'01011001'   ; 59 mins max
           retlw B'00100011'   ; 23 hours max

TABLE1     addwf PCL,F
           retlw 'S'           ; 0
           retlw 'T'           ; 1
           retlw 'O'           ; 2
           retlw 'R'           ; 3
           retlw 'E'           ; 4
           retlw 'D'           ; 5
           retlw ' '           ; 6
           retlw ' '           ; 7

TABLE2     addwf PCL,F
           retlw 'N'           ; 0
           retlw 'O'           ; 1
           retlw 'W'           ; 2
           retlw ' '           ; 3
           retlw 'S'           ; 4
           retlw 'W'           ; 5
           retlw 'I'           ; 6
           retlw 'T'           ; 7
           retlw 'C'           ; 8
           retlw 'H'           ; 9
           retlw ' '           ; 10
           retlw 'O'           ; 11
           retlw 'F'           ; 12
           retlw 'F'           ; 13
           retlw ' '           ; 14
           retlw ' '           ; 15

TABLE3     addwf PCL,F
           retlw 'P'           ; 0
           retlw 'R'           ; 1
           retlw 'E'           ; 2
           retlw 'V'           ; 3
           retlw ' '           ; 4
           retlw 'T'           ; 5
           retlw '0'           ; 6
           retlw 'T'           ; 7
           retlw 'A'           ; 8
           retlw 'L'           ; 9
           retlw ' '           ; 10
           retlw ' '           ; 11
           retlw ' '           ; 12
           retlw ' '           ; 13
           retlw ' '           ; 14
           retlw ' '           ; 15

TABLE4     addwf PCL,F
           retlw 'R'           ; 0
           retlw 'E'           ; 1
           retlw 'L'           ; 2
           retlw 'E'           ; 3
           retlw 'A'           ; 4
           retlw 'S'           ; 5
           retlw 'E'           ; 6
           retlw ' '           ; 7
           retlw 'S'           ; 8
           retlw 'W'           ; 9
           retlw 'I'           ; 10
           retlw 'T'           ; 11
           retlw 'C'           ; 12
           retlw 'H'           ; 13
           retlw ' '           ; 14
           retlw ' '           ; 15

TABLE5     addwf PCL,F
           retlw 'S'           ; 0
           retlw '1'           ; 1
           retlw ' '           ; 2
           retlw ' '           ; 3
           retlw 'S'           ; 4
           retlw '2'           ; 5
           retlw ' '           ; 6
           retlw ' '           ; 7
           retlw ' '           ; 8
           retlw ' '           ; 9
           retlw ' '           ; 10
           retlw 'W'           ; 11
           retlw 'H'           ; 12
           retlw 'E'           ; 13
           retlw 'E'           ; 14
           retlw 'L'           ; 15

TABLE6     addwf PCL,F
           retlw '+'           ; 0
           retlw '1'           ; 1
           retlw '0'           ; 2
           retlw ' '           ; 3
           retlw '-'           ; 4
           retlw '1'           ; 5
           retlw ' '           ; 6
           retlw ' '           ; 7
           retlw ' '           ; 8
           retlw ' '           ; 9
           retlw ' '           ; 10
           retlw ' '           ; 11
           retlw ' '           ; 12
           retlw ' '           ; 13
           retlw ' '           ; 14
           retlw ' '           ; 15

TABLE7     addwf PCL,F
           retlw 'W'           ; 0
           retlw 'A'           ; 1
           retlw 'I'           ; 2
           retlw 'T'           ; 3
           retlw ' '           ; 4
           retlw '5'           ; 5
           retlw 'S'           ; 6
           retlw 'E'           ; 7
           retlw 'C'           ; 8
           retlw ' '           ; 9
           retlw 'T'           ; 10                
           retlw 'O'           ; 11
           retlw ' '           ; 12
           retlw 'E'           ; 13
           retlw 'N'           ; 14
           retlw 'D'           ; 15

TABLE8     addwf PCL,F
           retlw 'S'           ; 0
           retlw '1'           ; 1
           retlw ' '           ; 2
           retlw ' '           ; 3
           retlw 'S'           ; 4
           retlw '2'           ; 5
           retlw ' '           ; 6
           retlw ' '           ; 7
           retlw ' '           ; 8
           retlw ' '           ; 9
           retlw ' '           ; 10
           retlw ' '           ; 11
           retlw 'T'           ; 12
           retlw 'E'           ; 13
           retlw 'M'           ; 14
           retlw 'P'           ; 15

TABLE9     addwf PCL,F
           retlw '+'           ; 0
           retlw '1'           ; 1
           retlw ' '           ; 2
           retlw ' '           ; 3
           retlw '-'           ; 4
           retlw '1'           ; 5
           retlw ' '           ; 6
           retlw ' '           ; 7
           retlw ' '           ; 8
           retlw ' '           ; 9
           retlw ' '           ; 10
           retlw ' '           ; 11
           retlw ' '           ; 12
           retlw ' '           ; 13
           retlw ' '           ; 14
           retlw ' '           ; 15

; ********

STARTIT    clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           clrf PORTC          ; clear PORTC's output if any

           BANK1
           movlw B'10001110'   ; set for RA0 analog, rest of RA & RE as digital
           movwf ADCON1        ; right justified (8 bit only) (bit 7=1)

           clrf TRISC
           MOVLW b'11000000'
           MOVWF TRISB     ; RB0-RB5 as output, RB6, RB7 as input
           movlw b'00011111'
           MOVWF TRISA     ; RA0-RA2, RA4 as input, RA3 as output (not used)
           MOVLW b'00000110' ; timer ratio 1:128, PORTB pullups on (bit 7 = 0)
           MOVWF OPTION_REG
           BANK0

           movlw b'10000001'     ; set AD on, Fosc/32, set for RA0
           movwf ADCON0

           call PAUSIT
           call LCDSET
           call PAUSIT

           clrf MILESFLAG     ; 0 = Km 1 = miles
           clrf CENTIFLAG     ; 0 = C  1 = F

           movlw 0
           call PRMGET
           movwf WHEELMSB
           movlw 1
           call PRMGET
           movwf WHEELLSB
           movlw 10
           call PRMGET
           movwf TEMPCORRECT

           btfsc PORTA,1      ; is PORTA,1 set (switch S2) at power on ?
           call SETDIAMETER   ; yes
           btfsc PORTA,2      ; is PORTA,1 set (switch S3) at power on ?
           call SETTEMP       ; yes

           btfss PORTB,6      ; is PORTB,6 clear at power on ?
           bsf CENTIFLAG,0    ; yes, set F for degrees
           btfss PORTB,7      ; is PORTB,7 clear at power on ?
           bsf MILESFLAG,0    ; yes, set M for distance units

           clrf CLKHRS
           clrf CLKMIN
           clrf CLKSEC

           clrf BINTIMEMSB    ; binary value of time count
           clrf BINTIMENSB
           clrf BINTIMELSB
           clrf WHEELSENSOR

           clrf TURNS
           clrf TURNS10MSB
           clrf TURNS10LSB

           movlw 10
           movwf SECSCOUNT
    
           clrf ADDERINT0     ; circumference adder integer
           clrf ADDERINT1
           clrf ADDERINT2
           clrf ADDERINT3

           call CALCCIRCUM

           movlw 25                ;reset start value of CLKCNT
           movwf CLKCNT
           call CLRLINE1
           call CLRLINE2

MAIN:   btfsc PORTA,1
        call SHOWPREVTOTAL

        btfsc PORTA,2
        goto STORETOTALS     ; and end

        btfss PORTA,3        ; reinstate these 2 statements to store when switch off
        goto STORETOTALS3    ; and end

        btfss INTCON,2  ; has a timer time-out been detected?
        goto TSTBT1     ; no
        BCF INTCON,2    ; yes
        decfsz CLKCNT,F ; decrement system clock counter. Is it = 0?
        goto TSTBT1
        call CLKADD

        decfsz SECSCOUNT,F
        goto MAIN2

        movf TURNS10LSB,W
        movwf REGA0
        movf TURNS10MSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3

        movlw 180        ; multiply by 180 (10 secs in 1 hr / 2)
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call MULTIPLY32

        movf CIRCINT3,W
        movwf REGB3
        movf CIRCINT2,W
        movwf REGB2
        movf CIRCINT1,W
        movwf REGB1
        movf CIRCINT0,W
        movwf REGB0
        call MULTIPLY32

        btfsc MILESFLAG,0
        call MILESCONV

        call BIN2DEC

        call LCD32
        bsf RSLINE,4
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT4,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT5,W
        iorlw 48
        call LCDOUT

        clrf TURNS10MSB
        clrf TURNS10LSB

        movlw 10
        movwf SECSCOUNT

MAIN2:  movlw 25                ;reset start value of CLKCNT
        movwf CLKCNT
        call LCD10

        bsf RSLINE,4
        bcf STATUS,C
        rrf TURNS,W
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        movlw 'T'
        call LCDOUT
        movlw '/'
        call LCDOUT
        movlw 's'
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT

        call LCD25
        bsf RSLINE,4
        call CALCDISTANCE
        call TEMPERATURE
        clrf TURNS

TSTBT1: movf PORTA,W
        andlw b'00010000'  ; isolate RA4
        movwf STOREX
        xorwf WHEELSENSOR,W
        btfsc STATUS,Z
        goto ST2
        incf TURNS,F
        movlw 1
        addwf TURNS10LSB,F
        movf STATUS,W
        andlw 1
        addwf TURNS10MSB,F
        call ADDER       ; perform add routine

ST2     movf STOREX,W
        movwf WHEELSENSOR

        call LCD1
        bsf RSLINE,4
        call SHOWTIME
        goto MAIN

; ***********

CALCCIRCUM:             ; multiply dia by 22 (PI fraction msb) (22/7)
        movf WHEELLSB,W
        movwf REGA0
        movf WHEELMSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3

        movlw 22
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call MULTIPLY32

        movlw 7
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        movf REGA0,W
        movwf CIRCINT0
        movf REGA1,W
        movwf CIRCINT1
        movf REGA2,W
        movwf CIRCINT2
        movf REGA3,W
        movwf CIRCINT3
        return

CALCDISTANCE
        movf ADDERINT3,W
        movwf REGA3
        movf ADDERINT2,W
        movwf REGA2
        movf ADDERINT1,W
        movwf REGA1
        movf ADDERINT0,W
        movwf REGA0

        clrf REGB3      ; divide by 2000
        clrf REGB2
        movlw h'07'
        movwf REGB1
        movlw h'D0'
        movwf REGB0
        call DIVIDE32

        btfsc MILESFLAG,0
        call MILESCONV

SHOWDIST call BIN2DEC    ; show distance

        movf DIGIT5,W     ; if distance >99 then show alternative display
        xorlw 32
        btfss STATUS,Z
        goto SHOWHUNDREDS

        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movlw 'K'
        btfsc MILESFLAG,0
        movlw 'M'
        call LCDOUT
        return

SHOWHUNDREDS: movf DIGIT5,W
        call LCDOUT
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movlw 'K'
        btfsc MILESFLAG,0
        movlw 'M'
        call LCDOUT
        return

; **********

PAUSIT:    movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

; **********

CLKADD          movlw CLKSEC            ;get address of CLKSEC
                movwf FSR               ;move it into indirect reg
                movlw 3                 ;set loop to 3
                movwf LOOP
                clrf STORE1

                incfsz BINTIMELSB,F
                goto ADDCLK
                incfsz BINTIMENSB,F
                goto ADDCLK
                incf BINTIMEMSB,F

ADDCLK          incf INDF,F             ;inc units - all in BCD
                movlw 6
                addwf INDF,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ;yes

ADDCL2          movf STORE1,W           ;now check if value > allowed value
                call CHKVAL
                movwf STORE2
                movf INDF,W
                subwf STORE2,F          ;is count =<  than allowed?
                btfsc STATUS,C
                goto ADDCL3  ;return
                clrf INDF               ;no, it's greater, so clear it

ADDCL2A         incf STORE1,F           ;and add 1 to time loop & byte
                incf FSR,F
                decfsz LOOP,F           ;dec loop, is it = 0?
                goto ADDCLK             ;no

ADDCL3          movf CLKHRS,W           ; are all BCD time vals = 0?
                iorwf CLKMIN,W
                iorwf CLKSEC,W
                btfss STATUS,Z
                return                  ; no
                clrf BINTIMEMSB         ; yes
                clrf BINTIMENSB
                clrf BINTIMELSB
                return

;******** LCD ROUTINES **********

LCD1:   movlw b'10000000'
        goto LCDLIN
LCD10:  movlw b'10001010'
        goto LCDLIN
LCD21:  movlw b'11000000'
        goto LCDLIN
LCD25:  movlw b'11000101'
        goto LCDLIN
LCD28:  movlw b'11001000'
        goto LCDLIN
LCD32:  movlw b'11001100'
        goto LCDLIN

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        nop 
        nop
        BCF PORTB,5
        RETURN

;*************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf PROMVAL,W  ;STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw h'55'     ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw h'AA'     ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA   ;Return carry set if overflow

subtract:
        call    negateb         ;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

; **********

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***


;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32  movf    REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

ADDER   movf ADDERINT3,W
        movwf REGA3
        movf ADDERINT2,W
        movwf REGA2
        movf ADDERINT1,W
        movwf REGA1
        movf ADDERINT0,W
        movwf REGA0

        movf CIRCINT3,W
        movwf REGB3
        movf CIRCINT2,W
        movwf REGB2
        movf CIRCINT1,W
        movwf REGB1
        movf CIRCINT0,W
        movwf REGB0
        call ADD

        movf REGA3,W
        movwf ADDERINT3
        movf REGA2,W
        movwf ADDERINT2
        movf REGA1,W
        movwf ADDERINT1
        movf REGA0,W
        movwf ADDERINT0
        return

SHOWTIME swapf CLKHRS,W
        andlw 15
        iorlw 48
        call LCDOUT
        movf CLKHRS,W
        andlw 15
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        swapf CLKMIN,W
        andlw 15
        iorlw 48
        call LCDOUT
        movf CLKMIN,W
        andlw 15
        iorlw 48
        call LCDOUT
        movlw ':'
        call LCDOUT
        swapf CLKSEC,W
        andlw 15
        iorlw 48
        call LCDOUT
        movf CLKSEC,W
        andlw 15
        iorlw 48
        call LCDOUT
        return

; ************

STORETOTALS call STORETOTAL2
        movf REGA3,W
        movwf PROMVAL
        movlw 2
        call SETPRM
        movf REGA2,W
        movwf PROMVAL
        movlw 3
        call SETPRM
        movf REGA1,W
        movwf PROMVAL
        movlw 4
        call SETPRM
        movf REGA0,W
        movwf PROMVAL
        movlw 5
        call SETPRM

SHOWEND call CLRLINE1
        call CLRLINE2
        call LCD1
        bsf RSLINE,4

        call SHOWTABLE1

        clrf LOOP
        call LCD21
        bsf RSLINE,4
STR3    movf LOOP,W
        call TABLE2
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR3

ENDPROG nop
        goto ENDPROG

STORETOTAL2
        movf ADDERINT3,W   ; get distance
        movwf REGB3
        movf ADDERINT2,W
        movwf REGB2
        movf ADDERINT1,W
        movwf REGB1
        movf ADDERINT0,W
        movwf REGB0

        movlw 2             ; get existing totals
        call PRMGET
        movwf REGA3
        movlw 3
        call PRMGET
        movwf REGA2
        movlw 4
        call PRMGET
        movwf REGA1
        movlw 5
        call PRMGET
        movwf REGA0
        call ADD
        return

STORETOTALS3: call STORETOTAL2
        movf REGA3,W
        movwf PROMVAL
        movlw 2
        call SETPRM
        movf REGA2,W
        movwf PROMVAL
        movlw 3
        call SETPRM
        movf REGA1,W
        movwf PROMVAL
        movlw 4
        call SETPRM
        movf REGA0,W
        movwf PROMVAL
        movlw 5
        call SETPRM

        call CLRLINE1
        call CLRLINE2
        call LCD1
        bsf RSLINE,4

        call SHOWTABLE1

ENDPROG2 nop
        goto ENDPROG2


SHOWPREVTOTAL call CLRLINE1
        call CLRLINE2
        call LCD1
        bsf RSLINE,4

        clrf LOOP
STR4    movf LOOP,W
        call TABLE3
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR4

        call LCD21
        bsf RSLINE,4

        movlw 2             ; get existing totals
        call PRMGET
        movwf REGA3
        movlw 3
        call PRMGET
        movwf REGA2
        movlw 4
        call PRMGET
        movwf REGA1
        movlw 5
        call PRMGET
        movwf REGA0

        clrf REGB3      ; divide by 2000
        clrf REGB2
        movlw h'07'
        movwf REGB1
        movlw h'D0'
        movwf REGB0
        call DIVIDE32
        btfsc MILESFLAG,0
        call MILESCONV

TOT2    call BIN2DEC
        movf DIGIT3,W
        call LCDOUT
        movf DIGIT4,W
        call LCDOUT
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT

        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movlw 'K'
        btfsc MILESFLAG,0
        movlw 'M'
        call LCDOUT

WAIT2   btfsc PORTA,1 ; 2
        goto WAIT2
        call CLRLINE1
        call CLRLINE2
        return

SETDIAMETER call LCD1
        bsf RSLINE,4

        call SHOWTABLE4

SD2     btfsc PORTA,1      ; is PORTA,1 clear ?
        goto SD2

        call LCD1
        bsf RSLINE,4

        clrf LOOP
STR6    movf LOOP,W
        call TABLE5
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR6

        call LCD21
        bsf RSLINE,4

        clrf LOOP
STR7    movf LOOP,W
        call TABLE6
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR7

        movlw 50            ; set delay counter to 50 (2 secs)
        movwf CLKCNT        ;
        clrf INTCON         ; clear interupt flag
PAUS3   btfss INTCON,2      ; has a timer time-out been detected?
        goto PAUS3          ; no
        bcf INTCON,2        ; yes
        decfsz CLKCNT,F     ; dec counter, is it zero?
        goto PAUS3          ; no

        call CLRLINE1
        call LCD21
        bsf RSLINE,4

        call SHOWTABLE7

        call SHOWDIAMETER
        movlw 25                ;reset start value of CLKCNT
        movwf CLKCNT
        clrf CLKSEC

SD3     btfsc PORTA,1   ; is S1 pressed?
        goto ADD10      ; yes
        btfsc PORTA,2   ; is S2 pressed?
        goto SUB1       ; yes

        btfss INTCON,2  ; has a timer time-out been detected?
        goto SD3        ; no
        BCF INTCON,2    ; yes
        decfsz CLKCNT,F ; decrement system clock counter. Is it = 0?
        goto SD3    
        call CLKADD
        movlw 25        ; reset start value of CLKCNT
        movwf CLKCNT
        movf CLKSEC,W
        xorlw 5         ; 5 secs count
        btfss STATUS,Z
        goto SD3        ; none

STOREDIA call CLRLINE2
        call LCD21
        bsf RSLINE,4
        goto ENDIT

ADD10   movlw 10
        addwf WHEELLSB,F
        btfss STATUS,C
        goto ADDSHOW
        incf WHEELMSB,F
        goto ADDSHOW

SUB1    decfsz WHEELLSB,F
        goto ADDSHOW
        decf WHEELMSB,F
        goto ADDSHOW

ADDSHOW call SHOWDIAMETER
        call PAUSIT
        call PAUSIT
        movlw 25
        movwf CLKCNT
        goto SD3

SHOWDIAMETER movf WHEELLSB,W
        movwf REGA0
        movf WHEELMSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call LCD1
        bsf RSLINE,4
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        iorlw 48
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw 'm'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

ENDIT:  movf WHEELMSB,W
        movwf PROMVAL
        movlw 0
        call SETPRM
        movf WHEELLSB,W
        movwf PROMVAL
        movlw 1
        call SETPRM

        call CLRLINE2
        call LCD21
        bsf RSLINE,4

        call SHOWTABLE1
        goto ENDPROG

MILESCONV  clrf REGB3          ; multiply by 5 for miles
        clrf REGB2
        clrf REGB1
        movlw 5
        movwf REGB0
        call MULTIPLY32

        clrf REGB3             ; divide by 8 for miles
        clrf REGB2
        clrf REGB1
        movlw 8
        movwf REGB0
        call DIVIDE32
        return

;********* GET TEMPERATURE VALUE

TEMPERATURE:
        bsf ADCON0,GO      ; start data conversion

GETADC: btfsc ADCON0,GO
        goto GETADC
        movf ADRESH,W      ; get ADC MSB val
        movwf REGA1
        BANK1
        movf ADRESL,W      ; get ADC LSB val
        BANK0
        movwf REGA0
        clrf REGA2
        clrf REGA3
        movlw 5            ; multiply by 5 (ADC 1024 = 5V)
        movwf REGB0        ; (input from sensor is just mV ref 1V)
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call MULTIPLY32

        movf TEMPCORRECT,W
        call CORRECTTEMP

        call BIN2DEC

SHOWTEMPERATURE:
        btfsc CENTIFLAG,0
        call TEMPCONV

TEMP2   call LCD21
        bsf RSLINE,4

        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT

        movlw 'C'
        btfsc CENTIFLAG,0
        movlw 'F'
        call LCDOUT
        bsf ADCON0,GO      ; start data conversion
        return

TEMPCONV movlw 9           ; multiply 9/5 + 320 for fahrenheit
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call MULTIPLY32

        movlw 5
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        movlw h'40'
        movwf REGB0
        movlw 1
        movwf REGB1
        clrf REGB2
        clrf REGB3
        call ADD
        return

CORRECTTEMP
        movf TEMPCORRECT,W
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call ADD        

        movlw 128
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call SUBTRACT
        return

SHOWTABLE1: clrf LOOP
STR2    movf LOOP,W
        call TABLE1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,3
        goto STR2
        return

SHOWTABLE4: clrf LOOP
STR5    movf LOOP,W
        call TABLE4
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR5
        return

SHOWTABLE7: clrf LOOP
STR8    movf LOOP,W
        call TABLE7
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto STR8
        return

SETTEMP call LCD1
        bsf RSLINE,4

        call SHOWTABLE4

TSD2     btfsc PORTA,2      ; is PORTA,2 clear ?
        goto TSD2

        call LCD1
        bsf RSLINE,4

        clrf LOOP
TSTR6   movf LOOP,W
        call TABLE8
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TSTR6

        call LCD21
        bsf RSLINE,4

        clrf LOOP
TSTR7   movf LOOP,W
        call TABLE9
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto TSTR7

        movlw 50            ; set delay counter to 50 (2 secs)
        movwf CLKCNT        ;
        clrf INTCON         ; clear interupt flag
TPAUS3   btfss INTCON,2      ; has a timer time-out been detected?
        goto TPAUS3          ; no
        bcf INTCON,2        ; yes
        decfsz CLKCNT,F     ; dec counter, is it zero?
        goto TPAUS3          ; no

        call CLRLINE1
        call LCD1  ;21
        bsf RSLINE,4

        call SHOWTABLE7

        call TEMPERATURE 
        movlw 25                ;reset start value of CLKCNT
        movwf CLKCNT
        clrf CLKSEC

TSD3     btfsc PORTA,1   ; is S1 pressed?
        goto TADD1      ; yes
        btfsc PORTA,2   ; is S2 pressed?
        goto TSUB1       ; yes

        btfss INTCON,2  ; has a timer time-out been detected?
        goto TSD3        ; no
        BCF INTCON,2    ; yes
        decfsz CLKCNT,F ; decrement system clock counter. Is it = 0?
        goto TSD3    
        call CLKADD
        movlw 25        ; reset start value of CLKCNT
        movwf CLKCNT
        movf CLKSEC,W
        xorlw 5         ; 5 secs count
        btfss STATUS,Z
        goto TSD3        ; none

STORETEMP call CLRLINE2
        call LCD1
        bsf RSLINE,4
        goto TENDIT

TADD1   incf TEMPCORRECT,F
        goto TADDSHOW

TSUB1   decf TEMPCORRECT,F

TADDSHOW call TEMPERATURE
        movlw ' '
        call LCDOUT
        call PAUSIT
        call PAUSIT
        movlw 25
        movwf CLKCNT
        goto TSD3

TENDIT: movf TEMPCORRECT,W
        movwf PROMVAL
        movlw 10
        call SETPRM

        goto SHOWEND

;        call CLRLINE2
;        call LCD21
;        bsf RSLINE,4

;        call SHOWTABLE2
;        goto ENDPROG

        org H'2100'      ; data eeprom address
        DE 0             ; 0 wheel dia msb in mm (7 ins)
        DE 178           ; 1 wheel dia lsb in mm (177.8mm)
        DE 0             ; 2
        DE 0             ; 3
        DE 0             ; 4
        DE 0             ; 5
        DE 0             ; 6
        DE 0             ; 7
        DE 0             ; 8
        DE 0             ; 9
        DE 128           ; 10 temp correction value (0-127 = subtract, 128-255 = add

        END
