#include <16F876.H>

#fuses XT,WDT,PUT,BROWNOUT,NOPROTECT,NOLVP,CPD,NOWRT
// do not set LVP to ON. This caused me a lot of head scratching!!

#byte port_a=5
#byte port_b=6
#byte port_c=7

#use delay(clock=3579545,restart_wdt)

// the pin assignments shown below
//Port A
#define timer_on	 PIN_A0
#define strobe_in	 PIN_A1
#define RTC_SCL		 PIN_A2
#define RTC_SDA		 PIN_A3

// LCD & Keyboard on port B
// #define ROW0 (1 << 0)
// #define ROW1 (1 << 1)
// #define ROW2 (1 << 2)
// #define ROW3 (1 << 3)
// #define COL0 (1 << 4) & LCD D4
// #define COL1 (1 << 5) & LCD D5
// #define COL2 (1 << 6) & LCD D6
// #define COL3 (1 << 7) & LCD D7

//Port C
#define data_control_out PIN_C1
// C2 is used for PWM output (35.8khz clock)
#define clock_in         PIN_C3           
#define backlight	 PIN_C4
// LCD	 C5  LCD rs
// LCD	 C6  LCD rw
// LCD	 C7  LCD enable

#define lamp_period	 12
#define lite_period	 18

#include "lcd_2x16.c"   // two line lcd control
#include "rempulse.c"	// remote control pule generation

int flag=0;  		// used for year calculation
#include "pcf8583.c"    // rtc control

int light=lamp_period,lite=lite_period;
#define KBD_DEBOUNCE_FACTOR 100
#include "4x4kbd.c"     // keyboard control  

int cur_hour=0,cur_min=0,cur_day=0;
int sec_strobe=0,timer_active=0xFF;
int dig[4],tmp=0,tmp1=1;
char k;


// **********************************************************************************
#int_timer1                          
clock_timer()
{
 //times the keypresses and backlight
 if(lite>0)
   {output_bit(backlight,1); lite--;}
 else
   {output_bit(backlight,0); }

 if(light>0)
   {light--;}
 return;
}
// **********************************************************************************
int read_key(int x_pos, int y_pos, int num_keys, int max_val)
{int temp,keys,key[2]; 

 do_it:
 k=0;
 lcd_gotoxy(x_pos,y_pos); 
 lcd_send_byte(0,0x0F);    //cursor ON
 for(temp=0;temp<num_keys;temp++)
   {
    while(k==0)
      {k=kbd_getc();
       light=lamp_period;
       restart_wdt();
      }
   key[temp]=k;
   lcd_gotoxy(x_pos+temp,y_pos);
   lcd_putc(key[temp]);
   k=0;
   }

  if(num_keys>1)
    keys=((key[0]-0x30)*0x10)+(key[1]-0x30);
  else
    keys=key[0]-0x30;

  if(keys>max_val) goto do_it;

 lcd_send_byte(0,0x0C); //cursor OFF

 return(keys);
}
// **********************************************************************************
void show_day(int day)
{
 if(day<2||day>7) {lcd_putc("Sun");}
 if(day==2) {lcd_putc("Mon");}
 if(day==3) {lcd_putc("Tue");}
 if(day==4) {lcd_putc("Wed");}
 if(day==5) {lcd_putc("Thu");}
 if(day==6) {lcd_putc("Fri");}
 if(day==7) {lcd_putc("Sat");}
 return;
}
// **********************************************************************************
void display_datetime(int mode)
{int day,month,year,dow,hours,minutes,seconds;
 if(mode==1) {goto direct;}

 if(input(strobe_in)&(tmp==1))
   {tmp=0;
    sec_strobe++;

    direct:
    rtc_get_date(day,month,year,dow);
    rtc_get_time(hours,minutes,seconds);
    // update ram counters
    cur_day  =dow;
    cur_hour =hours;
    cur_min  =minutes;
    // Output date (day-month-year)  
    lcd_gotoxy(2,1);  show_day(dow);
    lcd_gotoxy(6,1);  lcd_put_bcd(day); 
    lcd_putc("-");    lcd_put_bcd(month);
    lcd_putc("-20");  lcd_put_bcd(year);

    lcd_gotoxy(6,2);  lcd_put_bcd(hours);   
    // Flash colon using 1 second strobe from RTC pin1 to PIC
    lcd_gotoxy(8,2);  lcd_putc(0x3A); 
    lcd_put_bcd(minutes); 
   }

 if(!input(strobe_in)&tmp==0)
   {tmp=1;
    lcd_gotoxy(8,2);lcd_putc(0x20);
   }

 return;
}
// **********************************************************************************
void show_timer_data(int timer_no)
{
 lcd_putc("\f");
 lcd_put_bcd(read_eeprom((timer_no*0x10)+0x00));
 lcd_putc(":");
 lcd_put_bcd(read_eeprom((timer_no*0x10)+0x01));
 lcd_putc(" ");
 lcd_put_bcd(read_eeprom((timer_no*0x10)+0x02));
 lcd_putc(":");
 lcd_put_bcd(read_eeprom((timer_no*0x10)+0x03));
 lcd_putc(" ");
 show_day(read_eeprom((timer_no*0x10)+0x04));

 // display channel
 lcd_gotoxy(1,2);lcd_putc("C=");
 for(tmp1=0;tmp1<3;tmp1++)
  {lcd_putc(read_eeprom((timer_no*0x10)+0x07+tmp1)+0x30);
  }
 // display "repeat" bit
 lcd_putc(" Repeat=");
 if(read_eeprom((timer_no*0x10)+0x05)==1)
   lcd_putc("Yes");
 else
   lcd_putc("No");
 
 return;
}
// **********************************************************************************
clear_timer(int num)
{int erase=0;
 for(erase=0;erase<12;erase++)
   {write_eeprom((num*0x10+erase),0);
   }
 write_eeprom(0xFF,0xAA); // check location
 return;
}
// **********************************************************************************
void check_timer()
{int timer_no=0,req;

 again:
 if(timer_no>=9) {timer_no=0;}   

 req=read_eeprom((timer_no*0x10)+0x0A);
 lcd_putc("\f");
 lcd_gotoxy(5,1);lcd_putc("Timer ");lcd_putc(timer_no+0x30+1); //add 1 so that timer
                                                               //reads from 1 to 9
 if(req==0xAA)
   {delay_ms(500);  show_timer_data(timer_no);}
 else
   {lcd_gotoxy(6,2);lcd_putc("Empty");}

 k=0;
 while(k!='F')
  {k=kbd_getc();
   if(light==0){k='F';}
   if(k=='E') {timer_no++;            goto again;}
   if(k=='C') {clear_timer(timer_no); goto again;}
   restart_wdt();
  }
 return;
}
// **********************************************************************************
void set_timer_proper(int timer_no)
{int dig1=0;
 show_timer_data(timer_no); 

// read and store start time
 dig1 = read_key(1,1,2,0x23);   write_eeprom(((timer_no*0x10)+0x000),dig1); 
 dig1 = read_key(4,1,2,0x59);   write_eeprom(((timer_no*0x10)+0x001),dig1);  
 
// read and store stop time
 dig1 = read_key(7,1,2,0x23);    write_eeprom(((timer_no*0x10)+0x002),dig1);
 dig1 = read_key(10,1,2,0x59);   write_eeprom(((timer_no*0x10)+0x003),dig1);  

// read and store day
 dig1 = read_key(13,1,1,0x07);   write_eeprom(((timer_no*0x10)+0x004),dig1);
 lcd_gotoxy(13,1);show_day(dig1);

// read and store channel
 for(tmp1=0;tmp1<3;tmp1++)
  {ch_rpt:
   dig1 =read_key(3+tmp1,2,1,0x09); 
   if(dig1>9) goto ch_rpt;
   write_eeprom(((timer_no*0x10)+7+tmp1),dig1);
  }

// read and store repeat bit
 rpt:
 dig1 = read_key(14,2,1,0x01);   write_eeprom(((timer_no*0x10)+5),dig1); 

 lcd_gotoxy(14,2);
 if(dig1==1)  
   lcd_putc("Yes");
 else  
   lcd_putc("No ");

 if(dig1>1) 
   goto rpt;

// set timer active bit. Used when checking if timer required
 write_eeprom(((timer_no*0x10)+0x0A),0xAA);
  
// Clear data sent bit. Used so that data only sent once when timer requested
 write_eeprom(((timer_no*0x10)+0x0B),0x00);   

// Wait till E pressed
 k=0;
 while(k!='E')
  {k=kbd_getc();
   if(light==0){k='E';}
   restart_wdt();
  }
 return;
}
// **********************************************************************************
void set_timer()
{int loop_tmp;
 for(loop_tmp=0;loop_tmp<9;loop_tmp++)
  {
   if(read_eeprom((loop_tmp*0x10)+0x0A)!=0xAA)
     {set_timer_proper(loop_tmp);                                      
      goto endit;
     }
  }
 lcd_putc("\f");
 lcd_gotoxy(3,1);lcd_putc("TIMER MEMORY");
 lcd_gotoxy(7,2);lcd_putc("FULL");
 delay_ms(2000);
 endit:
 return;
}
// **********************************************************************************
void set_clock()
{int day,month,year,dow,hours,minutes,seconds;
  
 lcd_putc("\f");
 display_datetime(1);
 day     = read_key(6,1,2,0x31);  
 month   = read_key(9,1,2,0x12); 
 year    = read_key(14,1,2,0x99);
 hours   = read_key(6,2,2,0x23); 
 minutes = read_key(9,2,2,0x59);  
 dow     = read_key(2,1,1,0x07);
 rtc_set_datetime(day,month,year,dow,hours,minutes); 
 light=0;
 return;
}
// **********************************************************************************
void learn_fav(int fav_no)
{int dig1;
 for(tmp1=0;tmp1<3;tmp1++)
  {dig1 =read_key(3+tmp1,2,1,0x09); 
   write_eeprom(0xF0+(fav_no*0x3)+tmp1,dig1);
  }
 delay_ms(500);
 return;
}
// **********************************************************************************
void set_fav(void)
{
 and_again:
 lcd_putc("\fFavourite?");
 k=0;
 while(k!='E')
  {k=kbd_getc();
   if(light==0){k='E';}
   if(k=='A') {lcd_putc("\2A");learn_fav(0);goto and_again;}       
   if(k=='B') {lcd_putc("\2B");learn_fav(1);goto and_again;}       
   if(k=='C') {lcd_putc("\2C");learn_fav(2);goto and_again;}       
   if(k=='D') {lcd_putc("\2D");learn_fav(3);goto and_again;}       
   restart_wdt();
  }
 light=0;
 return;
}
// **********************************************************************************
void send_fav(int fav_no)
{
 // power off to ensure digibox is in correct mode to
 // receive commands
 power();
 sky();
 // sequentially send channel digits
 for(tmp1=0;tmp1<3;tmp1++)
   {button(read_eeprom((0xF0+tmp1)+(fav_no*0x3)));
    delay_ms(200);
   }
 light=0;
 return;
}
// **********************************************************************************
void function_select(void)
{int fun_no=0;
 while(light>0)
  {if(k=='F') // F is the 'blank' key
    {fun_no++; 
     if(fun_no>4)  {fun_no=1;}
     if(fun_no==1) {lcd_putc("\f  Check Timer");}
     if(fun_no==2) {lcd_putc("\f   Set Timer");}
     if(fun_no==3) {lcd_putc("\f   Set Clock");}
     if(fun_no==4) {lcd_putc("\fSet Fav Channels");}
    }

   if(k=='E') // E is the '.' key
    {
     if(fun_no==1) {check_timer(); light=0;}
     if(fun_no==2) {set_timer();   light=0;}
     if(fun_no==3) {set_clock();}
     if(fun_no==4) {set_fav();}
    }

   k=kbd_getc();
   restart_wdt();
  }
 lcd_putc("\f");
 return;
}
// **********************************************************************************
void send_timer_data(int timer_num)
{int pin=0;

 if(read_eeprom((timer_num*0x10)+11)==1) // already sent
  return;

 // power off to ensure digibox is in correct mode to
 // receive commands also turn on timer output.
 output_bit(timer_on,1);     
 delay_ms(200);
 power();
 sky();

 // sequentially send channel digits
 for(tmp1=0;tmp1<3;tmp1++)
   {button(read_eeprom((timer_num*0x10)+7+tmp1));
    delay_ms(200);
   }

 // set data sent bit. this ensures that data is only sent once
 write_eeprom((timer_num*0x10)+11,1);                                               

 return;
}

// **********************************************************************************
check_timers()
{int tim_temp=0;

 for(tim_temp=0;tim_temp<9;tim_temp++)			//check each timer
  {
   // check start time data
   if(read_eeprom((tim_temp*0x10)+10)==0xAA)	    	//is timer set
     {if(read_eeprom((tim_temp*0x10)+4)==cur_day)	//is day correct
        {if(read_eeprom((tim_temp*0x10)+0)==cur_hour)   //is hour correct
           {if(read_eeprom((tim_temp*0x10)+1)==cur_min) //is minute correct
              {send_timer_data(tim_temp);		// send data 
               timer_active=tim_temp;			// which timer is currently on
               write_rtc(0x30,timer_active);		// store in rtc

              }
           }
        }
     }

    // check stop times
    timer_active=read_rtc(0x30);
    if(tim_temp==timer_active)				// only need to check for current timer
     {if(read_eeprom((tim_temp*0x10)+10)==0xAA)	    	//is timer set
        {if(read_eeprom((tim_temp*0x10)+2)==cur_hour)   //is hour correct
          {if(read_eeprom((tim_temp*0x10)+3)==cur_min)  //is minute correct
            {output_bit(timer_on,0); delay_ms(20);	//power off timer relay
             timer_active=0xFF;				//clear timer active RAM location
             write_rtc(0x30,timer_active);		// store in rtc

            }
          }
        }
     }
  }

 // need to check for used timers that are no longer active
 timer_active=read_rtc(0x30);
 for(tim_temp=0;tim_temp<9;tim_temp++)			//check each timer
  {
   if((timer_active==0xFF)&(read_eeprom((tim_temp*0x10)+11)==1))
     {
      if(read_eeprom((tim_temp*0x10)+5)==1)  	//is repeat bit set
        {write_eeprom((tim_temp*0x10)+11,0);	//clear data sent bit
        }
      else
        {clear_timer(tim_temp);
        }
     }
  }
 return;
}
// **********************************************************************************
hello()
{
 output_bit(backlight,1);
 lcd_putc("\f");
 lcd_gotoxy(4,1);lcd_putc("DigiTimer");
 delay_ms(1000);
return;
} 
// **********************************************************************************
init_chip()
{  // functions for setting up chip
   // setup ports
   set_tris_a(0x12); 
   set_tris_b(0x0F);  
   set_tris_c(0x08);
   port_a=0;         
   port_b=0;          
   port_c=0;

   //init periferals
   lcd_init();       
   kbd_init();       
   rtc_init();

   // if timer_active not equal to 0xFF then timer must have been active
   // so we need to set relay on!
   timer_active=read_rtc(0x30);
   if(timer_active!=0xFF)
     {output_bit(timer_on,1);}
   else
     {output_bit(timer_on,0);}

   //display welcome message
   hello();

   // setup internal counters and pwm
   setup_counters(RTCC_INTERNAL,WDT_1152MS);
   setup_timer_1(T1_INTERNAL|T1_DIV_BY_8);
   enable_interrupts(INT_TIMER1);
   enable_interrupts(GLOBAL);

   // generate ir carrier on pin C2
   setup_ccp1(CCP_PWM);   
   setup_timer_2(T2_DIV_BY_1,24, 1);
   set_pwm1_duty(12);     

   // check to see if new/corrupt eeprom
   // if so initialise all data
   if(read_eeprom(0xFF)!=0xAA)
     {for(tmp1=0;tmp1<10;tmp1++)
      {clear_timer(tmp1);} 
     }

   // clear display
   lcd_putc("\f");

 return;
}
// **********************************************************************************
reset_timer_function() 
{
 // this cancels a timer event in progress
 output_bit(timer_on,0);
 timer_active=0xFF;
 write_rtc(0x30,timer_active);
 return;
}
// **********************************************************************************
main() 
  {
   // setup chip functions
   init_chip();

    do {
        main_loop:
        display_datetime(0);

	// read timer data every 2 seconds
        if(sec_strobe>=2)
         {sec_strobe=0;
          check_timers();
         }

        k=kbd_getc();
        restart_wdt();
        switch(k)
         { 
          case '0':button(0);	break;   
          case '1':button(1);	break;   
          case '2':button(2);	break;   
          case '3':button(3);	break;   
          case '4':button(4);	break;   
          case '5':button(5);	break;   
          case '6':button(6);	break;   
          case '7':button(7);	break;   
          case '8':button(8);	break;   
          case '9':button(9);	break;   
          case 'A':send_fav(0);	break;   
          case 'B':send_fav(1);	break;   
          case 'C':send_fav(2);	break;   
          case 'D':send_fav(3);	break;   
          case 'E':reset_timer_function(); break;
          case 'F':function_select(); break;   
          case  0 : goto main_loop;
         }    
      } while (true);

 }
// **********************************************************************************


