;*****************************************************************************        
;
;   Module:     display.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.2 2/06/05                                                  
;
;               Functions to implement access to the LCD using a 4 bit interface
;               1.1 26/05/05 added delay during 4bit mode setting
;               1.2 2/6/05 Updated product version string
;
;*****************************************************************************       


;*****************************************************************************        
;
;   Function :  lcdbusy
;               This call blocks until the busy flag in the LCD is clear
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
lcdbusy
    bsf     STATUS,RP0    ; Select Register page 1
    movlw   0x0FF        ; Set PORT for input
    movwf   DATA_BUS_TRIS
    bcf     STATUS, RP0    ; Select Register page 0
    
    bcf     lcdCtrl, LCD_RS; Set LCD for command mode
    movfw   lcdCtrl
    movwf   CONTROL
    bsf     lcdCtrl, LCD_RW; Setup to read busy flag
    movfw   lcdCtrl
    movwf   CONTROL
    
    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    nop
    movf    DATA_BUS, W    ; Read busy flag + DDram address
    andlw    0xF0
    movwf   lcdTmp2
    
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   CONTROL

    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    nop
    swapf    DATA_BUS, W    ; Read busy flag + DDram address
    andlw    0x0F
    addwf   lcdTmp2, F
    
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   CONTROL
    
    movfw   lcdTmp2
    andlw   0x80        ; Check Busy flag, High = Busy
    btfss   STATUS, Z
    goto    lcdbusy
            
    bcf     lcdCtrl, LCD_RW
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    bsf     STATUS, RP0    ; Select Register page 1
    clrf    DATA_BUS_TRIS    ; Set PORT for output
    bcf     STATUS, RP0    ; Select Register page 0
    return
        
        
        
;*****************************************************************************        
;
;   Function :  dspClear
;               This call clears the display and returns the cursor position
;               to top left.
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspClear
    movlw   0x001
    call    dspPutCmd
    return
    
    

;*****************************************************************************        
;
;   Function :  dspHome
;               This call returns the cursor position to top left.
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspHome
    movlw   0x002
    call    dspPutCmd
    return
        


;*****************************************************************************        
;
;   Function :  dspLine2
;               This call positions the cursor at the beginning of the second
;               line
;
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
dspLine2
    movlw   0x0c0               ; pos 40h = 01000000
    call    dspPutCmd
    return



;*****************************************************************************        
;
;   Function :  dspPutChar
;               This call writes a character to the current cursor position.
;
;   Input:      Character in W
;
;   Output:     None
;
;*****************************************************************************        
dspPutChar
    movwf   lcdTmp    ; Character to be sent is in W
    call    lcdbusy        ; Wait for LCD to be ready
    bcf     lcdCtrl, LCD_RW; Set LCD in read mode
    movfw   lcdCtrl
    movwf   CONTROL
    bsf     lcdCtrl, LCD_RS; Set LCD in data mode
    movfw   lcdCtrl
    movwf   CONTROL
    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   CONTROL
    movf    lcdTmp, W
    nop
    movwf   DATA_BUS    ; Send data to LCD
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   CONTROL

    bsf     lcdCtrl, LCD_E    ; LCD E-line High
    movfw   lcdCtrl
    movwf   CONTROL
    swapf   lcdTmp, W
    nop
    movwf   DATA_BUS    ; Send data to LCD
    bcf     lcdCtrl, LCD_E    ; LCD E-line Low
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    return
        


;*****************************************************************************        
;
;   Function :  dspPutCmd
;               writeLCDRaw
;               Sends a command to the LCD. writeLCDRaw does it without 
;               checking the busy status
;              
;   Input:      Command to write is in W
;
;   Output:     None
;
;*****************************************************************************        
dspPutCmd
    movwf   lcdTmp              ; Command to be sent is in W
    call    lcdbusy             ; Wait for LCD to be ready
    goto    dp001
    
writeRawLCD
    movwf   lcdTmp    
    
dp001
    bcf     lcdCtrl, LCD_RW
    movfw   lcdCtrl
    movwf   CONTROL
    bcf     lcdCtrl, LCD_RS
    movfw   lcdCtrl
    movwf   CONTROL
    bsf     lcdCtrl, LCD_E
    movfw   lcdCtrl
    movwf   CONTROL
    movf    lcdTmp, W
    nop
    movwf   DATA_BUS   
    nop 
    bcf     lcdCtrl, LCD_E    
    movfw   lcdCtrl
    movwf   CONTROL
    bsf     lcdCtrl, LCD_E
    movfw   lcdCtrl
    movwf   CONTROL
    swapf   lcdTmp, W
    nop
    movwf   DATA_BUS    
    bcf     lcdCtrl, LCD_E    
    movfw   lcdCtrl
    movwf   CONTROL
    nop    
    return  



;*****************************************************************************        
;
;   Function :  dspPutCmd4Bit
;               Puts the LCD into 4 bit mode from 8 bit mode
;              
;   Input:      Command to write is in W
;
;   Output:     None
;
;*****************************************************************************        
dspPutCmd4Bit
    movlw   0x20
    movwf   lcdTmp              ; Command to be sent is in W
    bcf     lcdCtrl, LCD_RW
    movfw   lcdCtrl
    nop
    movwf   CONTROL
    bcf     lcdCtrl, LCD_RS
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    bsf     lcdCtrl, LCD_E
    movfw   lcdCtrl
    movwf   CONTROL
    movf    lcdTmp, W
    nop
    nop
    movwf   DATA_BUS   
    nop 
    bcf     lcdCtrl, LCD_E    
    movfw   lcdCtrl
    movwf   CONTROL
    nop
    nop
    return  


;*****************************************************************************        
;
;   Function : uiWait10ms
;              delays for a multiple of 10ms
;
;   Input:     multiple in W
;
;*****************************************************************************        
uiWait10ms
    movwf   delay3
    
d1ms001
    movlw   D'100'
    call    uiWait100us
    decfsz  delay3, F
    goto    d1ms001
    return



;*****************************************************************************        
;
;   Function : uiWait100us
;              delays for a multiple of 100us
;
;   Input:     multiple in W
;
;*****************************************************************************        
uiWait100us
    movwf   delay2

d1us002
    movlw    D'165'                    
    movwf    delay1                   
    
d1us001    
    decfsz    delay1, F               
    goto    d1us001                    
    decfsz  delay2, F
    goto    d1us002
    return                         


;*****************************************************************************        
;
;   Function :  uiDspStr1
;               Prints a string to the display at the current cursor 
;               position. Does not wrap from first to second line
;
;   Input:      string to display in W
;
;   Output:     Display modified
;
;*****************************************************************************        

    ORG  0x300

uiDspStr1
    movwf    tmpVal    
        
uips1_001
    movlw   HIGH strTable1
    movwf   PCLATH    
    movf    tmpVal, W
    call    strTable1
    clrf    PCLATH
    xorlw   0
    btfsc   STATUS, Z
    goto    uips1_002
    call    dspPutChar
    incf    tmpVal, F
    goto    uips1_001

uips1_002
    clrf    PCLATH
    return



strTable1
    addwf   PCL, F
st1m1
    retlw    'E'
    retlw    'P'
    retlw    'E'
    retlw    ' '
    retlw    'C'
    retlw    'r'
    retlw    'o'
    retlw    's'
    retlw    's'
    retlw    'w'
    retlw    'o'
    retlw    'r'
    retlw    'd'
    retlw    0
st1m2
    retlw    'A' 
    retlw    's'
    retlw    's'
    retlw    'i'
    retlw    's'
    retlw    't'
    retlw    'a'
    retlw    'n'
    retlw    't'
    retlw    ' '
    retlw    'V'
    retlw    '1'
    retlw    '.'
    retlw    '1'
    retlw    0
st1m3
    retlw    'N'
    retlw    'o'
    retlw    ' '
    retlw    'w'
    retlw    'o'
    retlw    'r'
    retlw    'd' 
    retlw    's'
    retlw    ' '
    retlw    'f'
    retlw    'o'
    retlw    'u'
    retlw    'n'
    retlw    'd'
    retlw    0
st1m4
    retlw    'N'
    retlw    'o'
    retlw    ' '
    retlw    'm'
    retlw    'o'
    retlw    'r'
    retlw    'e' 
    retlw    ' '
    retlw    'w'
    retlw    'o'
    retlw    'r'
    retlw    'd'
    retlw    's'
    retlw    0
st1m5
    retlw    'S'
    retlw    'e'
    retlw    'l'
    retlw    'e'
    retlw    'c'
    retlw    't'
    retlw    ' ' 
    retlw    'o'
    retlw    'p'
    retlw    't'
    retlw    'i'
    retlw    'o'
    retlw    'n'
    retlw    0
st1m6
    retlw    '<'
    retlw    'W'
    retlw    'o'
    retlw    'r'
    retlw    'd'
    retlw    '>'
    retlw    ' '
    retlw    ' '
    retlw    'A' 
    retlw    'n'
    retlw    'a'
    retlw    'g'
    retlw    'r'
    retlw    'a'
    retlw    'm'
    retlw    ' '
    retlw    0
st1m7
    retlw    ' '
    retlw    'W'
    retlw    'o'
    retlw    'r'
    retlw    'd'
    retlw    ' '
    retlw    ' '
    retlw    '<'
    retlw    'A' 
    retlw    'n'
    retlw    'a'
    retlw    'g'
    retlw    'r'
    retlw    'a'
    retlw    'm'
    retlw    '>'
    retlw    0
st1m8          
    retlw    'W'
    retlw    'o'
    retlw    'r'
    retlw    'd'
    retlw    ' '
    retlw    'l'
    retlw    'e'
    retlw    'n'
    retlw    'g' 
    retlw    't'
    retlw    'h'
    retlw    '?'
    retlw    0

st1m9
    retlw    'E'
    retlw    'n'
    retlw    't'
    retlw    'e'
    retlw    'r'
    retlw    ' '
    retlw    'l'
    retlw    'e'
    retlw    't' 
    retlw    't'
    retlw    'e'
    retlw    'r'
    retlw    's'
    retlw    '.'
    retlw    '.'
    retlw    '.'

strTable1_end
    retlw    0
    
    
    IF ( (strTable1 & 0x0FF) >= (strTable1_end & 0x0FF) )
        MESSG   "Table strTable1 overflow. Try putting in an ORG statement"
    ENDIF

; Display strings
WELCOME_L1          EQU st1m1 - st1m1
WELCOME_L2          EQU st1m2 - st1m1
NO_WORDS_FOUND      EQU st1m3 - st1m1
NO_MORE_WORDS       EQU st1m4 - st1m1
SELECT_OPTION       EQU st1m5 - st1m1
WORD_ANAGRAM1       EQU st1m6 - st1m1
WORD_ANAGRAM2       EQU st1m7 - st1m1
SELECT_LENGTH       EQU st1m8 - st1m1
ENTER_LETTERS       EQU st1m9 - st1m1
