; TAPE100.ASM 21AUG98 - EPE PIC TAPE MEASURE - COPYRIGHT JOHN BECKER
; With correction routines (previously TAPEX35.ASM)
; PIC16C84 or PIC16F84, 4.0MHz XTAL, WDT off, POR on
; Written for TASM assembly

#DEFINE PAGE0 BCF 3,5    
#DEFINE PAGE1 BSF 3,5    

INDF:     .EQU $00              
OPTION:   .EQU $01              
PCL:      .EQU $02              
STATUS:   .EQU $03              
FSR:      .EQU $04              
PORTA:    .EQU $05              
TRISA:    .EQU $05              
PORTB:    .EQU $06              
TRISB:    .EQU $06              
EEDATA:   .EQU $08
EECON1:   .EQU $08
EEADR:    .EQU $09
EECON2:   .EQU $09
INTCON:   .EQU $0B

MISC1:    .EQU $0C             ;misc use
MISC2:    .EQU $0D             ;misc use
COUNT0:   .EQU $0E             ;counter 0
COUNT1:   .EQU $0F             ;counter 1
RECORD0:  .EQU $10             ;recording store LSB
RECORD1:  .EQU $11             ;recording store MSB
FEET1:    .EQU $12             ;feet byte 1 LSB
FEET2:    .EQU $13             ;feet byte 2 MSB
ANSA1:    .EQU $14             ;answer byte 1 LSB
ANSA2:    .EQU $15             ;answer byte 2 MSB
ANSA3:    .EQU $16             ;answer byte 3 MSB
ANSA4:    .EQU $17             ;answer byte 4 LSB
ANSA5:    .EQU $18             ;answer byte 5 MSB
ANSA6:    .EQU $19             ;answer byte 6 MSB
TOP0:     .EQU $1A             ;top of division byte 1 LSB
TOP1:     .EQU $1B             ;top of division byte 2 NSB
TOP2:     .EQU $1C             ;top of division byte 3 MSB
DIV1:     .EQU $1D             ;divider byte 1 LSB
DIV2:     .EQU $1E             ;divider byte 2 MSB
LOOPB:    .EQU $1F             ;loop counter B
STORE1:   .EQU $20             ;general store 1
STORE2:   .EQU $21             ;general store 2
LOOPA:    .EQU $22             ;loop counter A - for LCD only
RSLINE:   .EQU $23             ;bit 4 = RS line flag for LCD
CLKCNT:   .EQU $24             ;pre-counter for CLOCK
METRE0:   .EQU $25             ;metres byte 1 LSB
METRE1:   .EQU $26             ;metres byte 2 NSB
METRE2:   .EQU $27             ;metres byte 3 MSB
INCH1:    .EQU $28             ;inches byte 1 LSB
INCH2:    .EQU $29             ;inches byte 2 MSB
MASK:     .EQU $2A             ;foreground mask value (1 per metre)
ZERO:     .EQU $2B             ;zero count flag
LOOPW:    .EQU $2C             ;eeprom write counter (record counter)
LOOPR:    .EQU $2D             ;eeprom read counter (replay counter)
SAVE:     .EQU $2E             ;SAVE flag
TSTFLG:   .EQU $2F             ;test/setup flag

W:        .EQU 0
F:        .EQU 1                
C:        .EQU 0                
DC:       .EQU 1                
Z:        .EQU 2                
GIE:      .EQU 7               ;global interrupt bit
RBIF:     .EQU 0               ;RB4-RB7 change interrupt flag

WR:       .EQU 1               ;eeprom write initiate flag
WREN:     .EQU 2               ;eeprom write enable flag
RD:       .EQU 0               ;eeprom read enable flag

          .ORG $0004
          goto START
          .ORG $0005

START:   clrf PORTA            
         movlw %01000000
         movwf PORTB
         PAGE1
         movlw %00011100
         movwf TRISA           ;Port A0-A1 as output, A2-A4 as input 
         movlw %11000000
         movwf TRISB           ;Port B0-B5 as output, B6-B7 as input
         movlw %00000101       ;set timer ratio 1:64
         movwf OPTION          ;pull-ups on (bit 7 = 0)
         PAGE0

CLRINT:  bcf INTCON,GIE        ;disable all interrupts
         btfsc INTCON,GIE      ;are all interrupts disabled?
         goto CLRINT           ;no, try again
        
CLRALL:  movlw $0C             ;clear registers
         movwf FSR
CLRA2:   clrf INDF
         incf FSR,F
         btfss FSR,4
         goto CLRA2
         btfss FSR,5
         goto CLRA2
         goto SETUP            

TABLCD:  ADDWF PCL,F           ;LCD initialisation table
         RETLW %00110011       ;initialise lcd - first byte
         RETLW %00110011       ;2nd byte (repeat of first)
         RETLW %00110010       ;set for 4-bit operation
         RETLW %00101100       ;set for 2 lines
         RETLW %00000110       ;set entry mode to increment each address
         RETLW %00001100       ;set display on, cursor off, blink off
         RETLW %00000001       ;clear display
         RETLW %00000010       ;return home, cursor & RAM to zero
                               ;end initialisation table

TBDEC1:  ADDWF PCL,F           ;table for decimalisation lsb
         retlw $0A             ;lsb of 10
         retlw $64             ;lsb of 100
         retlw $E8             ;lsb of 1000
         retlw $10             ;lsb of 10000

TBDEC2:  ADDWF PCL,F           ;table for decimalisation msb
         retlw 0               ;msb of 10
         retlw 0               ;msb of 100
         retlw $03             ;msb of 1000
         retlw $27             ;msb of 10000

MESSAG1: addwf PCL,F
         retlw 'E'
         retlw 'P'
         retlw 'E'
         retlw ' '
         retlw 'P'
         retlw 'I'
         retlw 'C'
         retlw ' '
         retlw 'T'
         retlw 'A'
         retlw 'P'
         retlw 'E'
         retlw ' '
         retlw 'B'
         retlw 'O'
         retlw 'X'

MESSAG2: addwf PCL,F
         retlw 'P'
         retlw 'R'
         retlw 'E'
         retlw 'S'
         retlw 'S'
         retlw ' '
         retlw 'S'
         retlw 'E'
         retlw 'N'
         retlw 'D'
         retlw ' '
         retlw 'K'
         retlw 'E'
         retlw 'Y'
         retlw ' '
         retlw ' '

SETUP:   call PAUSIT           ;delay

         clrf LOOPB            ;clr LCD set-up loop
LCDSET:  movf LOOPB,W          ;get table address
         call TABLCD           ;get set-up instruction
         call LCDLIN           ;perform it
         incf LOOPB,F          ;inc loop
         btfss LOOPB,3         ;has last LCD set-up instruction now been done?
         goto LCDSET           ;no
         call PAUSIT           ;delay

         clrf LOOPB
         call LCD1
TITLE1:  movf LOOPB,W          ;get table address
         call MESSAG1          ;get set-up instruction
         call LCDOUT           ;perform it
         incf LOOPB,F          ;inc loop
         btfss LOOPB,4
         goto TITLE1

         clrf LOOPB
         call LCD21
TITLE2:  movf LOOPB,W          ;get table address
         call MESSAG2          ;get set-up instruction
         call LCDOUT           ;perform it
         incf LOOPB,F          ;inc loop
         btfss LOOPB,4
         goto TITLE2

         btfsc PORTA,2         ;is SEND switch on RA2 pressed?
         bsf TSTFLG,0          ;yes, set TEST flag bit 0 (basic correction)
         btfsc PORTA,3         ;is STORE switch on RA3 pressed?
         call CLRPRM           ;yes, clear EEPROM distance records
         btfsc PORTA,4         ;is MASK switch on RA4 pressed?
         bsf TSTFLG,1          ;yes, set TEST flag bit 1 (mask correction)
         btfss PORTB,6         ;is RECALL switch on RB6 pressed?
         call CLRPRM           ;yes, clear full EEPROM & set default timings

SET2:    movf PORTA,W          ;wait for switches to be released
         andlw %00011100
         btfss STATUS,Z
         goto SET2
SET3:    btfss PORTB,6
         goto SET3

         movlw 1               ;set MASK to 1
         btfsc TSTFLG,0        ;is TEST flag bit 0 set ?
         movlw 0               ;yes, set MASK to 0
         movwf MASK
         clrf LOOPR            ;reset replay (read) counter
         movlw 61              ;get current record (write) counter val
         call PRMGET           ;from location 61
         movwf LOOPW           ;set result into record counter

;.......... END OF SETUP


INTRPT:  btfsc PORTA,2         ;is SEND switch on RA2 pressed?
         call TXIT             ;yes
         btfsc PORTA,3         ;is STORE switch on RA3 pressed?
         call STOREIT          ;yes (also serves as + key for correction)
         btfsc PORTA,4         ;is MASK switch on RA4 pressed?
         call MASKIT           ;yes
         btfss PORTB,6         ;is RECALL switch on RB6 pressed?
         call RECALL           ;yes (also serves as - key for correction)
         movf TSTFLG,F
         btfss STATUS,Z        ;are test flags set?
         call TXIT             ;yes, so keep on sending
         goto INTRPT

TXIT:    movlw 10
         movwf LOOPB           ;set transmission loop to 10
         clrf COUNT0           ;clear counters
         clrf COUNT1
         bsf PORTA,0
         bsf SAVE,0

BEAMIT:  nop                   ;send 40kHz signal
         nop                   ;command qty sets freq/mark-space
         nop
         nop
         nop
         nop
         nop
         nop
         comf PORTA,F          ;toggle push-pull RA0/RA1
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         nop
         comf PORTA,F          ;toggle push-pull RA0/RA1
         decfsz LOOPB,F
         goto BEAMIT
         clrf PORTA
         call RECEIVE
         
         movf TSTFLG,F
         btfsc STATUS,Z        ;are test flags set ?
         goto BEAM2            ;no

         call LCD8             ;yes, show TEST message
         movlw 'B'
         btfss TSTFLG,0        ;set prefix letter for BASIC or MASK
         movlw 'M'
         call LCDOUT

         movlw 'T'             
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'S'
         call LCDOUT
         movlw 'T'
         call LCDOUT
         movlw ' '
         call LCDOUT
         call SHWTST
         goto BEAM3
         
BEAM2:   call LCD9
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw 'L'
         call LCDOUT
         movlw 'I'
         call LCDOUT
         movlw 'V'
         call LCDOUT
         movlw 'E'
         call LCDOUT

BEAM3:   call PAUSIT           ;pause
         call PAUSIT
         return

RECEIVE: btfsc TSTFLG,0        ;is TSTFLG bit 0 set (basic correction)?
         goto MASK0            ;yes
         movf MASK,W
         movwf LOOPB

MASK1:   movlw 2               ;masking delays
         movwf ANSA2
         movlw 48
         movwf ANSA1

MASK2:   movlw 4
         movwf ANSA3
MASK3:   decfsz ANSA3,F
         goto MASK3

         decfsz ANSA1,F
         goto MASK2
         decfsz ANSA2,F
         goto MASK2
         decfsz LOOPB,F
         goto MASK1

MASK0:   bcf INTCON,RBIF       ;clear RB4-RB7 interrupt change flag
         bcf ZERO,0
LISTEN:  btfsc INTCON,RBIF     ;has echo been heard? (int change on RB7)
         goto SHWCNT           ;yes
         movlw 1               ;no, so inc COUNT0
         addwf COUNT0,F
         movf STATUS,W
         andlw 1
         addwf COUNT1,F        ;add Carry to COUNT1
         btfss STATUS,C        ;is there a Carry?
         goto LISTEN           ;no
         bsf ZERO,0
         goto METRES
         
SHWCNT:  movlw 30              ;add equivalent count for transmission time
         addwf COUNT0,F
         btfsc STATUS,C
         incf COUNT1,F
         btfsc TSTFLG,0        ;is TEST flag bit 0 set ?
         goto METRES           ;yes, bypass MASK addition

         movf MASK,W
         movwf LOOPB           ;now add 256 (MSB = 1) + EEPROM value (LSB)
                               ;to count for each MASK value - author's
                               ;ideal was MSB 1 & LSB 234 = 490

MASKAD:  movlw 63              ;set EEPROM address to 63 (mask val)
         call PRMGET           ;get MSB
         addwf COUNT0,F
         btfsc STATUS,C
         incf COUNT1,F
         incf COUNT1,F
         decfsz LOOPB,F
         goto MASKAD

METRES:  movf COUNT0,W
         movwf RECORD0
         movf COUNT1,W
         movwf RECORD1

         call GETMMS           ;calculate millimetres
         call LCD1             ;show metres on line 1 part 1
         movlw METRE1
;         movlw RECORD0        ;author's option for count checking
         call DECIMAL          ;decimalise metres
         movf ANSA5,W
         movwf ANSA6
         movf ANSA4,W
         movwf ANSA5
         movlw '.'
         movwf ANSA4
         movlw 6
         movwf LOOPB
         movlw ANSA6
         movwf FSR

         movf ANSA6,W
         xorlw 48
         btfss STATUS,Z
         goto SHOWMT
         movlw ' '             ;blank leading zero
         movwf ANSA6

SHOWMT:  call SHOWDEC
         movlw 'm'
         call LCDOUT
         movlw 't'
         call LCDOUT
         movlw ' '
         call LCDOUT

         call GETINS           ;calculate feet & inches
         call GETFEET
         call INVERT           ;correct for final inches
         movf TOP1,W
         bcf STATUS,C
         btfss ZERO,0          ;is ZERO set?
         addlw 12              ;no
         movwf INCH1
         movf STATUS,W
         andlw 1
         addwf TOP2,W
         movwf INCH2
         movf INCH1,W
         xorlw 12
         btfss STATUS,Z
         goto SHOWFT
         clrf INCH1
         clrf INCH2
         incfsz FEET1,F
         goto SHOWFT
         incf FEET2,F

SHOWFT:  call LCD21
         movlw FEET1
         call DECIMAL          ;decimalise feet
         movlw 3
         movwf LOOPB
         movlw ANSA3
         movwf FSR

         movf ANSA3,W
         xorlw 48
         btfss STATUS,Z
         goto SHWFT2
         movlw ' '             ;blank leading zero
         movwf ANSA3
         movf ANSA2,W
         xorlw 48
         btfss STATUS,Z
         goto SHWFT2
         movlw ' '             ;blank leading zero
         movwf ANSA2

SHWFT2:  call SHOWDEC
         movlw 'f'
         call LCDOUT
         movlw 't'
         call LCDOUT

SHOWIN:  movlw INCH1
         call DECIMAL          ;show remaining inches
         movlw 2
         movwf LOOPB
         movlw ANSA2
         movwf FSR

         movf ANSA2,W
         xorlw 48
         btfss STATUS,Z
         goto SHOWIN2
         movlw ' '             ;blank leading zero
         movwf ANSA2

SHOWIN2: call SHOWDEC
         movlw 'i'
         call LCDOUT
         movlw 'n'
         call LCDOUT
         movlw ' '
         call LCDOUT
         call SHOWSW
         return

GETMMS:  clrf METRE0           ;multiply by basic timing factor
         movf COUNT0,W         ;on author's unit a count of 618 = 1 metre
         movwf METRE1          ;1000/618 = 1.6181229
         movf COUNT1,W         ;therefore multiply count x 1.6181229
         movwf METRE2          ;256 x .618 = 158 (THUS MSB 1, LSB 158)
         movf COUNT0,W         ;LSB is held as variable factor in EEPROM
         btfsc STATUS,Z        ;with default value of 158
         goto GETCM2
         movwf LOOPB
GETCM1:  movlw 62              ;get basic timing value from EEPROM 62
         call PRMGET
         addwf METRE0,F
         movf STATUS,W
         andlw 1
         addwf METRE1,F
         movf STATUS,W
         andlw 1
         addwf METRE2,F
         decfsz LOOPB,F
         goto GETCM1

GETCM2:  movf COUNT1,W
         btfsc STATUS,Z
         return
         movwf LOOPB
GETCM3:  movlw 62              ;get basic timing value from EEPROM 62
         call PRMGET
         addwf METRE1,F
         movf STATUS,W
         andlw 1
         addwf METRE2,F
         decfsz LOOPB,F
         goto GETCM3
         return

GETINS:  movlw 25              ;divide by 25.4 for inches measurement
         movwf DIV2            ;set divider msb for 25
         movlw 102             ;set lsb for 102 (= 0.4 decimal as binary)
         movwf DIV1
         movf METRE1,W
         movwf STORE1
         movf METRE2,W
         movwf STORE2

         call DIVIDE
         movf ANSA1,W
         movwf INCH1
         movf ANSA2,W
         movwf INCH2
         return

GETFEET: movlw 12              ;divide by 12.0 for feet measurement
         movwf DIV2            ;set divider msb for 12
         movlw 0               ;set lsb for 0
         movwf DIV1
         movf INCH1,W
         movwf STORE1
         movf INCH2,W
         movwf STORE2
         call DIVIDE
         movf ANSA1,W
         movwf FEET1
         movf ANSA2,W
         movwf FEET2
         return
         
DIVIDE:  movf STORE1,W
         movwf TOP1
         movf STORE2,W
         movwf TOP2
         clrf TOP0

         clrf ANSA1
         clrf ANSA2
         movf TOP1,W           ;is TOP = zero?
         iorwf TOP2,W
         btfsc STATUS,Z
         goto DIVIDE3          ;yes
         call INVERT           ;invert TOP for adding instead of subtraction

DIVIDE2: movf DIV1,W           ;add lsb of DIV to lsb of TOP
         addwf TOP0,F
         movlw 1
         andwf STATUS,C        ;add carry flag to msb of TOP
         addwf TOP1,F
         movlw 1
         andwf STATUS,C        ;add carry flag to msb of TOP
         addwf TOP2,F
         btfsc STATUS,C        ;is there a carry?
         goto DIVIDE3          ;yes
         movf DIV2,W           ;no, add msb of DIV to msb of TOP
         addwf TOP1,F
         movlw 1
         andwf STATUS,C        ;add carry flag to msb of TOP
         addwf TOP2,F
         btfsc STATUS,C        ;is there a carry?
         goto DIVIDE3          ;yes
         incfsz ANSA1,F        ;no, inc counter lsb, is there a zero rollover?
         goto DIVIDE2          ;no
         incf ANSA2,F          ;yes, inc counter msb
         goto DIVIDE2         
DIVIDE3: return

LCD210:  movlw %11001010       ;misc LCD pixel addresses - not all used
         goto LCDLIN
LCD28:   movlw %11001000
         goto LCDLIN
LCD21:   movlw %11000000
         goto LCDLIN
LCD13:   movlw %10001101
         goto LCDLIN
LCD11:   movlw %10001011
         goto LCDLIN
LCD9:    movlw %10001001
         goto LCDLIN
LCD8:    movlw %10001000
         goto LCDLIN
LCD1:    movlw %10000000

LCDLIN:  BCF RSLINE,4          ;clear RS flag - sets LCD command/line
        
LCDOUT:  MOVWF STORE1          ;temp store data for LCD
         MOVLW 20              ;set min time between sending full bytes to LCD
         MOVWF LOOPA
DELAY:   DECFSZ LOOPA,F
         GOTO DELAY            
         CALL SENDIT           ;send MSB
         CALL SENDIT           ;send LSB
         BSF RSLINE,4          ;set RS flag (default is flag set)
         return
         
SENDIT:  SWAPF STORE1,F        ;get and send data nibble
         MOVF STORE1,W         
         ANDLW 15              
         IORWF RSLINE,W        ;OR the RS bit
         MOVWF PORTB           ;output the byte
         BSF PORTB,5           ;set E high
         BCF PORTB,5           ;set E low
         RETURN                
         
PAUSIT:  MOVLW 10              ;delay set
         MOVWF CLKCNT          
         CLRF INTCON
PAUSE:   BTFSS INTCON,2        ;has a timer time-out been detected?
         GOTO PAUSE            ;no
         BCF INTCON,2          ;yes
         DECFSZ CLKCNT,F       ;dec loop, is it zero?
         GOTO PAUSE            ;no
         RETURN                ;yes
         
DECIMAL: clrf ANSA1
         clrf ANSA2
         clrf ANSA3
         clrf ANSA4
         clrf ANSA5
         movwf FSR

         movf INDF,W           ;check for zero value
         incf FSR,F
         iorwf INDF,W
         btfsc STATUS,Z
         goto DEC4
         
         movf INDF,W           ;copy value into TOP
         movwf TOP2
         decf FSR,F
         movf INDF,W
         movwf TOP1
         movlw 4
         movwf LOOPB
         movlw ANSA5
         movwf FSR

DECA1:   clrf STORE2
         decf LOOPB,W
         call TBDEC1
         movwf MISC1
         decf LOOPB,W
         call TBDEC2
         movwf MISC2
         call ADDIT
         movwf INDF
         decf FSR,F
         decfsz LOOPB,F
         goto DECA1
         movf TOP1,W
         movwf INDF

DECA2:   addlw 6
         btfss STATUS,DC
         goto DEC4
         clrf INDF
         incf FSR,F
         incf INDF,F
         movf INDF,W
         goto DECA2

ADDIT:   call INVERT           ;invert to allow adding
ADDIT2:  incf STORE2,F
         movf MISC1,W
         addwf TOP1,F
         movlw 1
         andwf STATUS,W
         addwf MISC2,W
         addwf TOP2,F
         btfss STATUS,C
         goto ADDIT2
                              
         call INVERT           ;invert to allow adding
         movf MISC1,W          ;subtract last addition value
         addwf TOP1,F
         btfsc STATUS,C
         incf TOP2,F
         movf MISC2,W
         addwf TOP2,F
         decf STORE2,W
         return

DEC4:    movlw 48
         iorwf ANSA1,F
         iorwf ANSA2,F
         iorwf ANSA3,F
         iorwf ANSA4,F
         iorwf ANSA5,F
         return

SHOWDEC: movf INDF,W
         call LCDOUT
         decf FSR,F
         decfsz LOOPB,F
         goto SHOWDEC
         return

INVERT:  comf TOP1,F           
         incf TOP1,F
         btfsc STATUS,Z
         decf TOP2,F
         comf TOP2,F
         return

MASKIT:  incf MASK,F           ;inc MASK
         movf MASK,W
         xorlw 10              ;is it = 10?
         btfss STATUS,Z
         goto SHOWSW           ;no
         movlw 1               ;yes, reset MASK to 1
         movwf MASK

SHOWSW:  call LCD210
         movlw 'M'
         call LCDOUT
         movlw 'a'
         call LCDOUT
         movlw 's'
         call LCDOUT
         movlw 'k'
         call LCDOUT
         movf MASK,W
         btfsc STATUS,Z
         goto SW2
         movf MASK,W
         iorlw 48
         call LCDOUT
         movlw 'm'
         goto SW3
SW2:     movlw ' '
         call LCDOUT
         movlw '0'
SW3:     call LCDOUT
         call PAUSIT
         call PAUSIT
         call PAUSIT
         return

RECALL:  movf TSTFLG,F
         btfss STATUS,Z       ;are test flags set ?
         goto DECIT           ;yes so goto decrement correction routine

         bcf ZERO,0
         bcf SAVE,0
         call LCD11            ;show record count on line 1 cell 11
         bcf STATUS,C
         rrf LOOPR,W
         movwf COUNT0
         incf COUNT0,F
         clrf COUNT1
         movlw COUNT0
         call DECIMAL
         call BLANKS

         call LCD9            ;show ident on line 1 cell 9
         movlw 'S'
         call LCDOUT
         movlw 'H'
         call LCDOUT
         movlw 'O'
         call LCDOUT
         movlw 'W'
         call LCDOUT
         movlw '='
         call LCDOUT

         movf LOOPR,W
         call PRMGET
         movwf COUNT0
         incf LOOPR,F
         movf LOOPR,W
         call PRMGET
         movwf COUNT1
         incf LOOPR,F
         movf LOOPR,W
         xorlw 60              ;limit of 60 (records 1-30)
         btfss STATUS,Z
         goto RECAL2
         clrf LOOPR           
RECAL2:  movf COUNT0,W
         iorwf COUNT1,W
         btfsc STATUS,Z
         bsf ZERO,0
         call METRES
SHWCT4:  btfss PORTB,6         ;is RECALL switch on RB6 pressed?
         goto SHWCT4           ;yes
         call PAUSIT
         return

STOREIT: movf TSTFLG,F
         btfss STATUS,Z        ;are test flags set?
         goto INCIT            ;yes, so goto increment correction routine
         btfss SAVE,0          ;no, is SAVE flag set?
         return                ;no
         bcf SAVE,0
         movf RECORD0,W
         movwf STORE1
         movf LOOPW,W
         call SETPRM
         movf RECORD1,W
         movwf STORE1
         incf LOOPW,F
         movf LOOPW,W
         call SETPRM

SAVE2:   call LCD11            ;show record count on line 1 cell 11
         bcf STATUS,C
         rrf LOOPW,W
         movwf COUNT0
         incf COUNT0,F
         clrf COUNT1
         movlw COUNT0
         call DECIMAL
         call BLANKS

         call LCD9             ;show record count on line 1 cell 9
         movlw 'S'
         call LCDOUT
         movlw 'A'
         call LCDOUT
         movlw 'V'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'D'
         call LCDOUT

         incf LOOPW,F
         movf LOOPW,W
         xorlw 60              ;limit of 60 (records 1-30)
         btfss STATUS,Z
         goto SAVE3
         clrf LOOPW           

SAVE3:   movf LOOPW,W          ;store new LOOPW value in EEPROM
         movwf STORE1
         movlw 61
         call SETPRM

WAITIT:  btfsc PORTA,3         ;is STORE switch on RA3 pressed?
         goto WAITIT
         call PAUSIT
         return

CLRPRM:  clrf LOOPA            ;clear eeprom routine
         clrf STORE1
CLRPR2:  movf LOOPA,W
         call SETPRM
         incf LOOPA,F
         movf LOOPA,W          ;is count = 62 ?
         xorlw 62
         btfss STATUS,Z
         goto CLRPR2           ;no
         call LCD13
         movlw 'C'
         call LCDOUT
         movlw 'L'
         call LCDOUT
         movlw 'R'
         call LCDOUT

         btfsc PORTB,6         ;is RECALL pressed?
         goto CLRPR3           ;no
         movlw 158             ;yes, set basic timing value to 158
         movwf STORE1
         movlw 62
         call SETPRM
         movlw 234             ;set mask timing value to 234
         movwf STORE1
         movlw 63
         call SETPRM
CLRPR4:  btfss PORTB,6         ;is switch on RB6 still pressed?
         goto CLRPR4           ;yes, so wait

CLRPR3:  btfsc PORTA,3         ;is switch on RA3 still pressed?
         goto CLRPR3           ;yes, so wait
         return

BLANKS:  movlw 5
         movwf LOOPB
         movlw ANSA5
         movwf FSR

         movlw 4
         movwf LOOPA
ZERO1:   movf INDF,W           ;blank leading zeros
         xorlw 48
         btfss STATUS,Z
         goto SHWCT2
         movlw 32
         movwf INDF
         decf FSR,F
         decfsz LOOPA,F
         goto ZERO1

SHWCT2:  movlw ANSA5
         movwf FSR
         call SHOWDEC
         return

;...............

;WRITE DATA TO EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1
        bsf EECON1,WREN ;enable write flag
        PAGE0
        movf STORE1,W   ;get data value from STORE1 and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register

MANUAL: PAGE1           ;these next 12 lines are according to
        movlw $55       ;Microchip manual dictated factors
        movwf EECON2    ;they cause the action required by
        movlw $AA       ;by the eeprom to store the data in EEDATA
        movwf EECON2    ;at the address held by EEADR.
        bsf EECON1,WR   ;set the ``perform write'' flag

CHKWRT: btfss EECON1,4  ;wait until bit 4 of EECON1 is set
        goto CHKWRT
        bcf EECON1,WREN ;disable write
        bcf EECON1,4    ;clear bit 4 of EECON1
        PAGE0
        bcf INTCON,6    ;clear bit 6 of INTCON
        return          ;and return

;..........

;READ DATA FROM EEPROM ROUTINE:

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: movwf EEADR     ;Now copy W into EEADR to set eeprom address
        PAGE1           ;
        BSF EECON1,RD   ;enable read flag
        PAGE0
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        return          ;and return

;............

INCIT:  movlw 62        ;set EEPROM address to 62 (basic correction)
        btfsc TSTFLG,1  ;is TSTFLG bit 1 set 
        movlw 63        ;yes, set EEPROM address to 63 (for mask correction)
        call PRMGET     ;get value to be incremented
        movwf STORE1
        incf STORE1,F   ;increment and restore it
        movlw 62        ;set EEPROM address to 62 (basic correction)
        btfsc TSTFLG,1  ;is TSTFLG bit 1 set 
        movlw 63        ;yes, set EEPROM address to 63 (for mask correction)
        call SETPRM
        return

DECIT:  movlw 62        ;set EEPROM address to 62 (basic correction)
        btfsc TSTFLG,1  ;is TSTFLG bit 1 set 
        movlw 63        ;yes, set EEPROM address to 63 (for mask correction)
        call PRMGET     ;get value to be decremented
        movwf STORE1
        decf STORE1,F   ;decrement and restore it
        movlw 62        ;set EEPROM address to 62 (basic correction)
        btfsc TSTFLG,1  ;is TSTFLG bit 1 set 
        movlw 63        ;yes, set EEPROM address to 63 (for mask correction)
        call SETPRM
        return

SHWTST: call LCD13      ;show mask correction on top right
        movlw 62        ;set EEPROM address to 62 (basic correction)
        btfsc TSTFLG,1  ;is TSTFLG bit 1 set ?
        movlw 63        ;yes, set EEPROM address to 63 (for mask correction)
        call PRMGET
        movwf COUNT0
        clrf COUNT1
        movlw COUNT0
        call DECIMAL
        movlw 3
        movwf LOOPB
        movlw ANSA3
        movwf FSR
        call SHOWDEC
        return
        
       .END

