;SNOOKER311.ASM 01MAR05  SNOOKER AND DARTS SCOREBOARD - John Becker

;PIC16F877A, 4MHz, WDT OFF, POR ON, XTAL XS

;PROGRAM WRITTEN IN TASM VARIANT - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F877 data sheet

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

        List P = PIC16F877A, R=DEC;
        __CONFIG   h'3F31'

        include P16F877A.inc

        CBLOCK 

; ****** general equates
LOOP
LOOPA
STORE
SLOWIT

; ****** BIN2DEC equates

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

REGB0                           ;lsb
REGB1
REGB2
REGB3                           ;msb

REGC0                           ;lsb
REGC1
REGC2
REGC3                           ;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

DARTSCOUNT

COLOURNO
PLAYERID
DIGITNUMBER
FOUL

BALLSCOUNTMSB        ; BCD
BALLSCOUNTNSB        ; BCD
BALLSCOUNTLSB        ; BCD
BALLQTYLEFT            

BREAKMSB             ; BCD
BREAKNSB             ; BCD
BREAKLSB             ; BCD
PREVBREAKMSB         ; BCD
PREVBREAKNSB         ; BCD
PREVBREAKLSB         ; BCD

PLAYER1FRAMEMSB      ; BCD
PLAYER1FRAMENSB      ; BCD
PLAYER1FRAMELSB      ; BCD

PLAYER2FRAMEMSB      ; BCD
PLAYER2FRAMENSB      ; BCD
PLAYER2FRAMELSB      ; BCD

DARTS1FRAMEMSB       ; binary
DARTS1FRAMELSB       ; binary
DARTS2FRAMEMSB       ; binary
DARTS2FRAMELSB       ; binary

FRAMESCOUNTMSB       ; LED coded
FRAMESCOUNTLSB       ; LED coded

COUNTFRAMESMSB       ; BCD
COUNTFRAMESLSB       ; BCD

DARTSTOPMSB          ; binary
DARTSTOPLSB          ; binary

PLAYER1TOTALFRAMES   ; LED coded
PLAYER2TOTALFRAMES   ; LED coded
TOTALFRAMES1
TOTALFRAMES2

SCOREMSB             ; BCD
SCORENSB             ; BCD
SCORELSB             ; BCD


COL
ROW
SWITCHVAL
STORE1
RSLINE
FSRSTORE
PROMVAL
NULLVALUE
LEDBLOCK2
DARTSDOUBLE
KEYSTORE
PREVBALL

        ENDC

MATRIX  EQU 4     ;matrix quantity value
                  ; 4 for (4 x 4)

        ORG 0
        goto START 
        ORG 4            ; Interrupt vector address
        goto START 
        ORG 5
        goto START	

TABLCD: addwf PCL,F      ;LCD initialisation table
        retlw %00110011  ;initialise lcd - first byte
        retlw %00110011  ;2nd byte (repeat of first)
        retlw %00110010  ;set for 4-bit operation
        retlw %00101100  ;set for 2 lines
        retlw %00000110  ;set entry mode to increment each address
        retlw %00001100  ;set display on, cursor off, blink off
        retlw %00000001  ;clear display
        retlw %00000010  ;return home, cursor & RAM to zero
                         ;end inititalisation table
                 
COMANODE:       andlw %00011111         ; common anode codes order -ABFGCDE 
                addwf PCL,F
                retlw B'01110111'       ; 0
                retlw B'00100100'       ; 1
                retlw B'01101011'       ; 2
                retlw B'01101110'       ; 3
                retlw B'00111100'       ; 4
                retlw B'01011110'       ; 5
                retlw B'00011111'       ; 6
                retlw B'01100100'       ; 7
                retlw B'01111111'       ; 8
                retlw B'01111100'       ; 9
                retlw B'00001000'       ; 10 (shows G seg only)
                retlw B'00000000'       ; 11
                retlw B'00000000'       ; 12
                retlw B'00000000'       ; 13
                retlw B'00000000'       ; 14
                retlw B'00000000'       ; 15
                retlw B'00000000'       ; 16

ITEMNUMBER:     addwf LEDBLOCK2,W
                addwf PCL,F             ; get register address for showing
                retlw FRAMESCOUNTMSB    ; 7-seg 7       RD0
                retlw FRAMESCOUNTLSB    ; 7-seg 8       RD1
                retlw PLAYER2FRAMENSB   ; 7-seg 5       RD2
                retlw PLAYER2FRAMELSB   ; 7-seg 6       RD3
                retlw PLAYER1FRAMELSB   ; 7-seg 3       RD4
                retlw PLAYER2FRAMEMSB   ; 7-seg 4       RD5
                retlw PLAYER1FRAMEMSB   ; 7-seg 1       RD6
                retlw PLAYER1FRAMENSB   ; 7-seg 2       RD7

                retlw FRAMESCOUNTMSB     ; 7-seg 7       RD0
                retlw FRAMESCOUNTLSB     ; 7-seg 8       RD1
                retlw NULLVALUE          ; 7-seg 5       RD2
                retlw PLAYER2TOTALFRAMES ; 7-seg 6       RD3
                retlw BREAKLSB           ; 7-seg 3       RD4
                retlw PLAYER1TOTALFRAMES ; 7-seg 4       RD5
                retlw BREAKMSB           ; 7-seg 1       RD6
                retlw BREAKNSB           ; 7-seg 2       RD7

                retlw NULLVALUE          ; 7-seg 7       RD0
                retlw NULLVALUE          ; 7-seg 8       RD1
                retlw NULLVALUE          ; 7-seg 5       RD2
                retlw NULLVALUE          ; 7-seg 6       RD3
                retlw BALLSCOUNTLSB      ; 7-seg 3       RD4
                retlw NULLVALUE          ; 7-seg 4       RD5
                retlw BALLSCOUNTMSB      ; 7-seg 1       RD6
                retlw BALLSCOUNTNSB      ; 7-seg 2       RD7

ROUTESWITCH: ADDWF PCL,F
        return          ; 0
        goto ADDB       ; 1 red
        goto ADDB       ; 2 yellow
        goto ADDB       ; 3 green
        goto ADDB       ; 4 brown
        goto ADDB       ; 5 blue
        goto ADDB       ; 6 pink
        goto ADDB       ; 7 black
        return          ; 8
        return          ; 9 
        goto ZEROFRAME  ; 10 [BLANK]
        goto FOUL1      ; 11    '.'
        goto SUBSNOOKER ; 12    'A'
        goto SETBLOCK2  ; 13    'B'
        goto CHANGEPLAYER ; 14  'C'
        return          ; 15    'D'
        return          ; 16

ROUTEDARTS: ADDWF PCL,F
        goto ADDDARTS   ; 0
        goto ADDDARTS   ; 1
        goto ADDDARTS   ; 2
        goto ADDDARTS   ; 3
        goto ADDDARTS   ; 4
        goto ADDDARTS   ; 5
        goto ADDDARTS   ; 6
        goto ADDDARTS   ; 7
        goto ADDDARTS   ; 8
        goto ADDDARTS   ; 9

        goto CHECKLEG   ; 10 [BLANK]
        goto DCHECKDOT  ; 11    '.'
        goto DCHECKA    ; 12    'A'
        goto SETBLOCK2D ; 13    'B'
        goto CHANGEPLAYERDARTS ; 14  'C'
        goto SUBNEWVAL  ; 15    'D'
        return          ; 16

DARTSHUNDREDS: ADDWF PCL,F       ; show DARTS intro line
        retlw 'S'
        retlw 'E'
        retlw 'T'
        retlw ' '
        retlw 'H'
        retlw 'U'
        retlw 'N'
        retlw 'D'
        retlw 'R'
        retlw 'E'
        retlw 'D'
        retlw 'S'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

; ******************

START:  BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto START

        bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PCLATH

        clrf PORTA           ; used for LCD
        clrf PORTB           ; used for switch matrix
        clrf PORTC           ; controls LED digit select
        clrf PORTD           ; controls LED segments code
        clrf PORTE           ; misc switches
        clrf RSLINE

        BANK1
        movlw %11000000
        movwf TRISA
        clrf TRISB
        movlw 15
        movwf TRISC          ; RC0-RC3 as input

        clrf TRISD           ; PORTD as output
        movlw %11111111      ;
        movwf TRISE          ; PORTE as input
        movlw B'00000110'    ; timer 1:128 (1/25th sec), pull-ups on
        movwf OPTION_REG
        movlw B'00000110'    ; RA0 to RA5 as digital
        movwf ADCON1  
        BANK0

        call SETUP

        call GETKEY
        movf SWITCHVAL,W
        xorlw %00001111       ; is 'D' pressed ?
        btfsc STATUS,Z
        goto DARTSCORING     ; yes, DARTS required

        bsf PLAYERID,0       ; no, SNOOKER required
        call ZEROFRAME

        call LCD21
        movlw '0'
        call LCDOUT
        call LCD215
        movlw '0'
        call LCDOUT

; ********** START OF SNOOKER MAIN *********

MAIN:   call LEDSONA
        call GETKEY
        movf SWITCHVAL,W
        btfsc STATUS,Z       ; is it zero?
        goto MAIN

        andlw %00001111
        movwf SWITCHVAL
        call ROUTESWITCH
        call WAITSWITCHA
        goto MAIN

; ****** ADD VALUE OF SWITCH SNOOKER BALL ********

ADDB:   btfsc FOUL,0         ; has a foul been called?
        incf PLAYERID,F      ; yes, allocate points to other player

        btfsc PLAYERID,0     ; is it player 1?
        goto ADDB2           ; no, it's player 2
        call ADDFRAMEP1
        call ADDBREAK
        return

ADDB2:  call ADDFRAMEP2
        call ADDBREAK
        return

; ************ SUBTRACT PREVIOUS BALL VALUE IN CASE OF ERROR ****

SUBSNOOKER: movf PREVBALL,W
        movwf SWITCHVAL

SUBB1:  btfsc PLAYERID,0     ; is it player 1?
        goto SUBB2           ; no, it's player 2
        call SUBFRAMEP1
        call SUBBREAK
        return

SUBB2:  call SUBFRAMEP2
        call SUBBREAK
        return

; ************ BLANKS LEADING ZEROS FOR LEDS *******

BLANKVAL: movf DIGIT8,W
        andlw %00001111
        movwf DIGIT8
        movf DIGIT9,W  
        andlw %00001111
        movwf DIGIT9 
        movf DIGIT10,W 
        andlw %00001111
        movwf DIGIT10

        movf DIGIT8,W          ; blank leading zero code for lcd
        btfss STATUS,Z         ; is MSB zero?
        goto ENDBLANKVAL       ; no
        bsf DIGIT8,4           ; yes, set for blank
        movf DIGIT9,W
        btfsc STATUS,Z         ; is NSB zero?
        bsf DIGIT9,4           ; yes, set for blank
ENDBLANKVAL: return            ; ignore LSB

; ************ CHANGE PLAYER FOR SNOOKER *********

CHANGEPLAYER:
        incf PLAYERID,F      ; yes, so clear break counter
        clrf BREAKMSB
        clrf BREAKNSB
        movlw 0
        call COMANODE
        movwf BREAKLSB
        clrf SCOREMSB
        clrf SCORENSB
        clrf SCORELSB

        call LCD7
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw 'B'
        call LCDOUT

        btfss PLAYERID,0
        goto CP2
        call LCD1
        movlw ' '
        call LCDOUT
        call LCD15
        movlw '<'
        call LCDOUT
        goto CP3

CP2:    call LCD1
        movlw '>'
        call LCDOUT
        call LCD15
        movlw ' '
        call LCDOUT
CP3:    return

; ******** SETS "FOUL" FLAG FOR SNOOKER ******

FOUL1:  bsf FOUL,0
        call LCD21
        movlw 'F'
        call LCDOUT
        return

; ********** INCREMENTS FRAME COUNT FOR SNOOKER *******

INCFRAME:
        clrf PLAYER1FRAMEMSB      ; BCD
        clrf PLAYER1FRAMENSB      ; BCD
        clrf PLAYER2FRAMEMSB      ; BCD
        clrf PLAYER2FRAMENSB      ; BCD

        movlw 0
        call COMANODE
        movwf PLAYER1FRAMELSB     ; BCD
        movwf PLAYER2FRAMELSB     ; BCD

        clrf DARTS1FRAMEMSB       ; binary
        clrf DARTS1FRAMELSB       ; binary
        clrf DARTS2FRAMEMSB       ; binary
        clrf DARTS2FRAMELSB       ; binary

        incf COUNTFRAMESLSB,F
        movf COUNTFRAMESLSB,W
        addlw 6
        btfss STATUS,DC
        goto INC2              ; no
        andlw 15
        movwf COUNTFRAMESLSB
        incf  COUNTFRAMESMSB,F
        movf COUNTFRAMESMSB,W
        call COMANODE
        movwf FRAMESCOUNTMSB

INC2:   movf COUNTFRAMESLSB,W
        call COMANODE
        movwf FRAMESCOUNTLSB

        call LCD24
        movlw '#'
        call LCDOUT
        movf COUNTFRAMESMSB,W
        btfsc STATUS,Z
        goto INC3
        iorlw 48
        call LCDOUT
INC3:   movf COUNTFRAMESLSB,W
        iorlw 48
        call LCDOUT
        call CHANGEPLAYER
        return

; ****** PROCESSES VALUE ADDED OR SUBTRACTED FOR SNOOKER *******

ADDVALUE: movf INDF,W
        movwf REGA0
        clrf  REGA1
        clrf  REGA2
        clrf  REGA3

        call BIN2DEC
        call SHOW8
        call BLANKVAL

        movf FSRSTORE,W
        movwf FSR
        movf DIGIT8,W
        call COMANODE
        movwf INDF
        incf FSR,F
        movf DIGIT9,W
        call COMANODE
        movwf INDF
        incf FSR,F
        movf DIGIT10,W
        call COMANODE
        movwf INDF

        btfss FOUL,0           ; is FOUL set?
        return                 ; no
        clrf FOUL              ; yes
        incf PLAYERID,F
        clrf SWITCHVAL
        call LCD21
        movlw ' '
        call LCDOUT
        return

; *****************

ADDFRAMEP1:                    ; add val to player 1 frame score
        movlw DARTS1FRAMELSB
        movwf FSR
        movlw PLAYER1FRAMEMSB
        movwf FSRSTORE
        call LCD2
        movf SWITCHVAL,W
        andlw %00001111
        movwf PREVBALL
        addwf INDF,F
        call ADDVALUE
        return

ADDFRAMEP2:                    ; add val to player 2 frame score
        movlw DARTS2FRAMELSB
        movwf FSR
        movlw PLAYER2FRAMEMSB
        movwf FSRSTORE
        call LCD13
        movf SWITCHVAL,W
        andlw %00001111
        movwf PREVBALL
        addwf INDF,F
        call ADDVALUE
        return

SUBFRAMEP1:
        movlw DARTS1FRAMELSB
        movwf FSR
        movlw PLAYER1FRAMEMSB
        movwf FSRSTORE
        call LCD2
        movf SWITCHVAL,W
        andlw %00001111
        movwf PREVBALL
        subwf INDF,F
        call ADDVALUE
        return

SUBFRAMEP2:
        movlw DARTS2FRAMELSB
        movwf FSR
        movlw PLAYER2FRAMEMSB
        movwf FSRSTORE
        call LCD13
        movf SWITCHVAL,W
        andlw %00001111
        movwf PREVBALL
        subwf INDF,F
        call ADDVALUE
        return

ADDBREAK:
        movlw SCORELSB
        movwf FSR
        movlw BREAKMSB
        movwf FSRSTORE
        call LCD7
        movf SWITCHVAL,W
        andlw %00001111
        addwf INDF,F
        call ADDVALUE
        movlw 'B'
        call LCDOUT
        movf SWITCHVAL,W
        btfss STATUS,Z
        call BALLSLEFT
        return

SUBBREAK:
        movlw SCORELSB
        movwf FSR
        movlw BREAKMSB
        movwf FSRSTORE
        call LCD7
        movf SWITCHVAL,W
        andlw %00001111
        subwf INDF,F
        call ADDVALUE
        movlw 'B'
        call LCDOUT
        movf SWITCHVAL,W
        btfss STATUS,Z
        call SUBBALLSLEFT
        return

; *************

WAITSWITCHA: call GETKEY       ; wait for switch release
         movlw %11110000  ; RC7 to RC4 high
         movwf PORTC
         nop              ;pause to allow PORTC to stabilise
WAITA2:  call LEDSONA
         movf PORTC,W     ;get PORTC
         andlw 15         ;isolate bits 0-3
         btfss STATUS,Z   ;is result zero (keys not pressed)?
         goto WAITA2
         call PAUSITA     ; allow for switch bounce
         return

; ************

SETBLOCK2: movlw %00001000   ; snooker
        addwf LEDBLOCK2,F
        movf LEDBLOCK2,W
        xorlw %00011000
        btfsc STATUS,Z
        clrf LEDBLOCK2
        return

SETBLOCK2D: movlw %00001000  ; darts
        addwf LEDBLOCK2,F
        bcf LEDBLOCK2,4
        call WAITSWITCHA
        return

; **************

BALLSLEFT:
        movlw BALLQTYLEFT
        movwf FSR
        movlw BALLSCOUNTMSB
        movwf FSRSTORE
        call LCD28
        movf SWITCHVAL,W
        andlw %00001111
        subwf INDF,F
        call ADDVALUE
        movlw 'R'
        call LCDOUT

        movf BALLQTYLEFT,W
        btfss STATUS,Z      ; is BALLSCOUNT = 0?
        return              ; no
        btfsc PLAYERID,0    ; is it player 1?
        goto BL2            ; no, it's player 2
        call LCD21
        incf TOTALFRAMES1,F
        movf TOTALFRAMES1,W
        iorlw 48
        call LCDOUT
        movf TOTALFRAMES1,W
        call COMANODE
        movwf PLAYER1TOTALFRAMES
        return

BL2:    call LCD215
        incf TOTALFRAMES2,F
        movf TOTALFRAMES2,W
        iorlw 48
        call LCDOUT
        movf TOTALFRAMES2,W
        call COMANODE
        movwf PLAYER2TOTALFRAMES
        return

SUBBALLSLEFT:
        movlw BALLQTYLEFT
        movwf FSR
        movlw BALLSCOUNTMSB
        movwf FSRSTORE
        call LCD28
        movf SWITCHVAL,W
        andlw %00001111
        addwf INDF,F
        call ADDVALUE
        movlw 'R'
        call LCDOUT
        return

; ******** SHOW 7-SEG DIGITS

LEDSONA: movf DIGITNUMBER,W   ; get digit count
        call ITEMNUMBER
        movwf FSR
        movf INDF,W
        clrf PORTD           ; turn off 7-seg anode enable (IC4/5)
        movwf PORTB          ; put segs data out to PORTB

        call DIGSHW          ; get which digit to show it on
        movwf PORTD          ; set PORTD digit select
        incf DIGITNUMBER,F   ; inc digit multiplex count
        bcf DIGITNUMBER,3    ; restrict to 0 to 7
        return

; **********

ZEROFRAME:                   ; snooker 
        call LCD1
        movlw '>'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '0'
        call LCDOUT

        call LCD7
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw 'B'
        call LCDOUT

        call LCD13
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw ' '
        call LCDOUT
        call INCFRAME

        call LCD28 
        movlw '1'
        call LCDOUT
        movlw '4'
        call LCDOUT
        movlw '7'
        call LCDOUT
        movlw 'R'
        call LCDOUT

        movlw 147
        movwf BALLQTYLEFT
        movlw 1
        call COMANODE
        movwf BALLSCOUNTMSB
        movlw 4
        call COMANODE
        movwf BALLSCOUNTNSB
        movlw 7
        call COMANODE
        movwf BALLSCOUNTLSB

        clrf LEDBLOCK2
        return

ZEROLEG:                         ; darts
        movf DARTSTOPMSB,W
        movwf DARTS1FRAMEMSB
        movwf DARTS2FRAMEMSB
        movwf REGA1
        
        movf DARTSTOPLSB,W
        movwf DARTS1FRAMELSB
        movwf DARTS2FRAMELSB
        movwf REGA0
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        movf DIGIT8,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMEMSB
        movwf PLAYER2FRAMEMSB
        movf DIGIT9,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMENSB
        movwf PLAYER2FRAMENSB
        movf DIGIT10,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMELSB
        movwf PLAYER2FRAMELSB

        call LCD2
        call SHOW7
        call LCD12
        call SHOW7

        clrf PREVBREAKMSB
        clrf PREVBREAKNSB
        clrf PREVBREAKLSB

        return

;******** LCD ROUTINES **********

LCD1:   movlw B'10000000'
        goto LCDLIN
LCD2:   movlw B'10000001'
        goto LCDLIN
LCD7:   movlw B'10000110'
        goto LCDLIN
LCD12:  movlw B'10001011'
        goto LCDLIN
LCD13:  movlw B'10001100'
        goto LCDLIN
LCD15:  movlw B'10001111'
        goto LCDLIN
LCD21:  movlw B'11000000'
        goto LCDLIN
LCD24:  movlw B'11000100'
        goto LCDLIN
LCD27:  movlw B'11000111'
        goto LCDLIN

LCD28:  movlw B'11001000'
        goto LCDLIN
LCD215: movlw B'11001111'

LCDLIN: clrf RSLINE         ; sets LCD command/line
        call LCDOUT         ; and outputs command code to LCD
        bsf RSLINE,4        ; set RS flag
        return

LCDOUT: movwf STORE1        ; temp store value that will be output to LCD
        movlw 60            ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT         ; send MSB, then (by default) send LSB
        call SENDIT
        return

SENDIT: swapf STORE1,F      ; swap byte nibbles
        movf STORE1,W       ; get nibble (MSB)
        andlw 15            ; AND to isolate nibble
        iorwf RSLINE,W      ; OR the RS bit
        movwf PORTA         ; output the byte
        nop
        nop
        bsf PORTA,5         ; set E high
        nop
        nop
        bcf PORTA,5         ; set E low
        return

PAUSITA: movlw 5
        movwf SLOWIT  
        clrf INTCON     ; clear interupt flag

PAUSEA:  call LEDSONA
        btfss INTCON,2
        goto PAUSEA
        bcf INTCON,2  
        decfsz SLOWIT,F
        goto PAUSEA
        return

PAUSITFIRST: movlw 5
        movwf SLOWIT  
        clrf INTCON     ; clear interupt flag

PAUSEF:  btfss INTCON,2
        goto PAUSEF
        bcf INTCON,2  
        decfsz SLOWIT,F
        goto PAUSEF
        return

CLRLINE1: call LCD1     ; set address for line 1 cell 1
        clrf LOOP       ;
CLRL1:  movlw ' '       ; clear cell
        call LCDOUT     ;
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto CLRL1      ; no
        return

CLRLINE2: call LCD21
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

SHOW7:  movf DIGIT7,W  
	call LCDOUT	
SHOW8:  movf DIGIT8,W
	call LCDOUT	
SHOW9:  movf DIGIT9,W  
	call LCDOUT	
SHOW10: movf DIGIT10,W  
	call LCDOUT	
	return

; *************

SETUP:  call PAUSITFIRST         ; 1/5 sec delay
        call LCDSET

        clrf PLAYERID
        clrf BREAKMSB
        clrf BREAKNSB
        clrf BREAKLSB
        clrf SCOREMSB
        clrf SCORENSB
        clrf SCORELSB

        clrf PLAYER1FRAMEMSB
        clrf PLAYER1FRAMENSB
        clrf PLAYER2FRAMEMSB
        clrf PLAYER2FRAMENSB

        movlw 0
        call COMANODE
        movwf PLAYER1FRAMELSB
        movwf PLAYER2FRAMELSB
        movwf PLAYER1TOTALFRAMES
        movwf PLAYER2TOTALFRAMES
        clrf TOTALFRAMES1
        clrf TOTALFRAMES2

        clrf FOUL
        movlw 1
        call COMANODE
        movwf FRAMESCOUNTLSB
        clrf FRAMESCOUNTMSB
        clrf COUNTFRAMESLSB
        clrf COUNTFRAMESMSB

        movlw 147
        movwf BALLQTYLEFT
        movlw 1
        call COMANODE
        movwf BALLSCOUNTMSB
        movlw 4
        call COMANODE
        movwf BALLSCOUNTNSB
        movlw 7
        call COMANODE
        movwf BALLSCOUNTLSB

        clrf DIGITNUMBER
        clrf PREVBREAKMSB
        clrf PREVBREAKNSB
        clrf PREVBREAKLSB
        movlw B'00001000'       ; 10 (shows G seg only)
        movwf NULLVALUE
        clrf LEDBLOCK2
        clrf DARTSDOUBLE

        clrf DARTS1FRAMELSB
        clrf DARTS1FRAMEMSB
        clrf DARTS2FRAMELSB
        clrf DARTS2FRAMEMSB

        call CLRLINE1
        call CLRLINE2

        return

; ********** START OF DARTS *********

DARTSCORING:
        call LEDSONA
        movlw 20
        call PRMGET
        movwf DARTSTOPMSB
        movlw 21
        call PRMGET
        movwf DARTSTOPLSB

        call ZEROLEG
        movlw B'00001000'       ; (shows G seg only)
        movwf PLAYER2FRAMEMSB
        movwf PLAYER2FRAMENSB
        movwf PLAYER2FRAMELSB
        movwf FRAMESCOUNTMSB
        movwf FRAMESCOUNTLSB 
        movwf BREAKMSB
        movwf BREAKNSB
        movwf BREAKLSB

        call WAITSWITCHA

        call LEDSONA

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWMS1: movf LOOP,W
        call DARTSHUNDREDS
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        call LEDSONA

DARTSSCORE2: call GETKEY
        call WAITSWITCHA
        call LEDSONA
        movf SWITCHVAL,W
        btfsc STATUS,Z       ; is it zero?
        goto DARTSSCORE2     ; yes
        andlw %00001111
        movwf SWITCHVAL

        xorlw 15             ; is 'D' pressed (Enter)?
        btfsc STATUS,Z
        goto DSCORE3         ; yes

        movf SWITCHVAL,W     ; is val >9
        addlw 6
        btfsc STATUS,DC
        goto DARTSSCORE2     ; yes

        call LEDSONA

        bcf STATUS,C
        rlf SWITCHVAL,W

        call PRMGET
        movwf DARTSTOPMSB
        movwf REGA1
        bcf STATUS,C
        rlf SWITCHVAL,W
        addlw 1
        call PRMGET
        movwf DARTSTOPLSB
        movwf REGA0
        clrf REGA2
        clrf REGA3

        call LEDSONA

        call BIN2DEC
        movf DIGIT8,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMEMSB
        movf DIGIT9,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMENSB
        movf DIGIT10,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMELSB

        call LEDSONA

        call LCD2
        call SHOW7
        call LCD12
        call SHOW7

        call LEDSONA

        goto DARTSSCORE2

DSCORE3: call LEDSONA        
        call WAITSWITCHA

        call CLRLINE2
        bsf PLAYERID,0
        call ZEROLEG
        call CHANGEPLAYERDARTS
        call LCD21
        movlw '0'
        call LCDOUT
        call LCD215
        movlw '0'
        call LCDOUT

        clrf DARTSCOUNT
        clrf FRAMESCOUNTMSB
        call LEDSONA

        call LCD7
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '?'
        call LCDOUT

        call LEDSONA

        movf DARTSTOPMSB,W   ; store new values for future recall
        movwf PROMVAL
        movlw 20
        call SETPRM
        movf DARTSTOPLSB,W
        movwf PROMVAL
        movlw 21
        call SETPRM

        call LEDSONA

        call LCD27
        movlw '#'
        call LCDOUT
        movlw '1'
        call LCDOUT
        movlw 1
        call COMANODE
        movwf FRAMESCOUNTLSB
        movlw 0
        call COMANODE
        movwf PLAYER1TOTALFRAMES
        movwf PLAYER2TOTALFRAMES

; *********** main darts routine **********

DARTS:  call LEDSONA
        call GETKEY
        movf SWITCHVAL,W
        btfsc STATUS,Z       ; is it zero?
        goto DARTS           ; yes

        andlw %00001111
        movwf SWITCHVAL
        call ROUTEDARTS
        goto DARTS

; *************

ADDDARTS:
        movf SCORENSB,W
        movwf SCOREMSB
        movf SCORELSB,W
        movwf SCORENSB
        movf SWITCHVAL,W
        movwf SCORELSB        

        call LCD7
        movf SCOREMSB,W
        iorlw 48
        call LCDOUT
        movf SCORENSB,W
        iorlw 48
        call LCDOUT
        movf SCORELSB,W
        iorlw 48
        call LCDOUT
        
        movf SCOREMSB,W      ; blank leading zeros
        movwf BREAKMSB
        btfss STATUS,Z
        call COMANODE
        movwf BREAKMSB

        movf SCORENSB,W
        btfss STATUS,Z
        call COMANODE
        movwf BREAKNSB

        movf SCORELSB,W
        btfss STATUS,Z
        call COMANODE
        movwf BREAKLSB

ADDEND: call WAITSWITCHA
        return

; ***********

SUBNEWVAL:
        movf SCOREMSB,W
        andlw %00001111
        movwf PREVBREAKMSB
        movf SCORENSB,W
        andlw %00001111
        movwf PREVBREAKNSB
        movf SCORELSB,W
        andlw %00001111
        movwf PREVBREAKLSB
        call SUBDARTS

        clrf BREAKMSB
        clrf BREAKNSB
        clrf BREAKLSB
        clrf SCOREMSB
        clrf SCORENSB
        clrf SCORELSB

        call LCD7
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '?'
        call LCDOUT
        call WAITSWITCHA
        return

DCHECKA: bsf DARTSDOUBLE,0
DCHECKDOT: movf PREVBREAKMSB,W  ; yes
        movwf SCOREMSB
        movf PREVBREAKNSB,W
        movwf SCORENSB
        movf PREVBREAKLSB,W
        movwf SCORELSB
        goto SUBNEWVAL

CHECKLEG: incf COUNTFRAMESLSB,F
        movf COUNTFRAMESLSB,W
        addlw 6
        btfss STATUS,DC
        goto INCD2              ; no
        andlw 15
        movwf COUNTFRAMESLSB
        incf  COUNTFRAMESMSB,F

INCD2:
        movf COUNTFRAMESMSB,W
        btfss STATUS,Z
        call COMANODE
        movwf FRAMESCOUNTMSB
        movf COUNTFRAMESLSB,W
        call COMANODE
        movwf FRAMESCOUNTLSB

        call LCD27
        movlw '#'
        call LCDOUT
        movf COUNTFRAMESMSB,W
        btfsc STATUS,Z
        goto INCD3
        iorlw 48
        call LCDOUT
INCD3:  movf COUNTFRAMESLSB,W
        iorlw 48
        call LCDOUT
        call ZEROLEG      ; 10 [BLANK]
        call CHANGEPLAYERDARTS
        call WAITSWITCHA
        return

SUBDARTS:
        movf SCORELSB,W      ; yes, put units into total
        movwf COLOURNO
        movf SCORENSB,W
        call TENS
        addwf COLOURNO,F     ; add in tens
        movf SCOREMSB,W
        btfsc STATUS,Z
        goto SUBD2
        movlw 100            ; prime W with 100
        addwf COLOURNO,F     ; yes, so add 100 (vals above 100 ignored)

SUBD2:  movf COLOURNO,W
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3

        btfsc PLAYERID,0      ; is it player 1?
        goto SUBDARTS2        ; no, it's player 2

        movf DARTS1FRAMELSB,W
        movwf REGA0
        movf DARTS1FRAMEMSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        btfsc DARTSDOUBLE,0
        goto SUBD4

        call SUBTRACT
        goto SUBD3

SUBD4:  call ADD
        bcf DARTSDOUBLE,0

SUBD3:  movf REGA0,W
        movwf DARTS1FRAMELSB
        movf REGA1,W
        movwf DARTS1FRAMEMSB
        call BIN2DEC

        movf DIGIT8,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMEMSB
        movf DIGIT9,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMENSB
        movf DIGIT10,W
        andlw %00001111
        call COMANODE
        movwf PLAYER1FRAMELSB

        call LCD2
        call SHOW7
        movf DARTS1FRAMEMSB,W
        iorwf DARTS1FRAMELSB,W

        btfss STATUS,Z
        return

        call LCD21
        incf TOTALFRAMES1,F
        movf TOTALFRAMES1,W
        call COMANODE
        movwf PLAYER1TOTALFRAMES
        movf TOTALFRAMES1,W
        iorlw 48
        call LCDOUT
        return

SUBDARTS2:
        movf DARTS2FRAMELSB,W
        movwf REGA0
        movf DARTS2FRAMEMSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        btfsc DARTSDOUBLE,0
        goto SUBD24
        call SUBTRACT
        goto SUBD23

SUBD24:  call ADD
        bcf DARTSDOUBLE,0

SUBD23: movf REGA0,W
        movwf DARTS2FRAMELSB
        movf REGA1,W
        movwf DARTS2FRAMEMSB
        call BIN2DEC

        movf DIGIT8,W
        andlw %00001111
        call COMANODE
        movwf PLAYER2FRAMEMSB
        movf DIGIT9,W
        andlw %00001111
        call COMANODE
        movwf PLAYER2FRAMENSB
        movf DIGIT10,W
        andlw %00001111
        call COMANODE
        movwf PLAYER2FRAMELSB

        call LCD12
        call SHOW7
        movf DARTS2FRAMEMSB,W
        iorwf DARTS2FRAMELSB,W
        btfss STATUS,Z
        return

        call LCD215
        incf TOTALFRAMES2,F
        movf TOTALFRAMES2,W
        call COMANODE
        movwf PLAYER2TOTALFRAMES
        movf TOTALFRAMES2,W
        iorlw 48
        call LCDOUT
        return

;..........GET KEYPAD VAL ROUTINE........

GETKEY:  clrf SWITCHVAL
         movlw %11110000  ; RC7 to RC4 high
         movwf PORTC
         nop              ;pause to allow PORTC to stabilise
         movf PORTC,W     ;get PORTC
         andlw 15         ;isolate bits 0-3
         btfsc STATUS,Z   ;is result NOT zero (keys pressed)?
         return           ;no, so return to main prog

         movlw %00010000  ;yes, a key is pressed so get it, trying bit 4 high first
         movwf PORTC      ;initial val for RC7-RC4
         movlw %00010000 
         movwf KEYSTORE
         clrf ROW

GK2:     movf PORTC,W     ;get PORTC
         andlw 15         ;isolate bits 0-3
         btfss STATUS,Z   ;is result zero (keys not pressed)?
         goto GK3         ;no
         movlw MATRIX
         addwf ROW,F
         rlf KEYSTORE,F    ;rotate RC7-RC4 left
         movf KEYSTORE,W
         andlw %11110000
         movwf PORTC
         btfss STATUS,C   ;is Carry set?
         goto GK2         ;no, so repeat
         return           ;yes, so return to main prog

GK3:     movwf STORE
         clrf COL         ;clear row number count

GK4:     bcf STATUS,C
         rrf STORE,F      ;rotate right PORTC store val
         btfsc STATUS,C   ;is carry flag set?
         goto SUMIT       ;yes so key pressed, go & finish answer
         incf COL,F
         goto GK4

SUMIT:   movf ROW,W       ;sum up results to single answer
         addwf COL,W      ;add ROW to COL (total of 0-15)
         call CONVERTKEY
         movwf SWITCHVAL
         return           ;return to main program

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

NEGATEA: movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return


;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide, mod

chksgnb	rlf	REGB3,w
	skpc
	return			;Positive

;Negate REGB
;Used by chksgnb, subtract, multiply, divide, mod

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return


;Add REGB to REGA (Unsigned)
;Used by add, multiply,

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incfsz	REGB3,w
	addwf	REGA3,f
	return

;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA   ;Return carry set if overflow

subtract:
        call    negateb         ;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32: movf  REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

; *************

CHANGEPLAYERDARTS:
        incf PLAYERID,F      ; yes, so clear break counter

        clrf BREAKMSB
        clrf BREAKNSB
        clrf BREAKLSB
        clrf SCOREMSB
        clrf SCORENSB
        clrf SCORELSB
        clrf PREVBREAKMSB
        clrf PREVBREAKNSB
        clrf PREVBREAKLSB
        clrf DARTSCOUNT

        call LCD7
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw '?'
        call LCDOUT
        movlw ' '
        call LCDOUT

        btfss PLAYERID,0
        goto CP2D
        call LCD1
        movlw ' '
        call LCDOUT
        call LCD15
        movlw '<'
        call LCDOUT
        goto CP3D

CP2D:   call LCD1
        movlw '>'
        call LCDOUT
        call LCD15
        movlw ' '
        call LCDOUT

CP3D:   call WAITSWITCHA
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

TENS:   addlw 22        ; for quick multiplying switch val by 10
        call PRMGET
        return

DIGSHW: movf DIGITNUMBER,W ; get digit count
        addlw 32
        call PRMGET
        return

CONVERTKEY: addlw 40    ; convert keypad val to key ID
        call PRMGET
        return

        ORG $2100

        DE $03,$E9     ;0  1001  ; darts starting values
        DE $00,$65     ;2  101
        DE $00,$C9     ;4  201
        DE $01,$2D     ;6  301
        DE $01,$91     ;8  401
        DE $01,$F5     ;10 501
        DE $02,$59     ;12 601
        DE $02,$BD     ;14 701
        DE $03,$21     ;16 801
        DE $03,$85     ;18 901
        DE $01,$F5     ;20 501   ; default darts top value on 1st loading

; ** the following were in tables in an earlier version but moved to EEPROM 
; for convenience without using PCLATH

        DE 0,10        ;22       ; for quick multiplying switch val by 10
        DE 20,30       ;24
        DE 40,50       ;26
        DE 60,70       ;28
        DE 80,90       ;30
        DE 1,2         ;32       ; get digit count
        DE 4,8         ;34
        DE 16,32       ;36
        DE 64,128      ;38

        DE 1           ;40       ; convert keypad val to key ID
        DE 2
        DE 3
        DE 12  ; 'A'
        DE 4
        DE 5
        DE 6
        DE 13  ; 'B'
        DE 7
        DE 8
        DE 9
        DE 14  ; 'C'
        DE 10  ; [BLANK]
        DE 16 
        DE 11  ; '.'
        DE 15  ; 'D'

        DE 0,0
        DE 0,0

	END
