
;Cycling Colour Controller V2 rev3 February 2004
;
;Port Assignments
;----------------
;Port A,0	OUTPUT	Red
;Port A,1	OUTPUT	Green
;Port A,2	OUTPUT	Blue
;Port A,3	OUTPUT	
;Port A,4	OUTPUT	
;Port B,0	INPUT	Fade/Overlap	-	set high for fade
;Port B,1	INPUT	Run/Freeze	-	set high for freeze
;Port B,2	INPUT	Red High Start	-	set high for high brightness on reset & static colour
;Port B,3	INPUT	Blue High Start	-	set high for high brightness on reset & static colour
;Port B,4	INPUT	Green High Start-	set high for high brightness on reset & static colour
;Port B,5	INPUT	Speed LSB	-	Speed variable introduces delays, set 000 for fastest, 111 for slowest
;Port B,6	INPUT	Speed
;Port B,7	INPUT	Speed MSB



W:	.EQU $00	;working register
OPTION: .EQU $01        ;
STATUS: .EQU $03        ;
PORTA:  .EQU $05        ;
PORTB:  .EQU $06        ;
INTCON: .EQU $0B        ;
red:	.EQU $10	;brightness levels
blue:	.EQU $11	;
green:	.EQU $12	;
rdir:	.EQU $13	;counting directions
bdir:	.EQU $14	;
gdir:	.EQU $15	;
rcopy:	.EQU $1A	;used as destructable copy of brightness levels in display routine
gcopy:	.EQU $1B	;
bcopy:	.EQU $1C	;
timer:	.EQU $1D	;used for countdown timer in PWM output routine DIS
fctrl:	.EQU $1E	;fade mode colour selector
spdcopy:.EQU $1F	;destructable copy of the speed variable
lcount:	.EQU $20	;loop counter
   	
	.org 4
	.org 5

	clrf PORTA      ;
	clrf PORTB	;
	BSF STATUS,5	;Page 1 memory addressing
	CLRF PORTB	;set PORT B as all output
	COMF PORTB,1	;complement it so they are all input
	CLRF PORTA	;set PORT A as all output
	BCF STATUS,5	;Page 0 memory addressing

cc:	movlw %00000001
	movwf red	;initial colour values all zero
	movwf blue
	movwf green

	movlw %11111111	;						**ALLOWS FITTING TO BE SET AS STATIC COLOUR ANY MIX OF THREE ON OR OFF**
	btfsc PORTB,2	;is red set to be high?
	movwf red	;if so, set high
	btfsc PORTB,3	;is blue set to be high?
	movwf blue	;if so, set high
	btfsc PORTB,4	;is green set to be high?
	movwf green	;if so, set high
	CALL DIS	;call DIS display routine
	btfsc PORTB,2	;next six lines loop back to cc if any of the colour switches are high
	goto cc
	btfsc PORTB,3
	goto cc
	btfsc PORTB,4
	goto cc		;if none have caused a loop back through cc then program continues

esccc:	clrf rdir	;
	clrf bdir	;
	clrf gdir	;
	clrf PORTB	;
	clrf PORTA	;
	clrf lcount	;clear loop counter

	movlw %00001001	;overlap mode
	movwf fctrl	;set fade control for overlap by default

	movlw %01000000	;set some initial mix values on the assumption that program will run in overlap mode
	movwf blue
	movlw %10000000
	movwf green
	movlw %00100000
	movwf red

	btfsc PORTB,0	;check mode - if high (overlap) go to start	**MODE CONTROL**
	goto start	;
	movlw %00000001	;and if not in overlap mode...
	movwf red	;clear all colours
	movwf green	;
	movwf blue	;
	movlw %00000001	;set overlap mode - this value sets for fade - (i.e.) only one colour visible at a time
	movwf fctrl	;set fade control

start:	movf PORTB,0	;capture port B					**SPEED CONTROL**
	andlw %11100000	;mask it for speed values only
	swapf w,1	;swap nibbles
	addlw %00000001	;add 1
	movwf spdcopy	;and into destructable copy
dislp:	CALL DIS	;call display routine
	bcf status,2	;clear status bit
	decf spdcopy,1	;decrement
	btfsc status,2	;
	goto stat	;continue if spdcopy has looped enough
	goto dislp	;or keep looping until it has

stat:	btfss PORTB,1	;if high this should stop the cycling action	**RUN/FREEZE CONTROL**
	goto brst	;escape to run routines if clear
	CALL DIS	;run display routine
	goto stat	;loop again

brst:	btfsc fctrl,0	;check red colour permission			**MODE IMPLEMENTATION**
	goto rloop	;and if so start red brightness control
	btfsc fctrl,1	;ditto
	goto rloop	;
	goto r_end

rloop:	bcf status,2	;clear status bit				**THREE IDENTICAL BRIGHTNESS ROUTINES**
	btfss rdir,0	;check to see if LSB of rdir is set, and skip to decrementing if it is
	incf red,1	;increment brightness level
	btfsc rdir,0	;check to see if LSB of rdir is unset, and skip decrementing if it is
	decf red,1	;decrement brightness level
	btfss status,2	;check to see if brightness level adjustment has caused an overflow or borrow
	goto r_end	;and if it hasn't, end this routine
	incf rdir,1	;if it has, increment rdir which will effectively complement rdir bit 0
	goto rloop	;then loop through again
r_end:	nop

	btfsc fctrl,2	;check green colour permission			**MODE IMPLEMENTATION**
	goto gloop	;and if so start green brightness control
	btfsc fctrl,3	;ditto
	goto gloop	;
	goto g_end

gloop:	bcf status,2	;same thing for green
	btfss gdir,0	;
	incf green,1	;
	btfsc gdir,0	;
	decf green,1	;
	btfss status,2	;
	goto g_end	;
	incf gdir,1	;
	goto gloop	;
g_end:	nop

	btfsc fctrl,4	;check blue colour permission			**MODE IMPLEMENTATION**
	goto bloop	;and if so start blue brightness control
	btfsc fctrl,5	;ditto
	goto bloop	;
	goto b_end	;

bloop:	bcf status,2	;and again for blue
	btfss bdir,0	;
	incf blue,1	;
	btfsc bdir,0	;
	decf blue,1	;
	btfss status,2	;
	goto b_end	;
	incf bdir,1	;
	goto bloop	;
b_end:	nop

	bcf status,2	;clear status bit				**FADER CONTROL**
	incf lcount,1	;increment loop counter
	btfss status,2	;check to see if 256 loops, if not---
	goto start	;---loop around again, but if so, move fade counter fctrl	
	rlf fctrl,1	;rotate once left
	incf lcount,1	;increment loop counter once extra		**MODE IMPLEMENTATION**
rotate:	clrf timer	;this variable is "spare" because only used in DIS routine, therefore can be used to control this loop	*WRAP AROUND
	bcf status,0	;clear carry bit											*CONTROL	
	btfsc fctrl,6	;													*
	bsf timer,1	;													*
	btfsc fctrl,7	;													*				
	bsf timer,1	;													*
	btfss timer,1	;if either bits 6 or 7 are high, this test will prevent looping back to start				*
	goto start	;....and causes a wrap around routine									*
	rlf fctrl,1	;													*
	btfsc status,0	;check to see if carry bit has become 1 as a result of the rlf						*
	bsf fctrl,0	;and set bit 0 of fctrl if it has, so acheiving wrap around						*
	goto rotate	;go round again
	
			;						**RUNS PWM OUTPUTS FROM BRIGHTNESS LEVELS**

DIS:	movf red,0	;move copy of brightness level to working register
	movwf rcopy	;and to destructable copy
	movf green,0	;move copy of brightness level to working register
	movwf gcopy	;and to destructable copy
	movf blue,0	;move copy of brightness level to working register
	movwf bcopy	;and to destructable copy
	clrf timer	;clear timer
	bcf status,2	;clear carry bit of status register
	bsf PORTA,0	;turn on red
	bsf PORTA,1	;turn on green
	bsf PORTA,2	;turn on blue
TL	incf timer,1	;increment timer variable
	btfsc status,2	;
	RETURN		;end the DIS routine if timing period/cycles over		
	bcf status,2	;clear carry/borrow bit
	decf rcopy,1	;decrement destructable brightness copy
	btfsc status,2	;check to see if this causes a "borrow"
	bcf PORTA,0	;and if so turn off the red output
	bcf status,2	;clear carry/borrow bit
	decf gcopy,1	;decrement destructable brightness copy
	btfsc status,2	;check to see if this causes a "borrow"
	bcf PORTA,1	;and if so turn off the green output
	bcf status,2	;clear carry/borrow bit
	decf bcopy,1	;decrement destructable brightness copy
	btfsc status,2	;check to see if this causes a "borrow"
	bcf PORTA,2	;and if so turn off the blue output
	goto TL
	RETURN

.END