            list        P=16C55,R=DEC

;****************************************************************************
;                                REACTION.ASM
;                PIC16C55 Software for Reaction Timer Project
;****************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Version : 1
;   Date    : 25-01-98

;   Description

;      Software source code for Reaction Timer project.


; ***************************************************************************


;   Hardware Interface Description  -  PIC16C55XT

;   Port   Circuit      Software     Port     Funtional Description
;   Name   Reference    Reference   Config

;   RA0    IC1 Pin  6     _ra0        O       /Enable - Digit0
;   RA1    IC1 Pin  7     _ra1        O       /Enable - Digit1
;   RA2    IC1 Pin  8     _ra2        O       /Enable - Digit2
;   RA3    IC1 Pin  9     _ra3        O       /Enable - Digit3

;   RB0    IC1 Pin 10     _rb0        O       /Enable - Seg a
;   RB1    IC1 Pin 11     _rb1        O       /Enable - Seg b
;   RB2    IC1 Pin 12     _rb2        O       /Enable - Seg c
;   RB3    IC1 Pin 13     _rb3        O       /Enable - Seg d
;   RB4    IC1 Pin 14     _rb4        O       /Enable - Seg e
;   RB5    IC1 Pin 15     _rb5        O       /Enable - Seg f
;   RB6    IC1 Pin 16     _rb6        O       /Enable - Seg g
;   RB7    IC1 Pin 17     _rb7        O       /Enable - Seg dp

;   RC0    IC1 Pin 18     _rc0        I       /SW2
;   RC1    IC1 Pin 19     _rc1        O       Enable - Green LED
;   RC2    IC1 Pin 20     _rc2        O       Enable - Red LED
;   RC3    IC1 Pin 21     _rc3        O       Spare
;   RC4    IC1 Pin 22     _rc4        O       Spare
;   RC5    IC1 Pin 23     _rc5        O       Spare
;   RC6    IC1 Pin 24     _rc6        O       Spare
;   RC7    IC1 Pin 25     _rc7        O       Spare


;   Port Config
;   I - Input, O - Output


; ***************************************************************************


; Seven Segment Display Character Definitions

;    Display Segments : xgfedcbaB
			
ch_0        equ         11000000B       ;           a
ch_1        equ         11111001B       ;          ---
ch_2        equ         10100100B       ;       f | g | b
ch_3        equ         10110000B       ;          ---
ch_4        equ         10011001B       ;       e |   | c
ch_5        equ         10010010B       ;          ---
ch_6        equ         10000010B       ;           d
ch_7        equ         11111000B       ;
ch_8        equ         10000000B       ;       x - Not Used
ch_9        equ         10010000B

blank       equ         11111111B

ch_H        equ         10001001B
ch_E        equ         10000110B
ch_L        equ         11000111B
ch_P        equ         10001100B


;****************************************************************************


;   Define Variables

            INCLUDE     "pic16c5x.h"    ; Define symbols

ACCaHI      equ         0x1F            ; Arithmetic store (accumulator a Hi-byte)
ACCaLO      equ         0x1E            ; Arithmetic store (accumulator a Lo-byte)
ACCbHI      equ         0x1D            ; Arithmetic store (accumulator b Hi-byte)
ACCbLO      equ         0x1C            ; Arithmetic store (accumulator b Lo-byte)

BCD3        equ         0x1B            ; Reaction time (most significant BCD digit)
BCD2        equ         0x1A            ; Reaction time
BCD1        equ         0x19            ; Reaction time
BCD0        equ         0x18            ; Reaction time (least significant BCD digit)

DIGIT3      equ         0x17            ; Display buffer (most significant digit)
DIGIT2      equ         0x16            ; Display buffer
DIGIT1      equ         0x15            ; Display buffer
DIGIT0      equ         0x14            ; Display buffer (least significant digit)

RTCC0       equ         0x13            ; Timer register 0
RTCC1       equ         0x12            ; Timer register 1

SHIFT_REG   equ         0x11            ; PRN shift register
SHIFT_CNTR  equ         0x10            ; PRN shift counter
PARITY_REG  equ         0x0F            ; PRN parity register
PARITY_CNTR equ         0x0E            ; PRN Parity counter
RND_NUM     equ         0x0D            ; Pseudo random number

STATE       equ         0x0C            ; State register

DLY_TMR     equ         0x0B            ; Delay timer

TMR_100MS   equ         0x0A            ; 100mS timer
TMR_SLEEP   equ         0x09            ; Go to sleep timer


; **************************************************************************


            ORG         0x01FF          ; Reset Vector Address PIC16C55
            NOP                         ;

            ORG         0x000           ; Start of program memory
            GOTO        Init            ;


; **************************************************************************


D_Sub                                   ; ACCb = ACCb - ACCa (16 bit)

            COMF        ACCaLO,f        ; ACCa = - ACCa (2's compliment)
            INCF        ACCaLO,f
            BTFSC       _z
            DECF        ACCaHI,f
            COMF        ACCaHI,f

D_Add                                   ; ACCb = ACCb + ACCa (16 bit)

            MOVF        ACCaLO,w
            ADDWF       ACCbLO,f
            BTFSC       _c
            INCF        ACCbHI,f
            MOVF        ACCaHI,w
            ADDWF       ACCbHI,f

            RETLW       0               ; Return from subroutine


; **************************************************************************


D_Mulx2                                 ; ACCb = ACCb x 2

            BCF         _c              ; Clear carry flag
            RLF         ACCbLO,f        ; Rotate left LSByte
            RLF         ACCbHI,f        ; Rotate left MSByte

            RETLW       0               ; Return from subroutine


; **************************************************************************


BCD_7Seg                                ; BCD to 7 Segment conversion

            ANDLW       0x0F            ; BCD < 16
            ADDWF       pc,f            ; Add BCD to program counter

            RETLW       ch_0            ; Return from subroutine with data for character '0'
            RETLW       ch_1            ; Return from subroutine with data for character '1'
            RETLW       ch_2            ; Return from subroutine with data for character '2'
            RETLW       ch_3            ; Return from subroutine with data for character '3'
            RETLW       ch_4            ; Return from subroutine with data for character '4'
            RETLW       ch_5            ; Return from subroutine with data for character '5'
            RETLW       ch_6            ; Return from subroutine with data for character '6'
            RETLW       ch_7            ; Return from subroutine with data for character '7'
            RETLW       ch_8            ; Return from subroutine with data for character '8'
            RETLW       ch_9            ; Return from subroutine with data for character '9'
            RETLW       blank           ; Return from subroutine with data for character ' '
            RETLW       blank           ; Return from subroutine with data for character ' '
            RETLW       blank           ; Return from subroutine with data for character ' '
            RETLW       blank           ; Return from subroutine with data for character ' '
            RETLW       blank           ; Return from subroutine with data for character ' '
            RETLW       blank           ; Return from subroutine with data for character ' '


; **************************************************************************


Random                                  ; Generate Random Number

            MOVLW       7               ;
            MOVWF       SHIFT_CNTR      ; SHIFT_CNTR = 7

Rnd_Rpt2    MOVLW       01001000B       ;
            MOVWF       PARITY_REG      ; PARITY_REG = Feedback mask
            CLRF        PARITY_CNTR     ; PARITY_CNTR = 0
            MOVF        SHIFT_REG,w     ;
            ANDWF       PARITY_REG,f    ; Determine feedback

Rnd_Rpt1    MOVF        PARITY_REG,f    ;
            BTFSC       _z              ; Test parity register
            GOTO        Rnd_Exit1       ; If zero then goto Rnd_Exit1 else continue
            BCF         _c              ;
            RRF         PARITY_REG,f    ; Shift next bit to be tested into carry
            BTFSC       _c              ; Test carry
            INCF        PARITY_CNTR,f   ; If carry is set then increment parity counter
            GOTO        Rnd_Rpt1        ; If not zero then goto Rnd_Rpt1 else continue

Rnd_Exit1   BCF         _c                ;
            BTFSC       PARITY_CNTR,bit0  ; Test parity of resulting feedback
            BSF         _c                ; If even the _c = 0 else _c = 1
            RLF         SHIFT_REG,f     ; Shift parity result into LSB of SHIFT_REG
            DECFSZ      SHIFT_CNTR,f    ; Decrement contents of SHIFT_CNTR and test if zero
            GOTO        Rnd_Rpt2        ; If not zero then goto Rnd_Rpt2 else continue

            MOVF        SHIFT_REG,w     ; Load w with contents of SHIFT_REG
            ANDLW       01111111B       ; Mask least significant 7 bits
            MOVWF       RND_NUM         ; Load RND_NUM with result

            RETLW       0               ; Return from subroutine


; **************************************************************************
; **************************************************************************


Init                                    ; MCLR initialisation routine

            MOVLW       000100B
            OPTION                      ; Configure option register
;                          |||----        Prescaler for rtcc = 1/32
;                         |-------        Prescaler assigned to rtcc
;                        |--------        rtcc signal edge = +ve
;                       |---------        rtcc signal source = Internal

            CLRF        rtcc            ; Initialise rtcc

            MOVLW       11111111B       ;
            MOVWF       porta           ; Initialise port A output register
            MOVLW       11110000B       ;
            TRIS        porta           ; Define port A data direction

            MOVLW       11111111B       ;
            MOVWF       portb           ; Initialise port B output register
            MOVLW       00000000B       ;
            TRIS        portb           ; Define port B data direction

            MOVLW       00000100B       ;
            MOVWF       portc           ; Initialise port C output register
            MOVLW       00000001B       ;
            TRIS        portc           ; Define port C data direction

;           **************** Initialise variables ****************

            MOVLW       blank           ;
            MOVWF       DIGIT3          ; Load data for blank into digit 3
            MOVWF       DIGIT2          ; Load data for blank into digit 2
            MOVLW       ch_0            ;
            MOVWF       DIGIT1          ; Load data for character '0' into digit 1
            MOVWF       DIGIT0          ; Load data for character '0' into digit 0
            BCF         DIGIT1,bit7     ; Illuminate digit 1 decimal point

            MOVF        SHIFT_REG,f     ;
            BTFSC       _z              ; Test SHIFT_REG
            INCF        SHIFT_REG,f     ; If zero then initialise (SHIFT_REG = 1)

            MOVLW       50              ;
            MOVWF       TMR_100MS       ; Initialise TMR_100MS = 50
            MOVLW       250             ;
            MOVWF       TMR_SLEEP       ; Initialise TMR_SLEEP = 250 (25 Seconds)

;           ******************************************************


                                        ; End of 'Init' routine


; **************************************************************************


Main                                    ; Start of main program loop

rtcc5_lo    BTFSS       rtcc,bit5       ; Test rtcc bit 5
            GOTO        rtcc5_lo        ; If lo then goto rtcc5_lo else continue

rtcc5_hi    BTFSC       rtcc,bit5       ; Test rtcc bit 5
            GOTO        rtcc5_hi        ; If hi then goto rtcc5_hi else continue

            DECF        TMR_100MS,f     ; Decrement TMR_100MS
            BTFSC       _z              ; Test TMR_100MS
            DECF        TMR_SLEEP,f     ; If zero then decrement TMR_SLEEP else continue
            BTFSC       _z              ; Test TMR_SLEEP
            GOTO        Shut_Down       ; If zero then goto Shut_Down else contine

            MOVLW       50              ;
            MOVF        TMR_100MS,f     ;
            BTFSC       _z              ; Test TMR100MS
            MOVWF       TMR_100MS       ; If zero then load TMR_100MS with 50 else continue

            MOVF        STATE,w         ;
            ANDLW       0x03            ; Ensure STATE is less than 4
            ADDWF       pc,f            ; Perform jump

            GOTO        Digit0          ; STATE = 0
            GOTO        Digit1          ; STATE = 1
            GOTO        Digit2          ; STATE = 2
            GOTO        Digit3          ; STATE = 3

;           ******************************************************

Shut_Down   MOVLW       0xFF            ;
            MOVWF       porta           ;
            MOVWF       portb           ; Extinguish display
            CLRF        portc           ; Extinguish red/green LED
            SLEEP                       ; Goto sleep (stop oscillator)

;           ******************************************************

Digit0      BSF         _ra3            ; Extinguish digit 3
            MOVF        DIGIT0,w
            MOVWF       portb
            BCF         _ra0            ; Illuminate digit 0
            INCF        STATE,f         ; State = 1
            GOTO        Main_End        ;

;           ******************************************************

Digit1      BSF         _ra0            ; Extinguish digit 0
            MOVF        DIGIT1,w
            MOVWF       portb
            BCF         _ra1            ; Illuminate digit 1
            INCF        STATE,f         ; State = 2
            GOTO        Main_End        ;

;           ******************************************************

Digit2      BSF         _ra1            ; Extinguish digit 1
            MOVF        DIGIT2,w
            MOVWF       portb
            BCF         _ra2            ; Illuminate digit 2
            INCF        STATE,f         ; State = 3
            GOTO        Main_End        ;

;           ******************************************************

Digit3      BSF         _ra2            ; Extinguish digit 2
            MOVF        DIGIT3,w
            MOVWF       portb
            BCF         _ra3            ; Illuminate digit 3
            CLRF        STATE           ; State = 0

            BTFSS       _rc0            ; Test SW2 status
            GOTO        SW2_Pressed     ; If pressed then goto SW2_Pressed else continue

            MOVF        DLY_TMR,f       ;
            BTFSS       _z              ; Test DLY_TMR
            DECF        DLY_TMR,f       ; If non zero then subract 1
            GOTO        Main_End        ;

SW2_Pressed MOVF        DLY_TMR,f       ;
            BTFSC       _z              ; Test DLY_TMR
            GOTO        Rnd_Num         ; If zero then goto Rnd_Num else continue

            MOVLW       10              ;
            MOVWF       DLY_TMR         ; DLY_TMR = 10
            GOTO        Main_End        ;

;           ******************************************************

Rnd_Num     CALL        Random          ; Calculate random number between 1 and 127
            MOVLW       15
            ADDWF       RND_NUM,f       ; 16 <= RND_NUM <= 142

;           ******************************************************

Rnd_Dly     BSF         _ra3            ; Extinguish digit 3
            BCF         _rc2            ; Extinguish red LED
            BSF         _rc1            ; Illuminate green LED
            
Re_Start    MOVF        RND_NUM,w       ;
            MOVWF       DLY_TMR         ; DLY_TMR = RND_NUM

Wait        CLRF        rtcc            ; rtcc = 0

Wait1       MOVLW       8               ;
            MOVWF       RTCC1           ; RTCC1 = 8

Wait2       BTFSS       rtcc,bit7       ; Test rtcc bit 7
            GOTO        Wait2           ; If lo then goto Wait2 else continue

Wait3       BTFSC       rtcc,bit7       ; Test rtcc bit 7
            GOTO        Wait3           ; If hi then goto Wait3 else continue

            BTFSS       _rc0            ; Test for cheat (SW2 is pressed)
            GOTO        Re_Start        ; If cheat then goto Re_Start

            DECFSZ      RTCC1,f         ; Decrement RTCC1 and test if zero
            GOTO        Wait2           ; If not zero then goto Wait2 else continue

            DECFSZ      DLY_TMR,f       ; Decrement DLY_TMR and test if zero
            GOTO        Wait1           ; If not zero then goto Wait1 else continue

            MOVLW       10              ;
            MOVWF       DLY_TMR         ; DLY_TMR = 10

;           ******************************************************

Stop        BCF         _rc1            ; Extinguish green LED
            BSF         _rc2            ; Illuminate red LED
            CLRF        rtcc            ; rtcc = 0
            CLRF        RTCC1           ; RTCC1 = 0

            MOVLW       250             ;
            MOVWF       TMR_SLEEP       ; Initialise TMR_SLEEP = 250 (25 Seconds)

Red_Rpt1    BTFSS       _rc0            ; Test if SW2 is pressed
            GOTO        Red_Exit1       ; If yes then goto Red_Exit1 else continue
            BTFSS       rtcc,bit7       ; Test if rtcc bit 7 is '1'
            GOTO        Red_Rpt1        ; If not then goto Red_Rpt1 else continue

Red_Rpt2    BTFSS       _rc0            ; Test if SW2 is pressed
            GOTO        Red_Exit2       ; If yes then goto Red_Exit2 else continue
            BTFSC       rtcc,bit7       ; Test if rtcc bit 7 is '0'
            GOTO        Red_Rpt2        ; If not then goto Red_Rpt2 else continue
            INCF        RTCC1,f         ; RTCC1 = RTCC1 + 1
            BTFSS       RTCC1,bit7      ; Test if more than 1 second has elapsed
            GOTO        Red_Rpt1        ; If not then goto Red_Rpt1
            GOTO        Red_Exit1       ; Else goto Red_Exit1

Red_Exit2   MOVF        rtcc,w
            MOVWF       RTCC0           ; RTCC0 = rtcc
            BTFSS       RTCC0,bit7      ; Test if RTCC0 bit 7 is '1'
            INCF        RTCC1,f         ; If not then RTCC1 = RTCC1 + 1
            GOTO        RTCC_BCD        ;

Red_Exit1   MOVF        rtcc,w
            MOVWF       RTCC0           ; RTCC0 = rtcc

;           ******************************************************

RTCC_BCD    BTFSC       RTCC1,bit7      ; Test for overflow
            GOTO        Overflow        ; If overflow then goto Overflow

            CLRF        BCD3            ; BCD3 = 0
            CLRF        BCD2            ; BCD2 = 0
            CLRF        BCD1            ; BCD1 = 0
            CLRF        BCD0            ; BCD0 = 0

            MOVF        RTCC1,w
            MOVWF       ACCbHI          ; ACCbHI = RTCC1
            MOVF        RTCC0,w
            MOVWF       ACCbLO          ; ACCbLO = RTCC0

;           ******************************************************

BCD3_Rpt    MOVLW       0CH             ; ACCa = 0C35H (16 bit)
            MOVWF       ACCaHI
            MOVLW       35H
            MOVWF       ACCaLO

            CALL        D_Sub           ; ACCb = ACCb + (- ACCa)
            BTFSS       _c              ; Test if result is negative
            GOTO        BCD3_End        ; If yes then goto BCD3_End else continue
            INCF        BCD3,f          ; BCD3 = BCD3 + 1
            GOTO        BCD3_Rpt

BCD3_End    CALL        D_Sub           ; ACCb = ACCb + (+ ACCa)
            CALL        D_Mulx2         ; ACCb = ACCb x 2

;           ******************************************************

            MOVF        BCD3,w
            XORLW       0AH
            BTFSC       _z              ; Test if BCD3 = 0AH
            GOTO        Overflow        ; If true then goto Overflow else continue

;           ******************************************************

BCD2_Rpt    MOVLW       02H             ; ACCa = 0271H (16 bit)
            MOVWF       ACCaHI
            MOVLW       71H
            MOVWF       ACCaLO

            CALL        D_Sub           ; ACCb = ACCb + (- ACCa)
            BTFSS       _c              ; Test if result is negative
            GOTO        BCD2_End        ; If yes then goto BCD2_End else continue
            INCF        BCD2,f          ; BCD2 = BCD2 + 1
            GOTO        BCD2_Rpt

BCD2_End    CALL        D_Sub           ; ACCb = ACCb + (+ ACCa)
            CALL        D_Mulx2         ; ACCb = ACCb x 2

;           ******************************************************

BCD1_Rpt    MOVLW       00H             ; ACCa = 007DH (16 bit)
            MOVWF       ACCaHI
            MOVLW       7DH
            MOVWF       ACCaLO

            CALL        D_Sub           ; ACCb = ACCb + (- ACCa)
            BTFSS       _c              ; Test if result is negative
            GOTO        BCD1_End        ; If yes then goto BCD1_End else continue
            INCF        BCD1,f          ; BCD1 = BCD1 + 1
            GOTO        BCD1_Rpt

BCD1_End    CALL        D_Sub           ; ACCb = ACCb + (+ ACCa)
            CALL        D_Mulx2         ; ACCb = ACCb x 2

;           ******************************************************

BCD0_Rpt    MOVLW       00H             ; ACCa = 0019H (16 bit)
            MOVWF       ACCaHI
            MOVLW       19H
            MOVWF       ACCaLO

            CALL        D_Sub           ; ACCb = ACCb + (- ACCa)
            BTFSS       _c              ; Test if result is negative
            GOTO        BCD0_End        ; If yes then goto BCD0_End else continue
            INCF        BCD0,f          ; BCD0 = BCD0 + 1
            GOTO        BCD0_Rpt

BCD0_End    CALL        D_Sub           ; ACCb = ACCb + (+ ACCa)

;           ******************************************************

            ; Convert BCD to segment and write to display

            MOVF        BCD3,w
            CALL        BCD_7Seg
            MOVWF       DIGIT3

            MOVF        BCD2,w
            CALL        BCD_7Seg
            MOVWF       DIGIT2

            MOVF        BCD1,w
            CALL        BCD_7Seg
            MOVWF       DIGIT1
            BCF         DIGIT1,bit7     ; Illuminate digit 1 decimal point

            MOVF        BCD0,w
            CALL        BCD_7Seg
            MOVWF       DIGIT0

            ; Blank leading zeros in display

            MOVF        DIGIT3,w
            XORLW       ch_0
            BTFSS       _z
            GOTO        Main_End
            MOVLW       blank
            MOVWF       DIGIT3

            MOVF        DIGIT2,w
            XORLW       ch_0
            BTFSS       _z
            GOTO        Main_End
            MOVLW       blank
            MOVWF       DIGIT2
            GOTO        Main_End

;           ******************************************************

Overflow    MOVLW       ch_H            ;
            MOVWF       DIGIT3          ; Load digit 3 with 'H'
            MOVLW       ch_E            ;
            MOVWF       DIGIT2          ; Load digit 2 with 'E'
            MOVLW       ch_L            ;
            MOVWF       DIGIT1          ; Load digit 1 with 'L'
            MOVLW       ch_P            ;
            MOVWF       DIGIT0          ; Load digit 0 with 'P'
            GOTO        Main_End        ;

;           ******************************************************


Main_End    GOTO        Main            ;


            END
