;****************************************************************************
;                                 PIC16C5X.H
;               Microchip PIC16C5X Microcontroller Header File
;****************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Version : 1
;   Date : 25-01-98

;   Description

;   This header file defines all the registers and bits within the PIC16C5X range


;****************************************************************************

; define constants
 
w           equ         0
f           equ         1

bit0        equ         0
bit1        equ         1
bit2        equ         2
bit3        equ         3
bit4        equ         4
bit5        equ         5
bit6        equ         6
bit7        equ         7

;****************************************************************************

; Define Special Function Registers

ind         equ         0x00            ; Indirect data register (not a physical register)
rtcc        equ         0x01            ; Real time clock counter
pc          equ         0x02            ; Program counter (low byte)
status      equ         0x03            ; Status register
fsr         equ         0x04            ; File select register (address pointer)
porta       equ         0x05            ; Port A input/output register
portb       equ         0x06            ; Port B input/output register
portc       equ         0x07            ; Port B input/output register

;****************************************************************************

; Define commonly used flags and bits

; Status register

#define     _c          status,bit0     ; Carry flag
#define     _dc         status,bit1     ; Digit carry flag
#define     _z          status,bit2     ; Zero flag
#define     _pd         status,bit3     ; Power down flag
#define     _to         status,bit4     ; Time out flag
#define     _rp0        status,bit5     ; Register page selection bit 0 (direct addressing)
#define     _rp1        status,bit6     ; Register page selection bit 1 (direct addressing)
#define     _rp2        status,bit7     ; Reserved for future use

; Input/Output ports

#define     _ra0        porta,bit0      ; Port A bit 0 (RA0)
#define     _ra1        porta,bit1      ; Port A bit 1 (RA1)
#define     _ra2        porta,bit2      ; Port A bit 2 (RA2)
#define     _ra3        porta,bit3      ; Port A bit 3 (RA3)
#define     _ra4        porta,bit4      ; Port A bit 4 (RA4)

#define     _rb0        portb,bit0      ; Port B bit 0 (RB0)
#define     _rb1        portb,bit1      ; Port B bit 1 (RB1)
#define     _rb2        portb,bit2      ; Port B bit 2 (RB2)
#define     _rb3        portb,bit3      ; Port B bit 3 (RB3)
#define     _rb4        portb,bit4      ; Port B bit 4 (RB4)
#define     _rb5        portb,bit5      ; Port B bit 5 (RB5)
#define     _rb6        portb,bit6      ; Port B bit 6 (RB6)
#define     _rb7        portb,bit7      ; Port B bit 7 (RB7)

#define     _rc0        portc,bit0      ; Port C bit 0 (RC0)
#define     _rc1        portc,bit1      ; Port C bit 1 (RC1)
#define     _rc2        portc,bit2      ; Port C bit 2 (RC2)
#define     _rc3        portc,bit3      ; Port C bit 3 (RC3)
#define     _rc4        portc,bit4      ; Port C bit 4 (RC4)
#define     _rc5        portc,bit5      ; Port C bit 5 (RC5)
#define     _rc6        portc,bit6      ; Port C bit 6 (RC6)
#define     _rc7        portc,bit7      ; Port C bit 7 (RC7)

;****************************************************************************
