;ORGAN820.ASM 23NOV06  ; COPYRIGHT JOHN BECKER - TOP OCTAVE GEN
; PIC POLYPHONIUM

PIC16F876, WDT OFF, POR ON, 10MHz

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F876, R=DEC; 
        __CONFIG h'3F32'
        include P16F876.inc

        CBLOCK
CLKCNT
COUNT
RATE

BITSVALB  ; freq toggling bits PORTB

NOTEMSB1  ; basic val note freq MSB
NOTEMSB2
NOTEMSB3
NOTEMSB4
NOTEMSB5
NOTEMSB6
NOTEMSB7
NOTEMSB8
NOTEMSB9

NOTELSB1 ; basic val note freq LSB
NOTELSB2
NOTELSB3
NOTELSB4
NOTELSB5
NOTELSB6
NOTELSB7
NOTELSB8
NOTELSB9

NOTELOW1 ; counter LSB
NOTELOW2
NOTELOW3
NOTELOW4
NOTELOW5
NOTELOW6
NOTELOW7
NOTELOW8
NOTELOW9

NOTEHIGH1 ; counter MSB
NOTEHIGH2
NOTEHIGH3
NOTEHIGH4
NOTEHIGH5
NOTEHIGH6
NOTEHIGH7
NOTEHIGH8
NOTEHIGH9

DELAY0 ; dummy
DELAY1 ; note length delays
DELAY2
DELAY3
DELAY4
DELAY5
DELAY6
DELAY7
DELAY8
DELAY9

OCTFLAG1   ; val which sets octave for the note
OCTFLAG2
OCTFLAG3
OCTFLAG4
OCTFLAG5
OCTFLAG6
OCTFLAG7
OCTFLAG8
OCTFLAG9

LENGTHNOTE
NOTEVAL
NOTELENFLAG

CHOSEN0 ; temp store for chosen path selection
CHOSEN1 ; chosen note path number (out of 8 total)
CHOSEN2
CHOSEN3
CHOSEN4
CHOSEN5
CHOSEN6
CHOSEN7
CHOSEN8
CHOSEN9

CONTINUOUS
CONTFLAG
SWITCH
DUMMY0
NOTEDELAY

	ENDC

; *********** BITS *******

BIT0    equ 0   ;PORTB
BIT1    equ 0   ;PORTB
BIT2    equ 1   ;PORTB
BIT3    equ 2   ;PORTB
BIT4    equ 3   ;PORTB
BIT5    equ 4   ;PORTB
BIT6    equ 5   ;PORTB
BIT7    equ 6   ;PORTB
BIT8    equ 7   ;PORTB

; **********************

        ORG 0
        goto GIEOFF
        nop
        nop
        nop
        ORG 4                 ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE        ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

;*******************

NOTEFREQMSB:
        andlw 15
        addwf PCL,F
        retlw 0 ; nil        0
        retlw 1 ; * 440 RB3  1 A
        retlw 1 ; * 466 RB2  2 As
        retlw 1 ; * 493 RB1  3 B
        retlw 1 ; * 523 RB0  4 C
        retlw 1 ; * 554 RA3  5 Cs
        retlw 1 ; * 587 RA2  6 D
        retlw 1 ; * 622 RA1  7 Ds
        retlw 1 ; * 659 RA0  8 E
        retlw 1 ; * 699 RB7  9 F
        retlw 1 ; * 739 RB6  10 Fs
        retlw 1 ; * 784 RB5  11 G
        retlw 1 ; * 830 RB4  12 Gs
        retlw 0 ; nil        13
        retlw 0 ; nil        14
        retlw 0 ; nil        15

NOTEFREQLSB:
        andlw 15
        addwf PCL,F
        retlw 0   ; 0  nil
        retlw 9   ; 1  A
        retlw 25  ; 2  As
        retlw 41  ; 3  B
        retlw 60  ; 4  C
        retlw 78  ; 5  Cs
        retlw 98  ; 6  D
        retlw 119 ; 7  Ds
        retlw 141 ; 8  E
        retlw 165 ; 9  F
        retlw 189 ; 10 Fs
        retlw 217 ; 11 G
        retlw 245 ; 12 Gs
        retlw 0   ; 13 nil
        retlw 0   ; 14 nil
        retlw 0   ; 15 nil

OCTAVE: btfss PORTA,2    ; is octave switch 1 set?
        goto OCT2        ; no

        btfss PORTA,3    ; is octave switch 2 set?
        goto OCTAVELO    ; no
        goto OCTAVEHI    ; yes

OCT2:   swapf NOTEVAL,W
        andlw %00000111    ; octave rate in bits 4-7, swapping to become 0-3
        addwf PCL,F
        retlw 0          ; 0 not used
        retlw %10000000  ; 1  A = 55   Oct
        retlw %01000000  ; 2  A = 110  Oct 
        retlw %00100000  ; 3  A = 220  Oct 
        retlw %00010000  ; 4  A = 440  Oct 
        retlw %00001000  ; 5  A = 880  Oct 
        retlw %00000100  ; 6  A = 1760 Oct 
        retlw %00000010  ; 7  A = 3520 Oct 

OCTAVELO: swapf NOTEVAL,W
        andlw %00000111    ; octave rate in bits 4-7, swapping to become 0-3
        addwf PCL,F
        retlw 0          ; 0 not used
        retlw %10000000  ; 1  A = 55   Oct
        retlw %10000000  ; 2  A = 55   Oct
        retlw %01000000  ; 3  A = 110  Oct 
        retlw %00100000  ; 4  A = 220  Oct 
        retlw %00010000  ; 5  A = 440  Oct 
        retlw %00001000  ; 6  A = 880  Oct 
        retlw %00000100  ; 7  A = 1760 Oct 

OCTAVEHI: swapf NOTEVAL,W
        andlw %00000111    ; octave rate in bits 4-7, swapping to become 0-3
        addwf PCL,F
        retlw 0          ; 0 not used
        retlw %01000000  ; 1  A = 110  Oct 
        retlw %00100000  ; 2  A = 220  Oct 
        retlw %00010000  ; 3  A = 440  Oct 
        retlw %00001000  ; 4  A = 880  Oct 
        retlw %00000100  ; 5  A = 1760 Oct 
        retlw %00000010  ; 6  A = 3520 Oct 
        retlw %00000010  ; 7  A = 3520 Oct 

SETLEN: bcf CONTFLAG,0
        andlw %00001111
        addwf PCL,F
        retlw 0         ; 0  nil
        retlw 2         ; 1  demisemiquaver
        retlw 4         ; 2  semiquaver
        retlw 8         ; 3  quaver
        retlw 32        ; 4  minim      ; 4 & 5 vals swapped because PC select
        retlw 16        ; 5  crotchet   ; keys 4 & 5 swapped
        retlw 64        ; 6  semibreve
        retlw 128       ; 7  breve
        retlw 3         ; 8  demisemiquaver dotted
        retlw 6         ; 9  semiquaver dotted
        retlw 12        ; 10 quaver dotted
        retlw 24        ; 11 crotchet dotted
        retlw 48        ; 12 minim dotted
        retlw 96        ; 13 semibreve dotted
        retlw 192       ; 14 breve dotted
        bsf CONTFLAG,0  ; 15 continuous
        bcf CHOSEN1,0
        retlw 32        

ROUTEIT: movf CHOSEN0,W  ;  which note path to use
        addwf PCL,F
        return         ;0 all paths chosen
        goto VAL1      ;1 Path 1
        goto VAL2      ;2 Path 2
        goto VAL3      ;3 Path 3
        goto VAL4      ;4 Path 4
        goto VAL5      ;5 Path 5 
        goto VAL6      ;6 Path 6 
        goto VAL7      ;7 Path 7 
        goto VAL8      ;8 Path 8
        goto VAL9      ;9 Path 9

SWITCHVAL: movf SWITCH,W
        addwf PCL,F
        retlw 0
        retlw 2
        retlw 4 
        retlw 7

; ***********

START:  bcf STATUS,RP0
        bcf STATUS,RP1

        clrf PORTA            ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC

        BANK1
        movlw %10000111       ; all digital I/O
        movwf ADCON1
        movlw %00001111       ; RA0-RA3 as input, rest as output
        movwf TRISA

        clrf TRISB            ; PORTB as output
        movlw 255
        movwf TRISC           ; PORTC as input

        movlw B'00000110'     ; set for digital RA, RE
        movwf ADCON1
        movlw B'10001110'     ; set for RA0 analog, rest of RA & RE as digital
        movwf ADCON1          ; right justified (8 bit only) (bit 7=1)

        movlw B'00000110'     ; timer 1:128, pull-ups on
        movwf OPTION_REG
        BANK0

        movlw 1
        movwf CLKCNT
        clrf INTCON     ;clear interrupt flag

        clrf NOTELENFLAG
        clrf BITSVALB
	clrf NOTEDELAY

        movlw 32 
        movwf DELAY1
        movwf DELAY2 
        movwf DELAY3
        movwf DELAY4
        movwf DELAY5 
        movwf DELAY6
        movwf DELAY7 
        movwf DELAY8
        movwf DELAY9

        clrf NOTELSB1
        clrf NOTELSB2
        clrf NOTELSB3
        clrf NOTELSB4
        clrf NOTELSB5
        clrf NOTELSB6
        clrf NOTELSB7
        clrf NOTELSB8
        clrf NOTELSB9
        clrf NOTEMSB1
        clrf NOTEMSB2
        clrf NOTEMSB3
        clrf NOTEMSB4
        clrf NOTEMSB5
        clrf NOTEMSB6
        clrf NOTEMSB7
        clrf NOTEMSB8
        clrf NOTEMSB9

        clrf CHOSEN1
        clrf CHOSEN2
        clrf CHOSEN3
        clrf CHOSEN4
        clrf CHOSEN5
        clrf CHOSEN6
        clrf CHOSEN7
        clrf CHOSEN8
        clrf CHOSEN9

        movlw 4
        movwf OCTFLAG1
        movwf OCTFLAG2
        movwf OCTFLAG3
        movwf OCTFLAG4
        movwf OCTFLAG5
        movwf OCTFLAG6
        movwf OCTFLAG7
        movwf OCTFLAG8
        movwf OCTFLAG9
        movwf RATE

        clrf CONTINUOUS
        clrf CONTFLAG
        goto LOOPIT

VAL1:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB1
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB1
        movf LENGTHNOTE,W
        movwf DELAY1
        clrf LENGTHNOTE
        bsf CHOSEN1,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG1
        goto LOOPIT

VAL2:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB2
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB2
        movf LENGTHNOTE,W
        movwf DELAY2
        clrf LENGTHNOTE
        bsf CHOSEN2,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG2
        goto LOOPIT

VAL3:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB3
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB3
        movf LENGTHNOTE,W
        movwf DELAY3
        clrf LENGTHNOTE
        bsf CHOSEN3,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG3
        goto LOOPIT

VAL4:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB4
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB4
        movf LENGTHNOTE,W
        movwf DELAY4
        clrf LENGTHNOTE
        bsf CHOSEN4,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG4
        goto LOOPIT

VAL5:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB5
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB5
        movf LENGTHNOTE,W
        movwf DELAY5
        clrf LENGTHNOTE
        bsf CHOSEN5,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG5
        goto LOOPIT

VAL6:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB6
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB6
        movf LENGTHNOTE,W
        movwf DELAY6
        clrf LENGTHNOTE
        bsf CHOSEN6,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG6
        goto LOOPIT

VAL7:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB7
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB7
        movf LENGTHNOTE,W
        movwf DELAY7
        clrf LENGTHNOTE
        bsf CHOSEN7,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG7
        goto LOOPIT

VAL8:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB8
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB8
        movf LENGTHNOTE,W
        movwf DELAY8
        clrf LENGTHNOTE
        bsf CHOSEN8,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG8
        goto LOOPIT

VAL9:   movf NOTEVAL,W
        call NOTEFREQMSB
        movwf NOTEMSB9
        movf NOTEVAL,W
        call NOTEFREQLSB
        movwf NOTELSB9
        movf LENGTHNOTE,W
        movwf DELAY9
        clrf LENGTHNOTE
        bsf CHOSEN9,0      ; flag to show path chosen
        movf RATE,W
        movwf OCTFLAG9
        goto LOOPIT

; *************** START OF MAIN PROG ***********

LOOPIT:
        movf PORTA,W          ; get note length rate from switches
        andlw %00000011
        addlw 4
        BANK1
        movwf OPTION_REG
        BANK0

        clrf BITSVALB

        movf NOTELSB1,W         ; get fixed val LSB
        addwf NOTELOW1,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH1,F       ; carry (if any) add to counter MSB
        movf NOTEMSB1,W         ; get fixed val MSB
        addwf NOTEHIGH1,F       ; add to counter MSB
        movf NOTEHIGH1,W  
        andwf OCTFLAG1,W
        btfss STATUS,Z
        bsf BITSVALB,BIT1       ; set appropriate bit

        movf NOTELSB2,W         ; get fixed val LSB
        addwf NOTELOW2,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH2,F       ; carry (if any) add to counter MSB
        movf NOTEMSB2,W
        addwf NOTEHIGH2,F
        movf NOTEHIGH2,W
        andwf OCTFLAG2,W
        btfss STATUS,Z
        bsf BITSVALB,BIT2       ; set appropriate bit

        movf NOTELSB3,W         ; get fixed val LSB
        addwf NOTELOW3,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH3,F       ; carry (if any) add to counter MSB
        movf NOTEMSB3,W
        addwf NOTEHIGH3,F
        movf NOTEHIGH3,W
        andwf OCTFLAG3,W
        btfss STATUS,Z
        bsf BITSVALB,BIT3       ; set appropriate bit

        movf NOTELSB4,W         ; get fixed val LSB
        addwf NOTELOW4,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH4,F       ; carry (if any) add to counter MSB
        movf NOTEMSB4,W
        addwf NOTEHIGH4,F
        movf NOTEHIGH4,W
        andwf OCTFLAG4,W
        btfss STATUS,Z
        bsf BITSVALB,BIT4       ; set appropriate bit

        movf NOTELSB5,W         ; get fixed val LSB
        addwf NOTELOW5,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH5,F       ; carry (if any) add to counter MSB
        movf NOTEMSB5,W
        addwf NOTEHIGH5,F
        movf NOTEHIGH5,W
        andwf OCTFLAG5,W
        btfss STATUS,Z
        bsf BITSVALB,BIT5       ; set appropriate bit

        movf NOTELSB6,W         ; get fixed val LSB
        addwf NOTELOW6,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH6,F       ; carry (if any) add to counter MSB
        movf NOTEMSB6,W
        addwf NOTEHIGH6,F
        movf NOTEHIGH6,W
        andwf OCTFLAG6,W
        btfss STATUS,Z
        bsf BITSVALB,BIT6       ; set appropriate bit

        movf NOTELSB7,W         ; get fixed val LSB
        addwf NOTELOW7,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH7,F       ; carry (if any) add to counter MSB
        movf NOTEMSB7,W
        addwf NOTEHIGH7,F
        movf NOTEHIGH7,W
        andwf OCTFLAG7,W
        btfss STATUS,Z
        bsf BITSVALB,BIT7       ; set appropriate bit

        movf NOTELSB8,W         ; get fixed val LSB
        addwf NOTELOW8,F        ; add to counter LSB
        movf STATUS,W
        andlw 1
        addwf NOTEHIGH8,F       ; carry (if any) add to counter MSB
        movf NOTEMSB8,W
        addwf NOTEHIGH8,F
        movf NOTEHIGH8,W
        andwf OCTFLAG8,W
        btfss STATUS,Z
        bsf BITSVALB,BIT8       ; set appropriate bit

MASKIT: movf BITSVALB,W
        btfsc CONTFLAG,0        
        andlw %00000001
        movwf PORTB
        btfss CONTFLAG,0
        goto M2
        call DUMMYDELAYS
        goto M3

M2:     call DODELAYS   ; no

M3:     movlw 22    ;23 ;25
        movwf COUNT      ; fine tunes overall freq a bit
x1:     decfsz COUNT,F
        goto x1
        nop

        btfsc PORTC,7   ; is bit 7 set (note length value byte)?
        goto NOTELENGTH  ; yes. Immediate response for NOTELENGTH data
        movf PORTC,W
        movwf NOTEVAL
        bcf NOTELENFLAG,0       ; clear note length flag
        goto LOOPIT

CHOSENROUTE: movlw 1
        btfss CHOSEN1,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 2
        btfss CHOSEN2,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 3
        btfss CHOSEN3,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 4
        btfss CHOSEN4,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 5
        btfss CHOSEN5,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 6
        btfss CHOSEN6,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 7
        btfss CHOSEN7,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 8
        btfss CHOSEN8,0 ; is path in use?
        goto  VALCHOSEN ; no, so choose it
        movlw 9         ; all paths in use

VALCHOSEN: movwf CHOSEN0
        return

NOTELENGTH: ;btfsc NOTELENFLAG,0 ; has note length flag been set?
        movf NOTELENFLAG,W
        andlw 1
        btfss STATUS,Z          ; has note length flag been set?
        goto LOOPIT             ; yes, continue
        movf PORTC,W            ; no, so update all
        call SETLEN             ; get note length

        movwf LENGTHNOTE
        call OCTAVE             ; get note val & oct data
        movwf RATE
        goto NL3

        movlw 1
        movwf CHOSEN0
        clrf NOTEMSB2
        clrf NOTELSB2
        clrf NOTEMSB3
        clrf NOTELSB3
        clrf NOTEMSB4
        clrf NOTELSB4
        clrf NOTEMSB5
        clrf NOTELSB5
        clrf NOTEMSB6
        clrf NOTELSB6
        clrf NOTEMSB7
        clrf NOTELSB7
        clrf NOTEMSB8
        clrf NOTELSB8
        bsf CONTFLAG,0
        goto NL2

NL3:    call CHOSENROUTE
NL2:    bsf NOTELENFLAG,0       ; set note length flag
        goto ROUTEIT            ; do update

DODELAYS: btfss INTCON,2        ; has a timer time-out been detected?
        return                  ; no

        btfss PORTA,4
        goto DEC1
        clrf INTCON

        incf NOTEDELAY,F        ; doubles basic timer delay
        btfss NOTEDELAY,0
        return

DEC1:   decfsz DELAY1,F         ; no, dec DELAYA, is it zero?
        goto DEC2               ; no
        clrf NOTEMSB1
        clrf NOTELSB1
        bcf CHOSEN1,0           ; clear flag to show path now free
        bcf BITSVALB,BIT1       ; clear appropriate bit

DEC2:   decfsz DELAY2,F         ; is it zero?
        goto DEC3               ; no
        clrf NOTEMSB2
        clrf NOTELSB2
        bcf CHOSEN2,0           ; clear flag to show path now free
        bcf BITSVALB,BIT2       ; clear appropriate bit

DEC3:   decfsz DELAY3,F         ; is it zero?
        goto DEC4               ; no
        clrf NOTEMSB3
        clrf NOTELSB3
        bcf CHOSEN3,0           ; clear flag to show path now free
        bcf BITSVALB,BIT3       ; clear appropriate bit

DEC4:   decfsz DELAY4,F         ; is it zero?
        goto DEC5               ; no
        clrf NOTEMSB4
        clrf NOTELSB4
        bcf CHOSEN4,0           ; clear flag to show path now free
        bcf BITSVALB,BIT4       ; clear appropriate bit

DEC5:   decfsz DELAY5,F         ; is it zero?
        goto DEC6               ; no
        clrf NOTEMSB5
        clrf NOTELSB5
        bcf CHOSEN5,0           ; clear flag to show path now free
        bcf BITSVALB,BIT5       ; clear appropriate bit

DEC6:   decfsz DELAY6,F         ; is it zero?
        goto DEC7               ; no
        clrf NOTEMSB6
        clrf NOTELSB6
        bcf CHOSEN6,0           ; clear flag to show path now free
        bcf BITSVALB,BIT6       ; clear appropriate bit

DEC7:   decfsz DELAY7,F         ; is it zero?
        goto DEC8               ; no
        clrf NOTEMSB7
        clrf NOTELSB7
        bcf CHOSEN7,0           ; clear flag to show path now free
        bcf BITSVALB,BIT7       ; clear appropriate bit

DEC8:   decfsz DELAY8,F         ; is it zero?
        goto DECNIL             ; no
        clrf NOTEMSB8
        clrf NOTELSB8
        bcf CHOSEN8,0           ; clear flag to show path now free
        bcf BITSVALB,BIT8       ; clear appropriate bit

DECNIL: clrf INTCON
        return

DUMMYDELAYS:
        btfss INTCON,2          ; has a timer time-out been detected?
        return                  ; no

DECD1:  decfsz DELAY1,F         ; no, dec DELAYA, is it zero?
        goto DECD2              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD2:  decfsz DELAY2,F         ; is it zero?
        goto DECD3              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD3:  decfsz DELAY3,F         ; is it zero?
        goto DECD4              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD4:  decfsz DELAY4,F         ; is it zero?
        goto DECD5              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD5:  decfsz DELAY5,F         ; is it zero?
        goto DECD6              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD6:  decfsz DELAY6,F         ; is it zero?
        goto DECD7              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD7:  decfsz DELAY7,F         ; is it zero?
        goto DECD8              ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECD8:  decfsz DELAY8,F         ; is it zero?
        goto DECDNIL            ; no
        clrf DUMMY0
        clrf DUMMY0
        bcf DUMMY0,0
        bcf DUMMY0,0

DECDNIL: clrf INTCON
        return

;********** GET ADC VALUE

GETADC: btfsc ADCON0,GO
        goto GETADC
ADC2:   BANK1
        movf ADRESL,W     ;get ADC LSB val
        BANK0
        return

********

; TABLE OF TRUE NOTE VALUES
; 1/8       1/4      1/2      Note 1       2       4        8   factor
; 1         2        3             4       5       6        7   PIC oct 
; 27.5      55       110      A0:  220     440     880      1760         
; 29.13525  58.2705  116.541  AS0: 233.082 466.164 932.328  1864.656     
; 30.867625 61.73525 123.4705 B0:  246.941 493.882 987.764  1975.528     
; 32.703125 65.40625 130.8125 C0:  261.625 523.25  1046.5   2093         
; 34.64775  79.2955  138.591  CS0: 277.182 554.364 1108.728 2217.456     
; 36.708    73.416   146.832  D0:  293.664 587.328 1174.656 2349.312     
; 38.89075  77.7815  155.563  DS0: 311.126 622.252 1244.504 2489.008     
; 41.203375 82.40675 164.8135 E0:  329.627 659.254 1318.508 2637.016     
; 43.653625 87.30725 174.6145 F0:  349.229 698.458 1396.916 2793.832     
; 46.24925  92.4985  184.997  FS0: 369.994 739.988 1479.976 2959.952     
; 48.999375 97.99875 195.9975 G0:  391.995 783.99  1567.98  3135.96      
; 51.913    103.826  207.652  GS0: 415.304 830.608 1661.216 3322.432     
; 55        110      220      A1:  440     880     1760     3520         

        END

