;PAIN16F360.ASM 12FEB05  PAIN MONITOR

;PIC16F876, 4MHz, WDT OFF, POR ON, XTAL XS

;PROGRAM WRITTEN IN TASM VARIANT - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F876 data sheet

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE SERIALDELAY call CYCLES5  ; set serial chip write delay value
                       ; CYCLES25 for 20MHz, CYCLES5 for 4MHz or below

        List P = PIC16F876, R=DEC;
        __CONFIG   h'3F31'

        include P16F876.inc

        CBLOCK 

; ****** general equates
LOOP
LOOPA
STORE
SLOWIT
STORE1
RSLINE

; ****** BIN2DEC equates

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

; ******* serial eeprom equates

MEMHI     
MEMLO     
WADDRL    
WADDRH    
WADDRLSTORE
WADDRHSTORE
RADDRH
RADDRL    
POLLCNT     ; serial eeprom use
SLAVE       ; serial eeprom use
TXBUF       ; serial eeprom use
BCOUNT  
COUNT   
DATAI   
DATAO   
EEPROM  
ECHAN
MEMCNT
ECHANTEMP
MEMFUL
PROMVAL
ABORT

; **** calendar

YEAR
MONTH
WKDAY
CLKDAY
CLKHRS
CLKMIN
CLKSEC

; ********* Switch events

PAINLEVEL
CHANGEPATIENT
EVENT2
EVENT3
BYTEOUT
TIMECOUNT
PRESSCOUNT
SWITCHOK
SWITCHDELAYON
SWITCHLSB
SWITCHMSB
STOREA
STOREB
STOREC
SWITCHA
SWITCHC
PATIENTNO
ALARMLED

        ENDC

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:         EQU 7        ; eeprom input bit
DO:         EQU 6        ; eeprom output bit
SDATA:      EQU 4        ; serial EE data & RTC data line (PORTC) 
SCLK:       EQU 3        ; serial EE clock 
TCLK:       EQU 3        ; RTC clk line (PORTA)

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START	

TABLCD: addwf PCL,F      ; LCD initialisation table
        retlw %00110011  ; initialise lcd - first byte
        retlw %00110011  ; 2nd byte (repeat of first)
        retlw %00110010  ; set for 4-bit operation
        retlw %00101100  ; set for 2 lines
        retlw %00000110  ; set entry mode to increment each address
        retlw %00001100  ; set display on, cursor off, blink off
        retlw %00000001  ; clear display
        retlw %00000010  ; return home, cursor & RAM to zero
                         ; end inititalisation table

PATIENT: addwf PCL,F
         retlw 'S'
         retlw 'E'
         retlw 'T'
         retlw ' '
         retlw 'I'
         retlw 'D'
         retlw '^'
         retlw ' '
         retlw ' '
         retlw '*'
         retlw '*'
         retlw '*'
         retlw '*'

TOPLINE: addwf PCL,F
         retlw 'I'
         retlw 'D'
         retlw ' '
         retlw 'N'
         retlw 'O'
         retlw ' '
         retlw ' '
         retlw ' '
         retlw 'E'
         retlw 'V'
         retlw 'E'
         retlw 'N'
         retlw 'T'
         retlw 'A'
         retlw ' '
         retlw '0'
         retlw '*'
         retlw '*'
         retlw '*'
         retlw '*'

MESSAG2: addwf PCL,F
        retlw 'C'
        retlw 'L'
        retlw 'E'
        retlw 'A'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'M'
        retlw 'E'
        retlw 'M'
        retlw 'O'
        retlw 'R'
        retlw 'Y'
        retlw ' '

MESSAG3: addwf PCL,F
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '0'
        retlw ' '
        retlw 'O'
        retlw 'F'
        retlw ' '
        retlw '3'
        retlw '2'
        retlw '7'
        retlw '6'
        retlw '8'
        retlw ' '
        retlw ' '

MESSAG4:  addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'N'
           retlw 'D'
           retlw 'I'
           retlw 'N'
           retlw 'G'
           retlw ' '
           retlw 'T'
           retlw 'O'
           retlw ' '
           retlw 'P'
           retlw 'C'
           retlw ' '
           retlw ' '
           retlw ' '

MESSAG6:  addwf PCL,F
           retlw 'W'
           retlw 'A'
           retlw 'I'
           retlw 'T'
           retlw ' '
           retlw 'F'
           retlw 'O'
           retlw 'R'
           retlw ' '
           retlw 'L'
           retlw 'I'
           retlw 'G'
           retlw 'H'
           retlw 'T'
           retlw ' '
           retlw ' '

LCDSET: clrf LOOP        ; clr LCD set-up loop
        clrf RSLINE      ; clear RS line for instruction send
LCDST2: movf LOOP,W      ; get table address
        call TABLCD      ; get set-up instruction
        call LCDOUT      ; perform it
        incf LOOP,F      ; inc loop
        btfss LOOP,3     ; has last LCD set-up instruction now been done?
        goto LCDST2      ; no
        return

SETPATIENT:     call LCD21
                clrf LOOP
PAT2:           movf LOOP,W
                call PATIENT
                call LCDOUT
		movf LOOP,W
                incf LOOP,F
                movf LOOP,W
                xorlw 9
                btfss STATUS,Z
                goto PAT2
                return

SHOWTOPLINE:    call LCD1
                clrf LOOP
TOP2:           movf LOOP,W
                call TOPLINE
                call LCDOUT
		movf LOOP,W
                incf LOOP,F
                movf LOOP,W
                xorlw 14
                btfss STATUS,Z
                goto TOP2
		return

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PCLATH
        clrf TIMECOUNT
        clrf SWITCHDELAYON
        clrf SWITCHOK
        movlw %00010000
        movwf ALARMLED

        movlw B'11011000'   ; RA0 (LCD E) low, RA5 low (LED 13 off)
        movwf PORTA  
        clrf PORTB  
        clrf PORTC  
        clrf RSLINE  
        BANK1
        movlw %11100010     ; RA2 low (switches on), RA0 (LCD E) low
        movwf TRISA  
        clrf TRISB          ; PORTB as output
        movlw %10100111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
        movwf TRISC         ; PORTC as input
        movlw B'00000110'   ; timer 1:128 (1/25th sec), pull-ups on
        movwf OPTION_REG
        movlw B'10000111'   ; RA0 to RA5 as digital
        movwf ADCON1  
        BANK0

        call SETUP

        movlw B'11011000'   ; RA0 (LCD E) low, RA5 low (LED 13 off)
        movwf PORTA  
        BANK1
        movlw %11100010     ; RA2 low (switches on), RA0 (LCD E) low
        movwf TRISA  
        BANK0
        nop
        nop
        btfss PORTA,5       ; is EEPROM clearance needed? S11 pressed
        goto CLEARIT        ; yes

; ********** START OF MAIN *********

MAIN:   BANK1
        movlw %11100010     ; RA2 low (switches on), RA0 (LCD E) low
        movwf TRISA  
        movlw 255
        movwf TRISB         ; PORTB as input
        movlw %10100111     ; PORTC bits 3,4 as output for serial eeprom, 6 as RS232 out
        movwf TRISC
        BANK0

MAINX:  btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN2              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        movwf STORE
        sublw   'T'             ; Is this a 'T' for Time ?
        btfsc   STATUS,Z
        goto RECEIVETIME        ; yes

        movf STORE,W
        sublw   'S'             ; Is this an 'S' for Set ?
        btfsc   STATUS,Z
        goto MAIN1              ; yes
        movf STORE,W
        sublw   'R'             ; Is this an 'R' for Reset ?
        btfsc   STATUS,Z
        goto CLEARIT            ; yes
        goto MAIN2              ; no

MAIN1:  BANK1
        clrf TRISB
        BANK0

MAIN3A: btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN3A             ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'G'             ; Is this a 'G' for Go ?
        btfsc   STATUS,Z
        call JOEDOWNLOAD        ; Yes, a 'G'

        call SHOWPATIENT
        call SHOWPAIN
        call SHOWBC
        clrf SWITCHMSB
        clrf SWITCHLSB
        goto MAIN

; ****** get switch press ******

MAIN2:  comf PORTA,W        ; get PORTA RA5 (active low)
        andlw %00100000
        movwf STOREA        ; store A as active high
        comf PORTB,W        ; get PORTB (active low)
        movwf STOREB        ; store B as active high
        comf PORTC,W        ; get PORTC (active low)
        andlw %00100111
        movwf STOREC        ; store C as active high

; ****** PROCESS SWITCH PRESS ******

GETA:   movf STOREA,W       ; get STOREA (active high)
        btfsc STATUS,Z      ; is it zero?
        goto GETB           ; yes

        call WAITSWITCHES
        call SETTRIS

        btfss SWITCHOK,0    ; is switch ok set?
        goto SHOWLEDB       ; no

        movlw 32
        addwf SWITCHA,W     ; toggle bit 5
        andlw %00100000
        bcf SWITCHA,5
        iorwf SWITCHA,F

        clrf SWITCHMSB
        clrf SWITCHC

        btfss SWITCHA,5
        goto VALA0
        bsf CHANGEPATIENT,0
        call CLRLINE2
        call SETPATIENT
        goto SHOWLEDB

VALA0:  bcf CHANGEPATIENT,0
        call STOREPATIENT
        call RECALLEVENTS
        call SHOWPATIENT
        call SHOWPAIN
        call SHOWBC
        clrf SWITCHLSB
        movf SWITCHMSB,W
        andlw %11110011      ; knock out S1/2
        movwf SWITCHMSB
        goto SHOWLEDB

; ******* PROCESS B ********

GETB:   movf STOREB,W        ; get STOREB (active high)
        btfsc STATUS,Z       ; is it zero?
        goto GETC            ; yes

        call WAITSWITCHES
        call SETTRIS         ; switches & LEDs off

        btfsc SWITCHOK,0      ; yes, is switch ok set?
        goto BOA
        clrf SWITCHLSB        ; no, clear leds
        clrf SWITCHMSB
        goto SHOWLEDB

BOA:    clrf SWITCHMSB
        movf STOREB,W        ; get STOREB (active high)
        movwf SWITCHLSB      ; store STOREB value
        call GETBVALUE
        movf LOOP,W          ; yes

        btfss CHANGEPATIENT,0 ; is patient no being changed?
        goto UPDATEPAINB      ; no

        movwf PATIENTNO       ; yes
        goto UPDATEID

UPDATEPAINB:        
        movwf PAINLEVEL       ; pain is being changed
        call SHOWPAIN
        call READRTC
        call STOREIT
        call STOREIT1
        call STORELATEST
        goto SHOWLEDB

; ******* PROCESS C ********

GETC:   movf STOREC,W        ; get PORTC (active high)
        btfss STATUS,Z       ; is it zero?
        goto SC0             ; no

        call SETTRIS         ; yes, set switches & LEDs off
        goto SHOWLEDB

SC0:    call WAITSWITCHES
        call SETTRIS         ; switches & LEDs off

        btfsc SWITCHOK,0       ; yes, is ok set?
        goto SC0A              ; yes
        clrf SWITCHLSB         ; no, so clear leds
        clrf SWITCHMSB
        goto SHOWLEDB

SC0A:   movf STOREC,W        ; get PORTC (active high)
        andlw %00100100      ; are S1 (bit 2) or S2 (bit 5) pressed?
        btfss STATUS,Z
        goto SC3             ; yes

; ***** PROCESS C S12/S13 *******

        btfss STOREC,0       ; is S13 pressed?
        goto SC12             ; no, so S12 is
        btfss CHANGEPATIENT,0  ; is patient being changed?
        goto SC1             ; no

ADD10:  movf PATIENTNO,W     ; yes, add 10 to number
        addlw 10
        movwf STORE
        addlw 156            ; is it greater than 99?
        movlw 99
        btfsc STATUS,C
        movwf STORE          ; yes, set back to 99
        movf STORE,W
        movwf PATIENTNO
        goto UPDATEID

SC1:    movf STOREC,W
        movwf SWITCHMSB
        clrf SWITCHLSB
        incf EVENT2,F
        call READRTC
        call STOREIT
        call STOREIT2
        call STORELATEST
        call SHOWBC
        goto SHOWLEDB

SC12:   btfss CHANGEPATIENT,0   ; switch 12 is pressed, is patient being changed?
        goto SC1C               ; no

        movlw 10                ; yes, deduct 10 from number
        subwf PATIENTNO,W
        movwf STORE
        movlw 1
        btfss STATUS,C          ; is it less than 1?
        movwf STORE             ; yes, so set to 1
        movf STORE,W
        movwf PATIENTNO
        goto UPDATEID

SC1C:   movf STOREC,W          ; event 3 being set
        movwf SWITCHMSB
        clrf SWITCHLSB
        incf EVENT3,F
        call READRTC
        call STOREIT
        call STOREIT3
        call STORELATEST
        call SHOWBC
        goto SHOWLEDB

; ***** PROCESS S1/S2 *******

SC3:    movf STOREC,W        ; get PORTC (active high)
        movwf SWITCHMSB
        clrf SWITCHLSB

        movlw 1
        movwf LOOP
        btfsc SWITCHMSB,2    ; S1 (bit 2)?
        goto VALC            ; yes
        incf LOOP,F          ; no, therefore S2 (bit 5)

VALC:   movf LOOP,W
        btfss CHANGEPATIENT,0 ; is patient no being changed?
        goto VALC1            ; no
        movwf PATIENTNO       ; yes
        goto UPDATEID

VALC1:  movwf PAINLEVEL
        call SHOWPAIN
        call READRTC
        call STOREIT
        call STOREIT1
        call STORELATEST
        goto SHOWLEDB

UPDATEID: call RECALLEVENTS
        call SHOWPATIENT
        call SHOWPAIN
        movf PATIENTNO,W
        movwf PROMVAL
        movlw 2
        call SETPRM

SHOWLEDB: call LEDSON
        call PAUSIT
        goto MAIN

LEDSON: BANK1
        bcf TRISA,1         ; LEDS on
        BANK0

        movlw %11000100     ; RA2 high (switch off), RA1 low (led on)
        iorwf SWITCHA,W
        iorwf ALARMLED,W
        movwf PORTA         ; RA0 low (LCD E), RA5 low (LED 13 off)

        movf SWITCHLSB,W
        movwf PORTB         ; turn on active B LED if any
        movf SWITCHMSB,W
        movwf PORTC         ; turn on active C LED if any
        movf SWITCHA,W

        incf TIMECOUNT,F    ; show time every second
        movf TIMECOUNT,W
        xorlw 5
        btfss STATUS,Z
        return

        clrf TIMECOUNT
        btfss CHANGEPATIENT,0
        call READRTC        ; show time

        BANK1
        bcf TRISA,1         ; LEDS on - re-update display
        BANK0

        movlw %11000000     ; RA2 high (switch off), RA1 low (led on)
        iorwf SWITCHA,W
        iorwf ALARMLED,W
        movwf PORTA         ; RA0 low (LCD E), RA5 low (LED 13 off)

        movf SWITCHLSB,W
        movwf PORTB         ; turn on active B LED if any
        movf SWITCHMSB,W
        movwf PORTC         ; turn on active C LED if any
        movf SWITCHA,W
        return


SHOWLCD: clrf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOW9
        return

WAITSWITCHES:
        btfss SWITCHDELAYON,0
        goto NOWAIT

        movf STOREA,W
        btfss STATUS,Z
        goto WAITSWITCHES2
        btfss CHANGEPATIENT,0
        goto WAITSWITCHES2

NOWAIT: bcf PORTA,4      ; turn on alarm LED
        bsf PORTA,3      ; turn on buzzer if fitted
        bsf SWITCHOK,0

WAITSWA: btfss PORTA,5       ; wait switch A release
        goto WAITSWA
WAITSWB: comf PORTB,W        ; wait switch B release
        btfss STATUS,Z
        goto WAITSWB
WAITSWC: comf PORTC,W        ; wait switch C release
        andlw %00100111
        btfss STATUS,Z
        goto WAITSWC
        call PAUSIT          ; delay for switch bounce

        bsf PORTA,4      ; turn off alarm LED
        bcf PORTA,3      ; turn off buzzer if fitted

        return

WAITSWITCHES2:
        movf STOREA,W
        btfss STATUS,Z
        goto WAITSWA2
        movf STOREB,W
        btfss STATUS,Z
        goto WAITSWB2
        movf STOREC,W
        btfss STATUS,Z
        goto WAITSWC2
        return

WAITSWB2: call SETTRIS   ; turn off switches, leds, turn on LCD output
        call SHOWWAIT

        BANK1
        movlw 255
        movwf TRISB
        bcf TRISA,2      ; turn on switches
        BANK0

        bcf PORTA,2      ; reactivate switch detection on PORTB
        bsf PORTA,2
        bcf PORTA,2

        clrf PRESSCOUNT
        clrf SWITCHOK
        bsf PORTA,4      ; turn on alarm led
        bcf PORTA,3      ; turn on buzzer if fitted
        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H
        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1

SWB2:   btfss PIR1,0     ; has timer 1 overflowed?
        goto SWB3        ; no
        bcf PIR1,0       ; timer rollover flag
        incf PRESSCOUNT,F
        movf PRESSCOUNT,W
        xorlw 6
        btfss STATUS,Z
        goto SWB3
        bcf PORTA,4      ; turn on alarm LED
        bsf PORTA,3      ; turn on buzzer if fitted
        bsf SWITCHOK,0

        call SETTRIS     ; turn off switches, leds, turn on LCD output
        call SHOWOK

        BANK1
        movlw 255
        movwf TRISB
        bcf TRISA,2      ; turn on switches
        BANK0

        bcf PORTA,2      ; reactivate switch detection on PORTB
        bsf PORTA,2
        bcf PORTA,2

SWB3:   comf PORTB,W     ; wait switch B release
        btfss STATUS,Z
        goto SWB2
        call PAUSIT      ; delay for switch bounce
        bsf PORTA,4      ; turn off alarm LED
        bcf PORTA,3      ; turn off buzzer if fitted
        call SHOWBC
        return

WAITSWC2: BANK1
        clrf TRISB
        BANK0

        call SHOWWAIT

        clrf PRESSCOUNT
        clrf SWITCHOK
        bsf PORTA,4
        bcf PORTA,3      ; buzzer if fitted
        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H
        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1

SWC2:   btfss PIR1,0     ; has timer 1 overflowed?
        goto SWC3        ; no
        bcf PIR1,0       ; timer rollover flag
        incf PRESSCOUNT,F
        movf PRESSCOUNT,W
        xorlw 6
        btfss STATUS,Z
        goto SWC3
        bcf PORTA,4
        bsf PORTA,3      ; buzzer if fitted
        bsf SWITCHOK,0
        call SHOWOK

SWC3:   comf PORTC,W     ; wait switch C release
        andlw %00100111
        btfss STATUS,Z
        goto SWC2
        call PAUSIT      ; delay for switch bounce
        bsf PORTA,4
        bcf PORTA,3      ; buzzer if fitted
        call SHOWBC
        return

*****

WAITSWA2: BANK1
         clrf TRISB
         BANK0

        call SHOWWAIT

        clrf PRESSCOUNT
        clrf SWITCHOK
        bsf PORTA,4
        bcf PORTA,3      ; buzzer if fitted
        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H
        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1

SWA2:   btfss PIR1,0     ; has timer 1 overflowed?
        goto SWA3        ; no
        bcf PIR1,0       ; timer rollover flag
        incf PRESSCOUNT,F
        movf PRESSCOUNT,W
        xorlw 6
        btfss STATUS,Z
        goto SWA3
        bcf PORTA,4
        bsf PORTA,3      ; buzzer if fitted
        bsf SWITCHOK,0
        call SHOWOK

SWA3:   comf PORTA,W     ; wait switch A release
        andlw %00100000
        btfss STATUS,Z
        goto SWA2
        call PAUSIT      ; delay for switch bounce
        bsf PORTA,4
        bcf PORTA,3      ; buzzer if fitted
        call SHOWBC
        return

SHOWOK: call CLRLINE2
        call LCD21
        movlw 'O'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

SHOWCOUNT:
        call SETTRIS        

        call LCD21
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        bcf STATUS,C
        rrf WADDRH,W    ; divide count by 8
        movwf REGA1
        rrf WADDRL,W
        movwf REGA0
        bcf STATUS,C
        rrf REGA1,F
        rrf REGA0,F
        bcf STATUS,C
        rrf REGA1,F
        rrf REGA0,F

        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOW7
        call LEDSON

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call SETTRIS
        call SHOWBC
        call READRTC
        call LEDSON
        return

SETTRIS: BANK1
        movlw %11000110  ; RA2 high (switches off), RA0 (LCD E) low
        movwf TRISA      ; RA1 high (leds off), RA5 low (LED 13 off)
        clrf TRISB
        movlw %10000000  ; bits 3,4 as output for serial eeprom, 6 as RS232 out
        movwf TRISC
        BANK0
        return

;******** LCD ROUTINES **********

LCD1:   movlw B'10000000'
        goto LCDLIN
LCD5:   movlw B'10000101'
        goto LCDLIN
LCD14:  movlw B'10001110'
        goto LCDLIN
LCD15:  movlw B'10001111'
        goto LCDLIN
LCD21:  movlw B'11000000'
        goto LCDLIN
LCD28:  movlw B'11001000'

LCDLIN: clrf RSLINE         ; sets LCD command/line
        call LCDOUT         ; and outputs command code to LCD
        bsf RSLINE,4        ; set RS flag
        return

SHOW1:  movf DIGIT1,W  
	call LCDOUT	
SHOW2:  movf DIGIT2,W  
	call LCDOUT	
SHOW3:  movf DIGIT3,W  
	call LCDOUT	
SHOW4:  movf DIGIT4,W  
	call LCDOUT	
SHOW5:  movf DIGIT5,W  
	call LCDOUT	
SHOW6:  movf DIGIT6,W  
	call LCDOUT	
SHOW7:  movf DIGIT7,W  
	call LCDOUT	
SHOW8:  movf DIGIT8,W  
	call LCDOUT	
SHOW9:  movf DIGIT9,W  
	call LCDOUT	
SHOW10: movf DIGIT10,W  
	call LCDOUT	
	return

LCDOUT: movwf STORE1        ; temp store value that will be output to LCD
        movlw 60            ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT         ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F      ; swap byte nibbles
        movf STORE1,W       ; get nibble (MSB)
        andlw 15            ; AND to isolate nibble
        iorwf RSLINE,W      ; OR the RS bit
        movwf PORTB         ; output the byte
        nop
        nop
        bsf PORTA,0         ; set E high
        nop
        nop
        bcf PORTA,0         ; set E low
        return

PAUSIT: movlw 6
        movwf SLOWIT  
        clrf INTCON     ; clear interupt flag

PAUSE:  btfss INTCON,2  
        goto PAUSE
        bcf INTCON,2  
        decfsz SLOWIT,F  
        goto PAUSE
        return

CLRLINE1: call LCD1     ; set address for line 1 cell 1
        clrf LOOP       ;
CLRL1:  movlw ' '       ; clear cell
        call LCDOUT     ;
        incf LOOP,F     ; inc loop
        btfss LOOP,4    ; has last LCD letter been sent?
        goto CLRL1      ; no
        return

CLRLINE2: call LCD21
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

STOREPATIENT: call CLRLINE2
        call READRTC
        return

GETBVALUE: movlw 3
        movwf LOOP
        btfsc SWITCHLSB,0
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,1
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,2
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,3
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,4
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,5
        goto VALB
        incf LOOP,F
        btfsc SWITCHLSB,6
        goto VALB
        incf LOOP,F
VALB:   return

SETUP:  call PAUSIT         ; 1/5 sec delay
        call LCDSET
        call PAUSIT         ; 1/5 sec delay

        call JOESETBAUD  ; set baud rate
        call CLEARADR
        movlw 0
        call PRMGET
        movwf WADDRH 
        movlw 1
        call PRMGET
        movwf WADDRL
        movlw 2
        call PRMGET
        btfsc STATUS,Z
        movlw 1
        movwf PATIENTNO
        movlw 3
        call PRMGET
        movwf SWITCHDELAYON

        call READRTC
        clrf SWITCHLSB
        clrf SWITCHMSB
        clrf SWITCHA
        clrf SWITCHC
        clrf CHANGEPATIENT

        call RECALLEVENTS
        call SHOWTOPLINE
        call SHOWPATIENT
        call SHOWPAIN
        call SHOWBC
        movlw 1
        movwf MEMCNT

        return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03
;---------------------------------------------------------------------
; Description:
; Sends 100 blocks of 258 bytes (256 data + 2 trailer) to the
; serial port.
; On receipt of a 'G' command from the PC, the PIC waits for 'B'
; command and then sends a 258 byte block. The PIC again waits for a 'B'
; command before sending the next block.
; The block being sent is reflected on the PORTB LEDS.
; Each block contains ASCII codes (0 to 255).
;
; The PIC waits for a character before sending back the ASCII block
;
;---------------------------------------------------------------------

JOESETBAUD
        BANK1                   ; Configure the baud rate generator
;        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
;        movlw 64                ; 4800 Baud with 20MHz XTAL (See PIC data sheet for these values)
;        movlw 42                ; 4800 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
;        movlw 47                ; 4800 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
        movlw 25                ; 9600 Baud with 4MHz XTAL (See PIC data sheet for these values)
;        movlw 23                ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
;        movlw 20                ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 4)
        movwf   TXSTA           ; In bank 1
        bcf     STATUS,RP0      ; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; ***************

JOEDOWNLOAD:
        bcf PORTA,4
        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H

        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1
        call CLRLINE2     ; clear LCD line 2

         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGJ movf LOOP,W
         call MESSAG4      ; sending to PC message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGJ
         call JOESENDPC    ; send chips to PC

LS2:     call SHOWTOPLINE

         movlw %00000000  ; restore timer 1 to main val
         movwf T1CON
         call    FlushRXBuffer   ; Flush the RX buffer in bank 0
         return

JOESENDPC
        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

; 'G' has been received - Confirm ready state back to PC

        movlw   'P'
        call    TxByte
        movlw   'I'
        call    TxByte
        movlw   'C'
        call    TxByte
        movlw   'e'
        call    TxByte
        movlw   'l'
        call    TxByte
        movlw   'e'
        call    TxByte
        movlw   'c'
        call    TxByte
        movf MEMCNT,W            ; number of EEPROM chips
        iorlw 48
        call    TxByte
        movlw 1
        call TxByte
        movlw 0        
        call    TxByte

        movf MEMCNT,W
        btfsc STATUS,Z          ; are there any eeprom chips installed?
        return                  ; no

BYPASS: movf ECHAN,W            ; temp store ECHAN
        movwf ECHANTEMP
        clrf ECHAN

        goto WAITB

WaitG 				; Wait for any character to be received
        call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        sublw   'G'             ; Is this a 'G'
        btfss   STATUS,Z
        goto    WaitG           ; Not a 'G'

; 'G' has been received - Confirm ready state back to PC
SendR:  movlw   'R'             ; Signal 'R'eady
        call    TxByte

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB
	call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        movwf   PORTB
        sublw   'B'             ; Is this a 'B'
        btfsc   STATUS,Z
        goto    SendNext        ; Yes a 'B'
        btfsc ABORT,0           ; is abort tranfser flag set?
        goto    ENDTF           ; yes, so abort transfer
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block

SendNext
         call READ         ; read from EEPROM chip
         movf MEMHI,W      ; get MSB value
         addlw 48
         call TXBYTE       ; send it to PC
         movf MEMLO,W      ; get LSB value
         addlw 48
         call TXBYTE       ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         btfss STATUS,C
         goto SendNext

; Data portion of the block has been sent, now send the Block terminator
        movlw   0x0D            ; CR
        call    TxByte
        movlw   0x0A            ; LF
        call    TxByte

        incf RADDRH,F
        btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
        goto    WaitB

        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

        incf ECHAN,F
        movf ECHAN,W
        xorwf MEMCNT,W
        btfss STATUS,Z
        goto WAITB

ENDTF:  movf ECHANTEMP,W   ; restore count into ECHAN
        movwf ECHAN
        call READRTC
        bsf PORTA,4
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop:
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow

RecLoop2:
        btfss PIR1,0          ; has timer 1 overflowed?
        goto RECLOOP3         ; no
        movlw 0
        bsf ABORT,0           ; yes, set flag
        return

RECLOOP3: nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    RecLoop2        ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer
        movf    RCREG,W
	movf    RCREG,W
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

NEGATEA: movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

STOREIT: movf PATIENTNO,W    ; store volts to external serial EEPROM chip
         movwf MEMHI
         movf YEAR,W
         movwf MEMLO
         call SAVESAMPLE

         movf MONTH,W
         movwf MEMHI
         movf CLKDAY,W
         movwf MEMLO
         call SAVESAMPLE

         movf CLKHRS,W
         movwf MEMHI
         movf CLKMIN,W
         movwf MEMLO
         call SAVESAMPLE

         movf PATIENTNO,W
         movwf PROMVAL
         movlw 2
         call SETPRM
         return

STOREIT1: movf CLKSEC,W
         movwf MEMHI
         movf PAINLEVEL,W
         movwf MEMLO
         call SAVESAMPLE
         call CHECKADR
         call STOREADR
         return

STOREIT2: movf CLKSEC,W
         movwf MEMHI
         movlw 16
         movwf MEMLO
         call SAVESAMPLE
         call CHECKADR
         call STOREADR
         return

STOREIT3: movf CLKSEC,W
         movwf MEMHI
         movlw 32
         movwf MEMLO
         call SAVESAMPLE
         call CHECKADR
         call STOREADR
         return

STOREADR: movf WADDRH,W   ; set write address MSB
         movwf PROMVAL
         movlw 0
         call SETPRM
         movf WADDRL,W    ; set write address LSB
         movwf PROMVAL
         movlw 1
         call SETPRM
         return

;*********

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT

SAVESAMPLE:  movf MEMHI,W  ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
        movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; dec address back to prev count
        call INCADDRESS
        return

;*********** cycles pause called by Serial EEPROM write routines ****

; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES5:   NOP
CYCLES4:   return

;*************


;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SDATA    ; data line goes low during
                             ; high clock for start bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC        ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          SERIALDELAY        ; timing adjustment        
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BSF PORTC,SDATA    ; data goes high while clock high for stop bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; set clock low again
          SERIALDELAY        ; timing adjustment
          RETLW 0

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          movlw %10100111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI      ; assume input bit is high
          BANK1
          movlw %10110111    ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             

                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          movlw %10100111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          SERIALDELAY
          BSF PORTC,SCLK      ; set clock high
          SERIALDELAY
          BSF PORTC,SDATA     ; data goes high while clock high for stop bit
          SERIALDELAY
          BCF PORTC,SCLK      ; set clock low again
          SERIALDELAY
          RETLW 0

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          movlw %10110111     ; bits 3,4 as output for serial eeprom, 6 as RS232 out
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          SERIALDELAY
          BTFSS PORTC,SDATA   ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK      ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ; data low byte
          return

LOWACK:   movf DATAI,W
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

; *****************

INCADDRESS: clrf MEMFUL
         movlw 2
         addwf WADDRL,F    ;inc write address by 2
         btfss STATUS,C
         return 
         incf WADDRH,F
         btfss WADDRH,7    ; is bit 7 of MSB now set?
         return            ; no
         bsf MEMFUL,0
         return

; *****************

CLEARADR: clrf MEMHI
        clrf MEMLO
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
        clrf MEMFUL
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return


; ******** CLEAR EXTERNAL SERIAL EEPROM ********

CLEARIT:
        movlw   'R'         ; confirm recd status back to PC
        call    TxByte

        bcf PORTA,4
        clrf WADDRL
        clrf WADDRH

        BANK1
        clrf TRISB
        BANK0

        call CLRLINE1        ; clear entire external serial eeprom
        call CLRLINE2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWCLR: movf LOOP,W
        call MESSAG2         ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCLR

        clrf LOOP
        call LCD21
SHOWCL2: movf LOOP,W
        call MESSAG3         ; clearing eeprom
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCL2
        call CLEARADR

CLEAR2: clrf MEMHI
        clrf MEMLO
        call SAVESAMPLE
        btfsc MEMFUL,0    ; is MEMFUL set from address inc routine?
        goto CLEAR4       ; yes
        btfss STATUS,C    ; is there a carry from address inc routine?
        goto CLEAR2       ; no

        movf WADDRL,W     ; yes, so show count
        movwf REGA0
        movf WADDRH,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call LCD21
        call SHOW6        ; show current record count
        movlw 'R'         ; send R to PC for sake of its bargraph count
        call TxByte

        goto CLEAR2

CLEAR4: clrf PROMVAL
        movlw 0
        call SETPRM
        clrf PROMVAL
        movlw 1
        call SETPRM
        movlw 1
        movwf PROMVAL
        movlw 2
        call SETPRM
        clrf PROMVAL
        movlw 3
        call SETPRM
        movlw 4
        call SETPRM
        movlw 5
        call SETPRM
        goto 0            ; restart PIC prog

; *************** CONVERT BYTE TO HEX & SHOW IT ******

BIN2HEX: movwf STORE
        swapf STORE,W   ;get most significant nibble
        andlw 15
        movwf DIGIT9
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT9,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT9,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT9
        movf STORE,W    ;get least significant nibble
        andlw 15
        movwf DIGIT10
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT10,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT10,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT10

SHOWHEX: movf DIGIT9,W
      call LCDOUT
      movf DIGIT10,W
      call LCDOUT
      return

; ************  REAL TIME CLOCK SECTION *********

RTCLOCK:

; ********* WRITE TO RT CLOCK

        bcf PORTA,4
        bsf PORTC,SDATA
        bsf PORTC,TCLK

        BANK1
        clrf TRISB
        bsf TRISA,1
        bsf TRISA,2
        bcf TRISC,TCLK
        BANK0

        call SETSTOP
        call SETSTART

        movlw %11010000   ; set RTC for write mode & wait ACK
        call RTCCLKOUT

        movlw %00000000
        call RTCCLKOUT    ; set RTC for address 0 & wait ACK
        movf CLKSEC,W
        call RTCCLKOUT    ; send secs to RTC & wait ACK
        movf CLKMIN,W
        call RTCCLKOUT    ; send mins to RTC & wait ACK
        movf CLKHRS,W
        call RTCCLKOUT    ; send hrs to RTC & wait ACK
        movf WKDAY,W
        call RTCCLKOUT    ; send wkday to RTC & wait ACK
        movf CLKDAY,W
        call RTCCLKOUT    ; send dateday to RTC & wait ACK
        movf MONTH,W
        call RTCCLKOUT    ; send month to RTC & wait ACK
        movf YEAR,W
        call RTCCLKOUT    ; send year to RTC & wait ACK
        call SETSTOP
        bsf PORTA,4

; ************* READ FROM RT CLOCK

READRTC: BANK1
        clrf TRISB
        clrf TRISC
        bsf TRISA,2
        bcf TRISC,TCLK
        BANK0

        call SETSTOP
        call SETSTART

        movlw %11010000   ; set RTC for write mode & wait ACK
        call RTCCLKOUT    ; 

        movlw %00000000
        call RTCCLKOUT    ; set RTC for address 0 & wait ACK 

        call SETSTOP

; 1 ****** WRITE TO SET RTC FOR READ MODE

        call SETSTART

        movlw %11010001   ; bit 0 = 1 direction read & wait ACK
        call RTCCLKOUT

; 4 *********** READ BYTES

        BANK1
        bsf TRISC,SDATA   ; SDATA as input
        BANK0

GETRTCVALUE:
        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 127
        movwf CLKSEC

        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 127
        movwf CLKMIN

        call RTCCLKREAD   ; read 1 byte
        call SENDACKREAD  ; send ACK
        movf STORE,W
        andlw 63
        movwf CLKHRS

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 7
        movwf WKDAY

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 63
        movwf CLKDAY

        call RTCCLKREAD    ; read 1 byte
        call SENDACKREAD   ; send ACK
        movf STORE,W
        andlw 31
        movwf MONTH

        call RTCCLKREAD    ; read 1 byte
        call SENDNOTACKREAD   ; send NOT-ACK
        movf STORE,W
        andlw 127
        movwf YEAR

        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        clrf TRISB
        bsf TRISA,1
        BANK0

        call LCD28
        movf CLKHRS,W
        call BIN2HEX
        movlw ':'
        call LCDOUT
        movf CLKMIN,W
        call BIN2HEX
        movlw ':'
        call LCDOUT
        movf CLKSEC,W
        call BIN2HEX
        movlw ' '
        call LCDOUT

        call SETTRIS
        return

; ********* RTC CLOCK OUT

RTCCLKOUT: movwf BYTEOUT
        movlw 8
        movwf LOOP

CLK1:   rlf BYTEOUT,F       ; MSB first
        bcf PORTC,SDATA     ; clear SDATA
        btfsc STATUS,C      ; is CARRY set ?
        bsf PORTC,SDATA     ; yes, set SDATA
        bsf PORTC,TCLK      ; clk up
        bcf PORTC,TCLK      ; clk down
        decfsz LOOP,F
        goto CLK1
        call WAITACKRTC
        return

; ******** WAIT ACK FROM RTC

WAITACKRTC: BANK1
        bsf TRISC,SDATA    ; SDATA as input
        BANK0
        bsf PORTC,TCLK     ; take clk high
wait1:  btfsc PORTC,SDATA  ; wait ACK
        goto WAIT1
        bcf PORTC,TCLK     ; take clk low

        BANK1
        bcf TRISC,SDATA    ; SDATA as output (with TCLK low)
        BANK0

        return

SENDACKREAD:
        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        BANK0
        bcf PORTC,SDATA    ; SDATA low as ACK
        bsf PORTC,TCLK     ; take clk high
        bcf PORTC,TCLK     ; take clk low
        BANK1
        bsf TRISC,SDATA    ; SDATA as input
        BANK0
        return

SENDNOTACKREAD:
        BANK1
        bcf TRISC,SDATA    ; SDATA as output
        BANK0
        bsf PORTC,SDATA    ; SDATA high as NOT-ACK
        bsf PORTC,TCLK     ; take clk high
        bcf PORTC,TCLK     ; take clk low
        BANK1
        bsf TRISC,SDATA   ; SDATA as input
        BANK0

        return

SETSTOP: bcf PORTC,SDATA  ; take data low while clk is low
        bsf PORTC,TCLK    ; take clk high while data is low
        bsf PORTC,SDATA   ; take data high while clk is high
        return

SETSTART:                 ; TCLK & SDATA assumed to be high
        bcf PORTC,SDATA   ; take data low while clk is high
        bcf PORTC,TCLK    ; take clk low while data is low
        return

RTCCLKREAD:
        clrf STORE
        movlw 8
        movwf LOOP

RTCREAD2: bsf PORTC,TCLK   ; TCLK high
        bcf STATUS,C
        rlf STORE,F
        btfsc PORTC,SDATA  ; get data bit
        bsf STORE,0
        bcf PORTC,TCLK     ; TCLK low
        decfsz LOOP,F
        goto RTCREAD2
        return

RECEIVETIME:
        BANK1
        clrf TRISB
        MOVLW %10000000
        MOVWF TRISC
        BANK0

; 'T' has been received - Confirm ready state back to PC
        movlw   'R'
        call    TxByte

        call TIMEX
        movwf CLKSEC
        call    TxByte

        call TIMEX
        movwf CLKMIN
        call    TxByte

        call TIMEX
        movwf CLKHRS
        call    TxByte

        call TIMEX           
        movwf WKDAY
        call    TxByte

        call TIMEX
        movwf CLKDAY
        call    TxByte

        call TIMEX
        movwf MONTH
        call    TxByte

        call TIMEX
        movwf YEAR
        call    TxByte

        call TIMEX
        movwf SWITCHDELAYON
        movwf PROMVAL
        movlw 3
        call SETPRM
        call    TxByte

        call RTCLOCK
        call SHOWTOPLINE
        movf PATIENTNO,W
        movwf REGA0
        call LCD5
        call SHOWLCD

        movf PAINLEVEL,W
        movwf REGA0
        call LCD14
        call SHOWLCD
        goto MAIN

TIMEX:  btfss   PIR1,RCIF       ; Check for any RX'd data
        goto TIMEX              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

SHOWBC: BANK1
        clrf TRISB
        bsf TRISA,2
        BANK0

        movf EVENT2,W
        movwf REGA0
        call LCD21
        movlw 'B'
        call LCDOUT
        call SHOWLCD
        movf EVENT3,W
        movwf REGA0
        movlw ' '
        call LCDOUT
        movlw 'C'
        call LCDOUT
        call SHOWLCD
        movlw ' '
        call LCDOUT

        call READRTC        ; show time
        return

SHOWWAIT: clrf LOOP
         call LCD21
SHOWMSGW: movf LOOP,W
         call MESSAG6       ; WAIT FOR LIGHT message
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGW
         return

STORELATEST:
        movf WADDRL,W       ; temp store current write address
        movwf WADDRLSTORE
        movf WADDRH,W
        movwf WADDRHSTORE

        bcf STATUS,C
        rlf PATIENTNO,W     ; multiply x 2 
        movwf WADDRL
        movlw $FE
        movwf WADDRH

        movf PATIENTNO,W
        movwf MEMHI
        movf PAINLEVEL,W    ; store to external serial EEPROM chip to $7Exx
        movwf MEMLO
        call SAVESAMPLE

        bcf STATUS,C
        rlf PATIENTNO,W     ; multiply x 2 
        movwf WADDRL
        movlw $FF
        movwf WADDRH
        movf EVENT2,W    ; store to external serial EEPROM chip to $7Fxx
        movwf MEMHI
        movf EVENT3,W
        movwf MEMLO
        call SAVESAMPLE

        movf WADDRLSTORE,W
        movwf WADDRL       ; restore current write address
        movf WADDRHSTORE,W
        movwf WADDRH
        call SHOWCOUNT
        return

CHECKADR:
        movf WADDRL,W
        btfss STATUS,Z     ; address = $7E00?
        return
        movf WADDRH,W
        xorlw $7E
        btfsc STATUS,Z     ; address = $7E00?
        clrf WADDRH        ; yes, so clear WADDRH and rollover to zero
        return

RECALLEVENTS:

        bcf STATUS,C
        rlf PATIENTNO,W     ; multiply x 2 
        movwf RADDRL
        movlw $FE
        movwf RADDRH

        call READ
        movf MEMLO,W
        movwf PAINLEVEL

        bcf STATUS,C
        rlf PATIENTNO,W     ; multiply x 2 
        movwf RADDRL
        movlw $FF
        movwf RADDRH

        call READ
        movf MEMHI,W
        movwf EVENT2
        movf MEMLO,W
        movwf EVENT3
        return

SHOWPATIENT:    movf PATIENTNO,W
                movwf REGA0
                clrf REGA1
                clrf REGA2
                clrf REGA3
                call BIN2DEC
                call LCD5
                call SHOW9
                clrf SWITCHLSB
                return

SHOWPAIN:       movf PAINLEVEL,W
                movwf REGA0
                clrf REGA1
                clrf REGA2
                clrf REGA3
                call BIN2DEC
                call LCD14
                call SHOW9
		return

        ORG $2100

        DE 0,0,0,0,0,0,0,0,0

	END
