;TOOLKIT.J EPE PIC16C84 PROGRAMMER 22FEB98 - COPYRIGHT JOHN BECKER
;WRITTEN FOR REGISTERED COPY OF A86/D86 ASSEMBER/DISASSEMBLER

;[si+0]       ;route
;[si+2]       ;temp timing store
;[si+4]       ;delay10 timing value
;[si+6]       ;delay1 timing value
;[si+8]       ;working store for delays
;[si+10]      ;byte% value
;[si+12]      ;value being send
;[si+14]      ;counter for sending byte
;[si+20]      ;varseg(a$)
;[si+22]      ;len(a$)
;[si+26]      ;varptr for a$ + counter for config
;[si+28]      ;counter for disassemble byte
;[si+30]      ;misc counter
;[si+32]      ;verify error count
;[si+34]      ;verify flag
;[si+36]      ;printer port output register address
;[si+38]      ;printer port input register address

;[si+40]      ;counter for MPASM send conversion store to [+100 etc]
;[si+42]      ;another counter
;[si+44]      ;counter for max number of bytes used in MPASM hex to TASM obj

;[+100 to +1124] mpasm hex split destination

START:
push ds               ;set segment
mov ds,01111          ;value changed from Basic: varseg(ma%(0))

mov si,0
cmp [si][w],0
ja RA1
call route0           ;configure PIC16C84
jmp EXOD

RA1:
cmp [si][w],1
ja RA2
call route1          ;program PIC from TASM binary file
jmp EXOD

RA2:
cmp [si][w],2
ja RA3
call route2          ;disassemble PIC16C84 byte values - part 1
jmp EXOD

RA3:
cmp [si][w],3
ja RA4
call route3          ;disassemble PIC16C84 byte values - part 2
jmp EXOD

RA4:
cmp [si][w],4
ja RA5
jmp EXOD              ;ma%(0) = 4 route not used

RA5:
cmp [si][w],5
ja RA6
call route5          ;program PIC from MPASM hex code
jmp EXOD

RA6:
cmp [si][w],6
ja EXOD
call route5           ;convert MPASM hex code to TASM binary

EXOD:                 ;final exit point
pop ds
retf

;...........

route0:               ;CONFIGURE PIC16C84
call gettiming

r0:
mov [si+12][w],0      ;$000000 advise next 16 bits are config data
mov [si+14][w],6      ;bit counter = 6
call sendit
mov bx,[si+10]       ;get configuration byte
mov [si+12],bx        ;move it into byte to be sent to store
shl [si+12][w],1      ;multiply it by 2
mov [si+14][w],9      ;set byte length counter = 9
call sendit
mov [si+12][w],63     ;$0111111 clearance code
mov [si+14][w],7     ;bit counter = 7
call sendit
mov [si+26][w],7      ;loop value

configloop:
mov [si+12][w],6      ;$000110 step address
mov [si+14][w],6     ;bit counter = 6
call sendit
dec [si+26][w]
jnz configloop

mov [si+12][w],1      ;$000001 code protect disable command
mov [si+14][w],6     ;bit counter = 6
call sendit
mov [si+12][w],7      ;$000111 code protect disable continued
mov [si+14][w],6     ;bit counter = 6
call sendit
mov [si+12][w],8      ;$001000 code protect disable continued
mov [si+14][w],6     ;bit counter = 6
call sendit
mov ax,[si+4]         ;10ms delay factor
mov [si+8],ax
call delay
mov [si+12][w],1      ;$000001 code protect disable command
mov [si+14][w],6     ;bit counter = 6
call sendit
mov [si+12][w],7      ;$000111 code protect disable continued
mov [si+14][w],6     ;bit counter = 6
call sendit
ret

;.........

route1:               ;program PIC with TASM binary file
push [si+22]          ;store len A$
call gettiming
mov di,[si+26]        ;set VARPTR for a$

r1:
mov ax,[si+20]        ;set VARSEG for a$
push ds
mov ds,ax
mov bh,[di]           ;get a$ high bit
mov bl,[di+1]         ;get a$ low bit
pop ds
mov [si+10],bx        ;store a$ val
inc di
inc di
                      ;send byte to PIC
mov [si+12][w],2      ;$000010
mov [si+14][w],6      ;bit counter = 6
call sendit
mov bx,[si+10]       ;recall a$ byte
mov [si+12],bx        ;move it into byte to be sent to store
shl [si+12][w],1      ;multiply it by 2

mov [si+14][w],16     ;set byte length counter
call sendit
mov [si+12][w],8      ;$001000
mov [si+14][w],6     ;bit counter = 6
call sendit
mov ax,[si+4]
mov [si+8],ax
call delay            ;10ms delay
mov [si+12][w],6      ;$000110
mov [si+14][w],6
call sendit

dec [si+22][w]
jnz r1
pop [si+22]           ;recall len a$
cmp [si+34][w],1      ;is verify needed?
jne R11               ;no
call verify           ;yes
R11:
ret

;..........

verify:
mov [si+32][w],0      ;reset error counter
mov ax,[si+4]
mov [si+8],ax
call delay            ;10ms delay
mov dx,[si+36]        ;reset PIC
mov al,16
or al,8
out dx,al
mov ax,[si+4]
mov [si+8],ax
call delay
mov dx,[si+36]
mov al,16
out dx,al
mov di,[si+26]        ;set VARPTR for a$

v1:
call route2           ;get PIC byte
jmp v4
v3:
call route3
v4:

mov ax,[si+20]        ;set VARSEG for a$
mov cx,[si+10]
shr cx,1
push ds
mov ds,ax
mov bh,[di]           ;get a$ high bit
mov bl,[di+1]         ;get a$ low bit
mov [di],cx
pop ds
cmp cx,bx             ;compare a$ val with val in PIC
je v2
inc [si+32][w]
v2:
inc di
inc di
dec [si+22][w]
jnz v3
ret

;.........

sendit:
mov dx,[si+36]
mov ax,[si+12]
and ax,1
or ax,16
push ax
or ax,2
out dx,al
mov ax,[si+6]
mov [si+8],ax
call delay
mov dx,[si+36]
pop ax
out dx,al
ror [si+12][w],1
dec [si+14][w]
jnz sendit
ret

;.......

gettiming:
mov [si+4][w],0  ;reset counter
mov ah,00
int 1AH
mov [si+2],dx    ;get current time val

timinga:
mov ah,00
int 1AH
cmp dx,[si+2]
je timinga       ;allow current time val period to complete
mov [si+2],dx

timing:          ;get count for one complete time period
inc [si+4][w]
mov ah,00
int 1AH
cmp dx,[si+2]
je timing

divide5:
mov bx,5         ;divide by 5 for long (10ms) delay
mov dx,0         ;set remainder location to 0
mov ax,[si+4]    ;move count into ax for division
div bx           ;divide ax/bx (answer in ax, remainder in dx, not used)
mov [si+4],ax    ;put answer into [si+4]

divide1000:
mov bx,10000     ;divide by 10000 for short delay approx 1 microsecond
mov dx,0         ;set remainder location to 0
mov ax,[si+4]    ;move count into ax for division
div bx           ;divide ax/bx (answer in ax, remainder in dx, not used)
mov [si+6],ax    ;put answer into [si+6]
cmp ax,0
ja enddiv
mov [si+6][w],1  ;if answer = 0 then set it to 1
enddiv:
ret

delay:
mov ah,0
int 1AH
dec [si+8][w]
jnz delay
ret

;..........

getbit:
mov dx,[si+36]
mov ax,16
or ax,2
out dx,al
mov ax,[si+6]
mov [si+8],ax
push dx
call delay
pop dx
mov ax,16
out dx,al
mov ax,[si+6]
mov [si+8],ax
call delay
mov dx,[si+38]
in al,dx
and al,64
cmp al,0
je getbit1
or [si+10],32768
getbit1:
ret

;...........

route2:               ;disassemble PIC16C84 value
call gettiming

route3:
mov [si+12][w],4      ;$000100 read data command
mov [si+14][w],6      ;bit counter = 6
call sendit
mov [si+30][w],16

R21:
shr [si+10][w],1
call getbit
dec [si+30][b]
jnz R21

mov [si+12][w],8      ;$001000 prog accept command
mov [si+14][w],6      ;bit counter = 6
call sendit
mov [si+12][w],6      ;$000110 step address
mov [si+14][w],6      ;bit counter = 6
call sendit
ret

;..........

route5:               ;program PIC with MPASM hex file
mov cx,[si+22]        ;get len(a$)
mov di,[si+26]        ;set VARPTR for a$
mov [si+40],si        ;add 100 to si for [si+100 etc]
add [si+40][w],100
mov [si+42][w],0      ;counter
mov [si+44][w],0      ;max byte counter

mov bx,2048
r5a:                  ;reset ma%(x) storage bytes
mov [si+40+bx][b],0
dec bx
jnz r5a

r5:
mov ax,[si+20]        ;set VARSEG for a$
push ds
mov ds,ax

converthex:           ;convert each a$ byte from hex to decimal value
mov al,[di]
cmp al,48
jb cvnext
sub al,48
cmp al,10
jb storecv
sub al,7

storecv:
mov [di],al
cvnext:
inc di
dec cx
jnz converthex
pop ds

mov di,[si+26]        ;set VARPTR for a$
mov ax,[si+20]        ;set VARSEG for a$
push ds
mov ds,ax

r51:                  
mov ah,[di+3]         ;get MS address val from a$
shl ah,1              ;i.e. PIC location address
shl ah,1
shl ah,1
shl ah,1
or ah,[di+4]
mov al,[di+5]         ;get LS address val from a$
shl al,1
shl al,1
shl al,1
shl al,1
or al,[di+6]
cmp ax,2044            ;...1022  *** 29FEB98
ja endr5

add ax,100
pop ds

mov [si+40],ax        ;set address for ma%(x) next storage byte
push ds
mov ds,[si+20]        ;set ds for a$
                      
                      ;get byte quantity for a$ section
mov ch,0              ;i.e. number of bytes in line
mov cl,[di+1]
shl cl,1
shl cl,1
shl cl,1
shl cl,1
or cl,[di+2]
cmp cl,0
je endr5
shr cx,1              ;divide count by 2

mov bx,9              ;set displacement for a$ byte position

R52:
mov ah,[di+bx]        ;get MS byte val from a$
shl ah,1
shl ah,1
shl ah,1
shl ah,1
inc bx
or ah,[di+bx]
inc bx
mov al,[di+bx]        ;get LS byte val from a$
shl al,1
shl al,1
shl al,1
shl al,1
inc bx
or al,[di+bx]
inc bx

pop ds
push bx
mov bx,[si+40]
mov [bx],ax
inc [si+40][w]
inc [si+40][w]
inc [si+42][w]
inc [si+42][w]

mov bx,[si+40]        ;is current count > max count?
cmp bx,[si+44]
jb R53                ;no
mov [si+44],bx        ;yes, so store it

R53:
pop bx
push ds
mov ds,[si+20]
dec cx
jnz R52
cmp [di+8][b],1       ;is this the final line of a$?
je endr5              ;yes
add bx,4              ;no, so repeat for next line
add di,bx
jmp R51

endr5:
pop ds

dec [si+42][w]
dec [si+42][w]

mov [si+20],ds        ;varseg for ma%(0) 
mov [si+26],si        ;start address for byte storage area
add [si+26][w],100    ;add displacement

mov ax,[si+44]        ;get total number of bytes converted
sub ax,100            ;subtract 100 .... xxx
mov [si+44],ax        ;amend si+44 ...xxxx
shr ax,1              ;divide by 2 .....xxx
mov [si+22],ax        ;store as number of bytes (length) to be sent


mov [si+100][b],40    ;add jump-to-5 command at head of code
mov [si+101][b],5

cmp [si][w],5         ;is programming needed?
ja v5                 ;no, data is for translation file only
call route1           ;yes
v5:
ret


