	NOLIST 
;Macros to add and subtract values, 16 bit. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Without instructions like 
;	add with carry 
;and 
;	subtract with carry, 
;multiple precision needs a little cunning 
;to get the carry right. 

;The following routines are based on 
;the Microchip application note AN617. 

;Warning! 
;These macros are crafted to get C right, 
;but Z reflects only the high byte of the result. 
;To get Z right for both bytes of the result, 
;these macros should be followed by: 
;	movf Var2,w 
;	xorwf Var2+1,w 

;Curiously, because the incfsz instruction does not have 
;an equivalent when the argument is a constant, 
;the macro for constant + variable is more complicated 
;than that for variable + variable. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;AddKV16 Add constant to variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

AddKV16 MACRO Konstant,Var2 

	if (HIGH Konstant) != 0xFF 

	movlw LOW Konstant 
	addwf Var2+1,f 
	movlw HIGH Konstant 
	btfsc STATUS,C 
	movlw HIGH Konstant+1 
	addwf Var2,f 

	else 

	movlw LOW Konstant 
	addwf Var2+1,f 
	movlw HIGH Konstant 
	btfsc STATUS,C 
	addwf Var2,f 

	endif 

	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;AddVV16 Add variable to variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

AddVV16 MACRO Var1,Var2 

	movf Var1+1,w 
	addwf Var2+1,f 
	movf Var1,w 
	btfsc STATUS,C 
	incfsz Var1,w 
	addwf Var2,f 

	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;SubKV16 Subtract constant from variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

SubKV16 MACRO Konstant,Var2 

	if (HIGH Konstant) != 0xFF 

	movlw LOW Konstant 
	subwf Var2+1,f 
	movlw HIGH Konstant 
	btfss STATUS,C 
	movlw HIGH Konstant+1 
	subwf Var2,f 

	else 

	movlw LOW Konstant 
	subwf Var2+1,f 
	movlw HIGH Konstant 
	btfss STATUS,C 
	subwf Var2,f 

	endif 

	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;SubVV16 Subtract variable from variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

SubVV16 MACRO Var1,Var2 

	movf Var1+1,w 
	subwf Var2+1,f 
	movf Var1,w 
	btfss STATUS,C 
	incfsz Var1,w 
	subwf Var2,f 

	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;AbsV16 Absolute variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

AbsV16 MACRO Var 
	LOCAL Abs190

	btfss Var,7
	goto Abs190

	comf Var,f
	comf Var+1,f
	movlw 1
	addwf Var+1,f
	btfsc STATUS,C
	addwf Var,f

Abs190

	ENDM

;****** ******* ******* ******* ******* ******* ******* *** * 
;NegV16 Negate variable, 16 bit 
;------ ------- ------- ------- ------- ------- ------- --- - 

NegV16 MACRO Var 

	comf Var,f
	comf Var+1,f
	movlw 1
	addwf Var+1,f
	btfsc STATUS,C
	addwf Var,f

	ENDM

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 




