	NOLIST 
;General conditional macros, 16 bit. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 - Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

;Signed comparisons on the PIC are a bit 
;counterintuitive and it is handy to have macros 
;to get the code right every time. 

;Well, most of the time. 

;Curiously EQ and NE are more difficult to implement 
;than LT, LE, GE, GT. 
;They are included below to be complete, 
;but in practice, it will usually be easy and 
;more efficient to implement these tests explicitly.

;****** ******* ******* ******* ******* ******* ******* *** * 
;EXPLANATION 
;------ ------- ------- ------- ------- ------- ------- --- - 

;It is essential to include the file: 
;	IfMnemonics.asm 
;as well as this file. 

;That file also explains how the macros 
;are intended to be used. 

;****** ******* ******* ******* ******* ******* ******* *** * 
;IfVK16 
;------ ------- ------- ------- ------- ------- ------- --- - 

IfVK16 MACRO Var1,Cf,Konstant 
	IF Cf==LT 
	movlw LOW Konstant 
	subwf Var1+1,w 
	movlw HIGH Konstant 
	btfss STATUS,C 
	addlw 1 
	subwf Var1,w 
	btfss STATUS,C 
	ENDIF 
	IF Cf==LE 
	movf Var1+1,w 
	sublw LOW Konstant 
	movf Var1,w 
	btfss STATUS,C 
	addlw 1 
	sublw HIGH Konstant 
	btfsc STATUS,C 
	ENDIF 
	IF Cf==GE 
	movlw LOW Konstant 
	subwf Var1+1,w 
	movlw HIGH Konstant 
	btfss STATUS,C 
	addlw 1 
	subwf Var1,w 
	btfsc STATUS,C 
	ENDIF 
	IF Cf==GT 
	movf Var1+1,w 
	sublw LOW Konstant 
	movf Var1,w 
	btfss STATUS,C 
	addlw 1 
	sublw HIGH Konstant 
	btfss STATUS,C 
	ENDIF 
	IF Cf==EQ 
	bcf STATUS,C
	movf Var1+1,w
	xorlw LOW Konstant 
	btfsc STATUS,Z
	bsf STATUS,C
	movf Var1,w
	xorlw HIGH Konstant 
	btfsc STATUS,Z
	bsf STATUS,C
	btfsc STATUS,C
	ENDIF 
	IF Cf==NE 
	bcf STATUS,C
	movf Var1+1,w
	xorlw LOW Konstant 
	btfsc STATUS,Z
	bsf STATUS,C
	movf Var1,w
	xorlw HIGH Konstant 
	btfsc STATUS,Z
	bsf STATUS,C
	btfss STATUS,C
	ENDIF 
	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;IfVV16 
;------ ------- ------- ------- ------- ------- ------- --- - 

IfVV16 MACRO Var1,Cf,Var2 
	IF Cf==LT 
	movf Var2+1,w 
	subwf Var1+1,w 
	movf Var2,w 
	btfss STATUS,C 
	addlw 1 
	subwf Var1,w 
	btfss STATUS,C 
	ENDIF 
	IF Cf==LE 
	movf Var1+1,w 
	subwf Var2+1,w 
	movf Var1,w 
	btfss STATUS,C 
	addlw 1 
	subwf Var2,w 
	btfsc STATUS,C 
	ENDIF 
	IF Cf==GE 
	movf Var2+1,w 
	subwf Var1+1,w 
	movf Var2,w 
	btfss STATUS,C 
	addlw 1 
	subwf Var1,w 
	btfsc STATUS,C 
	ENDIF 
	IF Cf==GT 
	movf Var1+1,w 
	subwf Var2+1,w 
	movf Var1,w 
	btfss STATUS,C 
	addlw 1 
	subwf Var2,w 
	btfss STATUS,C 
	ENDIF 
	IF Cf==EQ 
	bcf STATUS,C
	movf Var1+1,w
	xorwf Var2+1,w 
	btfsc STATUS,Z
	bsf STATUS,C
	movf Var1,w
	xorwf Var2,w 
	btfsc STATUS,Z
	bsf STATUS,C
	btfsc STATUS,C
	ENDIF 
	IF Cf==NE 
	bcf STATUS,C
	movf Var1+1,w
	xorwf Var2+1,w 
	btfsc STATUS,Z
	bsf STATUS,C
	movf Var1,w
	xorwf Var2,w 
	btfsc STATUS,Z
	bsf STATUS,C
	btfss STATUS,C
	ENDIF 
	ENDM 

;****** ******* ******* ******* ******* ******* ******* *** * 
;COPYRIGHT (C) 2005 - Keith Anderson 
;------ ------- ------- ------- ------- ------- ------- --- - 

	LIST 



