; EPE Pic 'n Mix - August 2004
; Andrew Jarvis
; pnm0804_timer1.asm v1.0
; 02 June 2004
;
; Example code to demonstrate 'Hello World' using Timer1
; Uses a PIC16F628 with internal 4MHz oscillator
; Produces flashing LED pattern on RB4 (pin 10)

	list p=PIC16f628,r=hex
	#include <p16f628.inc>
	errorlevel  -302	; suppress message 302, warning about ensuring correct bank bits

	__CONFIG   _INTRC_OSC_NOCLKOUT & _WDT_OFF & _PWRTE_ON & _BODEN_OFF & _MCLRE_OFF & _LVP_OFF & _DATA_CP_OFF & _CP_OFF  
	
	org 0			; reset vector
	goto start
	org 4			; interrupt vector
	
	; note - usual interrupt service routine handling procedures
	; omitted for clarity in this simple example.

	bcf PIR1, TMR1IF	; clear the TMR1 overflow interrupt flag
	movlw 0x10
	xorwf PORTB, F		; toggle PORTB<4>
	retfie			; exit isr

start
	banksel TRISB		; Bank 1
	clrf TRISB		; set PORTB as outputs

	movlw b'00000001'	; enable TMR1 overflow interrupt
	movwf PIE1

	banksel T1CON		; Bank 0
	movlw b'00110001'	; TMR1 prescale value 1:8, Timer1 on
	movwf T1CON

	clrf PORTB		; reset PORTB
	movlw b'11000000'	; enable global and peripheral interrupts
	movwf INTCON

	; do nothing, interrupt service routine will do all the work :-)
main	goto main

	end
	
