;*****************************************************************************        
;
;   Module:     main.asm
;               
;   Author:     Mike Hibbett, mike.hibbett@gmail.com
;                                                                  
;   Version:    1.0 10/09/07                                                  
;
;               Demonstrates the 1-wire driver features
;
;*****************************************************************************
#include P16F917.inc

	extern  delay5us
	extern  init1wireHw, reset1wire
	extern  write8wire, read8wire
	
	
	UDATA	
	
; buff0 - buff7 will hold the device type, 48 bit ID and 8 bit CRC
buff0	RES	1
buff1	RES	1
buff2	RES	1
buff3	RES	1
buff4	RES	1
buff5	RES	1
buff6	RES	1
buff7	RES	1
	
	
;*****************************************************************************        
;
;   Function :  Reset vector
;               Hardware entry point to the code
;               When the processor powers up, this is always the first 
;               location executed.
;
;   Input:      None.
;
;   Output:     N/A
;
;*****************************************************************************        
RESET	CODE 0x00
	
	goto	main
	
	
	CODE
	
	
;*****************************************************************************        
;
;   Function :  main
;               This function performs the top level 'application' of the 
;               program, which involves resetting the bus and looking for
;               a single 1-wire device on the bus. It stores the devices
;               unique id in the variables buff0 - buff7, which can be viewed
;               in the debugger.
;               
;   Input:      None
;
;   Output:     None
;
;*****************************************************************************        
main	
	; First, set the CPU to run at 8MHz. We have already defined the clock source
	; to be INTOSC in the CONFIG register ( in the MPLAB settings ), but we must set
	; OSCCON to run at 8MHz.
	bsf		STATUS,RP0
	bcf		STATUS,RP1
	movlw	0x71
	movwf	OSCCON
	bcf		STATUS,RP0
	bcf		STATUS,RP1
	
	; Initialise the I/O ports as required by the 1-wire 'driver' software
	call	init1wireHw
	
doreset	
	call	reset1wire
	btfsc	STATUS, Z
	goto	nodevice		; No devices detected
	
present
	nop	
	
	; Send the command to read the ROM ID
	movlw	0x33
	call	write8wire
	
	; Read the device type byte...
	call	read8wire
	movwf	buff0
	
	; Read the 48 bit device ID...
	call	read8wire
	movwf	buff1
	call	read8wire
	movwf	buff2
	call	read8wire
	movwf	buff3
	call	read8wire
	movwf	buff4
	call	read8wire
	movwf	buff5
	call	read8wire
	movwf	buff6
	
	; Read the 8 bit check byte 
	call	read8wire
	movwf	buff7
	
; Just stop now.
appEnd	
	goto	appEnd
	
; If no device was detected, just loop round and look again	
nodevice
	nop
	goto	doreset

	
	END
	