;*****************************************************************************        
;
;   Module:     interrupts.inc
;               
;   Author:     Mike Hibbett, mikehibbett@oceanfree.net 
;                                                                  
;   Version:    1.0 11/10/05                                              
;
;               The re-mapped interrupt routines. This file will start at
;               0x608 and MUST not be moved. The first piece of code MUST be
;               IntVecHigh. If you do not use interrupts, you may remove the
;               code from here to save space, or just leave the code as is.
;               If interrupts are not enabled, then the code will not be called. 
;
;
;*****************************************************************************        


;*****************************************************************************        
;
;   Function :  IntVecHigh
;               The re-mapped fast interrupt vector goes here, at 0x608
;
;   Input:      None.
;
;   Output:     Using the FAST directive to update registers automatically
;
;*****************************************************************************        
IntVecHigh
    reset           ; This interrupt is not used - so cause a reset if it 
    retfie  FAST    ; gets called.
    

;*****************************************************************************        
;
;   Function :  UserIntVecLow
;               Low level interrupt handler
;
;   Input:      None.
;
;   Output:     MUST not use FAST return directive, since the high level 
;               interrupt uses this.
;
;*****************************************************************************        
UserIntVecLow
    reset           ; This interrupt is not used - so cause a reset if it 
    retfie          ; gets called.


