VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form frmMain 
   Caption         =   "EPE Hex File Viewer"
   ClientHeight    =   6195
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   8400
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   6195
   ScaleWidth      =   8400
   StartUpPosition =   3  'Windows Default
   Begin RichTextLib.RichTextBox classicView 
      Height          =   975
      Left            =   0
      TabIndex        =   2
      Top             =   3000
      Width           =   735
      _ExtentX        =   1296
      _ExtentY        =   1720
      _Version        =   393217
      ScrollBars      =   2
      TextRTF         =   $"frmHexView.frx":0000
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSComctlLib.TabStrip viewSelect 
      Height          =   375
      Left            =   0
      TabIndex        =   1
      Top             =   2520
      Width           =   1935
      _ExtentX        =   3413
      _ExtentY        =   661
      Style           =   1
      Placement       =   1
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   2
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Split"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Classic"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.ImageList recordListImages 
      Left            =   840
      Top             =   3000
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   16777215
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   2
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmHexView.frx":00EC
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmHexView.frx":0200
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComDlg.CommonDialog commonDialog 
      Left            =   1560
      Top             =   3000
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      Filter          =   "Hex Files (*.hex)|*.hex"
      Flags           =   6144
      InitDir         =   ".\"
   End
   Begin MSComctlLib.ListView recordList 
      Height          =   2295
      Left            =   0
      TabIndex        =   0
      Top             =   120
      Width           =   8295
      _ExtentX        =   14631
      _ExtentY        =   4048
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   393217
      SmallIcons      =   "recordListImages"
      ForeColor       =   -2147483640
      BackColor       =   16777215
      Appearance      =   1
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Tahoma"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      NumItems        =   6
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Record"
         Object.Width           =   1411
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "Type"
         Object.Width           =   1235
      EndProperty
      BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   2
         SubItemIndex    =   2
         Text            =   "Bytes"
         Object.Width           =   1235
      EndProperty
      BeginProperty ColumnHeader(4) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   2
         SubItemIndex    =   3
         Text            =   "Address"
         Object.Width           =   1587
      EndProperty
      BeginProperty ColumnHeader(5) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   4
         Text            =   "Data"
         Object.Width           =   6526
      EndProperty
      BeginProperty ColumnHeader(6) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Alignment       =   2
         SubItemIndex    =   5
         Text            =   "Checksum"
         Object.Width           =   1941
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuOpen 
         Caption         =   "Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuRepair 
         Caption         =   "Repair"
         Enabled         =   0   'False
         Shortcut        =   ^R
      End
      Begin VB.Menu mnuExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "About..."
         Shortcut        =   {F1}
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' EPE Hex File Viewer
' Andrew Jarvis 08.08.04
'
' Revision History
' 08.08.04 Initial Revision
'

'force explicit variable declarations
Option Explicit

'hex file record constants
Private Const DATA_RECORD = 0
Private Const END_RECORD = 1
Private Const SEGMENT_RECORD = 2
Private Const START_SEGMENT_RECORD = 3
Private Const LINEAR_RECORD = 4
Private Const START_LINEAR_RECORD = 5

'view selection
Private Const RECORD_VIEW = 1

'line delimiters within the rich text control
Private delimiters As String
'current position of line within text
Private LineStart As Long
Private LineEnd As Long
Private LineText As String

'colours that are used to alternate through the data column
Private colour1 As Long
Private colour2 As Long

' reference to an external procedure needed from the Win32 API
Private Declare Sub RtlMoveMemory Lib "KERNEL32" (destination As Any, source As Any, ByVal bytes As Long)
Private Sub Form_Load()

    Dim cmdLine As String

    'initialise colour1 to light blue
    colour1 = RGB(128, 128, 255)
    'initialise colour2 to dark blue
    colour2 = RGB(91, 53, 253)
    'initialise delimiters to CR/LF
    delimiters = Chr$(13) & Chr$(10)

    ' size the main window to the width of the record list
    Width = recordList.Width
    ' disable the text view
    classicView.Visible = False
    
    'were we started from the command line?
    cmdLine = Command()
    If (Len(cmdLine) > 0) Then
        'assume yes - but with no validation.
        'open the command line target as a hex file
        OpenHexFile cmdLine
    End If
    
End Sub

Private Sub Form_OLEGiveFeedback(Effect As Long, DefaultCursors As Boolean)

End Sub

Private Sub Form_Resize()

    If ScaleHeight <> 0 Then
        'position the recordlist within the main window
        recordList.Move ScaleLeft, ScaleTop, ScaleWidth, ScaleHeight - viewSelect.Height
        'position the text view within the main window
        classicView.Move ScaleLeft, ScaleTop, ScaleWidth, ScaleHeight - viewSelect.Height
        'positio the tabstrip
        viewSelect.Top = ScaleTop + ScaleHeight - viewSelect.Height
    End If
    
End Sub
Private Sub mnuExit_Click()

    'exit the program
    Unload Me

End Sub
Private Sub mnuOpen_Click()

    'set the caption
    commonDialog.DialogTitle = "Open Hex File"
    'handle the common dialog for locating and choosing a file
    commonDialog.FileName = ""
    'select OpenFile action
    commonDialog.ShowOpen
    'only proceed if file selected
    If Len(commonDialog.FileName) <> 0 Then
        'load the hex file
        OpenHexFile commonDialog.FileName
    End If
    
End Sub
Private Sub mnuRepair_Click()
    
    'set the caption
    commonDialog.DialogTitle = "Save Hex File"
    'handle the common dialog for saving a file
    commonDialog.FileName = ""
    'select OpenFile action
    commonDialog.ShowSave
    'only proceed if file selected
    If Len(commonDialog.FileName) <> 0 Then
        'save the repaired hex file
        RepairHexFile commonDialog.FileName
    End If

End Sub
Private Sub viewSelect_Click()

    If viewSelect.SelectedItem.Index = RECORD_VIEW Then
        'if the currennt view selected is the record view
        'then switch to classic view
        classicView.Visible = False
        recordList.Visible = True
    Else
        'and vice versa
        classicView.Visible = True
        recordList.Visible = False
    End If
   
End Sub
Private Sub OpenHexFile(ByVal fname As String)

    Dim recordNumber As Integer
    Dim recordLine As String
    Dim newRecord As ListItem
    Dim lastRecord As ListItem
    Dim dataColour As Long
    Dim prevAddr As Long
        
    'initialise per-hexfile vars
    recordList.ListItems.Clear
    classicView.Text = ""
    recordNumber = 1
    mnuRepair.Enabled = False
    LineStart = 1
    prevAddr = 0
    dataColour = colour1
    
    'load the given hex file
    classicView.LoadFile fname
    LineText = classicView.Text
    
    'refresh the caption
    Caption = fname & " - EPE Hex File Viewer"
    
    'parse one record at a time
    recordLine = NextLine
    Do Until recordLine = ""
        'look for the record mark
        If Left$(recordLine, 1) = ":" Then
        
           ' create a new list item
            Set newRecord = recordList.ListItems.Add
            With newRecord
            
            ' record number
            .Text = recordNumber
            recordNumber = recordNumber + 1

            ' bytes
            .SubItems(2) = Val("&H" & Mid$(recordLine, 2, 2))

            ' address
            .SubItems(3) = Mid$(recordLine, 4, 4)
            
            If (recordNumber > 2) Then
                If (Val("&H" & .SubItems(3)) <> Val("&H" & lastRecord.SubItems(3)) + lastRecord.SubItems(2)) Then
                    If dataColour = colour2 Then
                        dataColour = colour1
                    Else
                        dataColour = colour2
                    End If
                End If
            End If
            prevAddr = Val("&H" & .SubItems(3))
            .ListSubItems.Item(3).ToolTipText = prevAddr
            
            ' data
            .SubItems(4) = Mid$(recordLine, 10, 2 * .SubItems(2))
            .ListSubItems.Item(4).ToolTipText = DataToolText(.SubItems(4))

            ' record type
            Select Case Val("&H" & Mid$(recordLine, 8, 2))
                Case DATA_RECORD
                    .SubItems(1) = "Data"
                    .ListSubItems.Item(1).ToolTipText = "Data Record"
                    .ListSubItems.Item(3).ForeColor = dataColour
                    .ListSubItems.Item(4).ForeColor = dataColour
                Case END_RECORD
                    .SubItems(1) = "End"
                    .ListSubItems.Item(1).ToolTipText = "End of File Record"
                Case SEGMENT_RECORD
                    .SubItems(1) = "Segment"
                    .ListSubItems.Item(1).ToolTipText = "Extended Segment Address Record"
                Case START_SEGMENT_RECORD
                    .SubItems(1) = "Start Segment"
                    .ListSubItems.Item(1).ToolTipText = "Start Segment Address Record"
                Case LINEAR_RECORD
                    .SubItems(1) = "Linear"
                    .ListSubItems.Item(1).ToolTipText = "Extended Linear Address Record"
                Case START_LINEAR_RECORD
                    .SubItems(1) = "Start Linear"
                    .ListSubItems.Item(1).ToolTipText = "Start Linear Address Record"
                Case Else
            End Select

            'checksum
            .SubItems(5) = Right$(recordLine, 2)
            If ChecksumValid(recordLine) Then
                .ListSubItems.Item(5).ForeColor = RGB(107, 165, 5)
                .ListSubItems.Item(5).ReportIcon = 1
            Else
                .ListSubItems.Item(5).ForeColor = vbRed
                .ListSubItems.Item(5).ReportIcon = 2
                mnuRepair.Enabled = True
            End If

            Set lastRecord = newRecord
            End With
            
        End If
        recordLine = NextLine
    Loop
    
End Sub
Private Sub RepairHexFile(ByVal fname As String)

    Dim chkExpected As Long
    Dim chkActual As Long
    Dim chkHex As String
    Dim newHex As String
    Dim recordLine As String
    
    LineStart = 1
    
    recordLine = NextLine
    Do Until recordLine = ""
    
        'get the checksums for each record
        CalcChecksums recordLine, chkExpected, chkActual
        If chkExpected <> chkActual Then
            'if they're different, effect a repair
            chkHex = Hex$(chkExpected)
            If Len(chkHex) = 1 Then chkHex = "0" & chkHex
            recordLine = Left$(recordLine, Len(recordLine) - 2) & chkHex
        End If
        
        newHex = newHex & recordLine & delimiters
        recordLine = NextLine
    Loop
    
    'save using given filename
    classicView.Text = newHex
    classicView.SaveFile fname, rtfText

    'load it back in
    OpenHexFile fname
End Sub
Private Function DataToolText(ByVal DataStr As String) As String

    Dim toolText As String
    Dim x As Integer
    
    toolText = ""
    'generate tooltip of viewable ASCII
    For x = 1 To Len(DataStr) Step 2
        toolText = toolText & " " & MakePrintable(Val("&H" & Mid$(DataStr, x, 2)))
    Next
    DataToolText = toolText
    
End Function
Private Function MakePrintable(ByVal charcode As Long) As String

    'check for charactercode within printable range
    If (charcode < 32 Or charcode > 126) Then
        charcode = 32
    End If
    MakePrintable = Chr$(charcode)
    
End Function
Private Function NextLine() As String
    
    'find the delimiters within the text
    LineEnd = InStr(LineStart, LineText, delimiters)
    
    If LineEnd = Null Or LineEnd = 0 Then
        'not found
        NextLine = ""
    Else
        'found  - extract the line
        NextLine = Mid$(LineText, LineStart, LineEnd - LineStart)
        LineStart = LineEnd + Len(delimiters)
    End If
    
End Function
Private Function ChecksumValid(ByVal Record As String) As Boolean

    Dim chkExpected As Long
    Dim chkActual As Long
    
    'simple wrapper to compare actual Vs expected checksum
    CalcChecksums Record, chkExpected, chkActual
    ChecksumValid = (chkExpected = chkActual)

End Function
Private Sub CalcChecksums(ByRef Record As String, ByRef chkExpected As Long, ByRef chkActual As Long)

    Dim x As Integer
    Dim chksumLSB As Byte

    'determine if checksum is correct
    chkExpected = 0
    For x = 2 To Len(Record) - 2 Step 2
        chkExpected = chkExpected + Val("&H" & Mid$(Record, x, 2))
    Next
    'get LSB
    RtlMoveMemory chksumLSB, chkExpected, 1
            
    If chksumLSB <> 0 Then
        '0 is a special case
        chkExpected = 256 - chksumLSB
    Else
        chkExpected = 0
    End If
    chkActual = Val("&H" & Mid$(Record, x, 2))
        
End Sub
