VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form MagnetometerFullGraph 
   Caption         =   "Magnetometer and Earth Resistivity Full Graph"
   ClientHeight    =   7590
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11880
   Icon            =   "MagnetometerFullGraph.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7590
   ScaleWidth      =   11880
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton Command1 
      BackColor       =   &H0000FF00&
      Caption         =   "Col/Black"
      Height          =   255
      Left            =   7200
      Style           =   1  'Graphical
      TabIndex        =   35
      Top             =   360
      Width           =   855
   End
   Begin VB.CommandButton ResetZoom 
      Caption         =   "R"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   480
      TabIndex        =   34
      ToolTipText     =   "Resets zoom value to default (zero)"
      Top             =   1320
      Width           =   375
   End
   Begin VB.CommandButton ResetPan 
      Caption         =   "R"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   480
      TabIndex        =   33
      ToolTipText     =   "Resets pan values to default (zero)"
      Top             =   480
      Width           =   375
   End
   Begin VB.CommandButton GPSvalues 
      BackColor       =   &H00FFFF00&
      Caption         =   "GPS Values"
      Height          =   255
      Left            =   8160
      Style           =   1  'Graphical
      TabIndex        =   32
      ToolTipText     =   "GPS values display on/off"
      Top             =   360
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.CommandButton Graph3D 
      BackColor       =   &H0000FF00&
      Caption         =   "3D Graph"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   30
      ToolTipText     =   "Calls up 3D Bargraph display"
      Top             =   3000
      Width           =   1095
   End
   Begin VB.CommandButton FullGraph 
      BackColor       =   &H0000FF00&
      Caption         =   "Full Graph"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   29
      ToolTipText     =   "Calls up Full Graph display"
      Top             =   2640
      Width           =   1095
   End
   Begin VB.CommandButton ZoomIt 
      Caption         =   "+"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   840
      Style           =   1  'Graphical
      TabIndex        =   28
      ToolTipText     =   "Zoom in (click Refresh to activate)"
      Top             =   1320
      Width           =   375
   End
   Begin VB.CommandButton ZoomIt 
      Caption         =   "-"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   120
      Picture         =   "MagnetometerFullGraph.frx":0442
      TabIndex        =   27
      ToolTipText     =   "Zoom out (click Refresh to activate)"
      Top             =   1320
      Width           =   375
   End
   Begin VB.CommandButton MoveIt 
      Height          =   375
      Index           =   3
      Left            =   120
      Picture         =   "MagnetometerFullGraph.frx":0884
      Style           =   1  'Graphical
      TabIndex        =   26
      ToolTipText     =   "Pan graph left (click Refresh to activate)"
      Top             =   480
      Width           =   375
   End
   Begin VB.CommandButton MoveIt 
      Height          =   375
      Index           =   2
      Left            =   480
      Picture         =   "MagnetometerFullGraph.frx":0CC6
      Style           =   1  'Graphical
      TabIndex        =   25
      ToolTipText     =   "Pan graph down (click Refresh to activate)"
      Top             =   840
      Width           =   375
   End
   Begin VB.CommandButton MoveIt 
      Height          =   375
      Index           =   1
      Left            =   840
      Picture         =   "MagnetometerFullGraph.frx":1108
      Style           =   1  'Graphical
      TabIndex        =   24
      ToolTipText     =   "Pan graph right (click Refresh to activate)"
      Top             =   480
      Width           =   375
   End
   Begin VB.CommandButton MoveIt 
      Height          =   375
      Index           =   0
      Left            =   480
      Picture         =   "MagnetometerFullGraph.frx":154A
      Style           =   1  'Graphical
      TabIndex        =   23
      ToolTipText     =   "Pan graph up (click Refresh to activate)"
      Top             =   120
      Width           =   375
   End
   Begin VB.CheckBox GridLines 
      Caption         =   "Grid lines"
      Height          =   255
      Left            =   6000
      TabIndex        =   22
      ToolTipText     =   "When ticked grid lines are drawn"
      Top             =   360
      Visible         =   0   'False
      Width           =   1095
   End
   Begin VB.PictureBox Picture1 
      Height          =   6615
      Left            =   1560
      ScaleHeight     =   6555
      ScaleWidth      =   10035
      TabIndex        =   21
      Top             =   720
      Width           =   10095
      Begin VB.ListBox GPSlist 
         Height          =   1815
         Left            =   3600
         TabIndex        =   31
         Top             =   120
         Visible         =   0   'False
         Width           =   6375
      End
   End
   Begin VB.CheckBox SelectOn 
      Caption         =   "Select On"
      Height          =   255
      Left            =   9240
      TabIndex        =   19
      ToolTipText     =   "When ticked row and column selections become valid"
      Top             =   0
      Width           =   1095
   End
   Begin VB.CommandButton SelectColumn 
      BackColor       =   &H0000FFFF&
      Caption         =   "Select Col/Row"
      Height          =   255
      Left            =   10320
      Style           =   1  'Graphical
      TabIndex        =   18
      ToolTipText     =   "Allows selective inclusion/exclusion of rows/columns"
      Top             =   0
      Width           =   1335
   End
   Begin VB.CheckBox Resist 
      Caption         =   "Current"
      Height          =   195
      Left            =   5040
      TabIndex        =   17
      ToolTipText     =   "Multiplies sample voltage by current value across TX probes"
      Top             =   360
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   2160
      TabIndex        =   15
      Text            =   "0"
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   0
      Width           =   975
   End
   Begin VB.CommandButton RefreshIt 
      BackColor       =   &H00FFFF00&
      Caption         =   "Refresh"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   6
      ToolTipText     =   "Click to implement correction changes"
      Top             =   3480
      Width           =   1095
   End
   Begin VB.CommandButton Fullgrid 
      BackColor       =   &H0000FF00&
      Caption         =   "Full Grid"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   12
      ToolTipText     =   "Calls up Full Grid display"
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton Main 
      BackColor       =   &H0000FFFF&
      Caption         =   "Main"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Return to main page"
      Top             =   1800
      Width           =   1095
   End
   Begin VB.CheckBox Rotate 
      Caption         =   "Vertical"
      Height          =   255
      Left            =   1560
      TabIndex        =   10
      ToolTipText     =   "Horizontal contours if unticked, vertical if ticked"
      Top             =   360
      Width           =   975
   End
   Begin VB.CheckBox Inverter 
      Caption         =   "Invert"
      Height          =   255
      Left            =   2640
      TabIndex        =   9
      ToolTipText     =   "When ticked sets high values low and low values high"
      Top             =   360
      Value           =   1  'Checked
      Width           =   1095
   End
   Begin VB.CheckBox BlanksFill 
      Caption         =   "Fill blanks"
      Height          =   255
      Left            =   3840
      TabIndex        =   5
      ToolTipText     =   "When ticked draws zero value lines on graph"
      Top             =   360
      Width           =   1095
   End
   Begin MSComctlLib.Slider Slider2 
      Height          =   3015
      Left            =   600
      TabIndex        =   4
      ToolTipText     =   "Add/Subtract from value after multiplying or dividing"
      Top             =   4440
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   5318
      _Version        =   393216
      Orientation     =   1
      Max             =   1000
      TickStyle       =   1
      TickFrequency   =   100
   End
   Begin MSComctlLib.Slider Slider3 
      Height          =   3015
      Left            =   120
      TabIndex        =   3
      ToolTipText     =   "Value multiply/divide"
      Top             =   4440
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   5318
      _Version        =   393216
      Orientation     =   1
      Min             =   1
      Max             =   100
      SelStart        =   1
      TickStyle       =   1
      TickFrequency   =   10
      Value           =   1
   End
   Begin VB.Label Label7 
      Caption         =   "Label7"
      Height          =   495
      Left            =   3360
      TabIndex        =   20
      Top             =   6000
      Width           =   1095
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Pre-subtract"
      Height          =   255
      Left            =   1200
      TabIndex        =   16
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   45
      Width           =   855
   End
   Begin VB.Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "New value"
      Height          =   255
      Left            =   6360
      TabIndex        =   14
      Top             =   0
      Width           =   2655
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Orig value"
      Height          =   255
      Left            =   3240
      TabIndex        =   13
      Top             =   0
      Width           =   2895
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "WAIT"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   405
      Left            =   9360
      TabIndex        =   11
      Top             =   240
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "0"
      Height          =   255
      Left            =   720
      TabIndex        =   8
      ToolTipText     =   "Slider value"
      Top             =   4200
      Width           =   375
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "1"
      Height          =   255
      Left            =   240
      TabIndex        =   7
      ToolTipText     =   "Slider value"
      Top             =   4200
      Width           =   255
   End
   Begin VB.Label AddGraph 
      Alignment       =   2  'Center
      Caption         =   "minus"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   600
      TabIndex        =   2
      ToolTipText     =   "Toggles between add to or subtract from graph value according to slider position"
      Top             =   3960
      Width           =   495
   End
   Begin VB.Label MultiplyGraph 
      Alignment       =   2  'Center
      Caption         =   "/"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      TabIndex        =   1
      ToolTipText     =   "Toggles between multiply or divide graph value according to slider position"
      Top             =   3960
      Width           =   255
   End
End
Attribute VB_Name = "MagnetometerFullGraph"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Magnetometer & Earth Resistivity full graph 13APR04

Public Sub PlotIt_Click()

If DownloadFlag2 = 1 Then Exit Sub

If Plotit3D = 1 Then Call MagBarPlotIt: Exit Sub

If PicPath = 1 Then Call MagPlotIt: Exit Sub

BlanksFill.Visible = True
Resist.Visible = True

Picture1.ScaleHeight = Picture1.Height / (ZoomerVal * 4)
Picture1.ScaleWidth = Picture1.Width / (ZoomerVal * 4)

Picture1.Cls
Label6.Visible = True: Label6.Refresh
Screen.MousePointer = vbHourglass
B = 0

Min = 65536: Max = 0:
Min2 = 65536: Max2 = 0

R = Rotate.Value: If R = 1 Then GoTo RotateDisplay

H = Picture1.Height / 129: W = Picture1.Width / 129
H1 = H: W1 = W

StartVal = 1
EndVal = MaxLineLen(0)

For A = 0 To MaxLineLen(0)

If SelectOn.Value = 1 And A < 128 Then
If MagnetometerSelect.Column(A + 130).Value = 0 Then GoTo 120
End If

tempA$ = FileData(0, A)

X = GraphHoriz: '+50

Y1 = 0: Y = (H * B) + H: If Y > Picture1.ScaleHeight Then Exit For

Picture1.PSet (X, Y)

For C = StartVal To EndVal Step 6

If X > Picture1.ScaleWidth + W Then Exit For

V = Val(Mid$(tempA$, C))

If PicPath = 0 Then
vc = V \ 512: ' extract current value
Current = vc / R1: ' get current in relation to known resistance
If Current = 0 Then Current = 1
V = V And 511
End If

If V = 0 Then v1 = 0: GoTo 100

If V < Min Then Min = V
If V > Max Then Max = V

If PicPath = 0 And Resist.Value = 1 Then
V = V * Current
End If

V = V - Val(Text1.Text)
If V < 0 Then V = 0

 If MultiplyGraph.Caption <> "X" Then
  v1 = Int(V / Slider3.Value)
  Else
  v1 = Int(V * Slider3.Value)
 End If

 If AddGraph.Caption <> "minus" Then
  v1 = v1 + Slider2.Value
  Else
  v1 = v1 - Slider2.Value
 End If

 If v1 < 0 Then v1 = 0: GoTo 100

If v1 < Min2 Then Min2 = v1
If v1 > Max2 Then Max2 = v1

100:
If BlanksFill.Value = 0 And v1 = 0 Then GoTo 110

 If Inverter.Value = 0 Then
 Y = (H * B) - v1 + H
 Else
 Y = (H * B) + v1 + H
 End If

If D = 0 Then Picture1.PSet (X, Y): D = 1
If ColBlack = 0 Then
Picture1.Line -(X, Y), Col(3, A And 7)
Else
Picture1.Line -(X, Y), vbBlack
End If

110: X = X + W

Next:
120:
B = B + 1: Next
If Min = 65536 Then Min = 0
If Min2 = 65536 Then Min2 = 0

Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Min = " & Min & "   Max = " & Max
Label2.Caption = "New Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus
Exit Sub

' ************************

RotateDisplay:

W = Picture1.Height / 129: H = Picture1.Width / 129
H1 = W: W1 = H

StartVal = 1
EndVal = MaxLineLen(1)

For A = 0 To MaxLineLen(1)

If SelectOn.Value = 1 Then
If A < 128 And MagnetometerSelect.Column(A).Value = 0 Then GoTo 220
End If

tempA$ = FileData(1, A)

Y = 50: Y1 = 0: X = (H * B) + H

If Y > Picture1.ScaleHeight + H Then Exit For
If X > Picture1.ScaleWidth + W Then Exit For

Picture1.Line (X, 0)-(X, Y), Col(3, A And 7)

For C = StartVal To EndVal Step 6
If X > Picture1.ScaleWidth + W Then Exit For
V = Val(Mid$(tempA$, C))

If PicPath = 0 Then
vc = V \ 512: ' extract current value
Current = vc / R1: ' get current in relation to known resistance
If Current = 0 Then Current = 1
V = V And 511
End If

If V = 0 Then v1 = 0: GoTo 200

If V < Min Then Min = V
If V > Max Then Max = V

If PicPath = 0 And Resist.Value = 1 Then
V = V * Current
End If

V = V - Val(Text1.Text)
If V < 0 Then V = 0

 If MultiplyGraph.Caption <> "X" Then
  v1 = Int(V / Slider3.Value)
  Else
  v1 = Int(V * Slider3.Value)
 End If

 If AddGraph.Caption <> "minus" Then
  v1 = v1 + Slider2.Value
  Else
  v1 = v1 - Slider2.Value
 End If

 If v1 < 0 Then v1 = 0: GoTo 200

If v1 < Min2 Then Min2 = v1
If v1 > Max2 Then Max2 = v1

200:
If BlanksFill.Value = 0 And v1 = 0 Then GoTo 210

 If Inverter.Value = 0 Then
 X = (H * B) - v1 + H
 Else
 X = (H * B) + v1 + H
 End If

If Y > Picture1.ScaleHeight + H Then Exit For

If D = 0 Then Picture1.PSet (X, Y): D = 1
Picture1.Line -(X, Y), Col(3, A And 7)

210: Y = Y + H

Next:
220:
B = B + 1: Next
If Min = 65536 Then Min = 0
If Min2 = 65536 Then Min2 = 0

Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Min = " & Min & "   Max = " & Max
Label2.Caption = "New Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus

End Sub

Private Sub BlanksFill_Click()
Call PlotIt_Click
End Sub

Private Sub Command1_Click()
ColBlack = (ColBlack + 1) And 1
Call PlotIt_Click
End Sub

Private Sub FullGraph_Click()
Plotit3D = 0
Rotate.Visible = True
Inverter.Visible = True
'GridLines.Visible = True
'Label10.Visible = True
Call PlotIt_Click
End Sub

Private Sub GPSvalues_Click()
If GPSlist.Visible = True Then
GPSlist.Visible = False
Call PlotIt_Click
Else
GPSlist.Visible = True
End If
End Sub

Private Sub Graph3D_Click()
Plotit3D = 1
Rotate.Visible = False
Inverter.Visible = False
Call PlotIt_Click
End Sub

Private Sub Label10_Click()
Beep
MsgBox "No, click on the Graph, not on the Label !", vbExclamation
End Sub

Private Sub MoveIt_Click(Index As Integer)

        Select Case Index
            Case 0: GraphVert = GraphVert - 1000   ' up
            Case 1: GraphHoriz = GraphHoriz + 1000 ' right
            Case 2: GraphVert = GraphVert + 1000   ' down
            Case 3: GraphHoriz = GraphHoriz - 1000 ' left
        End Select
        
'        Call PlotIt_Click

End Sub

Private Sub ResetZoom_Click()
ZoomerVal = 0.6
Call PlotIt_Click
End Sub

Private Sub ResetPan_Click()
GraphVert = 0: GraphHoriz = 0
Call PlotIt_Click
End Sub

Private Sub SelectColumn_Click()
MagnetometerSelect.Show
End Sub

Private Sub Form_Unload(Cancel As Integer)
Call Main_Click
End Sub

Private Sub FullGrid_Click()
MagnetometerFullGrid.Show
Call MagnetometerFullGrid.PlotIt_Click
End Sub

Private Sub Inverter_Click()
Call PlotIt_Click
End Sub

Private Sub Main_Click()
Magnetometer.Show
End Sub

Public Sub RefreshIt_Click()
MagnetometerSelect.Hide
Call PlotIt_Click
End Sub

Private Sub resist_Click()
Call PlotIt_Click
End Sub

Private Sub Rotate_Click()
Call PlotIt_Click
End Sub

Private Sub SelectOn_Click()
Call PlotIt_Click
End Sub

Private Sub slider3_change()
If DownloadFlag2 = 1 Then Exit Sub
V = Slider3.Value
Label3.Caption = V
End Sub

Private Sub slider2_change()
If DownloadFlag2 = 1 Then Exit Sub
V = Slider2.Value
Label4.Caption = V
End Sub

Private Sub MultiplyGraph_Click()
If MultiplyGraph.Caption = "X" Then
MultiplyGraph.Caption = "/"
Else
MultiplyGraph.Caption = "X"
End If
End Sub

Private Sub AddGraph_Click()
If AddGraph.Caption = "minus" Then
AddGraph.Caption = "add"
Else
AddGraph.Caption = "minus"
End If
End Sub

'Private Sub Command1_Click()
'Picture1.ScaleHeight = Picture1.ScaleHeight + 1000
'Picture1.ScaleWidth = Picture1.ScaleWidth + 1000
'Call PlotIt_Click
'End Sub

'Private Sub Command2_Click()
'Picture1.ScaleHeight = Picture1.ScaleHeight - 1000
'Picture1.ScaleWidth = Picture1.ScaleWidth - 1000
'Call PlotIt_Click
'End Sub

Public Sub MagPlotIt()
BlanksFill.Visible = False
Resist.Visible = False

If Plotit3D = 1 Then Call MagBarPlotIt: Exit Sub

ReverseFlag = 0
Multiplier = Slider3.Value: If MultiplyGraph.Caption = "/" Then Multiplier = 1 / Multiplier
Adder = Slider2.Value: If AddGraph.Caption = "minus" Then Adder = -Adder

Picture1.ScaleHeight = Picture1.Height / ZoomerVal
Picture1.ScaleWidth = Picture1.Width / ZoomerVal

Picture1.Cls
Label6.Visible = True: Label6.Refresh
Screen.MousePointer = vbHourglass
B = 0

Min = 65536: Max = 0:
Min2 = 65536: Max2 = 0

R = Rotate.Value: If R = 1 Then GoTo RotateDisplay
B = 0

H = Picture1.Height / 129: W = Picture1.Width / 129
H1 = H: W1 = W

StartVal = 1
EndVal = MaxLineLen(1)

For A = 0 To MaxLineLen(1)

startit = 0

If SelectOn.Value = 1 And A < 128 Then
If MagnetometerSelect.Column(A + 130).Value = 0 Then GoTo 120
End If

tempA$ = FileData(0, A)

X = Picture1.Width: Y1 = 0: Y = (H * B) + H
If Y > Picture1.ScaleHeight Then Exit For
X = GraphHoriz
compensate = Val(Mid$(tempA$, 1))

For C = 1 To Len(tempA$) Step 6
If X > Picture1.ScaleWidth + W Then Exit For

V = Val(Mid$(tempA$, C))

V = V - compensate

If V < Min Then Min = V
If V > Max Then Max = V

V = V - Val(Text1.Text)

v1 = Int(V * Multiplier) + Adder

If v1 < Min2 Then Min2 = v1
If v1 > Max2 Then Max2 = v1

100:
 If Inverter.Value = 0 Then
 Y = (H * B) - v1 + H + GraphVert
 Else
 Y = (H * B) + v1 + H + GraphVert
 End If
If Y > 32000 Then Y = 32000

If startit = 0 Then Picture1.PSet (X, Y): startit = 1

If ColBlack = 0 Then
Picture1.Line -(X, Y), Col(3, A And 7)
Else
Picture1.Line -(X, Y), vbBlack
End If

110: X = X + W

Next:
120:
B = B + 1: Next
If Min = 65536 Then Min = 0
If Min2 = 65536 Then Min2 = 0

Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Min = " & Min & "   Max = " & Max
Label2.Caption = "New Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus
Exit Sub

' ************************

RotateDisplay:

W = Picture1.Height / 129: H = Picture1.Width / 260: '129
H1 = W: W1 = H

B = 0
StartVal = 1
EndVal = MaxLineLen(0)

For A = 0 To FileDataQty(0)
startit = 0

If SelectOn.Value = 1 Then
If A < 128 And MagnetometerSelect.Column(A).Value = 0 Then GoTo 220
End If

tempA$ = FileData(0, A)
EndVal = Len(tempA$)

Y = 50: Y1 = 0: X = (H * B) + H + GraphHoriz

If Y > Picture1.ScaleHeight + H Then Exit For
If X > Picture1.ScaleWidth + W Then Exit For

Y = Picture1.Height

Y = 0

D = 0: E = 0
For C = 1 To Len(tempA$) Step 6
If X > Picture1.ScaleWidth + W Then Exit For

V = Val(Mid$(tempA$, C))
If V = 0 Then v1 = 0: GoTo 200

If V < Min Then Min = V
If V > Max Then Max = V

V = V - Val(Text1.Text)

v1 = Int(V * Multiplier) + Adder

If v1 < Min2 Then Min2 = v1
If v1 > Max2 Then Max2 = v1

200:
If BlanksFill.Value = 0 And v1 = 0 Then GoTo 210

 If Inverter.Value = 0 Then
 X = (H * B) - v1 + H
 Else
 X = (H * B) + v1 + H
 End If

If Y > Picture1.ScaleHeight + H Then Exit For

If startit = 0 Then Picture1.PSet (X, Y): startit = 1

Picture1.Line -(X, Y), Col(3, A And 7)

210: Y = Y + H

Next

220:
B = B + 1: Next
If Min = 65536 Then Min = 0
If Min2 = 65536 Then Min2 = 0

Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Min = " & Min & "   Max = " & Max
Label2.Caption = "New Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus

End Sub

Public Sub MagBarPlotIt()
BlanksFill.Visible = False
Resist.Visible = False

ReverseFlag = 0
Multiplier = Slider3.Value: If MultiplyGraph.Caption = "/" Then Multiplier = 1 / Multiplier
Adder = Slider2.Value: If AddGraph.Caption = "minus" Then Adder = -Adder

Picture1.ScaleHeight = Picture1.Height / ZoomerVal
Picture1.ScaleWidth = Picture1.Width / ZoomerVal

Picture1.Cls
Label6.Visible = True: Label6.Refresh
Screen.MousePointer = vbHourglass
B = 0

Min = 65536: Max = 0: Min2 = 65536: Max2 = 0

B = 0
H = Picture1.Height / 129: W = Picture1.Width / 30
H1 = H: W1 = W: X1 = 0

StartVal = 1: EndVal = MaxLineLen(1): C = FileDataQty(1)

For A = C To 0 Step -1

If SelectOn.Value = 1 And A < 128 Then
If MagnetometerSelect.Column(A + 130).Value = 0 Then GoTo 120
End If

tempA$ = FileData(0, A)
Y1 = 0: Y = (H * B) + H
If Y > Picture1.ScaleHeight Then Exit For
X = A * 100 + 12000 + GraphHoriz

For C = 1 To Len(tempA$) Step 6

If SelectOn.Value = 1 And (C \ 6) < 128 Then
If MagnetometerSelect.Column(C \ 6).Value = 0 Then GoTo 110
End If

V = Val(Mid$(tempA$, C)): If V = 0 Then v1 = 0: GoTo 100

If V < Min Then Min = V
If V > Max Then Max = V

V = V - Val(Text1.Text)

v1 = Int(V * Multiplier) + Adder

If v1 < Min2 Then Min2 = v1
If v1 > Max2 Then Max2 = v1

100:
y3 = B * 100 + (X / 1.5) + 1000 + GraphVert: '10

Y = v1
If Y < 1 Then Y = 1

Picture1.Line (X + 20, y3 - 40)-(X + 100 + 20, y3 - Y - 40), vbBlack, BF
If ColBlack = 0 Then
Picture1.Line (X, y3)-(X + 100, y3 - Y), Col(1, A And 31), BF
Else
Picture1.Line (X, y3)-(X + 100, y3 - Y), &HC0C0C0, BF
End If

'ExtFloodFill Picture1.hdc, x + 21, y3 - 41, GetPixel(Picture1.hdc, x + 21, y3 - 41), FLOODFILLSURFACE

110: X = X - W: X1 = X1 - 1: Next

120: B = B + 1: Next
If Min = 65536 Then Min = 0
If Min2 = 65536 Then Min2 = 0

Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Min = " & Min & "   Max = " & Max
Label2.Caption = "New Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus
Exit Sub

End Sub

Private Sub ZoomIt_Click(Index As Integer)

        Select Case Index
            Case 0: ZoomerVal = ZoomerVal * 0.9
                If Plotit3D = 1 Then
                    GraphHoriz = GraphHoriz + 2000
                    GraphVert = GraphVert - 500
                End If
            Case 1: ZoomerVal = ZoomerVal * 1.1
                If Plotit3D = 1 Then
                    GraphHoriz = GraphHoriz - 2000
                    GraphVert = GraphVert + 500
                End If
        End Select
'        Call PlotIt_Click

End Sub
