;RADAR170.ASM 09MAY05 - COPYRIGHT JOHN BECKER - EPE ULTRASONIC RADAR

;PIC16F877, 4MHz, WDT OFF, POR ON, XTAL XS

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '877 data sheet

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5
#DEFINE CHAN0 iorlw B'00000000'

        List P = PIC16F877, R=DEC; 
        __CONFIG   h'3F31'

        include P16F877.inc

        CBLOCK

LOOPA      ; general loop counter
RSLINE     ; LCD command/data flag
STORE      ; general store
SLOWIT     ; counter for pause
COUNT0     ; lsb
COUNT1     ; nsb
COUNT2     ; msb
DIGIT1     ; lsd digital conversion
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8     ; msd digital conversion
BITCNT     ; maths routine counter
DIGCNT     ; maths routine counter
LOOP
STEPS
FOREWARD
PCMONITOR
BAUDFLAG
MOTORSTEPS
STORE1
TIMEOUT
MINSTEP
MAXSTEP
RECDTEXT
ACKTEXT1
ACKTEXT2
ACKTEXT3
ARCVAL

        ENDC

SCANSTORE   .EQU $A0     ; averaging store 0, extends to $FF

        .ORG 0
        goto GIEOFF

        .ORG 4          ; Interrupt vector address
        goto GIEOFF

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

LCDSET: clrf LOOP       ;clr LCD set-up loop
        clrf RSLINE     ;clear RS line for instruction send
LCDST2: movf LOOP,W     ;get table address
        call TABLCD     ;get set-up instruction
        call LCDOUT     ;perform it
        incf LOOP,F     ;inc loop
        btfss LOOP,3    ;has last LCD set-up instruction now been done?
        goto LCDST2     ;no
        return

TABLCD: addwf PCL,F     ;LCD initialisation table
        retlw %00110011 ;initialise lcd - first byte
        retlw %00110011 ;2nd byte (repeat of first)
        retlw %00110010 ;set for 4-bit operation
        retlw %00101100 ;set for 2 lines
        retlw %00000110 ;set entry mode to increment each address
        retlw %00001100 ;set display on, cursor off, blink off
        retlw %00000001 ;clear display
        retlw %00000010 ;return home, cursor & RAM to zero
                        ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'E'
        retlw 'P'
        retlw 'E'
        retlw ' '
        retlw 'U'
        retlw 'S'
        retlw 'O'
        retlw 'N'
        retlw 'I'
        retlw 'C'
        retlw ' '
        retlw 'R'
        retlw 'A'
        retlw 'D'
        retlw 'A'
        retlw 'R'

FULL    MOVF STEPS,W    ;table for FULL operation
        ANDLW B'00000011' 
	ADDWF PCL,F	
        RETLW B'00001100'
        RETLW B'00001001' 
        RETLW B'00000011' 
        RETLW B'00000110' 

ROUTEIT: movwf RECDTEXT
        ANDLW B'00000111'
	ADDWF PCL,F	
        goto SETBAUD9600
        goto SETBAUD19200
        return
        return
        goto SETSTEPS48
        goto SETSTEPS96
        return
        goto SETMINMAX

SETMINMAX:; return
        bcf STATUS,C      ; divide by 8
        rrf RECDTEXT,F
        bcf STATUS,C 
        rrf RECDTEXT,F
        bcf STATUS,C 
        rrf RECDTEXT,F
        bcf STATUS,C 
        rrf MOTORSTEPS,W   ; halve MOTORSTEPS
        movwf ARCVAL       ; store it in ARCVAL
        movf RECDTEXT,W    ; subtract RECDTEXT val from ARCVAL
        subwf ARCVAL,W
        movwf MINSTEP      ; set MINSTEP to this value
        movf RECDTEXT,W
        addwf ARCVAL,W     ; add RECDTEXT val to ARCVAL
        movwf MAXSTEP      ; set MAXSTEP to this value
        bcf STATUS,C 
        rlf RECDTEXT,W     ; show ARCVAL x 2
        movwf ARCVAL
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2
        call BIN2DEC
        call LCD11
        bsf RSLINE,4
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        return

SETSTEPS48: movlw 47
        movwf MOTORSTEPS
        movwf STORE1
        movlw 0
        call SETPRM
        goto SHOWSTEPS

SETSTEPS96: movlw 95
        movwf MOTORSTEPS
        movwf STORE1
        movlw 0
        call SETPRM
        goto SHOWSTEPS

SHOWSTEPS: incf MOTORSTEPS,W
        movwf COUNT0
        clrf COUNT1
        clrf COUNT2
        call BIN2DEC
        call LCD2A
        bsf RSLINE,4
        movlw 'S'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movf DIGIT2,W
        call LCDOUT
        movf DIGIT1,W
        call LCDOUT
        return

;*******************

START:  clrf PORTA
        clrf PORTB
        clrf PORTC

        BANK1
        movlw %00000000
        movwf TRISB
        movlw B'00000100'       ; set LHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1            ; with ref to +VE and 0V
        movlw %00011011         ; RA0, RA1, RA3, RA4 as input
        movwf TRISA
        movlw %10000000         ; RC7 as input
        movwf TRISC
        clrf TRISD
        clrf TRISE
        movlw B'00000100'       ; timer 1:32, pull-ups off
        movwf OPTION_REG
        BANK0

        movlw B'01000001'       ; set AD on, Fosc/8 
        CHAN0                   ; set for CHAN0 - RA0
        movwf ADCON0

        clrf INTCON
        call PAUSIT
        call LCDSET
        call PAUSIT

SHOWTITLE: clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMS1: movf LOOP,W
        call MESSAG1
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        call PAUSIT

        clrf INTCON

        call SETBAUD9600  ; set baud rate

        clrf FOREWARD
        clrf PCMONITOR
        clrf BAUDFLAG

        movlw 0
        call PRMGET
        movwf MOTORSTEPS  ; set motor steps value
        movlw 26
        movwf MAXSTEP     ; set max clockwise value
        movlw 22
        movwf MINSTEP     ; set min clockwise value
        bcf STATUS,C
        rrf MOTORSTEPS,W  ; halve motor steps value
        movwf STEPS       ; set midway step position
        call SHOWSTEPS

        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H

;****************** START OF MAIN ***********

MAIN:   movlw 20
        movwf LOOP

        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN4              ; Nothing RX'd

MAIN1:  movf    RCREG,W         ; Store the RX'd data in 'W'
        movwf RECDTEXT
        movwf ACKTEXT1

        sublw   'G'             ; Is this a 'G' ?
        btfss   STATUS,Z
        goto MAIN2              ; not yet
        goto MAIN4

MAIN2:  movf ACKTEXT1,W
        call TXBYTE

MAIN2A: btfss PIR1,RCIF       ; Check for any RX'd data
        goto MAIN2A             ; Nothing RX'd
        movf RCREG,W         ; Store the RX'd data in 'W'
        movwf ACKTEXT2
        call TXBYTE

MAIN2B: btfss PIR1,RCIF       ; Check for any RX'd data
        goto MAIN2B             ; Nothing RX'd
        movf RCREG,W         ; Store the RX'd data in 'W'
        movwf ACKTEXT3
        call TXBYTE

        movf ACKTEXT1,W
        call ROUTEIT
        movf ACKTEXT2,W
        call ROUTEIT
        movf ACKTEXT3,W
        call ROUTEIT

        bsf PCMONITOR,0

MAIN4:  BANK1
        bcf TRISE,0         ; RE0 as output
        BANK0

BEAMITW: bsf PORTE,0        ; send 40kHz signal
        movlw 3             ; command qty sets freq/mark-space. 3 for 4MHz clock. 9 for 10MHz clock. 20 for 20MHz
        movwf LOOPA
B2:     decfsz LOOPA,F
        goto B2
        bcf PORTE,0         ; send 40kHz signal
        movlw 3             ; command qty sets freq/mark-space. 3 for 4MHz clock. 9 for 10MHz clock. 19 for 20MHz
        movwf LOOPA
B3:     decfsz LOOPA,F
        goto B3
        decfsz LOOP,F
        goto BEAMITW
;        goto BEAMITW       ; temporarily reinstate this command if you want to check 40kHz output (must be removed again after checking)

        BANK1
        bsf TRISE,0         ; RE0 as input (high impedance)
        BANK0

        movlw SCANSTORE
        iorlw %10000000
        movwf FSR

        movlw 96
        movwf LOOP
GET2:   bsf PORTB,0
        bsf ADCON0,GO           ; start data conversion
        nop
GETADC: btfsc ADCON0,GO
        goto GETADC
        movf ADRESH,W           ; get ADC MSB val
        BANK1
        movwf INDF              ; store it
        xorlw 255               ; is it = 255?
        btfsc STATUS,Z
        decf INDF,F             ; yes, so dec to 254 (as 255 is used as sync marker)
        BANK0
        incf FSR,F

        movlw 64
        movwf LOOPA
DELAYB: decfsz LOOPA,F
        goto DELAYB

        bcf PORTB,0
        decfsz LOOP,F
        goto GET2

        btfsc PCMONITOR,0
        goto SENDPC0

        clrf TMR1L       ; reset timer 1
        movlw 128
        movwf TMR1H
        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1

DELAYC: btfss PIR1,0     ; has timer 1 overflowed?
        goto DELAYC      ; not yet 
        goto STEPMOTOR

SENDPC0: clrf PORTC

        movlw SCANSTORE
        iorlw %10000000
        movwf FSR

        movlw 96
        movwf LOOP
        movlw $FF
        call TXBYTE
        movf STEPS,W
        call TXBYTE

SENDPC: movf INDF,W
        call TXBYTE
        incf FSR,F
        decfsz LOOP,F
        goto SENDPC

        clrf TMR1L       ; reset timer 1
        clrf TMR1H
        movlw 2
        movwf TIMEOUT
        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1

SENDPC2: btfss PIR1,0    ; has timer 1 overflowed?
        goto SENDPC1     ; not yet 
        clrf TMR1L       ; reset timer 1
        clrf TMR1H
        bcf PIR1,0       ; timer rollover flag

        decfsz TIMEOUT,F        ; has TIMEOUT reached zero?
        goto SENDPC1            ; not yet 

        bcf PCMONITOR,0         ; yes
        call SETBAUD9600        ; reset baud rate
        goto STEPMOTOR

SENDPC1: btfss  PIR1,RCIF       ; Check for any RX'd data
        goto SENDPC2            ; Nothing RX'd

SENDPC3: movf   RCREG,W         ; Store the RX'd data in 'W'
        sublw   'G'             ; Is this a 'G' ?
        btfss   STATUS,Z
        goto SENDPC2            ; no, wait again
        movf ARCVAL,W           ; is ARCVAL = 0?
        btfss STATUS,Z
        goto STEPMOTOR
        clrf PORTC              ; yes, so don't step motor (turn it off)
        goto MAIN

STEPMOTOR:
        btfsc FOREWARD,0
        goto BACK

FORE:   call FULL
        movwf PORTC
        incf STEPS,F
        movf STEPS,W
        xorwf MAXSTEP,W
        btfss STATUS,Z
        goto FORE2
        bsf FOREWARD,0
        goto MAIN

FORE2:  movf STEPS,W
        xorwf MOTORSTEPS,W
        btfss STATUS,Z
        goto MAIN
        bsf FOREWARD,0
        goto MAIN

BACK:   call FULL
        movwf PORTC
        decf STEPS,F
        movf STEPS,W
        xorwf MINSTEP,W
        btfss STATUS,Z
        goto BACK2
        bcf FOREWARD,0
        goto MAIN

BACK2:  movf STEPS,W
        btfss STATUS,Z
        goto MAIN
        bcf FOREWARD,0
        goto MAIN


;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD2:   movlw %10000001
        goto LCDLIN
LCD3:   movlw %10000010
        goto LCDLIN
LCD8:   movlw %10001000
        goto LCDLIN
LCD11:  movlw %10001011
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN
LCD2A:  movlw %11001010
        goto LCDLIN

LCD2B:  movlw %11001011

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 250
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTD
        BSF PORTD,5
        nop 
        nop
        BCF PORTD,5
        nop
        nop
        return

;.............

PAUSIT: movlw 50
        movwf SLOWIT
        bcf INTCON,2
PAUSE:  btfss INTCON,2
        goto PAUSE
        bcf INTCON,2
        decfsz SLOWIT,F
        goto PAUSE
        return

;************

BIN2DEC: clrf   DIGIT1
        clrf    DIGIT2
        clrf    DIGIT3
        clrf    DIGIT4
        clrf    DIGIT5
        clrf    DIGIT6
        clrf    DIGIT7
        clrf    DIGIT8

        movlw   24              ;24 bits to do
        movwf   BITCNT

BITLP:  rlf     COUNT0,F        ;Shift msb into carry
        rlf     COUNT1,F
        rlf     COUNT2,F

        movlw   DIGIT1
        movwf   FSR             ;Pointer to DIGITs
        movlw   8               ;8 DIGITs to do
        movwf   DIGCNT
ADJLP:  rlf     INDF,F          ;Shift DIGIT 1 bit left
        movlw   10
        subwf   INDF,w          ;Check and adjust for decimal overflow
        skpnc
        movwf   INDF

        incf    FSR,F           ;Next DIGIT
        decfsz  DIGCNT,F
        goto    ADJLP
        decfsz  BITCNT,F        ;Next bit
        goto    BITLP
        movlw 48
        iorwf DIGIT1,F       ; convert to ascii numeral
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        movf DIGIT3,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT3,4
        movf DIGIT2,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT2,4
        movf DIGIT8,W
        andlw 15
        btfss STATUS,Z
        return
        bcf DIGIT8,4
        return

;****************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

;*************** PC SERIAL PORT CONTROL **********

;  Modified from Joe Farr's file SAMPLE5.ASM

SETBAUD9600:
        BANK1                   ; Configure the baud rate generator
        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0

        call LCD21
        bsf RSLINE,4
        movlw 'B'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw '9'
        call LCDOUT
        movlw '6'
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SETBAUD19200:
        BANK1                   ; Configure the baud rate generator
        movlw 12                ; BRG for 19200baud from 4MHz, brgh=1
	movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0

        call LCD21
        bsf RSLINE,4
        movlw 'B'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw '1'
        call LCDOUT
        movlw '9'
        call LCDOUT
        movlw '2'
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw '0'
        call LCDOUT
        return

; Send byte in W to the USART

TxByte
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

                                        ;...............

                                        ;write data to eeprom routine modified for pic16f87x devices
                                        ;according to data sheet ds30292a page 43

                                        ;this routine is entered with w holding
                                        ;the eeprom byte address at which data
                                        ;is to be stored. the data to be stored
                                        ;is held in store1.
SETPRM:         bsf STATUS,RP1          ;set for page 2
                bcf STATUS,RP0          
                movwf EEADR             ;copy w into eeadr to set eeprom address
                bcf STATUS,RP1          ;set for page 0
                movf STORE1,W           ;get data value from store1 and hold in w
                bsf STATUS,RP1          ;set for page 2
                movwf EEDATA            ;copy w into eeprom data byte register
                bsf STATUS,RP0          ;set for page 3
                bcf EECON1,EEPGD        ;point to data memory
                bsf EECON1,WREN         ;enable write flag

MANUAL:         movlw $55               ;these lines cause the action required by
                movwf EECON2            ;by the eeprom to store the data in eedata
                movlw $AA               ;at the address held by eeadr.
                movwf EECON2            
                bsf EECON1,WR           ;set the ``perform write'' flag
                bcf STATUS,RP1          ;set for page 0
                bcf STATUS,RP0          

CHKWRT:         btfss PIR2,EEIF         ;wait until bit 4 of pir2 is set
                goto CHKWRT             
                bcf PIR2,EEIF           ;clear bit 4 of pir2
                return                  

                                        ;..........

                                        ;read data from eeprom routine modified for pic16f87x devices
                                        ;according to data sheet ds30292a page 43

                                        ;this routine is entered with w holding
                                        ;the eeprom byte address to be read.
PRMGET:         bsf STATUS,RP1          ;set for page 2
                bcf STATUS,RP0          
                movwf EEADR             ;copy w into eeadr to set eeprom address
                bsf STATUS,RP0          ;set for page 3
                bcf EECON1,EEPGD        ;point to data memory
                bsf EECON1,RD           ;enable read flag
                bcf STATUS,RP0          ;set for page 2
                movf EEDATA,W           ;read eeprom data now in eedata into w
                bcf STATUS,RP1          ;set for page 0
                return                  


          ORG $2100

        DE   47  ; 48 motor steps (0 - 47)

         .END


