; TK3TUT5.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; as TK3TUT4, showing how Carry bit rotates into reg

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                 
                clrf PORTA              ; clear Port A data register
                clrf PORTB              ; clear Port B data register
                BANK1                   ; BANK 1
                clrf TRISA              ; Port A direction register for output
                clrf TRISB              ; Port B direction register for output
                BANK0                   ; BANK 0
                 
                bsf STATUS,C            ; set the Carry bit in STATUS
                 
LOOP            rlf PORTB,F             ; rotate left PORTB
                goto LOOP               ; repeat
                 
                end                     ; final statement
