; TK3TUT28.ASM 26FEB03 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer with set rate, with BCD to 59 counting
; on 4 LED 7-seg displays
; with intermediate 1/25 counter
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag

CLKCNT          EQU H'20'               ; clock division counter
CLKSEC          EQU H'21'               ; clock seconds counter
CLKMIN          EQU H'22'               ; clock minutes counter
CLKHRS          EQU H'23'               ; clock hours counter
DIGIT           EQU H'24'               ; 7-segment digit select

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00010000'       ;RA4 as input, RA0-3 as output
                movwf TRISA
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                movlw 25                ; set 1/25th counter
                movwf CLKCNT
                clrf CLKSEC             ; clear secs
                clrf CLKMIN             ; clear mins
                clrf CLKHRS             ; clear hours
                clrf DIGIT              ; clear digit count
                bcf INTCON,2
                goto MAIN

COMCATHODE      addwf PCL,F             ; add W value to PCL
                retlw B'00111111'       ; 0   common cathode codes
                retlw B'00000110'       ; 1
                retlw B'01011011'       ; 2
                retlw B'01001111'       ; 3
                retlw B'01100110'       ; 4
                retlw B'01101101'       ; 5
                retlw B'01111100'       ; 6
                retlw B'00000111'       ; 7
                retlw B'01111111'       ; 8
                retlw B'01100111'       ; 9

COMANODE        addwf PCL,F
                retlw B'11000000'       ; 0   common anode codes
                retlw B'11111001'       ; 1
                retlw B'10100100'       ; 2
                retlw B'10110000'       ; 3
                retlw B'10011001'       ; 4
                retlw B'10010010'       ; 5
                retlw B'10000011'       ; 6
                retlw B'11111000'       ; 7
                retlw B'10000000'       ; 8
                retlw B'10011000'       ; 9
                 
DIGSEL          incf DIGIT,W            ; inc digit val into W
                andlw B'00000011'       ; limit to 3
                movwf DIGIT             ; move into digit counter
                btfss PORTA,3           ; is PORTA RA4 switch pressed (= 0)
                addlw 2                 ; yes, increase jump by 2 places (to MINTEN etc)
                addwf PCL,F             ; add result to program counter
                goto HRSTEN             ; gets to HRS only if RA4 switch not pressed
                goto HRSONE             ;
                goto MINTEN             ; mins shown for both switch on and off states
                goto MINONE             ;
                goto SECTEN             ; secs only shown if switch is pressed
                goto SECONE             ;
                 
DIGSHW          movf DIGIT,W            ; get digit count
                addwf PCL,F             ; add to counter
                retlw 1                 ; digit 1
                retlw 2                 ; digit 2
                retlw 4                 ; digit 3
                retlw 8                 ; digit 4
                 
MAIN            call DIGSEL             ; get required digit bit val
                btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes
                call CLKADD             ; perform time update
                goto MAIN               ; repeat from MAIN
                 
CLKADD          decfsz CLKCNT,F         ; dec 1/25 clock counter. Is it = 0?
                return                  ; no
                 
                movlw 25                ; yes, reset start value of CLKCNT
                movwf CLKCNT
                 
SECCLK          incf CLKSEC,F           ; inc secs in BCD
                movlw 6                 ; check units >9
                addwf CLKSEC,W          ; if 6 is added is there a digit carry?
                btfss STATUS,DC
                return                  ; no
                movwf CLKSEC            ; yes
                xorlw B'01100000'       ; XOR W with 96 (BCD 60)
                btfss STATUS,Z          ; is the answer = 0 (secs = 60)?
                return                  ; no
                clrf CLKSEC             ; yes, clear secs counter
                 
MINCLK          incf CLKMIN,F           ; inc mins in BCD
                movlw 6                 ; check units >9
                addwf CLKMIN,W          ; if 6 is added is there a digit carry?
                btfss STATUS,DC
                return                  ; no
                movwf CLKMIN            ; yes
                xorlw 96                ; XOR W with 96 (BCD 60)
                btfss STATUS,Z          ; is the answer = 0 (mins = 60)?
                return                  ; no
                clrf CLKMIN             ; yes, clear mins counter
                 
HRSCLK          incf CLKHRS,F           ; inc hrs in BCD
                movlw 6                 ; check units >9
                addwf CLKHRS,W          ; if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf CLKHRS            ; yes
                xorlw B'00100100'       ; XOR W with 36 (BCD 24)(check total=24)
                btfsc STATUS,Z          ; is the answer = 1 (equality)
                clrf CLKHRS             ; yes, clear hours count
                return 
                 
HRSTEN          swapf CLKHRS,W          ; get hours tens
                goto OUTPUT             ; show it
HRSONE          movf CLKHRS,W           ; get hours units
                goto OUTPUT             ; show it
                 
MINTEN          swapf CLKMIN,W          ; get mins tens
                goto OUTPUT             ; show it
MINONE          movf CLKMIN,W           ; get mins units
                goto OUTPUT             ; show it
                 
SECTEN          swapf CLKSEC,W          ; get secs tens
                goto OUTPUT             ; show it
SECONE          movf CLKSEC,W           ; get secs units and show it
                 
OUTPUT          andlw B'00001111'       ; get nibble LSB val
                call COMCATHODE         ; get 7-seg code for val
                clrf PORTA              ; turn off all digits
                movwf PORTB             ; output code to display
                call DIGSHW             ; get digit number to be turned on
                movwf PORTA             ; turn it on via PORTA
                movf DIGIT,W            ; get digit number
                xorlw 1                 ; limit to 1 (0 to 1)
                btfsc STATUS,Z          ; is digit 3 or 1 being shown (digit val + 1)
                bsf PORTB,7             ; yes, turn on decimal point
                return                  ; do it all again
                 
                end                     ; final line
