; TK3TUT26.ASM 03JAN03 - JOHN BECKER - EPE PIC TUTOR V2
; Use of Timer with BCD counting on 7-segment (single)
                 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

OPTION_REG      EQU 1                   ; OPTION register
PCL             EQU 2                   ; Program counter register
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
INTCON          EQU H'0B'               ; INTCON register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
DC              EQU 1                   ; Digit Carry flag

CLKCNT          EQU H'20'               ; clock division counter
CLKSEC          EQU H'21'               ; clock seconds counter

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                movlw 1
                movwf PORTA
                clrf PORTB
                BANK1
                clrf TRISA		; PORTA as output
                clrf TRISB		; PORTB as output
                movlw B'10000110'       ; move ratio value into W
                movwf OPTION_REG        ; set timer ratio to 1:128 (TMR0 rate)
                BANK0                   ; (light pull-ups off - bit 7 high)

                movlw 25
                movwf CLKCNT
                clrf CLKSEC
                bcf INTCON,2
                goto MAIN

COMCATHODE      addwf PCL,F             ; add W value to PCL
                retlw B'00111111'       ; 0   common cathode codes
                retlw B'00000110'       ; 1
                retlw B'01011011'       ; 2
                retlw B'01001111'       ; 3
                retlw B'01100110'       ; 4
                retlw B'01101101'       ; 5
                retlw B'01111100'       ; 6
                retlw B'00000111'       ; 7
                retlw B'01111111'       ; 8
                retlw B'01100111'       ; 9
                 
COMANODE        addwf PCL,F             ; add W value to PCL
                retlw B'11000000'       ; 0   common anode codes
                retlw B'11111001'       ; 1
                retlw B'10100100'       ; 2
                retlw B'10110000'       ; 3
                retlw B'10011001'       ; 4
                retlw B'10010010'       ; 5
                retlw B'10000011'       ; 6
                retlw B'11111000'       ; 7
                retlw B'10000000'       ; 8
                retlw B'10011000'       ; 9
                 
MAIN            btfss INTCON,2          ; has a timer time-out been detected?
                goto MAIN               ; no
                bcf INTCON,2            ; yes
                decfsz CLKCNT,F         ; dec clock division counter, is it zero?
                goto MAIN               ; no
                movlw 25                ; yes, reset CLKCNT
                movwf CLKCNT
                incf CLKSEC,F           ; inc count
                movf CLKSEC,W           ; check units >9
                addlw 6
                btfsc STATUS,DC         ; is there a digit carry?
                clrf CLKSEC             ; yes, clear counter
OUTPUT          movf CLKSEC,W           ; get count val
                andlw B'00001111'       ; AND for LS nibble
                call COMCATHODE         ; get 7-seg code for val
                movwf PORTB             ; output to display
                goto MAIN               ; repeat for next
                 
                end                     ; final line
