; TUT10.ASM 22DEC02 - JOHN BECKER - EPE PIC TUTOR V2
; using single switch on Port A to increment PORTB LED count
; showing how bit testing can be used to test switch status
; and to cause a count increment only at the moment the switch is pressed
 
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
                 
STATUS          EQU 3                   ; STATUS register
TRISA           EQU 5                   ; Port A direction register
PORTA           EQU 5                   ; Port A data register
TRISB           EQU 6                   ; Port B direction register
PORTB           EQU 6                   ; Port B data register
W               EQU 0                   ; Working register flag
F               EQU 1                   ; File register flag
C               EQU 0                   ; Carry flag
Z               EQU 2                   ; Zero flag
COUNT           EQU H'20'               ; name location H'20' as variable called COUNT
SWITCH          EQU H'21'               ; variable to hold previous switch status

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5

                clrf PORTA
                clrf PORTB
                BANK1
                movlw B'00000001'       ; RA0 as input
                movwf TRISA
                clrf TRISB
                BANK0
                 
BEGIN           clrf COUNT
                clrf SWITCH
                 
TESTIT          btfsc PORTA,0           ; test bit 0 of Port A, is it clear?
                goto TSTPRV             ; no, it's = 1 so go to TSTPRV
                bcf SWITCH,0            ; clear bit 0 of SWITCH
                goto TESTIT             ; jump back to TESTIT
TSTPRV          btfsc SWITCH,0          ; test bit 0 of SWITCH, is it clear?
                goto TESTIT             ; no, it's = 1 so go to TESTIT
                incf COUNT,F            ; yes, it's = 0 so inc count
                movf COUNT,W            ; get COUNT
                movwf PORTB             ; output to PORTB
                bsf SWITCH,0            ; set bit 0 of SWITCH
                goto TESTIT             ; repeat
                 
                end                     ; final statement
