/*
 * misc.h
 *
 * Interface to misc.c routines for the PICHEX package.
 *
 * Revision history:
 *
 * 11-Jul-1996: V-0.0; wrote definitions
 * 18-Jul-1996: V-0.1; changed to support LIBVERSION
 *
 * Copyright (C) 1996 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or used for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */


#ifndef __MISC_H
#define __MISC_H

#define PSIZE	1024		/* describes the 16C84 */
#define DSIZE   64
#define WSIZE  	14
#define IBASE  	0x2000
#define CBASE  	0x2007
#define DBASE  	0x2100
#define LP_OSC	0
#define XT_OSC 	1
#define HS_OSC 	2
#define RC_OSC 	3
#define OSC    	3
#define WDT    	4
#define PWRT   	8
#define CP     	16
#define CMASK	 0x1F

#ifndef EXIT_SUCCESS		/* should be in stdlib.h but ... */
#define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

#ifndef LIBVERSION
void quit(char *pname, char *msg);
void telluser(char *pname, char *msg, int e);
#else
#define quit(p,m)	{ sprintf(errmsg,"%s",m); return -1; }
#define telluser(p,m,e) { if ( e<0 ) quit(p,errhex(e)) }
#endif  /* LIBVERSION */

extern char errmsg[];

void showcf(FILE *fp);
void showid(FILE *fp);
int hex2int(int n, char *s);
unsigned check84(void);
unsigned checkall(void);

#endif /* __MISC_H */